/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.entity.EntityMobMist;

public class EntitySnowFlea
extends EntityMobMist {
    public EntitySnowFlea(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.75f);
        this.field_70138_W = 2.0f;
        this.field_70747_aH = 0.3f;
        this.field_70765_h = new FleaMoveHelper(this);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 5, true, false, (Predicate)null));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_SNOW_FLEA_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return MistSounds.ENTITY_SNOW_FLEA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_SNOW_FLEA_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(MistSounds.ENTITY_SNOW_FLEA_STEP, 0.15f, 1.0f);
    }

    protected SoundEvent getJumpSound() {
        return MistSounds.ENTITY_SNOW_FLEA_FLAY;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.SNOW_FLEA_LOOT;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity) && this.field_70146_Z.nextInt(8) == 0) {
            if (entity instanceof EntityLivingBase) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffect) {
        return potioneffect.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffect);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) == null) {
            livingdata = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public float func_70047_e() {
        return 0.65f;
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion effect;

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(4);
            if (i <= 1) {
                this.effect = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.effect = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.effect = MobEffects.field_76428_l;
            }
        }
    }

    static class FleaMoveHelper
    extends EntityMoveHelper {
        public FleaMoveHelper(EntitySnowFlea slimeIn) {
            super((EntityLiving)slimeIn);
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
                double d0 = this.field_75646_b - this.field_75648_a.field_70165_t;
                double d1 = this.field_75644_d - this.field_75648_a.field_70161_v;
                double d2 = this.field_75647_c - this.field_75648_a.field_70163_u;
                double d3 = d0 * d0 + d2 * d2 + d1 * d1;
                double d4 = 0.0;
                if (d3 < 2.5) {
                    this.field_75648_a.func_191989_p(0.0f);
                    return;
                }
                float f9 = (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.29577951308232) - 90.0f;
                this.field_75648_a.field_70177_z = this.func_75639_a(this.field_75648_a.field_70177_z, f9, 90.0f);
                this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                if ((d2 > (double)this.field_75648_a.field_70138_W || d3 > 4.0) && d0 * d0 + d1 * d1 < (double)Math.max(5.0f, this.field_75648_a.field_70130_N)) {
                    this.field_75648_a.func_70659_e((float)(this.field_75645_e * this.field_75648_a.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e()));
                    this.field_75648_a.func_70683_ar().func_75660_a();
                    this.field_75648_a.func_184185_a(MistSounds.ENTITY_SNOW_FLEA_FLAY, 0.15f, 1.0f);
                    this.field_188491_h = EntityMoveHelper.Action.JUMPING;
                }
            } else {
                super.func_75641_c();
            }
        }
    }

    static class AIAttack
    extends EntityAIAttackMelee {
        public AIAttack(EntitySnowFlea spider) {
            super((EntityCreature)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            float f = this.field_75441_b.func_70013_c();
            if (f >= 0.5f && this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }
}

