/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import ru.liahim.mist.api.block.IRubberBallCollideble;
import ru.liahim.mist.api.item.MistItems;

public class EntityRubberBall
extends EntityThrowable {
    private int lastBounce;
    private float size = 0.3125f;

    public EntityRubberBall(World world) {
        super(world);
        this.func_70105_a(this.size, this.size);
    }

    public EntityRubberBall(World world, double x, double y, double z) {
        super(world, x, y, z);
        this.func_70105_a(this.size, this.size);
    }

    public EntityRubberBall(World world, EntityLivingBase entity) {
        super(world, entity);
        this.func_70105_a(this.size, this.size);
    }

    protected ItemStack getItemStack() {
        return new ItemStack(MistItems.RUBBER);
    }

    protected void func_70184_a(RayTraceResult result) {
        BlockPos pos;
        IBlockState state;
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (result.field_72308_g instanceof EntityPlayer && ((EntityPlayer)result.field_72308_g).func_70093_af()) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getItemStack()));
            } else {
                double damage = this.getMotion().func_189985_c();
                if (damage > 0.1) {
                    result.field_72308_g.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), (float)(damage / 2.0));
                }
                this.field_70159_w = -this.field_70159_w * (this.field_70146_Z.nextDouble() * 0.5 + 0.5);
                this.field_70181_x *= this.field_70146_Z.nextDouble() * 0.5 + 0.5;
                this.field_70179_y = -this.field_70179_y * (this.field_70146_Z.nextDouble() * 0.5 + 0.5);
            }
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK && (!((state = this.field_70170_p.func_180495_p(pos = result.func_178782_a())).func_177230_c() instanceof IRubberBallCollideble) || ((IRubberBallCollideble)state.func_177230_c()).isCollide(this.field_70170_p, state, this, result, this.field_70146_Z))) {
            this.field_70170_p.func_184133_a(null, pos, state.func_177230_c().getSoundType(state, this.field_70170_p, pos, (Entity)this).func_185844_d(), SoundCategory.BLOCKS, 1.0f, 1.5f);
            this.doBounce(new Vec3d(result.field_178784_b.func_176730_m()), state.func_185904_a());
        }
        this.lastBounce = 0;
    }

    private void doBounce(Vec3d norm, Material mat) {
        Vec3d motion = this.getMotion();
        double velAlongNorm = norm.func_72430_b(motion);
        Vec3d newMotion = motion.func_178787_e(norm.func_186678_a(velAlongNorm * -this.bounciness(1.0)));
        this.setMotion(newMotion.func_186678_a(this.getMaterialMultipler(mat)));
    }

    private double bounciness(double add) {
        return add + this.field_70146_Z.nextDouble() * 0.1 + 0.7;
    }

    private double getMaterialMultipler(Material mat) {
        double i = 1.0;
        if (mat != null) {
            if (mat == Material.field_151578_c) {
                i = 0.9;
            } else if (mat == Material.field_151577_b) {
                i = 0.9;
            } else if (mat == Material.field_151585_k) {
                i = 0.8;
            } else if (mat == Material.field_151595_p || mat == Material.field_151597_y) {
                i = 0.5;
            }
        }
        return i;
    }

    public Vec3d getMotion() {
        return new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
    }

    private void setMotion(Vec3d vec) {
        this.field_70159_w = vec.field_72450_a;
        this.field_70181_x = vec.field_72448_b;
        this.field_70179_y = vec.field_72449_c;
    }

    protected float func_70185_h() {
        return 0.1f;
    }

    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        this.func_70030_z();
        if (!this.field_70170_p.field_72995_K) {
            ++this.lastBounce;
            if (!this.field_70170_p.field_72995_K && this.lastBounce < 5 && this.getMotion().func_189985_c() < (double)0.1f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)3);
                this.func_70106_y();
                this.field_70170_p.func_72838_d((Entity)new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, this.getItemStack()));
                return;
            }
            Vec3d vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3d vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            RayTraceResult raytrace = this.field_70170_p.func_147447_a(vec3d, vec3d1, true, true, false);
            vec3d = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3d1 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (raytrace != null) {
                vec3d1 = new Vec3d(raytrace.field_72307_f.field_72450_a, raytrace.field_72307_f.field_72448_b, raytrace.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
            double d0 = 0.0;
            boolean flag = false;
            for (int i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L()) continue;
                if (entity1 == this.field_184539_c) {
                    flag = true;
                    continue;
                }
                if (this.field_70192_c != null && this.field_70173_aa < 2 && this.field_184539_c == null) {
                    this.field_184539_c = entity1;
                    flag = true;
                    continue;
                }
                flag = false;
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.3);
                RayTraceResult raytraceresult1 = axisalignedbb.func_72327_a(vec3d, vec3d1);
                if (raytraceresult1 == null || !((d1 = vec3d.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (this.field_184539_c != null) {
                if (flag) {
                    this.field_184540_av = 2;
                } else if (this.field_184540_av-- <= 0) {
                    this.field_184539_c = null;
                }
            }
            if (entity != null) {
                raytrace = new RayTraceResult(entity);
            }
            if (raytrace != null) {
                if (raytrace.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(raytrace.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                    this.func_181015_d(raytrace.func_178782_a());
                } else if (!ForgeEventFactory.onProjectileImpact((EntityThrowable)this, (RayTraceResult)raytrace)) {
                    this.func_70184_a(raytrace);
                }
            }
        }
        this.field_70165_t += this.field_70159_w;
        this.field_70163_u += this.field_70181_x;
        this.field_70161_v += this.field_70179_y;
        float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
        this.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_70159_w, (double)this.field_70179_y) * 57.29577951308232);
        this.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_70181_x, (double)f) * 57.29577951308232);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        float f1 = this.func_70090_H() ? 0.8f : 0.99f;
        float f2 = this.func_70185_h();
        this.field_70159_w *= (double)f1;
        this.field_70181_x *= (double)f1;
        this.field_70179_y *= (double)f1;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)f2;
        }
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("LastBounce", this.lastBounce);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.lastBounce = compound.func_74762_e("LastBounce");
    }
}

