/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.EntityWulder;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIFollowSame;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;

public class EntityPrickler
extends EntityAlbino {
    private static final Set<ItemStack> TEMPTATION_STACKS = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, 26)});
    private static long pregnantTime = MistTime.getDayInMonth() * 24000;
    private AIHurtByAggressor aiHurt;

    public EntityPrickler(World world) {
        super(world);
        this.func_70105_a(0.9f, 0.95f);
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptTamed((EntityAnimalMist)this, 0.8, 1.2, false, TEMPTATION_STACKS);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAttackMelee(this, 1.2, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.2));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParentGender(this, 1.3));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIAvoidEntity(this, EntityPlayer.class, 8.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIFollowSame((EntityLiving)this, 1.0, 12.0, 24.0));
        this.aiHurt = new AIHurtByAggressor(this);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiHurt);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(3) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextBoolean();
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_PRICKLER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_PRICKLER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_PRICKLER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_70909_n() || player.field_71075_bZ.field_75098_d) {
            if (this.func_70877_b(stack)) {
                return super.func_184645_a(player, hand);
            }
            if (stack.func_77973_b() == Items.field_151057_cb) {
                stack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            return false;
        }
        return this.tamedProcess(player, stack);
    }

    public boolean func_70652_k(Entity entity) {
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            if (!source.func_76352_a()) {
                this.func_70652_k(entity);
            }
            if (this.func_110143_aJ() <= 0.0f) {
                this.closePanic(EntityWulder.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(2000) + 2000);
            } else {
                this.closePanic(EntityWulder.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(250) + 250);
            }
            this.setRevengeTime(this.field_70146_Z.nextInt((int)(500.0f * amount) + 1) + (int)(250.0f * amount) + 250);
        }
        return flag;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.PRICKLER_LOOT;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70099_a((ItemStack)TEMPTATION_STACKS.toArray()[this.field_70146_Z.nextInt(TEMPTATION_STACKS.size())], 0.0f);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 0.8f;
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        super.func_70636_d();
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityPrickler entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityPrickler(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        for (ItemStack st : TEMPTATION_STACKS) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getTameLevel() {
        return 2;
    }

    static class AIAvoidEntity
    extends EntityAIAvoidEntity {
        public AIAvoidEntity(EntityPrickler entity, Class<EntityPlayer> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
            super((EntityCreature)entity, classToAvoid, avoidDistance, farSpeed, nearSpeed);
        }

        public boolean func_75250_a() {
            return (!((EntityPrickler)this.field_75380_a).func_70909_n() || this.field_75380_a.func_110143_aJ() <= this.field_75380_a.func_110138_aP() / 3.0f) && super.func_75250_a();
        }
    }

    static class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityPrickler entity, double speed, boolean useLongMemory) {
            super((EntityCreature)entity, speed, useLongMemory);
        }

        public boolean func_75250_a() {
            return !((EntityPrickler)this.field_75441_b).isPregnant() && this.field_75441_b.func_110143_aJ() > this.field_75441_b.func_110138_aP() / 3.0f && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.field_75441_b.func_110143_aJ() > this.field_75441_b.func_110138_aP() / 3.0f && super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityPrickler entity) {
            super((EntityCreature)entity, false, new Class[0]);
        }

        public boolean func_75250_a() {
            return !((EntityTameable)this.field_75299_d).func_70909_n() && super.func_75250_a();
        }
    }
}

