/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.entity.IOffetPassangerMount;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.client.model.animation.SimpleIK;
import ru.liahim.mist.client.model.entity.ModelMonk;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.AbstractMistChestMount;
import ru.liahim.mist.entity.AbstractMistMount;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.EntityForestRunner;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptMeat;

public class EntityMonk
extends AbstractMistChestMount
implements IOffetPassangerMount {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityMonk.class, (DataSerializer)DataSerializers.field_187198_h);
    private static long pregnantTime = MistTime.getDayInMonth() * 32000;
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;
    private float[] vec = new float[3];

    public EntityMonk(World world) {
        super(world);
        this.field_70728_aV = 10;
        this.func_70105_a(1.8f, 1.9375f);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.6875f;
    }

    public double func_70042_X() {
        return 1.8125;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float offset = 0.9375f;
            float f3 = this.getStandingAnimationScale(0.0f);
            f3 *= f3;
            this.vec[0] = 0.0f;
            this.vec[1] = offset;
            this.vec[2] = 0.0625f + offset;
            this.vec = SimpleIK.rotateX(this.vec, -f3 * (float)Math.PI / 6.0f);
            this.vec[1] = this.vec[1] - offset;
            this.vec[2] = this.vec[2] - offset;
            this.vec = SimpleIK.rotateY(this.vec, -((float)Math.toRadians(this.field_70761_aq)));
            passenger.func_70107_b(this.field_70165_t + (double)this.vec[0], this.field_70163_u + this.func_70042_X() + passenger.func_70033_W() + (double)this.vec[1], this.field_70161_v + (double)this.vec[2]);
        }
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptMeat((EntityAnimalMist)this, 0.6, 1.0, true, 16.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIAttackMelee((EntityCreature)this, 1.2, false));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowParentGender(this, 1.15));
        this.field_70714_bg.func_75776_a(4, new AIAvoidEntity<EntityPlayer>(EntityPlayer.class, 16.0f, 1.0, 1.15));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, new AIAttackEntity<EntityPlayer>(EntityPlayer.class, true, false));
        this.field_70715_bh.func_75776_a(5, new AIAttackEntity<EntityForestRunner>(EntityForestRunner.class, true, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.9);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(2) + 1) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextBoolean();
    }

    public int func_70627_aG() {
        return 400;
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_MONK_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_MONK_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_MONK_DEATH;
    }

    @Override
    protected void func_180429_a(BlockPos pos, Block block) {
        if (!block.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = block.func_185467_w();
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.func_185467_w();
            }
            this.func_184185_a(SoundEvents.field_190030_ev, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(MistSounds.ENTITY_MONK_WARNING, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getStandingAnimationScale(float partialTicks) {
        return (this.clientSideStandAnimation0 + (this.clientSideStandAnimation - this.clientSideStandAnimation0) * partialTicks) / 6.0f;
    }

    @Override
    public float getSpeedMultipler() {
        return 0.3f;
    }

    @Override
    public float getSpintMultipler() {
        return 1.2f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70909_n() && !player.field_71075_bZ.field_75098_d) return this.tamedProcess(player, stack);
        if (player.func_70093_af()) {
            if (this.func_70631_g_()) return false;
            this.openGUI(player);
            return true;
        }
        if (this.func_70877_b(stack)) {
            if (!(this.func_110143_aJ() < this.func_110138_aP())) return super.func_184645_a(player, hand);
            this.func_175505_a(player, stack);
            this.func_70691_i(5.0f);
            return this.tamedProcess(player, stack);
        } else {
            if (stack.func_77973_b() == Items.field_151057_cb) {
                stack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            if (!this.hasChest() && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockChest) {
                this.setChested(true);
                this.playChestEquipSound();
                this.initHorseChest();
                this.horseChest.func_70299_a(1, stack.func_77979_a(1));
                if (!stack.func_190926_b()) return true;
                player.func_184611_a(hand, ItemStack.field_190927_a);
                return true;
            }
            if (this.isSaddled() && !this.func_184207_aI() && this.isRiddingItem(player.func_184614_ca()) && this.isRiddingItem(player.func_184592_cb())) {
                this.startRiding(player);
                return true;
            }
            if (stack.func_77973_b() != Items.field_151141_av || !this.func_70909_n() || this.isSaddled() || this.func_70631_g_()) return false;
            this.horseChest.func_70299_a(0, stack.func_77979_a(1));
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            this.updateHorseSlots();
            return true;
        }
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (this.field_70756_c == 0L && this.func_180425_c().func_177951_i((Vec3i)owner.func_180425_c()) <= 1024.0 && !(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityTameable teamable;
            if (target instanceof EntityAnimalMist) {
                return !this.func_70909_n();
            }
            if (target instanceof EntityTameable && (teamable = (EntityTameable)target).func_70909_n() && teamable.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse && ((AbstractHorse)target).func_110248_bS() || target instanceof AbstractMistMount && ((AbstractMistMount)target).func_70909_n());
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            if (this.func_110143_aJ() <= 0.0f) {
                this.closePanic(EntityMonk.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(1000) + 1000);
            }
            this.setRevengeTime(this.field_70756_c + (long)this.field_70146_Z.nextInt((int)(200.0f * amount) + 1) + (long)((int)(100.0f * amount)) + 100L);
        }
        return flag;
    }

    @Override
    protected <T extends EntityAnimalMist> void closePanic(Class<T> clazz, EntityPlayer sourse, long time) {
        List list = this.field_70170_p.func_72872_a(clazz, this.func_174813_aQ().func_72314_b(16.0, 3.0, 16.0));
        for (EntityAnimalMist entity : list) {
            if (!entity.func_70631_g_() || !entity.func_70635_at().func_75522_a((Entity)sourse)) continue;
            entity.setRevengeTime(time);
        }
    }

    public boolean func_70652_k(Entity entity) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.func_70631_g_() ? damage / 2.0f : damage);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.MONK_LOOT;
    }

    @Override
    protected int getSkillPoint() {
        return 2;
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(this.getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityMonk entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (this.field_70756_c == 0L) {
            return this.isOnTeam(entity);
        }
        return false;
    }

    public boolean isOnTeam(Entity entity) {
        if (this.func_70909_n()) {
            EntityLivingBase owner = this.func_70902_q();
            if (entity == owner) {
                return true;
            }
            if (owner != null) {
                return owner.func_184191_r(entity);
            }
        }
        return this.func_184194_a(entity.func_96124_cp());
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityMonk(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151078_bh) {
            return false;
        }
        return item instanceof ItemFood && ((ItemFood)item).func_77845_h();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public float[] getPassangerOffset(float[] vec, float limbSwing, float limbSwingAmount) {
        return ModelMonk.getPassangerOffset(vec, limbSwing, limbSwingAmount);
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        if (livingdata instanceof GroupData) {
            if (((GroupData)livingdata).madeParent) {
                this.func_70873_a(-24000);
            } else {
                this.setFemale(true);
                ((GroupData)livingdata).madeParent = this.field_70146_Z.nextBoolean();
            }
        } else {
            GroupData data = new GroupData();
            data.madeParent = this.isFemale() && this.field_70146_Z.nextBoolean();
            livingdata = data;
        }
        return livingdata;
    }

    @Override
    public int getTameLevel() {
        return 6;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean madeParent;

        private GroupData() {
        }
    }

    class AIAttackEntity<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIAttackEntity(Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
            super((EntityCreature)EntityMonk.this, classTarget, checkSight, onlyNearby);
        }

        public boolean func_75250_a() {
            if (EntityMonk.this.func_70631_g_()) {
                return false;
            }
            boolean check = super.func_75250_a();
            if (this.field_75309_a != null && this.field_75309_a.func_184187_bx() instanceof EntityMonk && EntityMonk.this.func_70643_av() != this.field_75309_a) {
                return false;
            }
            if (EntityMonk.this.func_70909_n()) {
                return !EntityMonk.this.func_152114_e(this.field_75309_a) && this.field_75309_a == EntityMonk.this.func_70643_av();
            }
            if (check && (EntityMonk.this.aiTempt == null || !EntityMonk.this.aiTempt.isRunning())) {
                return EntityMonk.this.func_70635_at().func_75522_a((Entity)this.field_75309_a);
            }
            return false;
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityMonk.this, true, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityMonk.this.func_70631_g_()) {
                this.func_75251_c();
            }
        }

        protected void func_179446_a(EntityCreature creature, EntityLivingBase entityLivingBase) {
            if (creature instanceof EntityMonk && !creature.func_70631_g_()) {
                creature.func_70604_c(entityLivingBase);
            }
        }
    }

    class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity {
        public AIAvoidEntity(Class<T> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
            super((EntityCreature)EntityMonk.this, classToAvoid, avoidDistance, farSpeed, nearSpeed);
        }

        public boolean func_75250_a() {
            return EntityMonk.this.func_70631_g_() && EntityMonk.this.field_70756_c > 0L && super.func_75250_a();
        }
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super((EntityCreature)EntityMonk.this, 1.5);
        }

        public boolean func_75250_a() {
            return !EntityMonk.this.func_70631_g_() && !EntityMonk.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityCreature creature, double speed, boolean useLongMemory) {
            super(creature, speed, useLongMemory);
        }

        public boolean func_75250_a() {
            if (EntityMonk.this.func_70631_g_()) {
                return false;
            }
            return super.func_75250_a();
        }

        protected void func_190102_a(EntityLivingBase entity, double distance) {
            double d0 = this.func_179512_a(entity);
            if (distance <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)entity);
                EntityMonk.this.setStanding(false);
            } else if (distance <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityMonk.this.setStanding(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityMonk.this.setStanding(true);
                    EntityMonk.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
                EntityMonk.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityMonk.this.setStanding(false);
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 9.0f + attackTarget.field_70130_N;
        }
    }
}

