/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIFollowSame;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;
import ru.liahim.mist.item.ItemMistFoodOnStick;

public class EntityMomo
extends EntityAlbino {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityMomo.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(EntityMomo.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<ItemStack> TEMPTATION_STACKS = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, 17)});
    private float xRotFactor = this.func_70090_H() || this.func_180799_ab() ? 0.0f : 1.0f;
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;
    private static long pregnantTime = MistTime.getDayInMonth() * 18000;
    private AIHurtByAggressor aiHurt;
    private int angerLevel;
    private UUID angerTargetUUID;

    public EntityMomo(World world) {
        super(world);
        this.func_70105_a(1.25f, 1.125f);
    }

    public double func_70042_X() {
        return this.isFemale() ? 0.8 : 0.9;
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptTamed((EntityAnimalMist)this, 1.2, 1.2, false, TEMPTATION_STACKS);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AILeapAtTarget(0.4f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAttackMelee(this, 1.45f, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIFollowParentGender(this, 1.1));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new AIAvoidEntity(this, EntityPlayer.class, 16.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIFollowSame((EntityLiving)this, 1.0, 12.0, 24.0));
        this.aiHurt = new AIHurtByAggressor(this);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiHurt);
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new AITargetAggressor(this));
    }

    @Override
    protected void func_70619_bc() {
        if (this.isAngry()) {
            --this.angerLevel;
        }
        if (this.angerLevel > 0 && this.angerTargetUUID != null && this.field_70717_bb == null) {
            EntityPlayer entityplayer;
            this.field_70717_bb = entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            this.field_70718_bc = this.func_142015_aE();
        }
        super.func_70619_bc();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(2) + 2) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextInt(3) != 0;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        return this.boosting || this.func_70877_b(ItemMistFoodOnStick.getFood(entityplayer.func_184614_ca())) || this.func_70877_b(ItemMistFoodOnStick.getFood(entityplayer.func_184592_cb()));
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
        }
        super.func_184206_a(key);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    private void becomeAngryAt(Entity entity) {
        this.angerLevel = 300 + this.field_70146_Z.nextInt(300);
        this.setRevengeTime(1000 + this.field_70146_Z.nextInt(1000));
        if (entity != null && entity instanceof EntityLivingBase) {
            this.angerTargetUUID = ((EntityLivingBase)entity).func_110124_au();
        }
    }

    public boolean isAngry() {
        return this.angerLevel > 0;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Saddle", this.isSaddled());
        compound.func_74777_a("Anger", (short)this.angerLevel);
        if (this.angerTargetUUID != null) {
            compound.func_74778_a("HurtBy", this.angerTargetUUID.toString());
        } else {
            compound.func_74778_a("HurtBy", "");
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
        this.angerLevel = compound.func_74765_d("Anger");
        String s = compound.func_74779_i("HurtBy");
        if (!s.isEmpty()) {
            this.angerTargetUUID = UUID.fromString(s);
            EntityPlayer entityplayer = this.field_70170_p.func_152378_a(this.angerTargetUUID);
            if (entityplayer != null) {
                this.field_70717_bb = entityplayer;
                this.field_70718_bc = this.func_142015_aE();
            }
        }
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_MOMO_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_MOMO_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_MOMO_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_70909_n() || player.field_71075_bZ.field_75098_d) {
            if (this.func_70877_b(stack)) {
                return super.func_184645_a(player, hand);
            }
            if (stack.func_77973_b() == Items.field_151057_cb) {
                stack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            if (this.isSaddled() && !this.func_184207_aI()) {
                this.startRiding(player);
                return true;
            }
            if (stack.func_77973_b() == Items.field_151141_av && !this.isSaddled() && !this.func_70631_g_()) {
                this.setSaddled(true);
                this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                stack.func_190918_g(1);
                return true;
            }
            return false;
        }
        return this.tamedProcess(player, stack);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            this.setRevengeTime(1000 + this.field_70146_Z.nextInt(1000));
            if (this.func_110143_aJ() <= 0.0f) {
                this.aiHurt.func_75249_e();
            }
        }
        return flag;
    }

    public boolean func_70652_k(Entity entity) {
        return entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.MOMO_LOOT;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70099_a((ItemStack)TEMPTATION_STACKS.toArray()[this.field_70146_Z.nextInt(TEMPTATION_STACKS.size())], 0.0f);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 0.4375f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.boosting && this.boostTime++ > this.totalBoostTime) {
                this.boosting = false;
            }
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                if (this.boosting) {
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_191986_a(0.0f, 0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        this.field_70180_af.func_187227_b(BOOST_TIME, (Object)this.totalBoostTime);
        return true;
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        if (this.field_70170_p.field_72995_K) {
            this.xRotFactor = this.func_70090_H() || this.func_180799_ab() ? Math.max(this.xRotFactor - 0.05f, 0.0f) : Math.min(this.xRotFactor + 0.05f, 1.0f);
        } else if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        super.func_70636_d();
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityMomo entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityMomo(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        for (ItemStack st : TEMPTATION_STACKS) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float getXRotFactor(float tick) {
        return this.xRotFactor;
    }

    @Override
    public boolean isDriven() {
        return true;
    }

    @Override
    public int getTameLevel() {
        return 1;
    }

    class AILeapAtTarget
    extends EntityAILeapAtTarget {
        EntityLiving field_75328_a;

        public AILeapAtTarget(float leapMotionY) {
            super((EntityLiving)EntityMomo.this, leapMotionY);
            this.field_75328_a = EntityMomo.this;
        }

        public boolean func_75250_a() {
            return this.field_75328_a.func_70638_az() != null && !this.field_75328_a.func_70638_az().field_70128_L && super.func_75250_a();
        }
    }

    class AIAvoidEntity
    extends EntityAIAvoidEntity {
        public AIAvoidEntity(EntityMomo entity, Class<EntityPlayer> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
            super((EntityCreature)entity, classToAvoid, avoidDistance, farSpeed, nearSpeed);
        }

        public boolean func_75250_a() {
            return ((EntityMomo)this.field_75380_a).field_70756_c > 0L && super.func_75250_a();
        }
    }

    class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityMomo entity, float speed, boolean useLongMemory) {
            super((EntityCreature)entity, (double)speed, useLongMemory);
        }

        public boolean func_75250_a() {
            return !((EntityMomo)this.field_75441_b).isPregnant() && this.field_75441_b.func_110143_aJ() > this.field_75441_b.func_110138_aP() / 2.0f && super.func_75250_a();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N * 2.0f + attackTarget.field_70130_N;
        }
    }

    class AITargetAggressor
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AITargetAggressor(EntityMomo entity) {
            super((EntityCreature)entity, EntityPlayer.class, true);
        }

        public boolean func_75250_a() {
            return ((EntityMomo)this.field_75299_d).isAngry() && super.func_75250_a();
        }

        public void func_75251_c() {
            super.func_75251_c();
            ((EntityMomo)this.field_75299_d).func_70624_b(null);
            ((EntityMomo)this.field_75299_d).func_70604_c(null);
        }
    }

    class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityMomo entity) {
            super((EntityCreature)entity, true, new Class[0]);
        }

        public boolean func_75250_a() {
            if (super.func_75250_a() && !((EntityTameable)this.field_75299_d).func_70909_n()) {
                double d0 = this.func_111175_f();
                for (EntityCreature entitycreature : this.field_75299_d.field_70170_p.func_72872_a(this.field_75299_d.getClass(), new AxisAlignedBB(this.field_75299_d.field_70165_t, this.field_75299_d.field_70163_u, this.field_75299_d.field_70161_v, this.field_75299_d.field_70165_t + 1.0, this.field_75299_d.field_70163_u + 1.0, this.field_75299_d.field_70161_v + 1.0).func_72314_b(d0, 10.0, d0))) {
                    if (this.field_75299_d == entitycreature || this.field_75299_d.func_70631_g_()) continue;
                    return true;
                }
            }
            return false;
        }

        public void func_75249_e() {
            ((EntityMomo)this.field_75299_d).becomeAngryAt((Entity)this.field_188509_g);
            super.func_75249_e();
        }

        protected void func_179446_a(EntityCreature creature, EntityLivingBase entityLivingBase) {
            super.func_179446_a(creature, entityLivingBase);
            if (creature instanceof EntityMomo) {
                ((EntityMomo)creature).becomeAngryAt((Entity)entityLivingBase);
            }
        }
    }
}

