/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.AbstractMistMount;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.EntityMomo;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptMeat;

public class EntityHulter
extends EntityAlbino {
    private static final DataParameter<Boolean> IS_STANDING = EntityDataManager.func_187226_a(EntityHulter.class, (DataSerializer)DataSerializers.field_187198_h);
    private static long pregnantTime = MistTime.getDayInMonth() * 24000;
    private float clientSideStandAnimation0;
    private float clientSideStandAnimation;
    private int warningSoundTicks;

    public EntityHulter(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.func_70105_a(1.8f, 2.4f);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.6875f;
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptMeat((EntityAnimalMist)this, 0.6, 1.0, true, 16.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIAttackMelee((EntityCreature)this, 1.15, false));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowParentGender(this, 1.15));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, new AIAttackPlayer<EntityPlayer>(EntityPlayer.class, true, false));
        this.field_70715_bh.func_75776_a(5, new AIAttackPlayer<EntityMomo>(EntityMomo.class, true, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_STANDING, (Object)false);
    }

    public boolean isStanding() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_STANDING);
    }

    public void setStanding(boolean standing) {
        this.field_70180_af.func_187227_b(IS_STANDING, (Object)standing);
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(2) + 1) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextBoolean();
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_HULTER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_HULTER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_HULTER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    protected void playWarningSound() {
        if (this.warningSoundTicks <= 0) {
            this.func_184185_a(MistSounds.ENTITY_HULTER_WARNING, 1.0f, this.func_70647_i());
            this.warningSoundTicks = 40;
        }
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f + 1.2f : (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f + 1.0f;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.clientSideStandAnimation0 = this.clientSideStandAnimation;
            this.clientSideStandAnimation = this.isStanding() ? MathHelper.func_76131_a((float)(this.clientSideStandAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientSideStandAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
        if (this.warningSoundTicks > 0) {
            --this.warningSoundTicks;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getStandingAnimationScale(float partialTicks) {
        return (this.clientSideStandAnimation0 + (this.clientSideStandAnimation - this.clientSideStandAnimation0) * partialTicks) / 6.0f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70909_n() && !player.field_71075_bZ.field_75098_d) return this.tamedProcess(player, stack);
        if (this.func_70877_b(stack)) {
            if (!(this.func_110143_aJ() < this.func_110138_aP())) return super.func_184645_a(player, hand);
            this.func_175505_a(player, stack);
            this.func_70691_i(5.0f);
            return this.tamedProcess(player, stack);
        } else {
            if (stack.func_77973_b() != Items.field_151057_cb) return false;
            stack.func_111282_a(player, (EntityLivingBase)this, hand);
            return true;
        }
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (this.field_70756_c == 0L && this.func_180425_c().func_177951_i((Vec3i)owner.func_180425_c()) <= 1024.0 && !(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityTameable teamable;
            if (target instanceof EntityAnimalMist) {
                return !this.func_70909_n();
            }
            if (target instanceof EntityTameable && (teamable = (EntityTameable)target).func_70909_n() && teamable.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse && ((AbstractHorse)target).func_110248_bS() || target instanceof AbstractMistMount && ((AbstractMistMount)target).func_70909_n());
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            this.setRevengeTime(this.field_70756_c + (long)this.field_70146_Z.nextInt((int)(200.0f * amount) + 1) + (long)((int)(100.0f * amount)) + 100L);
        }
        return flag;
    }

    public boolean func_70652_k(Entity entity) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.func_70631_g_() ? damage / 2.0f : damage);
        if (flag) {
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.HULTER_LOOT;
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityHulter entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityHulter(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151078_bh) {
            return false;
        }
        return item instanceof ItemFood && ((ItemFood)item).func_77845_h();
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        if (livingdata instanceof GroupData) {
            if (((GroupData)livingdata).madeParent) {
                this.func_70873_a(-24000);
            } else {
                this.setFemale(true);
                ((GroupData)livingdata).madeParent = this.field_70146_Z.nextBoolean();
            }
        } else {
            GroupData data = new GroupData();
            data.madeParent = this.isFemale() && this.field_70146_Z.nextBoolean();
            livingdata = data;
        }
        return livingdata;
    }

    @Override
    public int getTameLevel() {
        return 4;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean madeParent;

        private GroupData() {
        }
    }

    class AIAttackPlayer<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIAttackPlayer(Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
            super((EntityCreature)EntityHulter.this, classTarget, checkSight, onlyNearby);
        }

        public boolean func_75250_a() {
            boolean check = super.func_75250_a();
            if (EntityHulter.this.func_70909_n()) {
                return !EntityHulter.this.func_152114_e(this.field_75309_a) && this.field_75309_a == EntityHulter.this.func_70643_av();
            }
            if (check && (EntityHulter.this.aiTempt == null || !EntityHulter.this.aiTempt.isRunning())) {
                return EntityHulter.this.func_70635_at().func_75522_a((Entity)this.field_75309_a);
            }
            return false;
        }
    }

    class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityCreature creature, double speed, boolean useLongMemory) {
            super(creature, speed, useLongMemory);
        }

        protected void func_190102_a(EntityLivingBase entity, double distance) {
            double d0 = this.func_179512_a(entity);
            if (distance <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)entity);
                EntityHulter.this.setStanding(false);
            } else if (distance <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityHulter.this.setStanding(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityHulter.this.setStanding(true);
                    EntityHulter.this.playWarningSound();
                }
            } else {
                this.field_75439_d = 20;
                EntityHulter.this.setStanding(false);
            }
        }

        public void func_75251_c() {
            EntityHulter.this.setStanding(false);
            super.func_75251_c();
        }
    }
}

