/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.entity.EntityMobMist;
import ru.liahim.mist.world.biome.BiomeMist;

public class EntityGraveBug
extends EntityMobMist {
    private static final DataParameter<Byte> COLOR_TYPE = EntityDataManager.func_187226_a(EntityGraveBug.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Boolean> IS_CHILD = EntityDataManager.func_187226_a(EntityGraveBug.class, (DataSerializer)DataSerializers.field_187198_h);

    public EntityGraveBug(World world) {
        super(world);
        this.func_70105_a(0.75f, 0.5f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.4f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AISpiderAttack(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 2, true, false, (Predicate)null));
    }

    public float func_70047_e() {
        return 0.25f;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(IS_CHILD, (Object)false);
    }

    public void setColorType(int color) {
        this.field_70180_af.func_187227_b(COLOR_TYPE, (Object)((byte)color));
    }

    public byte getColorType() {
        return (Byte)this.field_70180_af.func_187225_a(COLOR_TYPE);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_CHILD);
    }

    public void setChild(boolean child) {
        this.field_70180_af.func_187227_b(IS_CHILD, (Object)child);
        if (child) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 0.5);
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b() * 0.5);
        }
        this.setChildSize(child);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (IS_CHILD.equals(key)) {
            this.setChildSize(this.func_70631_g_());
        }
        super.func_184206_a(key);
    }

    public void setChildSize(boolean isChild) {
        if (isChild) {
            super.func_70105_a(0.5f, 0.25f);
        } else {
            super.func_70105_a(0.75f, 0.5f);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("ColorType", this.getColorType());
        if (this.func_70631_g_()) {
            compound.func_74757_a("IsBaby", true);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorType(compound.func_74771_c("ColorType"));
        if (compound.func_74767_n("IsBaby")) {
            this.setChild(true);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_GRAVE_BUG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return MistSounds.ENTITY_GRAVE_BUG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_GRAVE_BUG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(MistSounds.ENTITY_GRAVE_BUG_STEP, 0.5f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.GRAVE_BUG_LOOT;
    }

    protected boolean func_146066_aG() {
        return !this.func_70631_g_();
    }

    public static boolean spawnBug(World world, BlockPos pos, Random rand) {
        if (!world.field_72995_K && rand.nextInt(6) == 0) {
            if (rand.nextInt(3) == 0) {
                for (int i = 0; i < rand.nextInt(3) + 3; ++i) {
                    EntityGraveBug bug = new EntityGraveBug(world);
                    bug.setChild(true);
                    bug.func_174828_a(pos.func_177963_a((double)(rand.nextFloat() * 0.5f + 0.25f), 0.0, (double)(rand.nextFloat() * 0.5f + 0.25f)), MathHelper.func_76142_g((float)(rand.nextFloat() * 360.0f)), 0.0f);
                    bug.func_180482_a(world.func_175649_E(new BlockPos((Vec3i)pos)), null);
                    bug.field_70759_as = bug.field_70177_z;
                    bug.field_70761_aq = bug.field_70177_z;
                    world.func_72838_d((Entity)bug);
                }
            } else {
                EntityGraveBug bug = new EntityGraveBug(world);
                bug.func_174828_a(pos, MathHelper.func_76142_g((float)(rand.nextFloat() * 360.0f)), 0.0f);
                bug.func_180482_a(world.func_175649_E(pos), null);
                bug.field_70759_as = bug.field_70177_z;
                bug.field_70761_aq = bug.field_70177_z;
                world.func_72838_d((Entity)bug);
            }
            return true;
        }
        return false;
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.ARTHROPOD;
    }

    public boolean func_70687_e(PotionEffect potioneffect) {
        return potioneffect.func_188419_a() == MobEffects.field_76436_u ? false : super.func_70687_e(potioneffect);
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity) && this.field_70146_Z.nextInt(4) == 0) {
            if (entity instanceof EntityLivingBase) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            EntityGraveBug entity;
            Class oclass;
            if (!this.field_70170_p.field_72995_K && (oclass = EntityList.getClass((ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)stack))) != null && ((Object)((Object)this)).getClass() == oclass && (entity = new EntityGraveBug(this.field_70170_p)) != null) {
                entity.setChild(true);
                entity.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                entity.func_180482_a(this.field_70170_p.func_175649_E(this.func_180425_c()), null);
                this.field_70170_p.func_72838_d((Entity)entity);
                if (stack.func_82837_s()) {
                    entity.func_96094_a(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        Potion potion;
        livingdata = super.func_180482_a(difficulty, livingdata);
        Biome biome = this.field_70170_p.func_180494_b(this.func_180425_c());
        int i = 0;
        if (biome instanceof BiomeMist && (i = ((BiomeMist)biome).getBiomeType().ordinal()) > EnumBiomeType.Swamp.ordinal()) {
            i = 0;
        }
        this.setColorType(i);
        if (livingdata == null) {
            livingdata = new GroupData();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD && this.field_70170_p.field_73012_v.nextFloat() < 0.1f * difficulty.func_180170_c()) {
                ((GroupData)livingdata).setRandomEffect(this.field_70170_p.field_73012_v);
            }
        }
        if (livingdata instanceof GroupData && (potion = ((GroupData)livingdata).effect) != null) {
            this.func_70690_d(new PotionEffect(potion, Integer.MAX_VALUE));
        }
        return livingdata;
    }

    public static class GroupData
    implements IEntityLivingData {
        public Potion effect;

        public void setRandomEffect(Random rand) {
            int i = rand.nextInt(5);
            if (i <= 1) {
                this.effect = MobEffects.field_76424_c;
            } else if (i <= 2) {
                this.effect = MobEffects.field_76420_g;
            } else if (i <= 3) {
                this.effect = MobEffects.field_76428_l;
            } else if (i <= 4) {
                this.effect = MobEffects.field_76441_p;
            }
        }
    }

    static class AISpiderAttack
    extends EntityAIAttackMelee {
        public AISpiderAttack(EntityGraveBug spider) {
            super((EntityCreature)spider, 1.0, true);
        }

        public boolean func_75253_b() {
            if (this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 2.0f + attackTarget.field_70130_N;
        }
    }
}

