/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import ru.liahim.mist.entity.EntityAnimalMist;

public abstract class EntityGender
extends EntityAnimalMist {
    protected static final DataParameter<Boolean> FEMALE = EntityDataManager.func_187226_a(EntityGender.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> PREGNANT = EntityDataManager.func_187226_a(EntityGender.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Byte> PREGNANT_STAGE = EntityDataManager.func_187226_a(EntityGender.class, (DataSerializer)DataSerializers.field_187191_a);
    private NBTTagList childTagList = new NBTTagList();
    private long conceptionTime;
    private int pregnantStage;

    public EntityGender(World world) {
        super(world);
    }

    public String getGenderTag() {
        if (this.isPregnant()) {
            if (this.pregnantStage == 0) {
                return "\u25cb";
            }
            if (this.pregnantStage == 1) {
                return "\u25d0";
            }
            return "\u25cf";
        }
        return "";
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FEMALE, (Object)false);
        this.field_70180_af.func_187214_a(PREGNANT, (Object)false);
        this.field_70180_af.func_187214_a(PREGNANT_STAGE, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        if (PREGNANT_STAGE.equals(key) && this.field_70170_p.field_72995_K) {
            this.pregnantStage = ((Byte)this.field_70180_af.func_187225_a(PREGNANT_STAGE)).byteValue();
        }
        super.func_184206_a(key);
    }

    private void setPregnantStage(int stage) {
        this.field_70180_af.func_187227_b(PREGNANT_STAGE, (Object)((byte)stage));
    }

    private int getPregnantStage() {
        return ((Byte)this.field_70180_af.func_187225_a(PREGNANT_STAGE)).byteValue();
    }

    private void setConceptionTime(long time) {
        this.conceptionTime = time;
        this.pregnantStage = this.calculatePregnantStage();
        this.setPregnantStage(this.pregnantStage);
    }

    private int calculatePregnantStage() {
        return MathHelper.func_76125_a((int)MathHelper.func_76141_d((float)((this.field_70170_p.func_82737_E() - this.conceptionTime) / (this.getPregnantTime() / 3L))), (int)0, (int)2);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.isPregnant()) {
            int i = this.calculatePregnantStage();
            if (this.pregnantStage != i) {
                this.pregnantStage = i;
                this.setPregnantStage(this.pregnantStage);
            }
            if (this.field_70170_p.func_82737_E() - this.conceptionTime > this.getPregnantTime()) {
                this.spawnBaby();
            }
        }
    }

    public boolean func_70878_b(EntityAnimal otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (((EntityGender)otherAnimal).isFemale() == this.isFemale()) {
            return false;
        }
        if (((EntityGender)otherAnimal).isPregnant() || this.isPregnant()) {
            return false;
        }
        return this.func_70880_s() && otherAnimal.func_70880_s();
    }

    public boolean isFemale() {
        return (Boolean)this.field_70180_af.func_187225_a(FEMALE);
    }

    public void setFemale(boolean female) {
        this.field_70180_af.func_187227_b(FEMALE, (Object)female);
    }

    public boolean isPregnant() {
        return this.isFemale() && (Boolean)this.field_70180_af.func_187225_a(PREGNANT) != false;
    }

    public void setPregnant(boolean pregnant) {
        this.field_70180_af.func_187227_b(PREGNANT, (Object)pregnant);
    }

    public void setChild(NBTTagList childTagList) {
        if (this.isFemale()) {
            this.childTagList = childTagList;
            this.setConceptionTime(this.field_70170_p.func_82737_E());
            this.setPregnant(true);
        }
    }

    private void spawnBaby() {
        if (this.canBirth()) {
            if (this.isPregnant()) {
                for (int i = 0; i < this.childTagList.func_74745_c(); ++i) {
                    EntityAgeable child = (EntityAgeable)EntityList.func_75615_a((NBTTagCompound)this.childTagList.func_150305_b(i), (World)this.field_70170_p);
                    child.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                    child.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)child)), (IEntityLivingData)null);
                    this.field_70170_p.func_72838_d((Entity)child);
                }
                this.childTagList = new NBTTagList();
                this.func_70873_a(6000);
                this.func_70661_as().func_75499_g();
            }
            this.setPregnant(false);
        } else {
            this.setConceptionTime(this.field_70170_p.func_82737_E() - this.getPregnantTime() + 100L);
        }
    }

    protected boolean canBirth() {
        return this.field_70122_E && !this.field_71087_bX && !this.func_70090_H() && !this.func_180799_ab() && !this.field_82175_bq && !this.field_70703_bu && !this.field_70134_J && (!this.func_70027_ad() || this.field_70178_ae);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            EntityAgeable child;
            Class oclass;
            if (!this.field_70170_p.field_72995_K && (oclass = EntityList.getClass((ResourceLocation)ItemMonsterPlacer.func_190908_h((ItemStack)stack))) != null && ((Object)((Object)this)).getClass() == oclass && (child = this.func_90011_a((EntityAgeable)this)) != null) {
                child.func_70873_a(-24000);
                child.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, 0.0f, 0.0f);
                child.func_180482_a(this.field_70170_p.func_175649_E(new BlockPos((Entity)child)), (IEntityLivingData)null);
                this.field_70170_p.func_72838_d((Entity)child);
                if (stack.func_82837_s()) {
                    child.func_96094_a(stack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Female", this.isFemale());
        compound.func_74757_a("Pregnant", this.isPregnant());
        compound.func_74772_a("ConceptionTime", this.conceptionTime);
        compound.func_74782_a("Child", (NBTBase)this.childTagList);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setFemale(compound.func_74767_n("Female"));
        this.setPregnant(compound.func_74767_n("Pregnant"));
        this.setConceptionTime(compound.func_74763_f("ConceptionTime"));
        this.childTagList = compound.func_150295_c("Child", 10);
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setFemale(this.initFemale());
        return super.func_180482_a(difficulty, livingdata);
    }

    protected abstract long getPregnantTime();

    public abstract int getChildCount();

    public abstract boolean initFemale();
}

