/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.entity.IMatWalkable;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.AbstractMistChestMount;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.EntityMossling;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptMeat;

public class EntityGalaga
extends AbstractMistChestMount
implements IMatWalkable {
    private static final DataParameter<Boolean> OPEN_MOUTH = EntityDataManager.func_187226_a(EntityGalaga.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> COLOR_TYPE = EntityDataManager.func_187226_a(EntityGalaga.class, (DataSerializer)DataSerializers.field_187191_a);
    private static long pregnantTime = MistTime.getDayInMonth() * 24000;
    private float clientOpenMouthAnimation0;
    private float clientOpenMouthAnimation;

    public EntityGalaga(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.func_70105_a(1.8f, 1.75f);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.6875f;
    }

    public double func_70042_X() {
        return 1.625;
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptMeat((EntityAnimalMist)this, 0.6, 1.0, true, 16.0);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAttackMelee((EntityCreature)this, 1.15, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, new AIAttackPlayer<EntityPlayer>(EntityPlayer.class, true, false));
        this.field_70715_bh.func_75776_a(2, new AIAttackPlayer<EntityMossling>(EntityMossling.class, true, false));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(3) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextBoolean();
    }

    public int func_70627_aG() {
        return 400;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_TYPE, (Object)0);
        this.field_70180_af.func_187214_a(OPEN_MOUTH, (Object)false);
    }

    public void setColorType(int color) {
        this.field_70180_af.func_187227_b(COLOR_TYPE, (Object)((byte)color));
    }

    public byte getColorType() {
        return (Byte)this.field_70180_af.func_187225_a(COLOR_TYPE);
    }

    public boolean isMouthOpened() {
        return (Boolean)this.field_70180_af.func_187225_a(OPEN_MOUTH);
    }

    public void setMouthOpened(boolean open) {
        this.field_70180_af.func_187227_b(OPEN_MOUTH, (Object)open);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("ColorType", this.getColorType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorType(compound.func_74771_c("ColorType"));
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        IEntityLivingData eld = super.func_180482_a(difficulty, livingdata);
        if (!this.isFemale()) {
            this.setColorType(this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(7) + 1) + 1);
        }
        return eld;
    }

    public boolean func_70648_aU() {
        return true;
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_GALAGA_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_GALAGA_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_GALAGA_DEATH;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.clientOpenMouthAnimation0 = this.clientOpenMouthAnimation;
            this.clientOpenMouthAnimation = this.isMouthOpened() ? MathHelper.func_76131_a((float)(this.clientOpenMouthAnimation + 1.0f), (float)0.0f, (float)6.0f) : MathHelper.func_76131_a((float)(this.clientOpenMouthAnimation - 1.0f), (float)0.0f, (float)6.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getOpenMouthAnimationScale(float partialTicks) {
        return (this.clientOpenMouthAnimation0 + (this.clientOpenMouthAnimation - this.clientOpenMouthAnimation0) * partialTicks) / 6.0f;
    }

    @Override
    public float getSpeedMultipler() {
        return 0.3f;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (!this.func_70909_n() && !player.field_71075_bZ.field_75098_d) return this.tamedProcess(player, stack);
        if (player.func_70093_af()) {
            if (this.func_70631_g_()) return false;
            this.openGUI(player);
            return true;
        }
        if (this.func_70877_b(stack)) {
            if (!(this.func_110143_aJ() < this.func_110138_aP())) return super.func_184645_a(player, hand);
            this.func_175505_a(player, stack);
            this.func_70691_i(5.0f);
            return this.tamedProcess(player, stack);
        } else {
            if (stack.func_77973_b() == Items.field_151057_cb) {
                stack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            if (!this.hasChest() && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockChest) {
                this.setChested(true);
                this.playChestEquipSound();
                this.initHorseChest();
                this.horseChest.func_70299_a(1, stack.func_77979_a(1));
                if (!stack.func_190926_b()) return true;
                player.func_184611_a(hand, ItemStack.field_190927_a);
                return true;
            }
            if (this.isSaddled() && !this.func_184207_aI() && this.isRiddingItem(player.func_184614_ca()) && this.isRiddingItem(player.func_184592_cb())) {
                this.startRiding(player);
                return true;
            }
            if (stack.func_77973_b() != Items.field_151141_av || !this.func_70909_n() || this.isSaddled() || this.func_70631_g_()) return false;
            this.horseChest.func_70299_a(0, stack.func_77979_a(1));
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            this.updateHorseSlots();
            return true;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            this.setRevengeTime(this.field_70756_c + (long)this.field_70146_Z.nextInt((int)(200.0f * amount) + 1) + (long)((int)(100.0f * amount)) + 100L);
        }
        return flag;
    }

    public boolean func_70652_k(Entity entity) {
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), this.func_70631_g_() ? damage / 2.0f : damage)) {
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70681_au().nextInt(4) == 0) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 1;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 2;
                }
                if (i > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, i * 50, 0));
                    if (((EntityLivingBase)entity).func_70681_au().nextBoolean()) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76421_d, i * 200, 2));
                    }
                }
            }
            this.func_174815_a((EntityLivingBase)this, entity);
            return true;
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.SALAM_LOOT;
    }

    protected float func_189749_co() {
        return 0.95f;
    }

    @Override
    public boolean childCheck() {
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityGalaga(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item == Items.field_151078_bh) {
            return false;
        }
        return item instanceof ItemFood && ((ItemFood)item).func_77845_h();
    }

    @Override
    public int getTameLevel() {
        return 5;
    }

    class AIAttackPlayer<T extends EntityLivingBase>
    extends EntityAINearestAttackableTarget<T> {
        public AIAttackPlayer(Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
            super((EntityCreature)EntityGalaga.this, classTarget, checkSight, onlyNearby);
        }

        public boolean func_75250_a() {
            boolean check = super.func_75250_a();
            if (this.field_75309_a != null && this.field_75309_a.func_184187_bx() instanceof EntityGalaga && EntityGalaga.this.func_70643_av() != this.field_75309_a) {
                return false;
            }
            if (EntityGalaga.this.func_70909_n()) {
                return !EntityGalaga.this.func_152114_e(this.field_75309_a) && this.field_75309_a == EntityGalaga.this.func_70643_av();
            }
            if (check && (EntityGalaga.this.aiTempt == null || !EntityGalaga.this.aiTempt.isRunning())) {
                return EntityGalaga.this.func_70635_at().func_75522_a((Entity)this.field_75309_a);
            }
            return false;
        }
    }

    class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityCreature creature, double speed, boolean useLongMemory) {
            super(creature, speed, useLongMemory);
        }

        protected void func_190102_a(EntityLivingBase entity, double distance) {
            double d0 = this.func_179512_a(entity);
            if (distance <= d0 && this.field_75439_d <= 0) {
                this.field_75439_d = 20;
                this.field_75441_b.func_70652_k((Entity)entity);
                EntityGalaga.this.setMouthOpened(false);
            } else if (distance <= d0 * 2.0) {
                if (this.field_75439_d <= 0) {
                    EntityGalaga.this.setMouthOpened(false);
                    this.field_75439_d = 20;
                }
                if (this.field_75439_d <= 10) {
                    EntityGalaga.this.setMouthOpened(true);
                }
            } else {
                this.field_75439_d = 20;
                EntityGalaga.this.setMouthOpened(false);
            }
        }

        public void func_75251_c() {
            EntityGalaga.this.setMouthOpened(false);
            super.func_75251_c();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N * 3.0f + attackTarget.field_70130_N;
        }
    }
}

