/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.EntityMonk;
import ru.liahim.mist.entity.ai.EntityAIFollowGender;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;

public class EntityForestRunner
extends EntityAlbino {
    private static final DataParameter<Integer> MILK_TIME = EntityDataManager.func_187226_a(EntityForestRunner.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<ItemStack> TEMPTATION_STACKS = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack(MistBlocks.TREE_SAPLING, 1, 3)});
    private static long pregnantTime = MistTime.getDayInMonth() * 24000;
    private int milkTimer;

    public EntityForestRunner(World world) {
        super(world);
        this.func_70105_a(1.2f, 1.3f);
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptTamed((EntityAnimalMist)this, 0.6, 1.2, true, TEMPTATION_STACKS);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParentGender(this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIFollowGender(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityPlayer.class, 16.0f, 1.0, 2.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityMonk.class, 17.0f, 1.5, 2.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    @Override
    protected void func_70619_bc() {
        if (this.milkTimer > 0) {
            --this.milkTimer;
            if (this.milkTimer == 0) {
                this.updateMilkTimer();
            }
        }
        super.func_70619_bc();
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(2) + 1) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextInt(4) != 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(MILK_TIME, (Object)0);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (MILK_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.milkTimer = (Integer)this.field_70180_af.func_187225_a(MILK_TIME);
        }
        super.func_184206_a(key);
    }

    private void updateMilkTimer() {
        this.field_70180_af.func_187227_b(MILK_TIME, (Object)this.milkTimer);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("MilkTime", this.milkTimer);
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.milkTimer = compound.func_74762_e("MilkTime");
        this.updateMilkTimer();
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_FOREST_RUNNER_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_FOREST_RUNNER_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_FOREST_RUNNER_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_70909_n() || player.field_71075_bZ.field_75098_d) {
            if (this.milkTimer == 0 && this.isFemale() && stack.func_77973_b() == Items.field_151133_ar && !player.field_71075_bZ.field_75098_d && !this.func_70631_g_()) {
                player.func_184185_a(SoundEvents.field_187564_an, 1.0f, 1.0f);
                stack.func_190918_g(1);
                if (stack.func_190926_b()) {
                    player.func_184611_a(hand, new ItemStack(Items.field_151117_aB));
                } else if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151117_aB))) {
                    player.func_71019_a(new ItemStack(Items.field_151117_aB), false);
                }
                this.milkTimer = 10000;
                this.updateMilkTimer();
                return true;
            }
            return super.func_184645_a(player, hand);
        }
        return this.tamedProcess(player, stack);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            if (this.func_110143_aJ() <= 0.0f) {
                this.closePanic(EntityForestRunner.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(8000) + 8000);
            } else {
                this.closePanic(EntityForestRunner.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(250) + 250);
            }
            this.setRevengeTime(this.field_70146_Z.nextInt((int)(500.0f * amount) + 1) + (int)(250.0f * amount) + 250);
        }
        return flag;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.FOREST_RUNNER_LOOT;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70099_a((ItemStack)TEMPTATION_STACKS.toArray()[this.field_70146_Z.nextInt(TEMPTATION_STACKS.size())], 0.0f);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.25f;
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityForestRunner entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityForestRunner(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        for (ItemStack st : TEMPTATION_STACKS) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @Override
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        super.func_180482_a(difficulty, livingdata);
        if (livingdata instanceof GroupData) {
            if (((GroupData)livingdata).init) {
                this.setFemale(false);
                ((GroupData)livingdata).init = false;
            } else {
                this.setFemale(true);
            }
        } else {
            livingdata = new GroupData();
        }
        return livingdata;
    }

    @Override
    public int getTameLevel() {
        return 2;
    }

    static class GroupData
    implements IEntityLivingData {
        public boolean init = true;

        private GroupData() {
        }
    }
}

