/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.base.Predicate;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.entity.EntityWaterMobMist;
import ru.liahim.mist.entity.ai.PathNavigateWaterMistUpper;

public class EntityDesertFish
extends EntityWaterMobMist {
    public EntityDesertFish(World world) {
        super(world);
        this.func_70105_a(0.875f, 0.875f);
        this.func_184644_a(PathNodeType.WATER, 8.0f);
        this.func_110163_bv();
    }

    @Override
    protected PathNavigate func_175447_b(World world) {
        return new PathNavigateWaterMistUpper((EntityLiving)this, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIAttack(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AISwimRandmly(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, 2, true, false, (Predicate)null));
    }

    public float func_70047_e() {
        return 0.25f;
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_DESERT_FISH_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return MistSounds.ENTITY_DESERT_FISH_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_DESERT_FISH_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(MistSounds.ENTITY_DESERT_FISH_STEP, 0.3f, 1.0f);
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f + 1.0f;
    }

    protected float func_70599_aP() {
        return 0.7f;
    }

    @Override
    public int func_70627_aG() {
        return 80;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.DESERT_FISH_LOOT;
    }

    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity instanceof EntityLivingBase) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 5;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 10;
                }
                if (i > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, i * 20, 0));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected int getAirVolum() {
        return 3000;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.func_70050_g(this.getAirVolum());
        return super.func_180482_a(difficulty, livingdata);
    }

    @Override
    public boolean func_70601_bi() {
        return true;
    }

    public static boolean spawnFish(World world, BlockPos pos, Random rand) {
        if (!world.field_72995_K) {
            EntityDesertFish fish = new EntityDesertFish(world);
            fish.func_174828_a(pos, MathHelper.func_76142_g((float)(rand.nextFloat() * 360.0f)), 0.0f);
            fish.func_180482_a(world.func_175649_E(pos), null);
            fish.field_70759_as = fish.field_70177_z;
            fish.field_70761_aq = fish.field_70177_z;
            world.func_72838_d((Entity)fish);
            return true;
        }
        return false;
    }

    static class AISwimRandmly
    extends EntityAIWander {
        public AISwimRandmly(EntityDesertFish fish) {
            super((EntityCreature)fish, 1.0);
        }

        @Nullable
        protected Vec3d func_190864_f() {
            Vec3d vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.field_75457_a, (int)10, (int)7);
            int i = 0;
            while (vec3d != null && this.field_75457_a.field_70170_p.func_180495_p(new BlockPos(vec3d)).func_185904_a() != Material.field_151586_h && i++ < 10) {
                vec3d = RandomPositionGenerator.func_75463_a((EntityCreature)this.field_75457_a, (int)10, (int)7);
            }
            return vec3d;
        }
    }

    static class AIAttack
    extends EntityAIAttackMelee {
        public AIAttack(EntityDesertFish fish) {
            super((EntityCreature)fish, 1.2, true);
        }

        public boolean func_75253_b() {
            if (this.field_75441_b.func_70681_au().nextInt(100) == 0) {
                this.field_75441_b.func_70624_b((EntityLivingBase)null);
                return false;
            }
            return super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 2.0f + attackTarget.field_70130_N;
        }
    }
}

