/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.AbstractMistMount;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIFollowSame;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;

public class EntityBrachiodon
extends EntityAlbino {
    private static final DataParameter<Byte> COLOR_TYPE = EntityDataManager.func_187226_a(EntityBrachiodon.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final Set<ItemStack> TEMPTATION_STACKS = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, 1), new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, 16)});
    private static long pregnantTime = MistTime.getDayInMonth() * 48000;

    public EntityBrachiodon(World world) {
        super(world);
        this.field_70728_aV = 5;
        this.func_70105_a(2.4f, 2.5f);
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptTamed((EntityAnimalMist)this, 0.6, 1.2, true, TEMPTATION_STACKS);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIAttackMelee());
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new AIPanic());
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIFollowParentGender(this, 1.25));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIFollowSame((EntityLiving)this, 1.0, 16.0, 32.0));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new AIHurtByTarget());
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIOwnerHurtByTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAIOwnerHurtTarget((EntityTameable)this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new AIAttackPlayer());
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new AINearestAttackableTarget());
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.6875f;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(7.0);
    }

    public boolean func_184652_a(EntityPlayer player) {
        return this.func_70909_n() && super.func_184652_a(player);
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        super.func_70636_d();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_TYPE, (Object)0);
    }

    public void setColorType(int color) {
        this.field_70180_af.func_187227_b(COLOR_TYPE, (Object)((byte)color));
    }

    public byte getColorType() {
        return (Byte)this.field_70180_af.func_187225_a(COLOR_TYPE);
    }

    public int func_70627_aG() {
        return 250;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74774_a("ColorType", this.getColorType());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorType(compound.func_74771_c("ColorType"));
    }

    @Override
    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setColorType(this.field_70146_Z.nextInt(4));
        return super.func_180482_a(difficulty, livingdata);
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_BRACHIODON_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return MistSounds.ENTITY_BRACHIODON_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_BRACHIODON_DEATH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_190030_ev, 0.15f, 1.0f);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.STEGO_LOOT;
    }

    @Override
    protected int getSkillPoint() {
        return 3;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            this.dropWool(cause, 0);
        }
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70099_a((ItemStack)TEMPTATION_STACKS.toArray()[this.field_70146_Z.nextInt(TEMPTATION_STACKS.size())], 0.0f);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_70909_n() || player.field_71075_bZ.field_75098_d) {
            boolean heal = false;
            if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                this.func_70691_i(5.0f);
                heal = true;
            }
            boolean mate = super.func_184645_a(player, hand);
            if (heal && !mate && !player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            return heal || mate;
        }
        return this.tamedProcess(player, stack);
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityBrachiodon entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (this.field_70756_c == 0L) {
            return this.isOnTeam(entity);
        }
        return false;
    }

    public boolean isOnTeam(Entity entity) {
        if (this.func_70909_n()) {
            EntityLivingBase owner = this.func_70902_q();
            if (entity == owner) {
                return true;
            }
            if (owner != null) {
                return owner.func_184191_r(entity);
            }
        }
        return this.func_184194_a(entity.func_96124_cp());
    }

    public boolean func_142018_a(EntityLivingBase target, EntityLivingBase owner) {
        if (this.field_70756_c == 0L && this.func_180425_c().func_177951_i((Vec3i)owner.func_180425_c()) <= 1024.0 && !(target instanceof EntityCreeper) && !(target instanceof EntityGhast)) {
            EntityTameable teamable;
            if (target instanceof EntityAnimalMist) {
                return !this.func_70909_n();
            }
            if (target instanceof EntityTameable && (teamable = (EntityTameable)target).func_70909_n() && teamable.func_70902_q() == owner) {
                return false;
            }
            if (target instanceof EntityPlayer && owner instanceof EntityPlayer && !((EntityPlayer)owner).func_96122_a((EntityPlayer)target)) {
                return false;
            }
            return !(target instanceof AbstractHorse && ((AbstractHorse)target).func_110248_bS() || target instanceof AbstractMistMount && ((AbstractMistMount)target).func_70909_n());
        }
        return false;
    }

    public boolean func_70877_b(ItemStack stack) {
        for (ItemStack st : TEMPTATION_STACKS) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public boolean func_70652_k(Entity entity) {
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            int i = this.func_70681_au().nextInt(6);
            if (i < 3) {
                entity.field_70181_x = entity.field_70181_x + (i == 0 ? 0.4 : 0.2);
            }
            this.func_174815_a((EntityLivingBase)this, entity);
        }
        return flag;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean flag = super.func_70097_a(source, amount);
        Entity entity = source.func_76346_g();
        if (flag && entity != null && entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            if (this.func_110143_aJ() <= 0.0f) {
                this.closePanic(EntityBrachiodon.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(4000) + 4000);
            } else {
                this.closePanic(EntityBrachiodon.class, (EntityPlayer)entity, this.field_70146_Z.nextInt(500) + 500);
            }
            this.setRevengeTime(this.field_70146_Z.nextInt((int)(500.0f * amount) + 1) + (int)(250.0f * amount) + 250);
        }
        return flag;
    }

    @Override
    public EntityAlbino getChild() {
        return new EntityBrachiodon(this.field_70170_p);
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(this.field_70146_Z.nextInt(2) + 1) + 1;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextBoolean();
    }

    @Override
    public int getTameLevel() {
        return 4;
    }

    class AINearestAttackableTarget
    extends EntityAINearestAttackableTarget {
        public AINearestAttackableTarget() {
            super((EntityCreature)EntityBrachiodon.this, EntityPlayer.class, false);
        }

        public boolean func_75250_a() {
            if (!EntityBrachiodon.this.func_70909_n() && EntityBrachiodon.this.field_70756_c > 0L) {
                return super.func_75250_a();
            }
            return false;
        }
    }

    class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee() {
            super((EntityCreature)EntityBrachiodon.this, 1.25, true);
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return this.field_75441_b.field_70130_N * this.field_75441_b.field_70130_N + attackTarget.field_70130_N;
        }
    }

    class AIPanic
    extends EntityAIPanic {
        public AIPanic() {
            super((EntityCreature)EntityBrachiodon.this, 1.5);
        }

        public boolean func_75250_a() {
            return !EntityBrachiodon.this.func_70631_g_() && !EntityBrachiodon.this.func_70027_ad() ? false : super.func_75250_a();
        }
    }

    class AIHurtByTarget
    extends EntityAIHurtByTarget {
        public AIHurtByTarget() {
            super((EntityCreature)EntityBrachiodon.this, true, new Class[0]);
        }

        public void func_75249_e() {
            super.func_75249_e();
            if (EntityBrachiodon.this.func_70631_g_()) {
                this.func_75251_c();
            }
        }

        protected void func_179446_a(EntityCreature creature, EntityLivingBase entityLivingBase) {
            if (creature instanceof EntityBrachiodon && !creature.func_70631_g_()) {
                creature.func_70604_c(entityLivingBase);
            }
        }
    }

    class AIAttackPlayer
    extends EntityAINearestAttackableTarget<EntityPlayer> {
        public AIAttackPlayer() {
            super((EntityCreature)EntityBrachiodon.this, EntityPlayer.class, 20, true, true, (Predicate)null);
        }

        public boolean func_75250_a() {
            if (EntityBrachiodon.this.func_70631_g_() || EntityBrachiodon.this.func_70909_n() && EntityBrachiodon.this.field_70756_c == 0L) {
                return false;
            }
            if (super.func_75250_a() && (EntityBrachiodon.this.aiTempt == null || !EntityBrachiodon.this.aiTempt.isRunning())) {
                return EntityBrachiodon.this.func_70635_at().func_75522_a((Entity)this.field_75309_a);
            }
            return false;
        }

        protected double func_111175_f() {
            for (EntityBrachiodon entitypolarbear : EntityBrachiodon.this.field_70170_p.func_72872_a(EntityBrachiodon.class, EntityBrachiodon.this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0))) {
                if (!entitypolarbear.func_70631_g_()) continue;
                return super.func_111175_f() * 0.5;
            }
            return 5.0;
        }
    }
}

