/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityAlbino;
import ru.liahim.mist.entity.EntityAnimalMist;
import ru.liahim.mist.entity.ai.EntityAIFollowParentGender;
import ru.liahim.mist.entity.ai.EntityAIFollowSame;
import ru.liahim.mist.entity.ai.EntityAIMateGender;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;
import ru.liahim.mist.item.ItemMistFoodOnStick;

public class EntityBarvog
extends EntityAlbino {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(EntityBarvog.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(EntityBarvog.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final Set<ItemStack> TEMPTATION_STACKS = Sets.newHashSet((Object[])new ItemStack[]{new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, 12), new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, 27)});
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;
    private static long pregnantTime = MistTime.getDayInMonth() * 24000;
    private AIHurtByAggressor aiHurt;

    public EntityBarvog(World world) {
        super(world);
        this.func_70105_a(1.6f, 1.4f);
    }

    public double func_70042_X() {
        return this.isFemale() ? 1.0 : 1.15;
    }

    protected void func_184651_r() {
        this.aiTempt = new EntityAITemptTamed((EntityAnimalMist)this, 1.2, 1.2, false, TEMPTATION_STACKS);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAILeapAtTarget((EntityLiving)this, 0.2f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new AIAttackMelee(this, 1.5, true));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new AIAvoidEntity(this, EntityPlayer.class, 16.0f, 1.0, 1.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.5));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMateGender(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.aiTempt);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIFollowParentGender(this, 1.1));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAIFollowSame((EntityLiving)this, 1.0, 12.0, 24.0));
        this.aiHurt = new AIHurtByAggressor(this);
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)this.aiHurt);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.5);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
    }

    public int func_70627_aG() {
        return 300;
    }

    @Override
    protected long getPregnantTime() {
        return pregnantTime;
    }

    @Override
    public int getChildCount() {
        return this.field_70146_Z.nextInt(4) + 2;
    }

    @Override
    public boolean initFemale() {
        return this.field_70146_Z.nextBoolean();
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer entityplayer = (EntityPlayer)entity;
        return this.boosting || this.func_70877_b(ItemMistFoodOnStick.getFood(entityplayer.func_184614_ca())) || this.func_70877_b(ItemMistFoodOnStick.getFood(entityplayer.func_184592_cb()));
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
        }
        super.func_184206_a(key);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Saddle", this.isSaddled());
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
    }

    protected SoundEvent func_184639_G() {
        return MistSounds.ENTITY_BARVOG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damage) {
        return MistSounds.ENTITY_BARVOG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return MistSounds.ENTITY_BARVOG_DEATH;
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187709_dP, 0.15f, 1.0f);
    }

    @Override
    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70756_c > 0L && !player.field_71075_bZ.field_75098_d) {
            return true;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (stack.func_77973_b() == Items.field_151063_bx) {
            return super.func_184645_a(player, hand);
        }
        if (this.func_70909_n() || player.field_71075_bZ.field_75098_d) {
            if (this.func_70877_b(stack)) {
                return super.func_184645_a(player, hand);
            }
            if (stack.func_77973_b() == Items.field_151057_cb) {
                stack.func_111282_a(player, (EntityLivingBase)this, hand);
                return true;
            }
            if (this.isSaddled() && !this.func_184207_aI()) {
                this.startRiding(player);
                return true;
            }
            if (stack.func_77973_b() == Items.field_151141_av && !this.isSaddled() && !this.func_70631_g_()) {
                this.setSaddled(true);
                this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                stack.func_190918_g(1);
                return true;
            }
            return false;
        }
        return this.tamedProcess(player, stack);
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K && this.isSaddled()) {
            this.func_145779_a(Items.field_151141_av, 1);
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()))) {
            if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70681_au().nextInt(4) == 0) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == EnumDifficulty.NORMAL) {
                    i = 1;
                } else if (this.field_70170_p.func_175659_aa() == EnumDifficulty.HARD) {
                    i = 2;
                }
                if (i > 0) {
                    ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76436_u, i * 50, 0));
                    if (((EntityLivingBase)entity).func_70681_au().nextBoolean()) {
                        ((EntityLivingBase)entity).func_70690_d(new PotionEffect(MobEffects.field_76431_k, i * 200, 1));
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTables.LAGUH_LOOT;
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.func_70099_a((ItemStack)TEMPTATION_STACKS.toArray()[this.field_70146_Z.nextInt(TEMPTATION_STACKS.size())], 0.0f);
        }
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public float func_70047_e() {
        return this.func_70631_g_() ? this.field_70131_O : 1.2f;
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        Entity entity;
        Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
        if (this.func_184207_aI() && this.func_82171_bF()) {
            this.field_70126_B = this.field_70177_z = entity.field_70177_z;
            this.field_70125_A = entity.field_70125_A * 0.5f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            this.field_70138_W = 1.0f;
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.boosting && this.boostTime++ > this.totalBoostTime) {
                this.boosting = false;
            }
            if (this.func_184186_bw()) {
                float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.225f;
                if (this.boosting) {
                    f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                }
                this.func_70659_e(f);
                super.func_191986_a(0.0f, 0.0f, 1.0f);
            } else {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f1 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0)) * 4.0f;
            if (f1 > 1.0f) {
                f1 = 1.0f;
            }
            this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70138_W = 0.5f;
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    @Override
    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        this.field_70180_af.func_187227_b(BOOST_TIME, (Object)this.totalBoostTime);
        return true;
    }

    @Override
    public void func_70636_d() {
        this.func_82168_bl();
        if (!this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        super.func_70636_d();
    }

    @Override
    public boolean childCheck() {
        List list = this.field_70170_p.func_72872_a(((Object)((Object)this)).getClass(), this.func_174813_aQ().func_72314_b(8.0, 4.0, 8.0));
        for (EntityBarvog entity : list) {
            if (!entity.func_70631_g_() || entity.canBeTempted() && entity.func_70909_n()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected EntityAlbino getChild() {
        return new EntityBarvog(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        for (ItemStack st : TEMPTATION_STACKS) {
            if (stack.func_77973_b() != st.func_77973_b() || stack.func_77952_i() != st.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDriven() {
        return true;
    }

    @Override
    public int getTameLevel() {
        return 3;
    }

    static class AIAvoidEntity
    extends EntityAIAvoidEntity {
        public AIAvoidEntity(EntityBarvog entity, Class<EntityPlayer> classToAvoid, float avoidDistance, double farSpeed, double nearSpeed) {
            super((EntityCreature)entity, classToAvoid, avoidDistance, farSpeed, nearSpeed);
        }

        public boolean func_75250_a() {
            return !((EntityBarvog)this.field_75380_a).func_70909_n() && this.field_75380_a.func_110143_aJ() <= this.field_75380_a.func_110138_aP() / 3.0f && super.func_75250_a();
        }
    }

    static class AIAttackMelee
    extends EntityAIAttackMelee {
        public AIAttackMelee(EntityBarvog entity, double speed, boolean useLongMemory) {
            super((EntityCreature)entity, speed, useLongMemory);
        }

        public boolean func_75250_a() {
            return !((EntityBarvog)this.field_75441_b).isPregnant() && this.field_75441_b.func_110143_aJ() > this.field_75441_b.func_110138_aP() / 3.0f && super.func_75250_a();
        }

        public boolean func_75253_b() {
            return this.field_75441_b.func_110143_aJ() > this.field_75441_b.func_110138_aP() / 3.0f && super.func_75253_b();
        }

        protected double func_179512_a(EntityLivingBase attackTarget) {
            return 4.0f + attackTarget.field_70130_N;
        }
    }

    static class AIHurtByAggressor
    extends EntityAIHurtByTarget {
        public AIHurtByAggressor(EntityBarvog entity) {
            super((EntityCreature)entity, false, new Class[0]);
        }

        public boolean func_75250_a() {
            return !((EntityTameable)this.field_75299_d).func_70909_n() && super.func_75250_a();
        }
    }
}

