/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import ru.liahim.mist.api.entity.IMatWalkable;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.entity.ai.EntityAITemptTamed;
import ru.liahim.mist.entity.ai.PathNavigateGroundMistUpper;
import ru.liahim.mist.entity.ai.PathNavigateGroundMistUpperSwamp;
import ru.liahim.mist.init.ModAdvancements;

public abstract class EntityAnimalMist
extends EntityTameable {
    protected long field_70756_c;
    protected EntityAITemptTamed aiTempt;
    protected static final int temptationStackDropChance = 4;

    public EntityAnimalMist(World world) {
        super(world);
        this.field_70138_W = 1.0f;
    }

    public void setRevengeTime(long time) {
        this.field_70756_c = time;
    }

    protected <T extends EntityAnimalMist> void closePanic(Class<T> clazz, EntityPlayer sourse, long time) {
        List list = this.field_70170_p.func_72872_a(clazz, this.func_174813_aQ().func_72314_b(16.0, 3.0, 16.0));
        for (EntityAnimalMist entity : list) {
            if (!entity.func_70635_at().func_75522_a((Entity)sourse)) continue;
            entity.setRevengeTime(time);
        }
    }

    protected void func_70619_bc() {
        if (this.field_70756_c > 0L) {
            --this.field_70756_c;
        }
        super.func_70619_bc();
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        Entity entity = cause.func_76346_g();
        if (entity instanceof EntityPlayer && !((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            ISkillCapaHandler.getHandler((EntityPlayer)entity).addSkill(ISkillCapaHandler.Skill.CUTTING, this.getSkillPoint());
        }
    }

    protected int getSkillPoint() {
        return 1;
    }

    protected void dropWool(DamageSource cause, int meta) {
        int i = this.field_70146_Z.nextInt(2);
        if (cause.func_76346_g() instanceof EntityPlayer) {
            int s = ISkillCapaHandler.Skill.getLevel((EntityPlayer)cause.func_76346_g(), ISkillCapaHandler.Skill.CUTTING);
            i += Math.min(this.field_70146_Z.nextInt(s), 2);
        }
        if (i > 0) {
            this.func_70099_a(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), i, meta), 0.0f);
        }
    }

    public boolean func_184191_r(Entity entity) {
        if (this.func_70909_n() && entity instanceof EntityPlayer) {
            return this.field_70756_c == 0L;
        }
        return super.func_184191_r(entity);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74772_a("RevengeTime", this.field_70756_c);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setRevengeTime(compound.func_74763_f("RevengeTime"));
    }

    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        if (!(ageable instanceof EntityTameable)) {
            return null;
        }
        EntityTameable child = this.getChild();
        child.func_70903_f(this.func_70909_n());
        child.func_184754_b(this.func_184753_b());
        child.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 0.5);
        return child;
    }

    public void func_70873_a(int age) {
        if (age >= 0 && this.func_70631_g_()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() * 2.0);
        }
        super.func_70873_a(age);
    }

    protected abstract EntityTameable getChild();

    public boolean canBeTempted() {
        return this.field_70756_c == 0L;
    }

    public boolean canBeTemptedByEntity(EntityPlayer player) {
        return this.getTameLevel() - ISkillCapaHandler.Skill.getLevel(player, ISkillCapaHandler.Skill.TAMING) <= 1;
    }

    public boolean isTamedByEntity(EntityPlayer player) {
        return this.func_70909_n();
    }

    public boolean childCheck() {
        return true;
    }

    protected boolean tamedProcess(EntityPlayer player, ItemStack stack) {
        if ((this.aiTempt == null || this.aiTempt.isRunning()) && this.func_70877_b(stack) && player.func_70068_e((Entity)this) < 9.0) {
            if (!this.field_70170_p.field_72995_K) {
                ISkillCapaHandler capa;
                int tameLevel;
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                if ((tameLevel = ISkillCapaHandler.Skill.TAMING.getLevel((capa = ISkillCapaHandler.getHandler(player)).getSkill(ISkillCapaHandler.Skill.TAMING))) >= this.getTameLevel() && this.field_70146_Z.nextInt(5) == 0 && !ForgeEventFactory.onAnimalTame((EntityAnimal)this, (EntityPlayer)player)) {
                    this.func_193101_c(player);
                    this.func_70604_c(null);
                    this.func_70624_b(null);
                    capa.addSkill(ISkillCapaHandler.Skill.TAMING, this.getTameLevel() * 5);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    if (player instanceof EntityPlayerMP) {
                        ModAdvancements.TAME_ANIMAL.trigger((EntityPlayerMP)player, this);
                    }
                } else {
                    capa.addSkill(ISkillCapaHandler.Skill.TAMING, Math.min(tameLevel, this.getTameLevel()));
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)6);
                }
            }
            return true;
        }
        return false;
    }

    protected void startRiding(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K && player.func_184220_m((Entity)this) && player instanceof EntityPlayerMP) {
            ModAdvancements.RIDING_ANIMAL.trigger((EntityPlayerMP)player, this);
        }
    }

    protected PathNavigate func_175447_b(World world) {
        return this instanceof IMatWalkable ? new PathNavigateGroundMistUpper((EntityLiving)this, world) : new PathNavigateGroundMistUpperSwamp((EntityLiving)this, world);
    }

    public abstract int getTameLevel();

    public boolean isDriven() {
        return false;
    }

    public boolean boost() {
        return false;
    }

    public static boolean isDriven(Entity entity) {
        return entity instanceof EntityAnimalMist && ((EntityAnimalMist)entity).isDriven();
    }
}

