/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import ru.liahim.mist.entity.EntityAlbino;

public abstract class AbstractMistMount
extends EntityAlbino
implements IInventoryChangedListener,
IJumpingMount {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(AbstractMistMount.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> SPRINT_TIME = EntityDataManager.func_187226_a(AbstractMistMount.class, (DataSerializer)DataSerializers.field_187192_b);
    private boolean sprinting;
    private int sprintTime;
    public ContainerHorseChest horseChest;
    protected boolean jump;
    protected boolean horseJumping;
    private IItemHandler itemHandler = null;

    public AbstractMistMount(World world) {
        super(world);
        this.field_70138_W = 1.0f;
        this.initHorseChest();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(SPRINT_TIME, (Object)0);
    }

    public boolean canBeSaddled() {
        return this.func_70909_n() && this.field_70756_c == 0L;
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public void setHorseJumping(boolean jumping) {
        this.horseJumping = jumping;
    }

    public void setSprintTime(int time) {
        this.field_70180_af.func_187227_b(SPRINT_TIME, (Object)time);
    }

    public boolean isHorseJumping() {
        return this.horseJumping;
    }

    public void sprint(boolean sprint) {
        this.sprinting = sprint;
        this.setSprintTime(this.sprintTime);
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        if (SPRINT_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.sprintTime = (Integer)this.field_70180_af.func_187225_a(SPRINT_TIME);
        }
        super.func_184206_a(key);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.sprinting && this.sprintTime > 0) {
            this.sprintTime = Math.max(this.sprintTime - 2, 0);
            if (this.sprintTime == 0) {
                this.setSprintTime(0);
            }
        }
    }

    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
            float f;
            EntityLivingBase passenger = (EntityLivingBase)this.func_184179_bs();
            forward = passenger.field_191988_bg * this.getSpeedMultipler();
            this.field_70126_B -= passenger.field_70702_br * 3.0f;
            this.field_70177_z = this.field_70126_B;
            this.field_70125_A = 0.0f;
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
            this.field_70761_aq = this.field_70177_z;
            this.field_70759_as = this.field_70177_z;
            if (forward <= 0.0f) {
                forward *= 0.5f;
            }
            if (this.jump && !this.isHorseJumping() && this.field_70122_E) {
                this.jump = false;
                this.field_70181_x = this.getHorseJumpStrength();
                if (this.func_70644_a(MobEffects.field_76430_j)) {
                    this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
                }
                this.setHorseJumping(true);
                this.field_70160_al = true;
                if (forward > 0.0f) {
                    f = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    float f1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                    this.field_70159_w += (double)(-0.4f * f);
                    this.field_70179_y += (double)(0.4f * f1);
                    this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
                }
            }
            this.field_70747_aH = this.func_70689_ay() * 0.1f;
            if (this.sprinting && this.sprintTime++ > this.getMaxSprintTime()) {
                this.sprint(false);
                passenger.func_70031_b(false);
            }
            if (this.func_184186_bw()) {
                f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e();
                if (passenger.func_70051_ag()) {
                    if (this.sprinting) {
                        f *= this.getSpintMultipler();
                    } else {
                        this.sprint(true);
                    }
                }
                this.func_70659_e(f);
                super.func_191986_a(strafe, vertical, forward);
            } else if (passenger instanceof EntityPlayer) {
                this.field_70159_w = 0.0;
                this.field_70181_x = 0.0;
                this.field_70179_y = 0.0;
            }
            if (this.field_70122_E) {
                this.setHorseJumping(false);
            }
            this.field_184618_aE = this.field_70721_aZ;
            double d1 = this.field_70165_t - this.field_70169_q;
            double d0 = this.field_70161_v - this.field_70166_s;
            float f2 = MathHelper.func_76133_a((double)(d1 * d1 + d0 * d0));
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            this.field_70721_aZ += (f2 - this.field_70721_aZ) * 0.4f;
            this.field_184619_aG += this.field_70721_aZ;
        } else {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(strafe, vertical, forward);
        }
    }

    public float getSpeedMultipler() {
        return 0.5f;
    }

    public float getSpintMultipler() {
        return 1.5f;
    }

    public double getHorseJumpStrength() {
        return 0.6;
    }

    public int getMaxSprintTime() {
        return 300;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_110206_u(int jumpPower) {
        if (this.func_184776_b() && jumpPower > 0) {
            this.jump = true;
        }
    }

    public boolean func_184776_b() {
        return this.isSaddled();
    }

    public void func_184775_b(int jumpPower) {
        if (this.func_184776_b() && jumpPower > 0) {
            this.jump = true;
        }
    }

    public void func_184777_r_() {
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public int getInventorySize() {
        return 2;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        if (!block.func_176223_P().func_185904_a().func_76224_d()) {
            SoundType soundtype = block.func_185467_w();
            if (this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150431_aC) {
                soundtype = Blocks.field_150431_aC.func_185467_w();
            }
            this.func_184185_a(SoundEvents.field_187566_ao, soundtype.func_185843_a() * 0.15f, soundtype.func_185847_b());
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        int i;
        if (distance > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((i = MathHelper.func_76123_f((float)((distance * 0.5f - 3.0f) * damageMultiplier))) > 0) {
            this.func_70097_a(DamageSource.field_76379_h, i);
            if (this.func_184207_aI()) {
                for (Entity entity : this.func_184182_bu()) {
                    entity.func_70097_a(DamageSource.field_76379_h, (float)i);
                }
            }
            IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
            Block block = iblockstate.func_177230_c();
            if (iblockstate.func_185904_a() != Material.field_151579_a && !this.func_174814_R()) {
                SoundType soundtype = block.func_185467_w();
                this.field_70170_p.func_184148_a((EntityPlayer)null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundtype.func_185844_d(), this.func_184176_by(), soundtype.func_185843_a() * 0.5f, soundtype.func_185847_b() * 0.75f);
            }
        }
    }

    public void openGUI(EntityPlayer player) {
        if ((!this.func_184207_aI() || this.func_184196_w((Entity)player)) && this.func_70909_n()) {
            this.horseChest.func_110133_a(this.func_70005_c_());
            player.openGui((Object)"mist", 8, this.field_70170_p, this.func_145782_y(), 0, 0);
        }
    }

    protected void initHorseChest() {
        ContainerHorseChest chest = this.horseChest;
        this.horseChest = new ContainerHorseChest("HorseChest", this.getInventorySize());
        this.horseChest.func_110133_a(this.func_70005_c_());
        if (chest != null) {
            chest.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(chest.func_70302_i_(), this.horseChest.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack stack = chest.func_70301_a(j);
                if (stack.func_190926_b()) continue;
                this.horseChest.func_70299_a(j, stack.func_77946_l());
            }
        }
        this.horseChest.func_110134_a((IInventoryChangedListener)this);
        this.updateHorseSlots();
        this.itemHandler = new InvWrapper((IInventory)this.horseChest);
    }

    protected void updateHorseSlots() {
        if (!this.field_70170_p.field_72995_K) {
            this.setSaddled(!this.horseChest.func_70301_a(0).func_190926_b() && this.canBeSaddled());
        }
    }

    public void func_76316_a(IInventory invBasic) {
        boolean flag = this.isSaddled();
        this.updateHorseSlots();
        if (this.field_70173_aa > 20 && !flag && this.isSaddled()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    public boolean wearsBag() {
        return false;
    }

    public boolean isBag(ItemStack stack) {
        return Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockChest;
    }

    public boolean func_174820_d(int slot, ItemStack stack) {
        int i = slot - 400;
        if (i == 0 && i < 2 && i < this.horseChest.func_70302_i_()) {
            if (i == 0 && stack.func_77973_b() != Items.field_151141_av) {
                return false;
            }
            if (i != 1 || this.wearsBag() && this.isBag(stack)) {
                this.horseChest.func_70299_a(i, stack);
                this.updateHorseSlots();
                return true;
            }
            return false;
        }
        int j = slot - 500 + 2;
        if (j >= 2 && j < this.horseChest.func_70302_i_()) {
            this.horseChest.func_70299_a(j, stack);
            return true;
        }
        return false;
    }

    @Override
    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (!this.field_70170_p.field_72995_K) {
            if (!this.field_70170_p.field_72995_K && this.isSaddled()) {
                this.func_145779_a(Items.field_151141_av, 1);
            }
            if (this.horseChest != null) {
                for (int i = 0; i < this.horseChest.func_70302_i_(); ++i) {
                    ItemStack stack = this.horseChest.func_70301_a(i);
                    if (stack.func_190926_b()) continue;
                    this.func_70099_a(stack, 0.0f);
                }
            }
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SprintTime", this.sprintTime);
        if (!this.horseChest.func_70301_a(0).func_190926_b()) {
            compound.func_74782_a("SaddleItem", (NBTBase)this.horseChest.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        ItemStack itemstack;
        super.func_70037_a(compound);
        this.sprintTime = compound.func_74762_e("SprintTime");
        if (compound.func_150297_b("SaddleItem", 10) && (itemstack = new ItemStack(compound.func_74775_l("SaddleItem"))).func_77973_b() == Items.field_151141_av) {
            this.horseChest.func_70299_a(0, itemstack);
        }
        this.updateHorseSlots();
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.itemHandler;
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

