/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.entity;

import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.world.World;
import ru.liahim.mist.entity.AbstractMistMount;

public abstract class AbstractMistChestMount
extends AbstractMistMount {
    private static final DataParameter<Boolean> DATA_ID_CHEST = EntityDataManager.func_187226_a(AbstractMistChestMount.class, (DataSerializer)DataSerializers.field_187198_h);

    public AbstractMistChestMount(World world) {
        super(world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_ID_CHEST, (Object)false);
    }

    public boolean hasChest() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_ID_CHEST);
    }

    public void setChested(boolean chested) {
        this.field_70180_af.func_187227_b(DATA_ID_CHEST, (Object)chested);
    }

    @Override
    public int getInventorySize() {
        return this.hasChest() ? 17 : super.getInventorySize();
    }

    public int getInventoryColumns() {
        return 5;
    }

    @Override
    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("ChestedHorse", this.hasChest());
        if (this.hasChest()) {
            NBTTagList list = new NBTTagList();
            for (int i = 1; i < this.horseChest.func_70302_i_(); ++i) {
                ItemStack stack = this.horseChest.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74774_a("Slot", (byte)i);
                stack.func_77955_b(nbt);
                list.func_74742_a((NBTBase)nbt);
            }
            compound.func_74782_a("Items", (NBTBase)list);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setChested(compound.func_74767_n("ChestedHorse"));
        if (this.hasChest()) {
            NBTTagList list = compound.func_150295_c("Items", 10);
            this.initHorseChest();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt = list.func_150305_b(i);
                int j = nbt.func_74771_c("Slot") & 0xFF;
                if (j < 1 || j >= this.horseChest.func_70302_i_()) continue;
                this.horseChest.func_70299_a(j, new ItemStack(nbt));
            }
        }
        this.updateHorseSlots();
    }

    @Override
    public boolean func_174820_d(int slot, ItemStack stack) {
        if (slot == 499) {
            if (this.hasChest() && stack.func_190926_b()) {
                this.setChested(false);
                this.initHorseChest();
                return true;
            }
            if (!this.hasChest() && Block.func_149634_a((Item)stack.func_77973_b()) instanceof BlockChest) {
                this.setChested(true);
                this.initHorseChest();
                return true;
            }
        }
        return super.func_174820_d(slot, stack);
    }

    protected boolean isRiddingItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        return !this.func_70877_b(stack) && item != Items.field_151063_bx && item != Items.field_151057_cb && (!this.isFemale() || this.func_70631_g_() || item != Items.field_151133_ar) && !(item instanceof ItemShears);
    }

    protected void playChestEquipSound() {
        this.func_184185_a(SoundEvents.field_187584_ax, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
    }
}

