/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.core.hooks;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.block.MistBlockStep;
import ru.liahim.mist.common.ClientProxy;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.core.asm.Hook;
import ru.liahim.mist.core.asm.ReturnCondition;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.util.FogTexture;
import ru.liahim.mist.util.TextureUtilForHook;

public class AnnotationHooks {
    @SideOnly(value=Side.CLIENT)
    @Hook(returnCondition=ReturnCondition.ON_TRUE)
    public static boolean addRainParticles(EntityRenderer er) {
        if (Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() == Mist.getID()) {
            ClientProxy.RainParticleRenderer.render(0.0f, Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x());
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Hook(injectOnExit=true)
    public static void read(Chunk chunk, PacketBuffer buf, int availableSections, boolean groundUpContinuous) {
        if (ModConfig.graphic.advancedFogRenderer && chunk.func_177412_p().field_72995_K && chunk.func_177412_p().field_73011_w.getDimension() == Mist.getID()) {
            FogTexture.createChunkTexture(chunk.func_177412_p(), chunk.field_76635_g, chunk.field_76647_h);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Hook(injectOnExit=true)
    public static void notifyBlockUpdate(RenderGlobal render, World world, BlockPos pos, IBlockState oldState, IBlockState newState, int flags) {
        if (ModConfig.graphic.advancedFogRenderer && world != null && world.field_72995_K && world.field_73011_w.getDimension() == Mist.getID() && (newState.getLightOpacity((IBlockAccess)world, pos) != oldState.getLightOpacity((IBlockAccess)world, pos) || newState.getLightValue((IBlockAccess)world, pos) != oldState.getLightValue((IBlockAccess)world, pos))) {
            FogTexture.createBlockTexture(world, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Hook(returnCondition=ReturnCondition.ON_TRUE, returnAnotherMethod="blendColorsHook")
    public static boolean blendColors(TextureUtil tu, int color_0, int color_1, int color_2, int color_3, boolean alpha) {
        return ModConfig.Graphic.mipMapOptimization;
    }

    public static int blendColorsHook(TextureUtil tu, int color_0, int color_1, int color_2, int color_3, boolean alpha) {
        return TextureUtilForHook.blendColors(color_0, color_1, color_2, color_3, alpha);
    }

    @Hook(returnCondition=ReturnCondition.ALWAYS)
    public static IRecipe findMatchingRecipe(CraftingManager crManager, InventoryCrafting craftMatrix, World world) {
        for (IRecipe irecipe : CraftingManager.field_193380_a) {
            if (!irecipe.func_77569_a(craftMatrix, world)) continue;
            Item result = irecipe.func_77572_b(craftMatrix).func_77973_b();
            if (result == Items.field_151055_y || Block.func_149634_a((Item)result) == Blocks.field_150462_ai || Block.func_149634_a((Item)result) == Blocks.field_150415_aT || Block.func_149634_a((Item)result) == Blocks.field_150452_aw && !irecipe.getRegistryName().func_110624_b().equals("mist")) {
                boolean check = false;
                for (int i = 0; i < craftMatrix.func_70302_i_(); ++i) {
                    if (!(Block.func_149634_a((Item)craftMatrix.func_70301_a(i).func_77973_b()) instanceof MistBlockStep)) continue;
                    check = true;
                    break;
                }
                if (check) continue;
                return irecipe;
            }
            return irecipe;
        }
        return null;
    }

    @Hook(injectOnExit=true, returnCondition=ReturnCondition.ON_TRUE)
    public static boolean attemptDamageItem(ItemStack stack, int amount, Random rand, @Nullable EntityPlayerMP player, @Hook.ReturnValue boolean returnValue) {
        NBTTagCompound tag;
        EntityEquipmentSlot slot;
        if (returnValue && player != null && stack.func_77973_b() instanceof ItemArmor && stack == player.func_184582_a(slot = ((ItemArmor)stack.func_77973_b()).field_77881_a) && (tag = stack.func_179543_a("MistInnerSuit")) != null) {
            player.func_184201_a(slot, new ItemStack(tag));
        }
        return returnValue;
    }

    @SideOnly(value=Side.CLIENT)
    @Hook(injectOnExit=true)
    public static void renderItemOverlayIntoGUI(RenderItem ri, FontRenderer fr, ItemStack stack, int xPosition, int yPosition, @Nullable String text) {
        ItemStack suit;
        NBTTagCompound tag;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemArmor && (tag = stack.func_179543_a("MistInnerSuit")) != null && (suit = new ItemStack(tag)).func_77973_b().showDurabilityBar(suit)) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            double health = suit.func_77973_b().getDurabilityForDisplay(suit);
            int rgbfordisplay = 0xFFFFFF;
            int i = Math.round(13.0f - (float)health * 13.0f);
            int j = rgbfordisplay;
            ri.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 14, 13, 2, 0, 0, 0, 255);
            ri.func_181565_a(bufferbuilder, xPosition + 2, yPosition + 14, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }
}

