/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.common;

import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.network.PacketTimeSync;
import ru.liahim.mist.util.TimeData;

public class MistTime {
    public static final int monthCount = 12;
    private static long timeOffset;
    private static int dayInMonth;
    private static long tickInMonth;
    private static long tickInYear;
    private static int day;
    private static int month;
    private static int year;
    private static int lastTick;
    private static boolean dirty;
    private static final String[] months;
    private static final String[] months1;

    public static void updateTime(WorldServer world) {
        int tick = 0;
        if (world.func_73056_e()) {
            MistTime.wakeUp();
        } else {
            tick = (int)(world.func_72820_D() % 24000L);
            if (tick == 18000 && lastTick == 17999) {
                MistTime.dayUp();
            }
        }
        if (dirty) {
            TimeData.get((World)world).setTime(day, month, year, timeOffset);
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketTimeSync(day, month, year, timeOffset));
            dirty = false;
        }
        lastTick = tick;
    }

    private static void dayUp() {
        if (++day >= dayInMonth) {
            day = 0;
            if (++month >= 12) {
                month = 0;
                ++year;
            }
        }
        dirty = true;
    }

    public static void wakeUp() {
        if (lastTick < 18000) {
            MistTime.dayUp();
        }
    }

    public static int getDayOfYear() {
        return month * dayInMonth + day;
    }

    public static long getTimeOffset() {
        return timeOffset;
    }

    public static int getDay() {
        return day;
    }

    public static int getMonth() {
        return month;
    }

    public static int getYear() {
        return year;
    }

    public static void setTimeOffset(long offset) {
        timeOffset = offset;
        dirty = true;
    }

    public static void setDay(int day) {
        MistTime.day = day;
    }

    public static void setMonth(int month) {
        MistTime.month = month;
    }

    public static void setYear(int year) {
        MistTime.year = year;
    }

    public static void setMonthLength(int days) {
        dayInMonth = days;
        tickInMonth = days * 24000;
        tickInYear = tickInMonth * 12L;
    }

    public static int getDayInMonth() {
        return dayInMonth;
    }

    public static long getTickInMonth() {
        return tickInMonth;
    }

    public static long getTickInYear() {
        return tickInYear;
    }

    public static long getTickOfMonth(World world) {
        return (long)(day * 24000) + (world.func_72820_D() + 6000L) % 24000L;
    }

    public static long getTickOfYear(World world) {
        return MistTime.getTickOfYear(MistTime.getTickOfMonth(world));
    }

    public static long getTickOfYear(long tickOfMonth) {
        return (long)month * tickInMonth + tickOfMonth;
    }

    public static void setTime(int day, int month, int year, long offset) {
        month %= 12;
        if (MistTime.day != (day %= dayInMonth)) {
            MistTime.day = day;
            dirty = true;
        }
        if (MistTime.month != month) {
            MistTime.month = month;
            dirty = true;
        }
        if (MistTime.year != year) {
            MistTime.year = year;
            dirty = true;
        }
        if (timeOffset != offset) {
            timeOffset = offset;
            dirty = true;
        }
    }

    public static boolean isNightTime(World world) {
        long tick = world.func_72820_D() % 24000L;
        return tick > 14000L && tick < 22000L;
    }

    public static String getDate() {
        return "Date: " + (day + 1) + " " + months1[month] + " " + (year + 1000);
    }

    static {
        months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        months1 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    }
}

