/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.common;

import java.util.Random;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import ru.liahim.mist.api.advancement.PortalType;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistPortalStone;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.handlers.ServerEventHandler;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.util.PlayerLocationData;
import ru.liahim.mist.util.PortalCoordData;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMistUp;

public class MistTeleporter
extends Teleporter {
    protected WorldServer worldServerInstance;
    protected Random rand;
    PortalCoordData data;
    PlayerLocationData spawnPoses;
    int dimIn;
    int dimOut;
    BlockPos pPos;

    public MistTeleporter(WorldServer world, BlockPos pPos) {
        super(world);
        this.worldServerInstance = world;
        this.dimOut = this.worldServerInstance.field_73011_w.getDimension();
        this.rand = new Random(world.func_72905_C());
        this.data = PortalCoordData.get((World)world);
        this.spawnPoses = PlayerLocationData.get((World)world);
        this.pPos = pPos;
    }

    public void func_180266_a(Entity entity, float rotationYaw) {
        this.dimIn = entity.field_70170_p.field_73011_w.getDimension();
        boolean change = false;
        if (!this.func_180620_b(entity, rotationYaw)) {
            if (!this.isSafeBiomeAt(this.pPos)) {
                BlockPos safeCoords = this.findSafeCoords(128, entity);
                if (safeCoords != null) {
                    entity.func_70012_b((double)safeCoords.func_177958_n(), entity.field_70163_u, (double)safeCoords.func_177952_p(), rotationYaw, 0.0f);
                    change = true;
                } else {
                    safeCoords = this.findSafeCoords(256, entity);
                    if (safeCoords != null) {
                        entity.func_70012_b((double)safeCoords.func_177958_n(), entity.field_70163_u, (double)safeCoords.func_177952_p(), rotationYaw, 0.0f);
                        change = true;
                    } else {
                        safeCoords = this.findSafeCoords(512, entity);
                        if (safeCoords != null) {
                            entity.func_70012_b((double)safeCoords.func_177958_n(), entity.field_70163_u, (double)safeCoords.func_177952_p(), rotationYaw, 0.0f);
                            change = true;
                        } else {
                            if (entity instanceof EntityPlayerMP) {
                                EntityPlayerMP playerMP = (EntityPlayerMP)entity;
                                ModAdvancements.OPEN_PORTAL.trigger(playerMP, this.worldServerInstance, this.pPos, PortalType.IN_VOID);
                            }
                            Mist.logger.info("I did everything possible, but could not find a safe biome.");
                        }
                    }
                }
            }
            if (change) {
                if (!this.func_180620_b(entity, rotationYaw)) {
                    this.func_85188_a(entity);
                    this.func_180620_b(entity, rotationYaw);
                }
            } else {
                this.func_85188_a(entity);
                this.func_180620_b(entity, rotationYaw);
            }
        }
    }

    private boolean isSafeBiomeAt(BlockPos pos) {
        if (this.dimOut == Mist.getID()) {
            return this.worldServerInstance.func_180494_b(pos) instanceof BiomeMistUp;
        }
        return true;
    }

    private BlockPos findSafeCoords(int range, Entity entityIn) {
        for (int i = 0; i < 25; ++i) {
            int dz;
            int dx = this.rand.nextInt(range) - this.rand.nextInt(range);
            if (!this.isSafeBiomeAt(this.pPos.func_177982_a(dx, 0, dz = this.rand.nextInt(range) - this.rand.nextInt(range)))) continue;
            return this.pPos.func_177982_a(dx, 0, dz);
        }
        return null;
    }

    public boolean func_180620_b(Entity entity, float rotationYaw) {
        int i = 128;
        double d0 = -1.0;
        boolean flag = true;
        BlockPos pos = BlockPos.field_177992_a;
        if (this.data.getCoords(this.dimIn, this.pPos) != null) {
            BlockPos savePos = this.data.getCoords(this.dimIn, this.pPos);
            if (this.worldServerInstance.func_180495_p(savePos).func_177230_c() == MistBlocks.PORTAL) {
                d0 = 0.0;
                pos = savePos;
                flag = false;
            } else {
                this.data.removeCoords(this.dimIn, this.pPos);
            }
        }
        if (this.data.getCoords(this.dimIn, this.pPos) == null) {
            BlockPos pos3 = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t) - (entity.field_70165_t < 0.0 ? 1 : 0), MathHelper.func_76128_c((double)entity.field_70163_u) + 1, MathHelper.func_76128_c((double)entity.field_70161_v) - (entity.field_70161_v < 0.0 ? 1 : 0));
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    BlockPos pos1 = pos3.func_177982_a(i1, this.worldServerInstance.func_72940_L() - 1 - pos3.func_177956_o(), j1);
                    while (pos1.func_177956_o() >= 0) {
                        BlockPos pos2 = pos1.func_177977_b();
                        if (this.worldServerInstance.func_180495_p(pos1).func_177230_c() == MistBlocks.PORTAL && this.data.getDim(this.dimOut, pos1) == this.dimIn) {
                            double d1 = pos1.func_177951_i((Vec3i)pos3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                pos = pos1;
                            }
                        }
                        pos1 = pos2;
                    }
                }
            }
        }
        if (d0 >= 0.0) {
            if (flag) {
                this.data.addCoords(this.dimIn, this.pPos, this.dimOut, pos);
            }
            double x = (double)(pos.func_177958_n() - (int)(Math.sin(Math.toRadians(rotationYaw)) * 2.0)) + 0.5;
            double y = (double)pos.func_177956_o() - 0.5;
            double z = (double)(pos.func_177952_p() + (int)(Math.cos(Math.toRadians(rotationYaw)) * 2.0)) + 0.5;
            entity.field_70159_w = 0.0;
            entity.field_70181_x = 0.0;
            entity.field_70179_y = 0.0;
            entity.field_70177_z = rotationYaw;
            if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_184851_cj = true;
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
                if (this.dimOut == Mist.getID()) {
                    this.spawnPoses.addSpawnPos((EntityPlayer)((EntityPlayerMP)entity), MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
                    ServerEventHandler.setSpawnPos((EntityPlayerMP)entity);
                }
            } else {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        int i = 16;
        double d0 = -1.0;
        int h = 0;
        int d = 65;
        if (this.dimOut == Mist.getID()) {
            h = MistWorld.getFogMaxHight() + 4;
            d = 129;
        }
        BlockPos pos = BlockPos.field_177992_a;
        BlockPos pos3 = new BlockPos(MathHelper.func_76128_c((double)entity.field_70165_t) - (entity.field_70165_t < 0.0 ? 1 : 0), MathHelper.func_76128_c((double)entity.field_70163_u) + 1, MathHelper.func_76128_c((double)entity.field_70161_v) - (entity.field_70161_v < 0.0 ? 1 : 0));
        for (int x1 = -i; x1 <= i; ++x1) {
            for (int z1 = -i; z1 <= i; ++z1) {
                if (!this.isSafeBiomeAt(pos3.func_177982_a(x1, 0, z1))) continue;
                BlockPos blockpos1 = pos3.func_177982_a(x1, this.worldServerInstance.func_72940_L() - 3 - pos3.func_177956_o(), z1);
                while (blockpos1.func_177956_o() >= h) {
                    BlockPos pos2 = blockpos1.func_177977_b();
                    while (pos2.func_177956_o() > 1 && this.worldServerInstance.func_180495_p(pos2).func_185904_a().func_76222_j() && !(this.worldServerInstance.func_180495_p(pos2).func_177230_c() instanceof BlockLiquid)) {
                        blockpos1 = pos2;
                        pos2 = blockpos1.func_177977_b();
                    }
                    if (this.worldServerInstance.func_180495_p(blockpos1).func_185904_a().func_76222_j() && !(this.worldServerInstance.func_180495_p(blockpos1).func_177230_c() instanceof BlockLiquid) && (this.worldServerInstance.func_180495_p(pos2).func_185904_a().func_76220_a() || this.worldServerInstance.func_180495_p(pos2).func_177230_c() instanceof BlockLiquid)) {
                        boolean check = true;
                        for (int x2 = -1; x2 <= 1; ++x2) {
                            for (int z2 = -1; z2 <= 1; ++z2) {
                                BlockPos blockpos4 = pos2.func_177982_a(x2, 0, z2);
                                if (!check || this.worldServerInstance.func_180495_p(blockpos4.func_177984_a()).func_185904_a().func_76222_j() && !(this.worldServerInstance.func_180495_p(blockpos4.func_177984_a()).func_177230_c() instanceof BlockLiquid) && this.worldServerInstance.func_180495_p(blockpos4.func_177981_b(2)).func_185904_a().func_76222_j() && !(this.worldServerInstance.func_180495_p(blockpos4.func_177981_b(2)).func_177230_c() instanceof BlockLiquid) && (this.worldServerInstance.func_180495_p(blockpos4).func_185904_a().func_76220_a() || this.worldServerInstance.func_180495_p(blockpos4).func_185904_a() == Material.field_151586_h)) continue;
                                check = false;
                            }
                        }
                        if (check) {
                            double d1 = blockpos1.func_177951_i((Vec3i)pos3);
                            if (d0 < 0.0 || d1 < d0) {
                                d0 = d1;
                                pos = blockpos1.func_177984_a();
                            }
                        }
                    }
                    blockpos1 = pos2;
                }
            }
        }
        if (d0 < 0.0) {
            pos = pos3.func_177982_a(0, d - pos3.func_177956_o(), 0);
            for (int x3 = -1; x3 <= 1; ++x3) {
                for (int y3 = -2; y3 <= 1; ++y3) {
                    for (int z3 = -1; z3 <= 1; ++z3) {
                        BlockPos blockpos5 = pos.func_177982_a(x3, y3, z3);
                        if (y3 == -2) {
                            this.worldServerInstance.func_175656_a(blockpos5, Blocks.field_150333_U.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP));
                            continue;
                        }
                        this.worldServerInstance.func_175698_g(blockpos5);
                    }
                }
            }
        }
        this.worldServerInstance.func_175656_a(pos.func_177977_b(), MistBlocks.PORTAL_WORK.func_176223_P().func_177226_a((IProperty)MistPortalStone.ISUP, (Comparable)Boolean.valueOf(false)));
        this.worldServerInstance.func_175656_a(pos, MistBlocks.PORTAL.func_176223_P());
        this.worldServerInstance.func_175656_a(pos.func_177984_a(), MistBlocks.PORTAL_WORK.func_176223_P().func_177226_a((IProperty)MistPortalStone.ISUP, (Comparable)Boolean.valueOf(true)));
        this.data.addCoords(this.dimIn, this.pPos, this.dimOut, pos);
        this.data.addCoords(this.dimOut, pos, this.dimIn, this.pPos);
        return true;
    }
}

