/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.common;

import com.tmtravlr.jaff.api.JustAFewFishAPI;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.loottable.LootTables;
import ru.liahim.mist.block.MistSaltpeterOre;
import ru.liahim.mist.commands.SetMistEffects;
import ru.liahim.mist.commands.SetMistSkills;
import ru.liahim.mist.common.CommonProxy;
import ru.liahim.mist.common.MistTab;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.init.ModBiomes;
import ru.liahim.mist.init.ModBlocks;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.init.ModEntities;
import ru.liahim.mist.init.ModItems;
import ru.liahim.mist.init.ModRecipes;
import ru.liahim.mist.init.ModSounds;
import ru.liahim.mist.init.ModTiles;
import ru.liahim.mist.item.ItemMistSoap;
import ru.liahim.mist.world.WorldProviderMist;

@Mod(modid="mist", name="misty_world", version="1.2.5.3", updateJSON="https://gist.githubusercontent.com/Liahim85/cf1ee7ca8b76425bcb1ee228a3ae762a/raw/mw_updates.json", acceptedMinecraftVersions="[1.12.2]")
public class Mist {
    public static final String MODID = "mist";
    public static final String NAME = "misty_world";
    public static final String VERSION = "1.2.5.3";
    public static final Logger logger = LogManager.getLogger((String)"misty_world");
    public static DimensionType dimensionType;
    public static CreativeTabs mistTab;
    public static final EnumPlantType MIST_DOWN_PLANT;
    public static final int FLAG = 18;
    public static boolean saltymod;
    @Mod.Instance(value="mist")
    public static Mist instance;
    @SidedProxy(clientSide="ru.liahim.mist.common.ClientProxy", serverSide="ru.liahim.mist.common.CommonProxy")
    public static CommonProxy proxy;

    public static int getID() {
        return ModConfig.dimension.dimensionID;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger.info("Starting misty_world PreInitialization");
        saltymod = Loader.isModLoaded((String)"saltmod");
        ModConfig.init();
        ModBlocks.registerBlocks();
        ModTiles.registerTileEntity();
        ModItems.registerItems();
        ModEntities.registerEntities();
        ModBiomes.registerBiomes();
        ModRecipes.registerRecipes();
        ModSounds.registerSounds();
        ModAdvancements.load();
        LootTables.Init();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        logger.info("Starting misty_world Initialization");
        ModRecipes.postRegisterRecipes();
        dimensionType = DimensionType.register((String)NAME, (String)"_mist", (int)Mist.getID(), WorldProviderMist.class, (boolean)false);
        DimensionManager.registerDimension((int)Mist.getID(), (DimensionType)dimensionType);
        Mist.initCompatibilityMod();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("Starting misty_world PostInitialization");
        proxy.postInit(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new SetMistEffects());
        event.registerServerCommand((ICommand)new SetMistSkills());
    }

    public static void initCompatibilityMod() {
        if (Loader.isModLoaded((String)"jaff")) {
            JustAFewFishAPI.addFluidBlockToBlacklist((Block)MistBlocks.ACID_BLOCK);
        }
        if (saltymod) {
            Item mudArmor;
            MistSaltpeterOre.salt = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("saltmod", "salt"));
            Block extractor = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("saltmod", "extractor"));
            if (extractor != null) {
                GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(MODID, "extractor"), (ResourceLocation)new ResourceLocation("saltmod", "extractor"), (ItemStack)new ItemStack(extractor), (Object[])new Object[]{"RCR", "R R", "RRR", Character.valueOf('R'), new ItemStack(MistItems.ROCKS), Character.valueOf('C'), new ItemStack(Items.field_151066_bu)});
            }
            if ((mudArmor = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("saltmod", "mud_helmet"))) != null) {
                ItemMistSoap.mudArmor = mudArmor;
            }
        }
    }

    static {
        mistTab = new MistTab("mist.tab");
        MIST_DOWN_PLANT = EnumPlantType.getPlantType((String)"mist_down_plant");
        FluidRegistry.enableUniversalBucket();
    }
}

