/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.common;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.RenderLivingBase;
import net.minecraft.client.renderer.entity.RenderPlayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.Item;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.item.IColoredItem;
import ru.liahim.mist.client.renderer.CloudRendererMist;
import ru.liahim.mist.client.renderer.RainParticleRenderer;
import ru.liahim.mist.client.renderer.SkyRendererMist;
import ru.liahim.mist.client.renderer.WeatherRendererMist;
import ru.liahim.mist.client.renderer.layers.LayerRespirator;
import ru.liahim.mist.client.renderer.layers.LayerSuit;
import ru.liahim.mist.common.CommonProxy;
import ru.liahim.mist.handlers.ClientEventHandler;
import ru.liahim.mist.handlers.FogRenderer;
import ru.liahim.mist.init.ItemColoring;
import ru.liahim.mist.init.ModClientRegistry;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.init.ModParticle;
import ru.liahim.mist.init.ModSounds;
import ru.liahim.mist.shader.ShaderProgram;
import ru.liahim.mist.util.FogTexture;
import ru.liahim.mist.world.MistWorld;

public class ClientProxy
extends CommonProxy {
    public static final IRenderHandler CloudRendererMist = new CloudRendererMist();
    public static final IRenderHandler SkyRendererMist = new SkyRendererMist();
    public static final IRenderHandler WeatherRendererMist = new WeatherRendererMist();
    public static final IRenderHandler RainParticleRenderer = new RainParticleRenderer();
    public static final MusicTicker.MusicType MIST_UP_DAY_MUSIC = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"mist_up_day", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ModSounds.registerSoundEvent("mist_up_day_music"), 12000, 24000});
    public static final MusicTicker.MusicType MIST_UP_NIGHT_MUSIC = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"mist_night_day", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ModSounds.registerSoundEvent("mist_up_night_music"), 12000, 24000});
    public static final MusicTicker.MusicType MIST_DOWN_MUSIC = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"mist_down", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ModSounds.registerSoundEvent("mist_down_music"), 3000, 6000});
    public static final MusicTicker.MusicType MIST_SUNSET_UP_MUSIC = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"mist_sunset_up", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ModSounds.registerSoundEvent("mist_sunset_up_music"), 0, 0});
    public static final MusicTicker.MusicType MIST_SUNSET_DOWN_MUSIC = (MusicTicker.MusicType)EnumHelper.addEnum(MusicTicker.MusicType.class, (String)"mist_sunset_down", (Class[])new Class[]{SoundEvent.class, Integer.TYPE, Integer.TYPE}, (Object[])new Object[]{ModSounds.registerSoundEvent("mist_sunset_down_music"), 0, 0});
    public static KeyBinding maskKey = new KeyBinding(I18n.func_135052_a((String)"keybind.mist.mask_inventory", (Object[])new Object[0]), 50, "key.categories.inventory");
    public static KeyBinding skillKey = new KeyBinding(I18n.func_135052_a((String)"keybind.mist.skill_inventory", (Object[])new Object[0]), 23, "key.categories.inventory");
    private static List<Block> blocksToColour = Lists.newArrayList();
    private static List<Item> itemsToColor = Lists.newArrayList();

    @Override
    public void setClientSeed(long seed) {
        MistWorld.setClientSeed(seed);
    }

    @Override
    public long getClientSeed() {
        return MistWorld.getClientSeed();
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        if (ModConfig.graphic.advancedFogRenderer) {
            ShaderProgram.initShaders();
            FogTexture.initFogTexture();
        }
        MinecraftForge.EVENT_BUS.register((Object)new FogRenderer());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        ModClientRegistry.registerBlockRenderer();
        ModClientRegistry.registerItemRenderer();
        ModClientRegistry.registerEntityRenderer();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        ClientRegistry.registerKeyBinding((KeyBinding)maskKey);
        ClientRegistry.registerKeyBinding((KeyBinding)skillKey);
        this.registerLayerRenderer();
        this.registerColouring();
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        super.postInit(event);
        ModParticle.registerParticles();
        ItemColoring.createFoodColorList();
    }

    @Override
    public void registerBlockColored(Block block) {
        IColoredBlock coloredBlock;
        if (block instanceof IColoredBlock && ((coloredBlock = (IColoredBlock)block).getBlockColor() != null || coloredBlock.getItemColor() != null)) {
            blocksToColour.add(block);
        }
    }

    @Override
    public void registerItemColored(Item item) {
        if (item instanceof IColoredItem && ((IColoredItem)item).getItemColor() != null) {
            itemsToColor.add(item);
        }
    }

    public void registerColouring() {
        for (Block block : blocksToColour) {
            IColoredBlock colorBlock = (IColoredBlock)block;
            if (colorBlock.getBlockColor() != null) {
                Minecraft.func_71410_x().func_184125_al().func_186722_a(colorBlock.getBlockColor(), new Block[]{block});
            }
            if (colorBlock.getItemColor() == null) continue;
            Minecraft.func_71410_x().getItemColors().func_186731_a(colorBlock.getItemColor(), new Block[]{block});
        }
        for (Item item : itemsToColor) {
            IColoredItem coloredItem = (IColoredItem)item;
            Minecraft.func_71410_x().getItemColors().func_186730_a(coloredItem.getItemColor(), new Item[]{item});
        }
    }

    public void registerLayerRenderer() {
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")).func_177094_a((LayerRenderer)new LayerRespirator((RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")));
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")).func_177094_a((LayerRenderer)new LayerRespirator((RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")));
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")).func_177094_a((LayerRenderer)new LayerSuit((RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("default")));
        ((RenderPlayer)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")).func_177094_a((LayerRenderer)new LayerSuit((RenderLivingBase)Minecraft.func_71410_x().func_175598_ae().getSkinMap().get("slim")));
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation("mist:fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }

    @Override
    public void registerStateWithIgnoring(Block block, IProperty prop) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{prop}).func_178441_a());
    }

    @Override
    public void registerStateWithName(Block block, IProperty prop, String suffix) {
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMap.Builder().func_178440_a(prop).func_178439_a(suffix).func_178441_a());
    }

    @Override
    public boolean hasOptifine() {
        return !FMLClientHandler.instance().hasOptifine();
    }

    @Override
    public void onConfigChange() {
        FogRenderer.updateFogQuality();
    }
}

