/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.client.renderer.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidRegistry;
import ru.liahim.mist.block.gizmos.MistCampfire;
import ru.liahim.mist.tileentity.TileEntityCampfire;

public class TileEntityCampfireRenderer
extends TileEntitySpecialRenderer<TileEntityCampfire> {
    public int[] colors = new int[4];
    private static final ResourceLocation[] SOUP_TEXTURES = new ResourceLocation[]{new ResourceLocation("mist", "textures/blocks/soup/soup_mask_0.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_1.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_2.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_3.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_4.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_5.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_6.png"), new ResourceLocation("mist", "textures/blocks/soup/soup_mask_7.png")};
    private static final ResourceLocation SOUP_MIX = new ResourceLocation("mist:textures/blocks/soup/soup_mix.png");

    public void render(TileEntityCampfire te, double x, double y, double z, float partialTicks, int destroyStage, float alphaIn) {
        if (te.hasCookingTool()) {
            if (te.getCookingTool() == MistCampfire.CookingTool.POT) {
                if (te.getVolum() > 0) {
                    float h = (float)te.getVolum() * 0.0625f + 0.5f;
                    float red = 1.0f;
                    float green = 1.0f;
                    float blue = 1.0f;
                    float alpha = 1.0f;
                    Tessellator tessellator = Tessellator.func_178181_a();
                    BufferBuilder vertexbuffer = tessellator.func_178180_c();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179137_b((double)x, (double)y, (double)z);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179092_a((int)516, (float)0.0f);
                    GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    float progress = te.getCookProgress();
                    float index = Math.min(te.getFinalAmount() / (float)te.getVolum() / 6.0f, 1.0f);
                    float riches = progress * index;
                    this.colors = te.getFoodColors();
                    if (riches < 1.0f) {
                        ResourceLocation fluidTexture = FluidRegistry.WATER.getStill();
                        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(fluidTexture.toString());
                        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
                        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                        vertexbuffer.func_181662_b(0.28125, (double)h, 0.28125).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94206_g()).func_181666_a(red, green, blue, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b(0.28125, (double)h, 0.71825).func_187315_a((double)sprite.func_94209_e(), (double)sprite.func_94207_b(7.0)).func_181666_a(red, green, blue, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b(0.71825, (double)h, 0.71825).func_187315_a((double)sprite.func_94214_a(7.0), (double)sprite.func_94207_b(7.0)).func_181666_a(red, green, blue, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        vertexbuffer.func_181662_b(0.71825, (double)h, 0.28125).func_187315_a((double)sprite.func_94214_a(7.0), (double)sprite.func_94206_g()).func_181666_a(red, green, blue, 1.0f).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    float mix = 0.0f;
                    float amount = 0.3f;
                    if (riches > 0.0f) {
                        int count = 0;
                        blue = 0.0f;
                        green = 0.0f;
                        red = 0.0f;
                        for (int i = 0; i < this.colors.length; ++i) {
                            if (this.colors[i] == 0) continue;
                            red += (float)(this.colors[i] >> 16 & 0xFF) / 255.0f * 0.7f;
                            green += (float)(this.colors[i] >> 8 & 0xFF) / 255.0f * 0.7f;
                            blue += (float)(this.colors[i] & 0xFF) / 255.0f * 0.7f;
                            ++count;
                        }
                        if (count > 0) {
                            mix = ((red /= (float)count) + (green /= (float)count) + (blue /= (float)count)) / 3.0f;
                            red = red * (1.0f - progress * amount) + mix * progress * amount;
                            green = green * (1.0f - progress * amount) + mix * progress * amount;
                            blue = blue * (1.0f - progress * amount) + mix * progress * amount;
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(SOUP_MIX);
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                            vertexbuffer.func_181662_b(0.28125, (double)h, 0.28125).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, riches).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b(0.28125, (double)h, 0.71825).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, riches).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b(0.71825, (double)h, 0.71825).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, riches).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b(0.71825, (double)h, 0.28125).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, riches).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            tessellator.func_78381_a();
                        }
                    }
                    amount = 0.2f;
                    for (int i = 0; i < this.colors.length; ++i) {
                        if (this.colors[i] == 0) continue;
                        red = (float)(this.colors[i] >> 16 & 0xFF) / 255.0f * 0.9f;
                        green = (float)(this.colors[i] >> 8 & 0xFF) / 255.0f * 0.9f;
                        blue = (float)(this.colors[i] & 0xFF) / 255.0f * 0.9f;
                        if (mix > 0.0f) {
                            red = red * (1.0f - progress * amount) + mix * progress * amount;
                            green = green * (1.0f - progress * amount) + mix * progress * amount;
                            blue = blue * (1.0f - progress * amount) + mix * progress * amount;
                        }
                        for (int j = 0; j < SOUP_TEXTURES.length; ++j) {
                            Minecraft.func_71410_x().func_110434_K().func_110577_a(SOUP_TEXTURES[j]);
                            alpha = (float)te.getAnimationPhase((i * 80 + j * 40 + (i + j & 3) * 8) % 320, partialTicks) * index;
                            if (!(alpha > 0.0f)) continue;
                            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
                            vertexbuffer.func_181662_b(0.28125, (double)h, 0.28125).func_187315_a(0.0, 0.0).func_181666_a(red, green, blue, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b(0.28125, (double)h, 0.71825).func_187315_a(0.0, 1.0).func_181666_a(red, green, blue, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b(0.71825, (double)h, 0.71825).func_187315_a(1.0, 1.0).func_181666_a(red, green, blue, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            vertexbuffer.func_181662_b(0.71825, (double)h, 0.28125).func_187315_a(1.0, 0.0).func_181666_a(red, green, blue, alpha).func_181663_c(0.0f, 1.0f, 0.0f).func_181675_d();
                            tessellator.func_78381_a();
                        }
                    }
                    GlStateManager.func_179092_a((int)516, (float)0.1f);
                    GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179121_F();
                }
            } else if (te.getCookingTool() == MistCampfire.CookingTool.GRILL) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.578125), (double)(z + 0.5));
                GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179114_b((float)(-te.getFacing().func_185119_l()), (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
                GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)0.0);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(te.getGrillStack(0), ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179109_b((float)1.0f, (float)0.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(te.getGrillStack(1), ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(te.getGrillStack(2), ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179109_b((float)-1.0f, (float)0.0f, (float)0.0f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(te.getGrillStack(3), ItemCameraTransforms.TransformType.NONE);
                GlStateManager.func_179121_F();
            }
        }
    }
}

