/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.client.renderer;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import ru.liahim.mist.handlers.FogRenderer;

public class SkyRendererMist
extends IRenderHandler {
    private static final ResourceLocation MOON_PHASES_TEXTURES = new ResourceLocation("mist:textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_TEXTURES = new ResourceLocation("textures/environment/sun.png");
    private boolean vboEnabled = OpenGlHelper.func_176075_f();
    private final VertexFormat vertexBufferFormat = new VertexFormat();
    private VertexBuffer starVBO;
    private VertexBuffer skyVBO;
    private VertexBuffer sky2VBO;
    private int starGLCallList = -1;
    private int glSkyList = -1;
    private int glSkyList2 = -1;

    public SkyRendererMist() {
        this.vertexBufferFormat.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
        this.generateStars();
        this.generateSky();
        this.generateSky2();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        if (mc.field_71474_y.field_74337_g) {
            this.renderSky(partialTicks, world, mc, EntityRenderer.field_78515_b);
        } else {
            this.renderSky(partialTicks, world, mc, 2);
        }
    }

    public void renderSky(float partialTicks, WorldClient theWorld, Minecraft mc, int pass) {
        GlStateManager.func_179090_x();
        Vec3d vec3d = theWorld.func_72833_a(mc.func_175606_aa(), partialTicks);
        float f = (float)vec3d.field_72450_a;
        float f1 = (float)vec3d.field_72448_b;
        float f2 = (float)vec3d.field_72449_c;
        if (pass != 2) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179127_m();
        GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        if (this.vboEnabled) {
            this.skyVBO.func_177359_a();
            GlStateManager.func_187410_q((int)32884);
            GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
            this.skyVBO.func_177358_a(7);
            this.skyVBO.func_177361_b();
            GlStateManager.func_187429_p((int)32884);
        } else {
            GlStateManager.func_179148_o((int)this.glSkyList);
        }
        GlStateManager.func_179106_n();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderHelper.func_74518_a();
        float[] afloat = theWorld.field_73011_w.func_76560_a(theWorld.func_72826_c(partialTicks), partialTicks);
        if (afloat != null) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179094_E();
            GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)(MathHelper.func_76126_a((float)theWorld.func_72929_e(partialTicks)) < 0.0f ? 180.0f : 0.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            float f6 = afloat[0];
            float f7 = afloat[1];
            float f8 = afloat[2];
            if (pass != 2) {
                float f9 = (f6 * 30.0f + f7 * 59.0f + f8 * 11.0f) / 100.0f;
                float f10 = (f6 * 30.0f + f7 * 70.0f) / 100.0f;
                float f11 = (f6 * 30.0f + f8 * 70.0f) / 100.0f;
                f6 = f9;
                f7 = f10;
                f8 = f11;
            }
            vertexbuffer.func_181668_a(6, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b(0.0, 100.0, 0.0).func_181666_a(f6, f7, f8, afloat[3]).func_181675_d();
            int j = 16;
            for (int l = 0; l <= 16; ++l) {
                float f21 = (float)l * ((float)Math.PI * 2) / 16.0f;
                float f12 = MathHelper.func_76126_a((float)f21);
                float f13 = MathHelper.func_76134_b((float)f21);
                vertexbuffer.func_181662_b((double)(f12 * 120.0f), (double)(f13 * 120.0f), (double)(-f13 * 40.0f * afloat[3])).func_181666_a(afloat[0], afloat[1], afloat[2], 0.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179103_j((int)7424);
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        float f16 = 1.0f - theWorld.func_72867_j(partialTicks);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)f16);
        GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(theWorld.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        float f17 = 30.0f;
        mc.field_71446_o.func_110577_a(SUN_TEXTURES);
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-f17), 100.0, (double)(-f17)).func_187315_a(0.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)f17, 100.0, (double)(-f17)).func_187315_a(1.0, 0.0).func_181675_d();
        vertexbuffer.func_181662_b((double)f17, 100.0, (double)f17).func_187315_a(1.0, 1.0).func_181675_d();
        vertexbuffer.func_181662_b((double)(-f17), 100.0, (double)f17).func_187315_a(0.0, 1.0).func_181675_d();
        tessellator.func_78381_a();
        f17 = 20.0f;
        mc.field_71446_o.func_110577_a(MOON_PHASES_TEXTURES);
        int i = theWorld.func_72853_d();
        int k = i % 4;
        int i1 = i / 4 % 2;
        float f22 = (float)(k + 0) / 4.0f;
        float f23 = (float)(i1 + 0) / 2.0f;
        float f24 = (float)(k + 1) / 4.0f;
        float f14 = (float)(i1 + 1) / 2.0f;
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_181662_b((double)(-f17), -100.0, (double)f17).func_187315_a((double)f24, (double)f14).func_181675_d();
        vertexbuffer.func_181662_b((double)f17, -100.0, (double)f17).func_187315_a((double)f22, (double)f14).func_181675_d();
        vertexbuffer.func_181662_b((double)f17, -100.0, (double)(-f17)).func_187315_a((double)f22, (double)f23).func_181675_d();
        vertexbuffer.func_181662_b((double)(-f17), -100.0, (double)(-f17)).func_187315_a((double)f24, (double)f23).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179090_x();
        float f15 = theWorld.func_72880_h(partialTicks) * f16;
        if (f15 > 0.0f) {
            GlStateManager.func_179131_c((float)f15, (float)f15, (float)f15, (float)f15);
            if (this.vboEnabled) {
                this.starVBO.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                this.starVBO.func_177358_a(7);
                this.starVBO.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)this.starGLCallList);
            }
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179090_x();
        GlStateManager.func_179127_m();
        float r = FogRenderer.red;
        float g = FogRenderer.green;
        float b = FogRenderer.blue;
        double h = (mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - (double)FogRenderer.fogHeight) * 1.1;
        double hd = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b;
        double d = (mc.field_71474_y.field_151451_c + 2) * 8;
        int a = 16;
        double w = Math.sin(Math.toRadians(180 / a)) * d;
        double u = Math.cos(Math.toRadians(180 / a)) * d;
        for (float j = 0.0f; j < 360.0f; j += (float)(360 / a)) {
            GlStateManager.func_179114_b((float)(360 / a), (float)0.0f, (float)1.0f, (float)0.0f);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b(-u, -h / 2.0, -w).func_181666_a(r, g, b, 0.5f).func_181675_d();
            vertexbuffer.func_181662_b(-u, -h / 2.0, w).func_181666_a(r, g, b, 0.5f).func_181675_d();
            vertexbuffer.func_181662_b(-u, -hd, w).func_181666_a(r, g, b, 0.5f).func_181675_d();
            vertexbuffer.func_181662_b(-u, -hd, -w).func_181666_a(r, g, b, 1.0f).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179141_d();
        GlStateManager.func_179124_c((float)0.0f, (float)0.0f, (float)0.0f);
        double d0 = mc.field_71439_g.func_174824_e((float)partialTicks).field_72448_b - theWorld.func_72919_O();
        if (d0 < 0.0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            if (this.vboEnabled) {
                this.sky2VBO.func_177359_a();
                GlStateManager.func_187410_q((int)32884);
                GlStateManager.func_187420_d((int)3, (int)5126, (int)12, (int)0);
                this.sky2VBO.func_177358_a(7);
                this.sky2VBO.func_177361_b();
                GlStateManager.func_187429_p((int)32884);
            } else {
                GlStateManager.func_179148_o((int)this.glSkyList2);
            }
            GlStateManager.func_179121_F();
            float f18 = 1.0f;
            float f19 = -((float)(d0 + 65.0));
            float f20 = -1.0f;
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            vertexbuffer.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, (double)f19, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, (double)f19, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(-1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, 1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            vertexbuffer.func_181662_b(1.0, -1.0, -1.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            tessellator.func_78381_a();
        }
        if (theWorld.field_73011_w.func_76561_g()) {
            GlStateManager.func_179124_c((float)(f * 0.2f + 0.04f), (float)(f1 * 0.2f + 0.04f), (float)(f2 * 0.6f + 0.1f));
        } else {
            GlStateManager.func_179124_c((float)f, (float)f1, (float)f2);
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((float)(d0 - 16.0))), (float)0.0f);
        GlStateManager.func_179148_o((int)this.glSkyList2);
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)true);
    }

    private void generateSky2() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        if (this.sky2VBO != null) {
            this.sky2VBO.func_177362_c();
        }
        if (this.glSkyList2 >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList2);
            this.glSkyList2 = -1;
        }
        if (this.vboEnabled) {
            this.sky2VBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(vertexbuffer, -16.0f, true);
            vertexbuffer.func_178977_d();
            vertexbuffer.func_178965_a();
            this.sky2VBO.func_181722_a(vertexbuffer.func_178966_f());
        } else {
            this.glSkyList2 = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glSkyList2, (int)4864);
            this.renderSky(vertexbuffer, -16.0f, true);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void generateSky() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        if (this.skyVBO != null) {
            this.skyVBO.func_177362_c();
        }
        if (this.glSkyList >= 0) {
            GLAllocation.func_74523_b((int)this.glSkyList);
            this.glSkyList = -1;
        }
        if (this.vboEnabled) {
            this.skyVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderSky(vertexbuffer, 16.0f, false);
            vertexbuffer.func_178977_d();
            vertexbuffer.func_178965_a();
            this.skyVBO.func_181722_a(vertexbuffer.func_178966_f());
        } else {
            this.glSkyList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)this.glSkyList, (int)4864);
            this.renderSky(vertexbuffer, 16.0f, false);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
        }
    }

    private void renderSky(BufferBuilder worldRendererIn, float posY, boolean reverseX) {
        int i = 64;
        int j = 6;
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int l = -384; l <= 384; l += 64) {
                float f = k;
                float f1 = k + 64;
                if (reverseX) {
                    f1 = k;
                    f = k + 64;
                }
                worldRendererIn.func_181662_b((double)f, (double)posY, (double)l).func_181675_d();
                worldRendererIn.func_181662_b((double)f1, (double)posY, (double)l).func_181675_d();
                worldRendererIn.func_181662_b((double)f1, (double)posY, (double)(l + 64)).func_181675_d();
                worldRendererIn.func_181662_b((double)f, (double)posY, (double)(l + 64)).func_181675_d();
            }
        }
    }

    private void generateStars() {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        if (this.starVBO != null) {
            this.starVBO.func_177362_c();
        }
        if (this.starGLCallList >= 0) {
            GLAllocation.func_74523_b((int)this.starGLCallList);
            this.starGLCallList = -1;
        }
        if (this.vboEnabled) {
            this.starVBO = new VertexBuffer(this.vertexBufferFormat);
            this.renderStars(vertexbuffer);
            vertexbuffer.func_178977_d();
            vertexbuffer.func_178965_a();
            this.starVBO.func_181722_a(vertexbuffer.func_178966_f());
        } else {
            this.starGLCallList = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_179094_E();
            GlStateManager.func_187423_f((int)this.starGLCallList, (int)4864);
            this.renderStars(vertexbuffer);
            tessellator.func_78381_a();
            GlStateManager.func_187415_K();
            GlStateManager.func_179121_F();
        }
    }

    private void renderStars(BufferBuilder worldRendererIn) {
        Random random = new Random(10842L);
        worldRendererIn.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int i = 0; i < 1500; ++i) {
            double d0 = random.nextFloat() * 2.0f - 1.0f;
            double d1 = random.nextFloat() * 2.0f - 1.0f;
            double d2 = random.nextFloat() * 2.0f - 1.0f;
            double d3 = 0.15f + random.nextFloat() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = random.nextDouble() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d17 = 0.0;
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d20 = 0.0;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                worldRendererIn.func_181662_b(d5 + d25, d6 + d23, d7 + d26).func_181675_d();
            }
        }
    }
}

