/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.client.model.entity;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.client.model.animation.SimpleIK;
import ru.liahim.mist.entity.EntityMonk;

@SideOnly(value=Side.CLIENT)
public class ModelMonk
extends ModelBase {
    public ModelRenderer head;
    public ModelRenderer childHead;
    public ModelRenderer back;
    public ModelRenderer body;
    public ModelRenderer legFR1;
    public ModelRenderer legFL1;
    public ModelRenderer legFR2;
    public ModelRenderer legFL2;
    public ModelRenderer legFR3;
    public ModelRenderer legFL3;
    public ModelRenderer legFR4;
    public ModelRenderer legFL4;
    public ModelRenderer legBR1;
    public ModelRenderer legBL1;
    public ModelRenderer legBR2;
    public ModelRenderer legBL2;
    public ModelRenderer legBR3;
    public ModelRenderer legBL3;
    private SimpleIK ikFR;
    private SimpleIK ikFL;
    private SimpleIK ikBR;
    private SimpleIK ikBL;
    static final float speed = 0.65f;
    static final float bRadius = 12.0f;
    static final float pi = (float)Math.PI;
    static final float shift = 1.5707964f;

    public ModelMonk(float scale) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.back = new ModelRenderer((ModelBase)this, 0, 0);
        this.back.func_78790_a(-8.0f, -18.0f, -4.0f, 16, 20, 16, scale);
        this.back.func_78784_a(0, 36);
        this.back.func_78790_a(-6.0f, -18.0f, -7.0f, 12, 17, 3, scale);
        this.back.func_78784_a(0, 100);
        this.back.func_78790_a(-8.0f, -18.0f, -5.0f, 16, 20, 1, scale);
        this.back.func_78793_a(0.0f, 9.0f, 15.0f);
        this.back.field_78795_f = 1.3089969f;
        this.body = new ModelRenderer((ModelBase)this, 48, 20);
        this.body.func_78790_a(-10.0f, -11.0f, -1.0f, 20, 19, 16, scale);
        this.body.func_78784_a(64, 9);
        this.body.func_78790_a(-6.0f, -8.0f, -4.0f, 12, 8, 3, scale);
        this.body.func_78784_a(40, 92);
        this.body.func_78790_a(-10.0f, 3.0f, -2.0f, 20, 5, 1, scale);
        this.body.func_78793_a(0.0f, -18.0f, -3.0f);
        this.body.field_78795_f = 0.34906587f;
        this.back.func_78792_a(this.body);
        this.head = new ModelRenderer((ModelBase)this, 94, 0);
        this.head.func_78790_a(-4.0f, -4.01f, -8.0f, 8, 10, 9, scale);
        this.head.func_78784_a(0, 56);
        this.head.func_78790_a(-5.0f, -4.02f, -8.01f, 10, 8, 6, scale);
        this.head.func_78784_a(30, 36);
        this.head.func_78790_a(-3.0f, -4.02f, -11.01f, 6, 8, 3, scale);
        this.head.func_78793_a(0.0f, -11.0f, 5.0f);
        this.head.field_78795_f = -1.5707964f;
        this.body.func_78792_a(this.head);
        this.childHead = new ModelRenderer((ModelBase)this, 94, 0);
        this.childHead.func_78790_a(-4.0f, -4.21f, -8.6f, 8, 10, 9, 0.8f);
        this.childHead.func_78784_a(0, 56);
        this.childHead.func_78790_a(-5.0f, -4.02f, -8.41f, 10, 8, 6, 1.0f);
        this.childHead.func_78784_a(30, 36);
        this.childHead.func_78790_a(-3.0f, -4.42f, -13.01f, 6, 8, 3, 0.6f);
        this.childHead.func_78793_a(0.0f, -11.0f, 6.0f);
        this.childHead.field_78795_f = -1.5707964f;
        this.body.func_78792_a(this.childHead);
        this.legFR1 = new ModelRenderer((ModelBase)this, 32, 55);
        this.legFR1.func_78790_a(-3.0f, -3.0f, -4.0f, 9, 15, 6, scale);
        this.legFR1.func_78793_a(-10.0f, -4.0f, 6.0f);
        this.legFR2 = new ModelRenderer((ModelBase)this, 104, 19);
        this.legFR2.func_78790_a(0.0f, -1.0f, -3.99f, 7, 9, 5, scale);
        this.legFR2.func_78793_a(-3.0f, 7.0f, 0.0f);
        this.legFR1.func_78792_a(this.legFR2);
        this.legFR3 = new ModelRenderer((ModelBase)this, 0, 70);
        this.legFR3.func_78790_a(-0.02f, -9.0f, -1.0f, 4, 9, 6, scale);
        this.legFR3.func_78793_a(0.0f, 17.0f, 1.0f);
        this.legFR4 = new ModelRenderer((ModelBase)this, 20, 76);
        this.legFR4.func_78790_a(1.0f, -4.0f, 0.0f, 4, 5, 6, scale);
        this.legFR4.func_78793_a(0.0f, 0.0f, 0.0f);
        this.legFR3.func_78792_a(this.legFR4);
        this.legFL1 = new ModelRenderer((ModelBase)this, 62, 55);
        this.legFL1.func_78790_a(-6.0f, -3.0f, -4.0f, 9, 15, 6, scale);
        this.legFL1.func_78793_a(10.0f, -4.0f, 6.0f);
        this.legFL2 = new ModelRenderer((ModelBase)this, 92, 55);
        this.legFL2.func_78790_a(-7.0f, -1.0f, -3.99f, 7, 9, 5, scale);
        this.legFL2.func_78793_a(3.0f, 7.0f, 0.0f);
        this.legFL1.func_78792_a(this.legFL2);
        this.legFL3 = new ModelRenderer((ModelBase)this, 0, 85);
        this.legFL3.func_78790_a(-3.98f, -9.0f, -1.0f, 4, 9, 6, scale);
        this.legFL3.func_78793_a(0.0f, 17.0f, 1.0f);
        this.legFL4 = new ModelRenderer((ModelBase)this, 20, 87);
        this.legFL4.func_78790_a(-5.0f, -4.0f, 0.0f, 4, 5, 6, scale);
        this.legFL4.func_78793_a(0.0f, 0.0f, 0.0f);
        this.legFL3.func_78792_a(this.legFL4);
        this.legBR1 = new ModelRenderer((ModelBase)this, 40, 76);
        this.legBR1.func_78790_a(-1.0f, -2.0f, -2.0f, 6, 10, 6, scale);
        this.legBR1.func_78793_a(-8.0f, 0.0f, 0.0f);
        this.legBR2 = new ModelRenderer((ModelBase)this, 106, 69);
        this.legBR2.func_78790_a(-0.01f, 0.0f, 0.0f, 5, 8, 6, scale);
        this.legBR2.func_78793_a(0.0f, 8.0f, -2.0f);
        this.legBR1.func_78792_a(this.legBR2);
        this.legBR3 = new ModelRenderer((ModelBase)this, 86, 70);
        this.legBR3.func_78790_a(0.98f, -4.0f, 0.0f, 4, 5, 6, scale);
        this.legBR3.func_78793_a(0.0f, 8.0f, 1.0f);
        this.legBL1 = new ModelRenderer((ModelBase)this, 64, 76);
        this.legBL1.func_78790_a(-5.0f, -2.0f, -2.0f, 6, 10, 6, scale);
        this.legBL1.func_78793_a(8.0f, 0.0f, 0.0f);
        this.legBL2 = new ModelRenderer((ModelBase)this, 106, 83);
        this.legBL2.func_78790_a(-4.99f, 0.0f, 0.0f, 5, 8, 6, scale);
        this.legBL2.func_78793_a(0.0f, 8.0f, -2.0f);
        this.legBL1.func_78792_a(this.legBL2);
        this.legBL3 = new ModelRenderer((ModelBase)this, 86, 86);
        this.legBL3.func_78790_a(-4.98f, -4.0f, 0.0f, 4, 5, 6, scale);
        this.legBL3.func_78793_a(0.0f, 8.0f, 1.0f);
        this.ikFR = new SimpleIK(EnumFacing.Axis.X, true, new float[]{0.0f, -9.0f, -1.0f}, this.back, this.body, this.legFR1, this.legFR2, this.legFR3);
        this.ikFL = new SimpleIK(EnumFacing.Axis.X, false, new float[]{0.0f, -9.0f, -1.0f}, this.back, this.body, this.legFL1, this.legFL2, this.legFL3);
        this.ikBR = new SimpleIK(EnumFacing.Axis.Z, false, this.back, this.legBR1, this.legBR2, this.legBR3);
        this.ikBL = new SimpleIK(EnumFacing.Axis.Z, false, this.back, this.legBL1, this.legBL2, this.legBL3);
        this.legFR3.field_78800_c = -10.0f;
        this.legFL3.field_78800_c = 10.0f;
        this.legBR3.field_78800_c = -8.0f;
        this.legBL3.field_78800_c = 8.0f;
    }

    public ModelMonk() {
        this(0.0f);
    }

    public void func_78088_a(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        this.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        this.head.field_78807_k = this.field_78091_s;
        boolean bl = this.childHead.field_78807_k = !this.field_78091_s;
        if (this.field_78091_s) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.func_179109_b((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.back.func_78785_a(scale);
            this.legFL1.func_78785_a(scale);
            this.legFR1.func_78785_a(scale);
            this.legFL3.func_78785_a(scale);
            this.legFR3.func_78785_a(scale);
            this.legBL1.func_78785_a(scale);
            this.legBR1.func_78785_a(scale);
            this.legBL3.func_78785_a(scale);
            this.legBR3.func_78785_a(scale);
            GlStateManager.func_179121_F();
        } else {
            this.back.func_78785_a(scale);
            this.legFL1.func_78785_a(scale);
            this.legFR1.func_78785_a(scale);
            this.legFL3.func_78785_a(scale);
            this.legFR3.func_78785_a(scale);
            this.legBL1.func_78785_a(scale);
            this.legBR1.func_78785_a(scale);
            this.legBL3.func_78785_a(scale);
            this.legBR3.func_78785_a(scale);
        }
    }

    public static float[] getPassangerOffset(float[] vec, float limbSwing, float limbSwingAmount) {
        limbSwingAmount = Math.min(limbSwingAmount, 1.0f);
        vec[0] = MathHelper.func_76126_a((float)(limbSwing *= 0.65f)) * 0.15f * limbSwingAmount;
        vec[1] = 0.0f;
        vec[2] = 0.0f;
        return vec;
    }

    public void func_78087_a(float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor, Entity entity) {
        float zR;
        float yR;
        float zL;
        limbSwingAmount = Math.min(limbSwingAmount, 1.0f);
        float f = MathHelper.func_76126_a((float)(limbSwing *= 0.65f)) * 0.15f * limbSwingAmount;
        float f1 = MathHelper.func_76134_b((float)(limbSwing * 2.0f)) * 0.01f * limbSwingAmount;
        float f2 = ((EntityMonk)entity).getStandingAnimationScale(ageInTicks - (float)entity.field_70173_aa);
        f2 *= f2;
        this.back.field_78795_f = 1.3089969f + f1 - (float)Math.PI * f2 / 6.0f;
        this.back.field_78808_h = f;
        this.head.field_78795_f = headPitch * 0.0175f * 0.9f - 1.5707964f - f1 + (float)Math.PI * f2 / 6.0f;
        this.head.field_78796_g = -f;
        this.head.field_78808_h = -netHeadYaw * 0.0175f * 0.5f;
        this.childHead.field_78795_f = this.head.field_78795_f;
        this.childHead.field_78796_g = this.head.field_78796_g;
        this.childHead.field_78808_h = this.head.field_78808_h;
        float[] baseR = this.ikFR.calculateBasePoint();
        float[] baseL = this.ikFL.calculateBasePoint();
        float yL = -MathHelper.func_76126_a((float)limbSwing) * 12.0f;
        if (yL > 0.0f) {
            yL = 0.0f;
            zL = (limbSwing % (float)Math.PI / (float)Math.PI * 2.0f - 1.0f) * 12.0f;
            yR = -MathHelper.func_76126_a((float)(limbSwing + (float)Math.PI)) * 12.0f / 4.0f;
            zR = MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * 12.0f;
        } else {
            yL /= 4.0f;
            zL = MathHelper.func_76134_b((float)limbSwing) * 12.0f;
            yR = 0.0f;
            zR = ((limbSwing + (float)Math.PI) % (float)Math.PI / (float)Math.PI * 2.0f - 1.0f) * 12.0f;
        }
        yR = yR * limbSwingAmount + 23.0f;
        zR = zR * limbSwingAmount - 13.35f + 3.0f * limbSwingAmount;
        yL = yL * limbSwingAmount + 23.0f;
        zL = zL * limbSwingAmount - 13.35f + 3.0f * limbSwingAmount;
        if (f2 > 0.0f) {
            int centreY = -2;
            int centreZ = -1;
            float[] xRot = SimpleIK.rotateX(new float[]{0.0f, yR - (float)centreY, zR - (float)centreZ}, -(f2 *= (float)Math.PI) * 0.75f);
            this.legFR3.field_78797_d = xRot[1] + (float)centreY;
            this.legFR3.field_78798_e = xRot[2] + (float)centreZ;
            this.legFR4.field_78795_f = -MathHelper.func_76134_b((float)limbSwing) * (float)Math.PI / 6.0f * limbSwingAmount - 0.17453294f;
            this.legFR3.field_78795_f = -this.legFR4.field_78795_f - f2;
            xRot = SimpleIK.rotateX(new float[]{0.0f, yL - (float)centreY, zL - (float)centreZ}, -f2 * 0.75f);
            this.legFL3.field_78797_d = xRot[1] + (float)centreY;
            this.legFL3.field_78798_e = xRot[2] + (float)centreZ;
            this.legFL4.field_78795_f = -MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * (float)Math.PI / 6.0f * limbSwingAmount - 0.17453294f;
            this.legFL3.field_78795_f = -this.legFL4.field_78795_f - f2;
        } else {
            this.legFR3.field_78797_d = yL;
            this.legFR3.field_78798_e = zL;
            this.legFR3.field_78795_f = MathHelper.func_76134_b((float)limbSwing) * (float)Math.PI / 6.0f * limbSwingAmount + 0.17453294f;
            this.legFR4.field_78795_f = -this.legFR3.field_78795_f;
            float x = this.legFR3.field_78800_c - baseR[0];
            float y = this.legFR3.field_78797_d - baseR[1];
            float z = this.legFR3.field_78798_e - baseR[2];
            float l = (float)Math.sqrt(x * x + y * y + z * z);
            this.legFR3.field_78808_h = (float)(-Math.atan(x / l));
            this.legFL3.field_78797_d = yR;
            this.legFL3.field_78798_e = zR;
            this.legFL3.field_78795_f = MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * (float)Math.PI / 6.0f * limbSwingAmount + 0.17453294f;
            this.legFL4.field_78795_f = -this.legFL3.field_78795_f;
            x = this.legFL3.field_78800_c - baseL[0];
            y = this.legFL3.field_78797_d - baseL[1];
            z = this.legFL3.field_78798_e - baseL[2];
            l = (float)Math.sqrt(x * x + y * y + z * z);
            this.legFL3.field_78808_h = (float)(-Math.atan(x / l));
        }
        this.ikFR.rotateBones(-1.5707964f, baseR);
        this.ikFL.rotateBones(-1.5707964f, baseL);
        yL = -MathHelper.func_76126_a((float)(limbSwing -= 1.5707964f)) * 12.0f;
        if (yL > 0.0f) {
            yL = 0.0f;
            zL = (limbSwing % (float)Math.PI / (float)Math.PI * 2.0f - 1.0f) * 12.0f;
            yR = -MathHelper.func_76126_a((float)(limbSwing + (float)Math.PI)) * 12.0f / 4.0f;
            zR = MathHelper.func_76134_b((float)(limbSwing + (float)Math.PI)) * 12.0f;
        } else {
            yL /= 4.0f;
            zL = MathHelper.func_76134_b((float)limbSwing) * 12.0f;
            yR = 0.0f;
            zR = ((limbSwing + (float)Math.PI) % (float)Math.PI / (float)Math.PI * 2.0f - 1.0f) * 12.0f;
        }
        this.legBR3.field_78797_d = (yR *= limbSwingAmount) + 23.0f;
        this.legBR3.field_78798_e = (zR *= limbSwingAmount) + 15.0f;
        this.legBL3.field_78797_d = (yL *= limbSwingAmount) + 23.0f;
        this.legBL3.field_78798_e = (zL *= limbSwingAmount) + 15.0f;
        this.ikBR.rotateBones(0.0f);
        this.ikBL.rotateBones(0.0f);
    }
}

