/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.client.model.animation;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class SimpleIK {
    private final float[] base;
    private final ModelRenderer[] parents;
    private final ModelRenderer bone_1;
    private final ModelRenderer bone_2;
    private final ModelRenderer target;
    private final float[] targetShift;
    private final float length_1;
    private final float length_2;
    private final float[] ang_1;
    private final float[] ang_2;
    private final float[] targetPos;
    private final boolean invert;
    private final EnumFacing.Axis planeAxis;

    public SimpleIK(EnumFacing.Axis planeAxis, boolean invert, ModelRenderer ... parents) {
        this(planeAxis, invert, (float[])null, parents);
    }

    public SimpleIK(EnumFacing.Axis planeAxis, boolean invert, @Nullable float[] targetShift, ModelRenderer ... parents) {
        float[] fArray;
        float[] fArray2;
        this.planeAxis = planeAxis;
        this.invert = invert;
        this.bone_1 = parents[parents.length - 3];
        this.bone_2 = parents[parents.length - 2];
        this.target = parents[parents.length - 1];
        this.targetShift = targetShift;
        this.parents = new ModelRenderer[parents.length - 3];
        for (int i = 0; i < this.parents.length; ++i) {
            this.parents[i] = parents[i];
        }
        float x = this.target.field_78800_c;
        float y = this.target.field_78797_d;
        float z = this.target.field_78798_e;
        if (this.targetShift != null) {
            x += this.targetShift[0];
            y += this.targetShift[1];
            z += this.targetShift[2];
        }
        this.base = new float[]{this.bone_1.field_78800_c, this.bone_1.field_78797_d, this.bone_1.field_78798_e};
        this.length_1 = (float)Math.sqrt(this.bone_2.field_78800_c * this.bone_2.field_78800_c + this.bone_2.field_78797_d * this.bone_2.field_78797_d + this.bone_2.field_78798_e * this.bone_2.field_78798_e);
        this.length_2 = (float)Math.sqrt(x * x + y * y + z * z);
        if (this.bone_2.field_78797_d == 0.0f) {
            float[] fArray3 = new float[2];
            fArray3[0] = 0.0f;
            fArray2 = fArray3;
            fArray3[1] = 0.0f;
        } else {
            float[] fArray4 = new float[2];
            fArray4[0] = (float)Math.atan(this.bone_2.field_78798_e / this.bone_2.field_78797_d);
            fArray2 = fArray4;
            fArray4[1] = (float)Math.atan(this.bone_2.field_78800_c / this.bone_2.field_78797_d);
        }
        this.ang_1 = fArray2;
        if (y == 0.0f) {
            float[] fArray5 = new float[2];
            fArray5[0] = 0.0f;
            fArray = fArray5;
            fArray5[1] = 0.0f;
        } else {
            float[] fArray6 = new float[2];
            fArray6[0] = (float)Math.atan(z / y);
            fArray = fArray6;
            fArray6[1] = (float)Math.atan(x / y);
        }
        this.ang_2 = fArray;
        this.targetPos = new float[]{this.bone_2.field_78800_c + x, this.bone_2.field_78798_e + z};
    }

    public void rotateBones(float ang) {
        this.rotateBones(ang, this.calculateBasePoint());
    }

    public void rotateBones(float ang, float[] base) {
        float[] matrix;
        float length;
        float x = this.target.field_78800_c;
        float y = this.target.field_78797_d;
        float z = this.target.field_78798_e;
        if (this.targetShift != null && (this.targetShift[0] != 0.0f || this.targetShift[1] != 0.0f || this.targetShift[2] != 0.0f)) {
            float[] targetVec = (float[])this.targetShift.clone();
            if (this.target.field_78795_f != 0.0f) {
                targetVec = SimpleIK.rotateX(targetVec, this.target.field_78795_f);
            }
            if (this.target.field_78796_g != 0.0f) {
                targetVec = SimpleIK.rotateY(targetVec, this.target.field_78796_g);
            }
            if (this.target.field_78808_h != 0.0f) {
                targetVec = SimpleIK.rotateZ(targetVec, this.target.field_78808_h);
            }
            x += targetVec[0];
            y += targetVec[1];
            z += targetVec[2];
        }
        if ((length = (float)Math.sqrt((x -= base[0]) * x + (y -= base[1]) * y + (z -= base[2]) * z)) > this.length_1 + this.length_2) {
            length = this.length_1 + this.length_2;
        } else if (length < Math.abs(this.length_1 - this.length_2)) {
            length = Math.abs(this.length_1 - this.length_2);
        }
        float bone_1_ang = (float)Math.acos((this.length_1 * this.length_1 + length * length - this.length_2 * this.length_2) / (2.0f * this.length_1 * length));
        float bone_2_ang = (float)Math.PI - (float)Math.acos((this.length_1 * this.length_1 + this.length_2 * this.length_2 - length * length) / (2.0f * this.length_1 * this.length_2));
        if (Float.isNaN(bone_1_ang)) {
            bone_1_ang = 0.0f;
        }
        if (Float.isNaN(bone_2_ang)) {
            bone_2_ang = 0.0f;
        }
        if (this.invert) {
            bone_1_ang = -bone_1_ang;
            bone_2_ang = -bone_2_ang;
            ang = -ang;
        }
        if (this.planeAxis == EnumFacing.Axis.X) {
            boolean back;
            boolean bl = back = y < 0.0f;
            if (back) {
                y = -y;
            }
            float planeAngle = (float)Math.atan(z / y);
            float[] axis = SimpleIK.rotateX(new float[]{x, y, z}, -planeAngle);
            matrix = SimpleIK.rotationMatrix(this.targetPos[1] == 0.0f || axis[1] == 0.0f ? 0.0f : (float)(-Math.atan(this.targetPos[1] / axis[1])), 0.0f, (bone_1_ang -= (float)Math.atan(axis[0] / axis[1])) + this.ang_1[1], null);
            if (ang != 0.0f) {
                matrix = SimpleIK.multiply(SimpleIK.rotationMatrix(axis[0], axis[1], axis[2], -ang, null), matrix, null);
            }
            if (back) {
                planeAngle = (float)Math.PI - planeAngle;
            }
            if (planeAngle != 0.0f) {
                matrix = SimpleIK.multiply(SimpleIK.rotationMatrix(planeAngle, 0.0f, 0.0f, null), matrix, null);
            }
            this.bone_2.field_78808_h = -bone_2_ang - this.ang_1[1] + this.ang_2[1];
        } else if (this.planeAxis == EnumFacing.Axis.Y) {
            boolean back;
            boolean bl = back = x >= 0.0f;
            if (back) {
                x = -x;
            }
            float planeAngle = (float)(-Math.atan(z / x));
            float[] axis = SimpleIK.rotateY(new float[]{x, y, z}, -planeAngle);
            bone_1_ang = (float)(1.5707963267948966 + Math.atan(axis[1] / axis[0])) + bone_1_ang;
            matrix = SimpleIK.rotationMatrix(this.targetPos[1] == 0.0f || axis[1] == 0.0f ? 0.0f : (float)(-Math.atan(this.targetPos[1] / axis[1])), 0.0f, bone_1_ang + this.ang_1[1], null);
            if (ang != 0.0f) {
                matrix = SimpleIK.multiply(SimpleIK.rotationMatrix(axis[0], axis[1], axis[2], -ang, null), matrix, null);
            }
            if (back) {
                planeAngle = (float)Math.PI - planeAngle;
            }
            if (planeAngle != 0.0f) {
                matrix = SimpleIK.multiply(SimpleIK.rotationMatrix(0.0f, planeAngle, 0.0f, null), matrix, null);
            }
            this.bone_2.field_78808_h = -bone_2_ang - this.ang_1[1] + this.ang_2[1];
        } else {
            boolean back;
            boolean bl = back = y < 0.0f;
            if (back) {
                y = -y;
            }
            float planeAngle = (float)(-Math.atan(x / y));
            float[] axis = SimpleIK.rotateZ(new float[]{x, y, z}, -planeAngle);
            bone_1_ang = (float)Math.atan(axis[2] / axis[1]) - bone_1_ang;
            matrix = SimpleIK.rotationMatrix(bone_1_ang - this.ang_1[0], 0.0f, this.targetPos[0] == 0.0f || axis[1] == 0.0f ? 0.0f : (float)Math.atan(this.targetPos[0] / axis[1]), null);
            if (ang != 0.0f) {
                matrix = SimpleIK.multiply(SimpleIK.rotationMatrix(axis[0], axis[1], axis[2], ang, null), matrix, null);
            }
            if (back) {
                planeAngle = (float)Math.PI - planeAngle;
            }
            if (planeAngle != 0.0f) {
                matrix = SimpleIK.multiply(SimpleIK.rotationMatrix(0.0f, 0.0f, planeAngle, null), matrix, null);
            }
            this.bone_2.field_78795_f = bone_2_ang + this.ang_1[0] - this.ang_2[0];
        }
        float[] angles = SimpleIK.eulerAngles(matrix, null);
        this.bone_1.field_78795_f = angles[0];
        this.bone_1.field_78796_g = angles[1];
        this.bone_1.field_78808_h = angles[2];
        this.bone_1.field_78800_c = base[0];
        this.bone_1.field_78797_d = base[1];
        this.bone_1.field_78798_e = base[2];
    }

    public float[] calculateBasePoint() {
        return this.calculateBasePoint(this.base, this.parents);
    }

    public float[] calculateBasePoint(@Nonnull float[] target, ModelRenderer ... models) {
        float[] vec = (float[])target.clone();
        for (int i = models.length - 1; i >= 0; --i) {
            ModelRenderer model = models[i];
            if (model.field_78795_f != 0.0f) {
                vec = SimpleIK.rotateX(vec, model.field_78795_f);
            }
            if (model.field_78796_g != 0.0f) {
                vec = SimpleIK.rotateY(vec, model.field_78796_g);
            }
            if (model.field_78808_h != 0.0f) {
                vec = SimpleIK.rotateZ(vec, model.field_78808_h);
            }
            vec = SimpleIK.addVector(vec, model.field_78800_c, model.field_78797_d, model.field_78798_e);
        }
        return vec;
    }

    public static float[] rotateX(float[] vec, float ang) {
        float cos = MathHelper.func_76134_b((float)ang);
        float sin = MathHelper.func_76126_a((float)ang);
        float y = vec[1] * cos - vec[2] * sin;
        float z = vec[2] * cos + vec[1] * sin;
        vec[1] = y;
        vec[2] = z;
        return vec;
    }

    public static float[] rotateY(float[] vec, float ang) {
        float cos = MathHelper.func_76134_b((float)ang);
        float sin = MathHelper.func_76126_a((float)ang);
        float x = vec[0] * cos + vec[2] * sin;
        float z = vec[2] * cos - vec[0] * sin;
        vec[0] = x;
        vec[2] = z;
        return vec;
    }

    public static float[] rotateZ(float[] vec, float ang) {
        float cos = MathHelper.func_76134_b((float)ang);
        float sin = MathHelper.func_76126_a((float)ang);
        float x = vec[0] * cos - vec[1] * sin;
        float y = vec[1] * cos + vec[0] * sin;
        vec[0] = x;
        vec[1] = y;
        return vec;
    }

    public static float[] multiply(float[] a, float[] b, float[] out) {
        if (out == null || out.length < 9) {
            out = new float[9];
        }
        float a11 = a[0];
        float a12 = a[1];
        float a13 = a[2];
        float a21 = a[3];
        float a22 = a[4];
        float a23 = a[5];
        float a31 = a[6];
        float a32 = a[7];
        float a33 = a[8];
        float b11 = b[0];
        float b12 = b[1];
        float b13 = b[2];
        float b21 = b[3];
        float b22 = b[4];
        float b23 = b[5];
        float b31 = b[6];
        float b32 = b[7];
        float b33 = b[8];
        out[0] = a11 * b11 + a12 * b21 + a13 * b31;
        out[1] = a11 * b12 + a12 * b22 + a13 * b32;
        out[2] = a11 * b13 + a12 * b23 + a13 * b33;
        out[3] = a21 * b11 + a22 * b21 + a23 * b31;
        out[4] = a21 * b12 + a22 * b22 + a23 * b32;
        out[5] = a21 * b13 + a22 * b23 + a23 * b33;
        out[6] = a31 * b11 + a32 * b21 + a33 * b31;
        out[7] = a31 * b12 + a32 * b22 + a33 * b32;
        out[8] = a31 * b13 + a32 * b23 + a33 * b33;
        return out;
    }

    private static float[] eulerAngles(float[] matrix, float[] out) {
        if (out == null || out.length < 3) {
            out = new float[3];
        }
        float r11 = matrix[0];
        float r12 = matrix[1];
        float r13 = matrix[2];
        float r21 = matrix[3];
        float r31 = matrix[6];
        float r32 = matrix[7];
        float r33 = matrix[8];
        float psi = 0.0f;
        float theta = 0.0f;
        float phi = 0.0f;
        if (r31 != 1.0f && r31 != -1.0f) {
            theta = (float)(-Math.asin(r31));
            float cos = (float)Math.cos(theta);
            psi = (float)Math.atan2(r32 / cos, r33 / cos);
            phi = (float)Math.atan2(r21 / cos, r11 / cos);
        } else if (r31 == -1.0f) {
            theta = 1.5707964f;
            psi = phi + (float)Math.atan2(r12, r13);
        } else {
            theta = -1.5707964f;
            psi = -phi + (float)Math.atan2(-r12, -r13);
        }
        out[0] = psi;
        out[1] = theta;
        out[2] = phi;
        return out;
    }

    private static float[] rotationMatrix(float x, float y, float z, float[] out) {
        if (out == null || out.length < 9) {
            out = new float[9];
        }
        float sinPsi = (float)Math.sin(x);
        float cosPsi = (float)Math.cos(x);
        float sinTht = (float)Math.sin(y);
        float cosTht = (float)Math.cos(y);
        float sinPhi = (float)Math.sin(z);
        float cosPhi = (float)Math.cos(z);
        return SimpleIK.copy(out, cosTht * cosPhi, sinPsi * sinTht * cosPhi - cosPsi * sinPhi, cosPsi * sinTht * cosPhi + sinPsi * sinPhi, cosTht * sinPhi, sinPsi * sinTht * sinPhi + cosPsi * cosPhi, cosPsi * sinTht * sinPhi - sinPsi * cosPhi, -sinTht, sinPsi * cosTht, cosPsi * cosTht);
    }

    private static float[] rotationMatrix(float ux, float uy, float uz, float th, float[] out) {
        float len;
        if (out == null || out.length < 9) {
            out = new float[9];
        }
        if ((len = (float)Math.sqrt(ux * ux + uy * uy + uz * uz)) != 0.0f) {
            ux /= len;
            uy /= len;
            uz /= len;
        } else {
            ux = 1.0f;
            uy = 0.0f;
            uz = 0.0f;
        }
        float cos = (float)Math.cos(th);
        float sin = (float)Math.sin(th);
        float icos = 1.0f - cos;
        float uxsq = ux * ux;
        float uysq = uy * uy;
        float uzsq = uz * uz;
        return SimpleIK.copy(out, cos + uxsq * icos, ux * uy * icos - uz * sin, ux * uz * icos + uy * sin, uy * ux * icos + uz * sin, cos + uysq * icos, uy * uz * icos - ux * sin, uz * ux * icos - uy * sin, uz * uy * icos + ux * sin, cos + uzsq * icos);
    }

    private static float[] copy(float[] out, float a, float b, float c, float d, float e, float f, float g, float h, float i) {
        out[0] = a;
        out[1] = b;
        out[2] = c;
        out[3] = d;
        out[4] = e;
        out[5] = f;
        out[6] = g;
        out[7] = h;
        out[8] = i;
        return out;
    }

    public static float[] addVector(float[] v1, float[] v2) {
        return SimpleIK.addVector(v1, v2[0], v2[1], v2[2]);
    }

    public static float[] addVector(float[] v1, float x, float y, float z) {
        v1[0] = v1[0] + x;
        v1[1] = v1[1] + y;
        v1[2] = v1[2] + z;
        return v1;
    }
}

