/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public final class RockOnGroundModel
implements IModel {
    public static final RockOnGroundModel INSTANCE = new RockOnGroundModel((ImmutableList<ResourceLocation>)ImmutableList.of());
    private final ImmutableList<ResourceLocation> textures;
    private final ItemOverrideList overrides;

    public RockOnGroundModel(ImmutableList<ResourceLocation> textures) {
        this(textures, ItemOverrideList.field_188022_a);
    }

    public RockOnGroundModel(ImmutableList<ResourceLocation> textures, ItemOverrideList overrides) {
        this.textures = textures;
        this.overrides = overrides;
    }

    public RockOnGroundModel(ModelBlock model) {
        this(RockOnGroundModel.getTextures(model), model.func_187967_g());
    }

    private static ImmutableList<ResourceLocation> getTextures(ModelBlock model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i = 0;
        while (model.func_178300_b("layer" + i)) {
            builder.add((Object)new ResourceLocation(model.func_178308_c("layer" + i)));
            ++i;
        }
        return builder.build();
    }

    public Collection<ResourceLocation> getTextures() {
        return this.textures;
    }

    public RockOnGroundModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < textures.size() + this.textures.size(); ++i) {
            if (textures.containsKey((Object)("layer" + i))) {
                builder.add((Object)new ResourceLocation((String)textures.get((Object)("layer" + i))));
                continue;
            }
            if (i >= this.textures.size()) continue;
            builder.add(this.textures.get(i));
        }
        return new RockOnGroundModel((ImmutableList<ResourceLocation>)builder.build(), this.overrides);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional transform = state.apply(Optional.empty());
        for (int i = 0; i < this.textures.size(); ++i) {
            TextureAtlasSprite sprite = bakedTextureGetter.apply((ResourceLocation)this.textures.get(i));
            builder.addAll(RockOnGroundModel.getQuadsForSprite(i, sprite, format, transform));
        }
        TextureAtlasSprite particle = bakedTextureGetter.apply(this.textures.isEmpty() ? new ResourceLocation("missingno") : (ResourceLocation)this.textures.get(0));
        ImmutableMap map = PerspectiveMapWrapper.getTransforms((IModelState)state);
        return new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), particle, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)map, this.overrides, null);
    }

    public static ImmutableList<BakedQuad> getQuadsForSprite(int tint, TextureAtlasSprite sprite, VertexFormat format, Optional<TRSRTransformation> transform) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.func_94211_a();
        int vMax = sprite.func_94216_b();
        BitSet faces = new BitSet((uMax + 1) * (vMax + 1) * 4);
        for (int f = 0; f < sprite.func_110970_k(); ++f) {
            int[] pixels = sprite.func_147965_a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (int v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u = 0; u < uMax; ++u) {
                    boolean t = RockOnGroundModel.isTransparent(pixels, uMax, vMax, u, v);
                    if (ptu && !t) {
                        RockOnGroundModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.WEST, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptu && t) {
                        RockOnGroundModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.EAST, tint, sprite, uMax, vMax, u, v);
                    }
                    if (ptv[u] && !t) {
                        RockOnGroundModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.UP, tint, sprite, uMax, vMax, u, v);
                    }
                    if (!ptv[u] && t) {
                        RockOnGroundModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.DOWN, tint, sprite, uMax, vMax, u, v);
                    }
                    ptu = t;
                    ptv[u] = t;
                }
                if (ptu) continue;
                RockOnGroundModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.EAST, tint, sprite, uMax, vMax, uMax, v);
            }
            for (int u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                RockOnGroundModel.addSideQuad((ImmutableList.Builder<BakedQuad>)builder, faces, format, transform, EnumFacing.DOWN, tint, sprite, uMax, vMax, u, vMax);
            }
        }
        builder.add((Object)RockOnGroundModel.buildQuad(format, transform, EnumFacing.NORTH, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94210_h(), 0.0f, 1.0f, 0.46875f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 0.0f, 0.46875f, sprite.func_94212_f(), sprite.func_94210_h()));
        builder.add((Object)RockOnGroundModel.buildQuad(format, transform, EnumFacing.SOUTH, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 0.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 0.53125f, sprite.func_94212_f(), sprite.func_94206_g(), 0.0f, 1.0f, 0.53125f, sprite.func_94209_e(), sprite.func_94206_g()));
        return builder.build();
    }

    private static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static void addSideQuad(ImmutableList.Builder<BakedQuad> builder, BitSet faces, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int uMax, int vMax, int u, int v) {
        int index;
        int si = side.ordinal();
        if (si > 4) {
            si -= 2;
        }
        if (!faces.get(index = (vMax + 1) * ((uMax + 1) * si + u) + v)) {
            faces.set(index);
            builder.add((Object)RockOnGroundModel.buildSideQuad(format, transform, side, tint, sprite, u, v));
        }
    }

    private static BakedQuad buildSideQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, int tint, TextureAtlasSprite sprite, int u, int v) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.func_94211_a();
        float y0 = (float)v / (float)sprite.func_94216_b();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case WEST: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case EAST: {
                y1 = ((float)v + 1.0f) / (float)sprite.func_94216_b();
                break;
            }
            case DOWN: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case UP: {
                x1 = ((float)u + 1.0f) / (float)sprite.func_94211_a();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.func_176730_m().func_177958_n() * 0.5f / (float)sprite.func_94211_a());
        float u1 = 16.0f * (x1 - (float)side.func_176730_m().func_177958_n() * 0.5f / (float)sprite.func_94211_a());
        float v0 = 16.0f * (1.0f - y0 - (float)side.func_176730_m().func_177956_o() * 0.5f / (float)sprite.func_94216_b());
        float v1 = 16.0f * (1.0f - y1 - (float)side.func_176730_m().func_177956_o() * 0.5f / (float)sprite.func_94216_b());
        switch (side) {
            case WEST: 
            case EAST: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.func_94216_b();
                v1 += 0.5f / (float)sprite.func_94216_b();
                break;
            }
            case DOWN: 
            case UP: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.func_94211_a();
                u1 -= 0.5f / (float)sprite.func_94211_a();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case WEST: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case EAST: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case DOWN: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case UP: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return RockOnGroundModel.buildQuad(format, transform, side.func_176734_d(), sprite, tint, x0, y0, z1, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0), x1, y1, z1, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x1, y1, z2, sprite.func_94214_a((double)u1), sprite.func_94207_b((double)v1), x0, y0, z2, sprite.func_94214_a((double)u0), sprite.func_94207_b((double)v0));
    }

    private static final BakedQuad buildQuad(VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, TextureAtlasSprite sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        side = side.func_176732_a(EnumFacing.Axis.X);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        RockOnGroundModel.putVertex(builder, format, transform, side, y0, z0 - 0.46875f, x0, u0, v0);
        RockOnGroundModel.putVertex(builder, format, transform, side, y1, z1 - 0.46875f, x1, u1, v1);
        RockOnGroundModel.putVertex(builder, format, transform, side, y2, z2 - 0.46875f, x2, u2, v2);
        RockOnGroundModel.putVertex(builder, format, transform, side, y3, z3 - 0.46875f, x3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, VertexFormat format, Optional<TRSRTransformation> transform, EnumFacing side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        transform.get().getMatrix().transform((Tuple4f)vec);
                        builder.put(e, new float[]{vec.x, vec.y, vec.z, vec.w});
                        continue block6;
                    }
                    builder.put(e, new float[]{x, y, z, 1.0f});
                    continue block6;
                }
                case COLOR: {
                    builder.put(e, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    continue block6;
                }
                case UV: {
                    if (format.func_177348_c(e).func_177369_e() == 0) {
                        builder.put(e, new float[]{u, v, 0.0f, 1.0f});
                        continue block6;
                    }
                }
                case NORMAL: {
                    builder.put(e, new float[]{side.func_82601_c(), side.func_96559_d(), side.func_82599_e(), 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    private static final class BakedItemModel
    implements IBakedModel {
        private final ImmutableList<BakedQuad> quads;
        private final TextureAtlasSprite particle;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms;
        private final IBakedModel otherModel;
        private final boolean isCulled;
        private final ItemOverrideList overrides;

        public BakedItemModel(ImmutableList<BakedQuad> quads, TextureAtlasSprite particle, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transforms, ItemOverrideList overrides, @Nullable IBakedModel otherModel) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            if (otherModel != null) {
                this.otherModel = otherModel;
                this.isCulled = true;
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (BakedQuad quad : quads) {
                    if (quad.func_178210_d() != EnumFacing.SOUTH) continue;
                    builder.add((Object)quad);
                }
                this.otherModel = new BakedItemModel((ImmutableList<BakedQuad>)builder.build(), particle, transforms, overrides, this);
                this.isCulled = false;
            }
        }

        public boolean func_177555_b() {
            return true;
        }

        public boolean func_177556_c() {
            return false;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public ItemOverrideList func_188617_f() {
            return this.overrides;
        }

        public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType type) {
            Pair pair = PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.transforms, (ItemCameraTransforms.TransformType)type);
            if (type == ItemCameraTransforms.TransformType.GUI && !this.isCulled && pair.getRight() == null) {
                return Pair.of((Object)this.otherModel, null);
            }
            if (type != ItemCameraTransforms.TransformType.GUI && this.isCulled) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }
    }
}

