/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.capability.handler;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import ru.liahim.mist.capability.handler.ISkillCapaHandler;
import ru.liahim.mist.network.PacketHandler;
import ru.liahim.mist.network.PacketSkillSync;

public class SkillCapaHandler
implements ISkillCapaHandler {
    private int[] skills = new int[ISkillCapaHandler.Skill.values().length];
    private EntityPlayerMP playerMP;

    @Override
    public int getSkill(ISkillCapaHandler.Skill skill) {
        return this.skills[skill.ordinal()];
    }

    @Override
    public void setSkill(ISkillCapaHandler.Skill skill, int amount) {
        this.skills[skill.ordinal()] = MathHelper.func_76125_a((int)amount, (int)0, (int)skill.getTotalSize());
        if (this.playerMP != null) {
            PacketHandler.INSTANCE.sendTo((IMessage)new PacketSkillSync(ISkillCapaHandler.getHandler((EntityPlayer)this.playerMP).getSkillsArray()), this.playerMP);
        }
    }

    @Override
    public void addSkill(ISkillCapaHandler.Skill skill, int amount) {
        this.setSkill(skill, this.skills[skill.ordinal()] + amount);
    }

    @Override
    public int[] getSkillsArray() {
        return this.skills;
    }

    @Override
    public void setSkillsArray(int[] skills) {
        this.skills = skills;
    }

    @Override
    public void setPlayer(EntityPlayer player) {
        this.playerMP = player instanceof EntityPlayerMP ? (EntityPlayerMP)player : null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        for (ISkillCapaHandler.Skill skill : ISkillCapaHandler.Skill.values()) {
            nbt.func_74768_a(skill.getName(), this.skills[skill.ordinal()]);
        }
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        for (ISkillCapaHandler.Skill skill : ISkillCapaHandler.Skill.values()) {
            this.setSkill(skill, nbt.func_74762_e(skill.getName()));
        }
    }
}

