/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.capability.handler;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import ru.liahim.mist.capability.SkillCapability;
import ru.liahim.mist.init.ModConfig;

public interface ISkillCapaHandler
extends INBTSerializable<NBTTagCompound> {
    public int getSkill(Skill var1);

    public void setSkill(Skill var1, int var2);

    public void addSkill(Skill var1, int var2);

    public int[] getSkillsArray();

    public void setSkillsArray(int[] var1);

    public void setPlayer(EntityPlayer var1);

    public static ISkillCapaHandler getHandler(EntityPlayer player) {
        ISkillCapaHandler handler = (ISkillCapaHandler)player.getCapability(SkillCapability.CAPABILITY_SKILL, null);
        handler.setPlayer(player);
        return handler;
    }

    public static enum Skill {
        TAMING("taming", new int[]{50, 150, 300, 500, 750, 1000}),
        CUTTING("cutting", new int[]{100, 300, 600, 1000}),
        MASON("mason", new int[]{500, 1000, 1500, 2000, 2500, 3000});

        private final String name;
        private final int[] levelSizesIn;
        private int[] levelSizes;
        private int[] order;
        public static Map<String, Skill> skills;

        private Skill(String name, int[] levelSizes) {
            this.name = name;
            this.levelSizesIn = levelSizes;
            this.updateSizes();
        }

        public void updateSizes() {
            this.levelSizes = new int[this.levelSizesIn.length + 1];
            this.order = new int[this.levelSizesIn.length + 1];
            int size = 0;
            double m = ModConfig.player.skillFactor[this.ordinal()];
            for (int i = 0; i < this.levelSizesIn.length; ++i) {
                size = (int)((double)size + (double)this.levelSizesIn[i] * m);
                this.levelSizes[i] = (int)((double)this.levelSizesIn[i] * m);
                this.order[i + 1] = size;
            }
            this.levelSizes[this.levelSizesIn.length] = -1;
            this.order[0] = 0;
        }

        public String getName() {
            return this.name;
        }

        public int getLevel(int count) {
            for (int i = 1; i < this.order.length; ++i) {
                if (count >= this.order[i]) continue;
                return i;
            }
            return this.order.length;
        }

        public int getLevelSize(int count) {
            return this.levelSizes[this.getLevel(count) - 1];
        }

        public int getLevelsCount() {
            return this.levelSizes.length;
        }

        public float getPosition(int count) {
            int level = this.getLevel(count) - 1;
            return (float)(count - this.order[level]) / (float)this.levelSizes[level];
        }

        public int getSizeForLevel(int level) {
            if (--level < 0) {
                level = 0;
            }
            return this.order[level];
        }

        public int getTotalSize() {
            return this.getSizeForLevel(this.order.length);
        }

        public static int getLevel(EntityPlayer player, Skill skill) {
            return skill.getLevel(ISkillCapaHandler.getHandler(player).getSkill(skill));
        }

        public static Skill fromName(String name) {
            return skills.get(name);
        }

        static {
            skills = Maps.newHashMap();
            for (Skill skill : Skill.values()) {
                skills.put(skill.getName(), skill);
            }
        }
    }
}

