/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.capability.handler;

import java.util.HashSet;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import ru.liahim.mist.capability.handler.IFoodHandler;
import ru.liahim.mist.item.food.ItemMistMushroom;

public class FoodHandler
implements IFoodHandler {
    private int[] mushroomStudyList = new int[ItemMistMushroom.MUSHROOMS.length * 16];
    private int[] mushroomCookStudyList = new int[ItemMistMushroom.MUSHROOMS.length * 16];
    private HashSet<String> toxicFoodList = new HashSet();

    @Override
    public int getMushroomStudy(int meta, boolean isCook) {
        if (isCook) {
            if (meta >= 0 && meta < this.mushroomCookStudyList.length) {
                return this.mushroomCookStudyList[meta];
            }
        } else if (meta >= 0 && meta < this.mushroomStudyList.length) {
            return this.mushroomStudyList[meta];
        }
        return 0;
    }

    @Override
    public boolean setMushroomStudy(int meta, int study, boolean isCook) {
        if (isCook) {
            if (meta >= 0 && meta < this.mushroomCookStudyList.length) {
                this.mushroomCookStudyList[meta] = study;
                return true;
            }
        } else if (meta >= 0 && meta < this.mushroomStudyList.length) {
            this.mushroomStudyList[meta] = study;
            return true;
        }
        return false;
    }

    @Override
    public int[] getMushroomList(boolean isCook) {
        return isCook ? this.mushroomCookStudyList : this.mushroomStudyList;
    }

    @Override
    public void setMushroomList(int[] list, boolean isCook) {
        if (isCook) {
            this.mushroomCookStudyList = list;
        } else {
            this.mushroomStudyList = list;
        }
    }

    @Override
    public boolean mergeMushroomList(int[] list, boolean isCook) {
        boolean change = false;
        if (isCook) {
            for (int i = 0; i < this.mushroomCookStudyList.length && i < list.length; ++i) {
                if (list[i] == 0 || list[i] == this.mushroomCookStudyList[i]) continue;
                this.mushroomCookStudyList[i] = list[i];
                change = true;
            }
        } else {
            for (int i = 0; i < this.mushroomStudyList.length && i < list.length; ++i) {
                if (list[i] == 0 || list[i] == this.mushroomStudyList[i]) continue;
                this.mushroomStudyList[i] = list[i];
                change = true;
            }
        }
        return change;
    }

    @Override
    public boolean setFoodStudy(ItemStack stack) {
        return this.setFoodStudy(String.valueOf(stack.func_77960_j()) + "_" + stack.func_77973_b().getRegistryName().toString());
    }

    @Override
    public boolean setFoodStudy(String string) {
        return this.toxicFoodList.add(string);
    }

    @Override
    public boolean isFoodStudy(ItemStack stack) {
        return this.toxicFoodList.contains(String.valueOf(stack.func_77960_j()) + "_" + stack.func_77973_b().getRegistryName().toString());
    }

    @Override
    public String[] getFoodStudyList() {
        int size = this.toxicFoodList.size();
        String[] ii = new String[this.toxicFoodList.size()];
        if (size > 0) {
            int i = 0;
            for (Object x : this.toxicFoodList.toArray()) {
                ii[i++] = (String)x;
            }
        }
        return ii;
    }

    @Override
    public void setFoodStudyList(String[] array) {
        for (String i : array) {
            this.setFoodStudy(i);
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74783_a("MushroomsStadyList", this.mushroomStudyList);
        tag.func_74783_a("MushroomsCookStadyList", this.mushroomCookStudyList);
        NBTTagList list = new NBTTagList();
        for (String str : this.getFoodStudyList()) {
            NBTTagCompound temp = new NBTTagCompound();
            temp.func_74778_a("Item", str);
            list.func_74742_a((NBTBase)temp);
        }
        tag.func_74782_a("ToxicFoodStadyList", (NBTBase)list);
        return tag;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        int[] list = nbt.func_74759_k("MushroomsStadyList");
        for (int i = 0; i < this.mushroomStudyList.length; ++i) {
            this.mushroomStudyList[i] = i < list.length ? list[i] : 0;
        }
        int[] cookList = nbt.func_74759_k("MushroomsCookStadyList");
        for (int i = 0; i < this.mushroomCookStudyList.length; ++i) {
            this.mushroomCookStudyList[i] = i < cookList.length ? cookList[i] : 0;
        }
        NBTTagList str = nbt.func_150295_c("ToxicFoodStadyList", 10);
        for (int i = 0; i < str.func_74745_c(); ++i) {
            this.setFoodStudy(str.func_150305_b(i).func_74779_i("Item"));
        }
    }
}

