/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.upperplant;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IRubberBallCollideble;
import ru.liahim.mist.api.block.ISeasonalChanges;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityRubberBall;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.world.MistWorld;

public class MistNightberry
extends MistBlock
implements IColoredBlock,
ISeasonalChanges,
IRubberBallCollideble {
    public static final PropertyEnum<EnumAge> AGE = PropertyEnum.func_177709_a((String)"age", EnumAge.class);
    public static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return BlockColoring.GRASS_COLORING_0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistNightberry() {
        super(Material.field_151585_k);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY)));
        this.func_149711_c(0.2f);
        this.func_149675_a(true);
    }

    @Override
    public String func_149739_a() {
        return "item.mist." + super.func_149739_a().substring(5);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public int func_149750_m(IBlockState state) {
        return state.func_177229_b(AGE) == EnumAge.FRUIT ? 2 : 0;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            if (rand.nextInt(10) == 0 && !(world.func_180495_p(pos.func_177979_c(2)).func_177230_c() instanceof BlockLiquid)) {
                world.func_175698_g(pos);
            } else {
                IBlockState newState = this.getSeasonState(world, pos, state, MistTime.getTickOfMonth(world));
                if (newState != null) {
                    world.func_175656_a(pos, newState);
                }
            }
        }
    }

    @Override
    public IBlockState getSeasonState(World world, BlockPos pos, IBlockState state, long monthTick) {
        EnumAge age = (EnumAge)((Object)state.func_177229_b(AGE));
        if (this.isFruitingNight(world, pos)) {
            return age == EnumAge.POTENTIAL ? state.func_177226_a(AGE, (Comparable)((Object)EnumAge.FRUIT)) : null;
        }
        return age != EnumAge.POTENTIAL ? state.func_177226_a(AGE, (Comparable)((Object)EnumAge.POTENTIAL)) : null;
    }

    private boolean isFruitingNight(World world, BlockPos pos) {
        int currentDay = MistTime.getDay();
        int fruitingDay = (int)MistWorld.getPosRandom(world, pos, MistTime.getDayInMonth());
        long tick = (world.func_72820_D() + 6000L) % 24000L;
        if (currentDay == fruitingDay && tick >= 20000L) {
            return true;
        }
        return (currentDay + 1) % MistTime.getDayInMonth() == fruitingDay && tick < 4000L;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (state.func_177229_b(AGE) == EnumAge.FRUIT && side == EnumFacing.UP) {
            if (!world.field_72995_K) {
                this.spawnFruit(world, pos.func_177972_a(side));
                world.func_175656_a(pos, state.func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY)));
            }
            return true;
        }
        return false;
    }

    protected void spawnFruit(World world, BlockPos pos) {
        ItemStack stack = new ItemStack((Item)MistItems.NIGHTBERRY);
        EntityItem entity_item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
        entity_item.func_174869_p();
        world.func_72838_d((Entity)entity_item);
        world.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.2f, 1.5f);
    }

    @Override
    public boolean isCollide(World world, IBlockState state, EntityRubberBall ball, RayTraceResult result, Random rand) {
        if (!world.field_72995_K && state.func_177229_b(AGE) == EnumAge.FRUIT && ball.getMotion().func_189985_c() > 0.5) {
            this.spawnFruit(world, result.func_178782_a().func_177972_a(result.field_178784_b));
            world.func_175656_a(result.func_178782_a(), state.func_177226_a(AGE, (Comparable)((Object)EnumAge.EMPTY)));
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != MistBlocks.FLOATING_MAT) {
            world.func_175655_b(pos, true);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumAge)((Object)state.func_177229_b(AGE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(AGE, (Comparable)((Object)EnumAge.values()[meta]));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public static enum EnumAge implements IStringSerializable
    {
        EMPTY("empty"),
        POTENTIAL("potential"),
        FRUIT("fruit");

        private final String name;

        private EnumAge(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

