/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.upperplant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import javax.vecmath.Vector2f;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockWettable;
import ru.liahim.mist.block.upperplant.MistMushroom;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.tileentity.TileEntityMycelium;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class MistMycelium
extends MistBlockWettable
implements ITileEntityProvider {
    public static final PropertyEnum<SoilType> SOIL = PropertyEnum.func_177709_a((String)"soil", SoilType.class);

    public MistMycelium() {
        super(Material.field_151578_c, 2);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.5f);
        this.setHarvestLevel("shovel", 0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected boolean showPorosityTooltip() {
        return false;
    }

    @Override
    public boolean doIfWet(World world, BlockPos pos, IBlockState state, Vector2f waterType, boolean fog, Random rand) {
        TileEntity te;
        if (!fog && (te = world.func_175625_s(pos)) instanceof TileEntityMycelium) {
            this.placeMushroom(world, pos, state, (TileEntityMycelium)te, rand, 1);
        }
        return false;
    }

    @Override
    public boolean doIfDry(World world, BlockPos pos, IBlockState state, boolean lava, Random rand) {
        TileEntity te;
        if (!lava && (te = world.func_175625_s(pos)) instanceof TileEntityMycelium && (((TileEntityMycelium)te).getMushroomState() == MistBlocks.MUSHROOMS_0.func_176223_P().func_177226_a(MistMushroom.TYPE_0, (Comparable)((Object)MistMushroom.MushroomType_0.SAND)) || ((TileEntityMycelium)te).getMushroomState() == MistBlocks.MUSHROOMS_1.func_176223_P().func_177226_a(MistMushroom.TYPE_1, (Comparable)((Object)MistMushroom.MushroomType_1.TAN)))) {
            this.placeMushroom(world, pos, state, (TileEntityMycelium)te, rand, 1);
        }
        return false;
    }

    protected void placeMushroom(World world, BlockPos pos, IBlockState state, TileEntityMycelium te, Random rand, int count) {
        if (pos.func_177956_o() > MistWorld.getFogMaxHight() && te.getMushroomState() != null && MistWorld.getHumi(world, pos, 0.0f) > (float)this.getNeededHumi(te.getMushroomState())) {
            for (int i = 0; i < count; ++i) {
                int r;
                EnumFacing face = EnumFacing.field_176754_o[rand.nextInt(4)];
                BlockPos checkPos = pos.func_177972_a(face);
                IBlockState checkState = world.func_180495_p(checkPos);
                double distance = 1.0;
                boolean reverse = false;
                int fuse = 0;
                int maxSize = te.getMaxSize();
                int radius = rand.nextInt(maxSize + 1);
                int faceSize = te.getFaceSize(face);
                for (r = 0; r < radius; ++r) {
                    if (reverse || checkState.func_177230_c() instanceof IWettable && !((IWettable)checkState.func_177230_c()).isAcid() && !(checkState.func_177230_c() instanceof MistMycelium)) {
                        if (reverse) {
                            if (++fuse > 3) {
                                te.setFaceSize(face, Math.min(r, faceSize));
                                break;
                            }
                            reverse = false;
                        } else {
                            fuse = 0;
                        }
                        int j = rand.nextInt(3);
                        if (j == 0) {
                            face = face.func_176735_f();
                        } else if (j == 2) {
                            face = face.func_176746_e();
                        }
                        if (j != 1 && distance > pos.func_177951_i((Vec3i)checkPos.func_177972_a(face))) {
                            face = rand.nextBoolean() ? face.func_176734_d() : (j == 0 ? face.func_176746_e() : face.func_176735_f());
                        }
                        checkPos = checkPos.func_177972_a(face);
                        checkState = world.func_180495_p(checkPos);
                        distance = pos.func_177951_i((Vec3i)checkPos);
                        continue;
                    }
                    boolean air = checkState.func_185904_a().func_76222_j();
                    checkState = world.func_180495_p((checkPos = checkPos.func_177972_a(face.func_176734_d())).func_177984_a());
                    if (checkState.func_177230_c() instanceof IWettable && !((IWettable)checkState.func_177230_c()).isAcid() && !(checkState.func_177230_c() instanceof MistMycelium)) {
                        checkPos = checkPos.func_177984_a();
                    } else if (air && checkPos.func_177977_b().func_177956_o() > MistWorld.getFogMaxHight()) {
                        checkState = world.func_180495_p(checkPos.func_177977_b());
                        if (checkState.func_177230_c() instanceof IWettable && !((IWettable)checkState.func_177230_c()).isAcid() && !(checkState.func_177230_c() instanceof MistMycelium)) {
                            checkPos = checkPos.func_177977_b();
                        }
                    } else {
                        checkState = world.func_180495_p(checkPos);
                        reverse = true;
                        --r;
                    }
                    distance = pos.func_177951_i((Vec3i)checkPos);
                }
                if ((double)r >= (double)faceSize * 0.75) {
                    te.setFaceSize(face, Math.min(faceSize == maxSize || r <= faceSize ? faceSize + 1 : r, 32));
                }
                boolean place = checkState.func_177230_c() == this;
                checkPos = checkState.func_177230_c() instanceof IWettable && !((IWettable)checkState.func_177230_c()).isAcid() ? checkPos.func_177984_a() : checkPos.func_177972_a(face.func_176734_d());
                checkState = world.func_180495_p(checkPos);
                while (checkState.func_177230_c() instanceof IWettable && !((IWettable)checkState.func_177230_c()).isAcid() && !(checkState.func_177230_c() instanceof MistMycelium) && checkState.func_177230_c() != MistBlocks.CLAY) {
                    place = false;
                    checkPos = checkPos.func_177984_a();
                    checkState = world.func_180495_p(checkPos);
                }
                boolean chance = rand.nextInt(32) < maxSize;
                int hum = SoilHelper.getHumus(world.func_180495_p(checkPos.func_177977_b()));
                if (checkState == Blocks.field_150350_a.func_176223_P() && (!world.func_175678_i(checkPos) || world.func_180495_p(checkPos.func_177977_b()).func_177230_c() == this && rand.nextInt(4) == 0) && (chance || hum > 0) && MistWorld.getHumi(world, checkPos, 0.0f) > (float)this.getNeededHumi(te.getMushroomState())) {
                    world.func_175656_a(checkPos, te.getMushroomState());
                    if (!chance) {
                        SoilHelper.setSoil(world, checkPos.func_177977_b(), world.func_180495_p(checkPos.func_177977_b()), hum - 1, 2);
                    }
                    te.setDeadTime(0);
                    if (count <= 1 || !rand.nextBoolean()) continue;
                    break;
                }
                if (maxSize < 16 && maxSize <= rand.nextInt(16)) continue;
                te.setDeadTime(te.getDeadTime() + 1);
                if (te.getDeadTime() != 64) continue;
                SoilHelper.setSoil(world, pos, ((Block)((SoilType)((Object)state.func_177229_b(SOIL))).getSoil()).func_176223_P(), 1, (Boolean)state.func_177229_b((IProperty)WET), 2);
                if (maxSize <= 16) break;
                boolean gold = ((MistMushroom)te.getMushroomState().func_177230_c()).getTypeProperty() == MistMushroom.TYPE_1 && te.getMushroomState().func_177229_b(MistMushroom.TYPE_1) == MistMushroom.MushroomType_1.GOLD;
                for (int j = 0; j < maxSize - 16 && !MistMycelium.generateMycelium(world, checkPos = pos.func_177982_a(rand.nextInt(64) - 32, 0, rand.nextInt(64) - 32), te.getMushroomState(), rand, gold ? 130 : MistWorld.getFogMaxHight(), false); ++j) {
                }
                break;
            }
        }
    }

    private int getNeededHumi(IBlockState state) {
        PropertyEnum prop = ((MistMushroom)state.func_177230_c()).getTypeProperty();
        if (prop == MistMushroom.TYPE_0) {
            switch ((MistMushroom.MushroomType_0)((Object)state.func_177229_b(MistMushroom.TYPE_0))) {
                case BROWN: 
                case RED: 
                case ORANGE: 
                case PINK: {
                    return 77;
                }
                case SAND: {
                    return 70;
                }
            }
            return 82;
        }
        if (prop == MistMushroom.TYPE_1) {
            switch ((MistMushroom.MushroomType_1)((Object)state.func_177229_b(MistMushroom.TYPE_1))) {
                case BEIGE: 
                case COPPER: {
                    return 75;
                }
                case TAN: {
                    return 70;
                }
            }
            return 80;
        }
        return 200;
    }

    protected ItemStack getSilkTouchDrop(IBlockState state, @Nullable TileEntity te) {
        Item item = Item.func_150898_a((Block)this);
        ItemStack stack = new ItemStack(item, 1, this.func_176201_c(state));
        if (te != null && te instanceof TileEntityMycelium) {
            NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            tag.func_74782_a("BlockEntityTag", (NBTBase)((TileEntityMycelium)te).getMushroomNBT(new NBTTagCompound()));
            stack.func_77982_d(tag);
        }
        return stack;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.005f);
        if (ModConfig.dimension.myceliumHarvesting || this.canSilkHarvest(world, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.getSilkTouchDrop(state, te);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            for (ItemStack item : items) {
                MistMycelium.func_180635_a((World)world, (BlockPos)pos, (ItemStack)item);
            }
        } else {
            this.harvesters.set(player);
            int i = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)stack);
            this.func_176226_b(world, pos, state, i);
            this.harvesters.set(null);
        }
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)((Block)((SoilType)((Object)state.func_177229_b(SOIL))).getSoil()));
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((Block)((SoilType)((Object)state.func_177229_b(SOIL))).getSoil()).func_176201_c(((Block)((SoilType)((Object)state.func_177229_b(SOIL))).getSoil()).func_176223_P().func_177226_a((IProperty)WET, state.func_177229_b((IProperty)WET)));
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess world, BlockPos pos) {
        return ((Block)((SoilType)((Object)state.func_177229_b(SOIL))).getSoil()).func_180659_g(state, world, pos);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMycelium();
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((SoilType)((Object)state.func_177229_b(SOIL))).getMetadata() << 1 | ((Boolean)state.func_177229_b((IProperty)WET) != false ? 0 : 1);
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SOIL, (Comparable)((Object)SoilType.byMetadata(meta >> 1))).func_177226_a((IProperty)WET, (Comparable)Boolean.valueOf((meta & 1) == 0));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SOIL, WET});
    }

    @Override
    public int getWaterPerm(IBlockState state) {
        return ((SoilType)((Object)state.func_177229_b(SOIL))).getSoil().getWaterPerm(((Block)((SoilType)((Object)state.func_177229_b(SOIL))).getSoil()).func_176223_P());
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getSilkTouchDrop(state, world.func_175625_s(pos));
    }

    public static boolean generateMycelium(World world, BlockPos chunkPos, IBlockState mushroom, Random rand) {
        return MistMycelium.generateMycelium(world, chunkPos, mushroom, rand, MistWorld.getFogMaxHight(), true);
    }

    public static boolean generateMycelium(World world, BlockPos chunkPos, IBlockState mushroom, Random rand, int hight) {
        return MistMycelium.generateMycelium(world, chunkPos, mushroom, rand, hight, true);
    }

    public static boolean generateMycelium(World world, BlockPos chunkPos, IBlockState mushroom, Random rand, int hight, boolean isNature) {
        SoilType type;
        IBlockState state;
        BlockPos pos;
        BlockPos blockPos = pos = isNature ? world.func_175645_m(chunkPos.func_177982_a(rand.nextInt(16) + 8, 0, rand.nextInt(16) + 8)) : chunkPos;
        while (pos.func_177956_o() > hight && !world.isSideSolid(pos, EnumFacing.UP)) {
            pos = pos.func_177977_b();
        }
        if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76224_d()) {
            return false;
        }
        if ((pos = pos.func_177977_b()).func_177956_o() > hight && (state = world.func_180495_p(pos)).func_177230_c() instanceof IWettable && !((IWettable)state.func_177230_c()).isAcid() && !(state.func_177230_c() instanceof MistMycelium) && (type = SoilType.bySoil((IWettable)state.func_177230_c())) != null) {
            world.func_180501_a(pos, MistBlocks.MYCELIUM.func_176223_P().func_177226_a(SOIL, (Comparable)((Object)type)).func_177226_a((IProperty)IWettable.WET, state.func_177229_b((IProperty)IWettable.WET)), isNature ? 18 : 3);
            ((TileEntityMycelium)world.func_175625_s(pos)).setMushroomState(mushroom, isNature);
            if (isNature) {
                chunkPos = pos;
                for (int i = 0; i < 8 + rand.nextInt(8); ++i) {
                    pos = world.func_175645_m(chunkPos.func_177982_a(rand.nextInt(64) - 32, 0, rand.nextInt(64) - 32));
                    while (pos.func_177956_o() > hight && !world.isSideSolid(pos, EnumFacing.UP)) {
                        pos = pos.func_177977_b();
                    }
                    if (pos.func_177956_o() <= hight) continue;
                    state = world.func_180495_p(pos);
                    pos = pos.func_177984_a();
                    if (!(state.func_177230_c() instanceof IWettable) || ((IWettable)state.func_177230_c()).isAcid() || state.func_177230_c() == MistBlocks.CLAY || world.func_180495_p(pos).func_185904_a().func_76224_d() || !world.func_180495_p(pos).func_185904_a().func_76222_j() || world.func_175678_i(pos)) continue;
                    world.func_180501_a(pos, mushroom, 18);
                }
            }
            return true;
        }
        return false;
    }

    public static enum SoilType implements IStringSerializable
    {
        FOREST(0, "f", MistBlocks.DIRT_F),
        CLAY(1, "c", MistBlocks.DIRT_C),
        SAND(2, "s", MistBlocks.DIRT_S),
        ROCK(3, "r", MistBlocks.DIRT_R),
        TROPIC(4, "t", MistBlocks.DIRT_T);

        private static final SoilType[] META_LOOKUP;
        private static final HashMap<IWettable, SoilType> SOIL_LOOKUP;
        private final int meta;
        private final String name;
        private final IWettable block;

        private SoilType(int meta, String name, IWettable block) {
            this.meta = meta;
            this.name = name;
            this.block = block;
        }

        public int getMetadata() {
            return this.meta;
        }

        public IWettable getSoil() {
            return this.block;
        }

        public static SoilType byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public static SoilType bySoil(IWettable soil) {
            return SOIL_LOOKUP.get(soil);
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new SoilType[SoilType.values().length];
            SOIL_LOOKUP = new HashMap();
            SoilType[] soilTypeArray = SoilType.values();
            int n = soilTypeArray.length;
            for (int i = 0; i < n; ++i) {
                SoilType type;
                SoilType.META_LOOKUP[type.getMetadata()] = type = soilTypeArray[i];
            }
            for (SoilType type : SoilType.values()) {
                SOIL_LOOKUP.put(type.getSoil(), type);
            }
        }
    }
}

