/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.upperplant;

import java.util.Random;
import net.minecraft.block.BlockMushroom;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraftforge.common.EnumPlantType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.tileentity.TileEntityMycelium;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public abstract class MistMushroom
extends BlockMushroom {
    public static final PropertyEnum<MushroomType_0> TYPE_0 = PropertyEnum.func_177709_a((String)"type", MushroomType_0.class);
    public static final PropertyEnum<MushroomType_1> TYPE_1 = PropertyEnum.func_177709_a((String)"type", MushroomType_1.class);
    public static final NoiseGeneratorPerlin NOISE_0 = new NoiseGeneratorPerlin(new Random(1234L), 1);
    public static final NoiseGeneratorPerlin NOISE_1 = new NoiseGeneratorPerlin(new Random(3456L), 1);

    public MistMushroom() {
        this.func_149672_a(SoundType.field_185850_c);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int time;
        IBlockState downState = world.func_180495_p(pos.func_177977_b());
        if (MistWorld.isPosInFog(world, pos.func_177977_b()) || downState.func_177230_c() instanceof IWettable && ((IWettable)downState.func_177230_c()).isAcid()) {
            world.func_175698_g(pos);
        } else if (rand.nextInt(4) == 0 && !MistMushroom.isPair(state, world.func_175625_s(pos.func_177977_b())) && (time = (int)(world.func_72820_D() % 24000L)) >= 6000 && time < 12000) {
            int hum;
            world.func_175698_g(pos);
            if (downState.func_177230_c() instanceof MistSoil && (hum = SoilHelper.getHumus(downState)) < 2) {
                SoilHelper.setSoil(world, pos.func_177977_b(), downState, hum + 1, 2);
            }
        }
    }

    public static boolean isPair(IBlockState mushroom, TileEntity te) {
        if (te instanceof TileEntityMycelium) {
            return mushroom == ((TileEntityMycelium)te).getMushroomState();
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            world.func_175698_g(pos);
            MistMushroom.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(this.func_180660_a(state, world.field_73012_v, 0), 1, this.func_180651_a(state)));
        }
        return false;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof IWettable && !((IWettable)world.func_180495_p(pos.func_177977_b()).func_177230_c()).isAcid();
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Cave;
    }

    public abstract PropertyEnum getTypeProperty();

    public abstract String getTypeName(int var1);

    public abstract IFoodProperty getFoodProperty(int var1);

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MistItems.MUSHROOMS_FOOD;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)MistItems.MUSHROOMS_FOOD, 1, this.func_180651_a(state));
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return false;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return false;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
    }

    public static interface IFoodProperty {
        public int getHealAmount(boolean var1);

        public float getSaturationModifier(boolean var1);

        public PotionEffect[] getPotionEffect(boolean var1);

        public float getProbability(boolean var1);

        public boolean isEdable(boolean var1);
    }

    public static enum MushroomType_1 implements IStringSerializable,
    IFoodProperty
    {
        SPOT(0, "spot", 2, 0.1f, false, 3, 0.6f, true, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 600, 1, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76436_u, 50, 0, false, false)}, 0.3f),
        CUP(1, "cup", 1, 0.3f, false, 2, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 400, 3, false, false), new PotionEffect(MobEffects.field_76436_u, 200, 0, false, false), new PotionEffect(MobEffects.field_76437_t, 1200, 2, false, false), new PotionEffect(MobEffects.field_76419_f, 1200, 2, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76436_u, 75, 0, false, false), new PotionEffect(MobEffects.field_76437_t, 600, 2, false, false), new PotionEffect(MobEffects.field_76419_f, 600, 2, false, false)}),
        AZURE(2, "azure", 1, 0.3f, false, 2, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 600, 4, false, false), new PotionEffect(MobEffects.field_76436_u, 300, 0, false, false), new PotionEffect(MobEffects.field_76440_q, 600, 0, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 100, 2, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false), new PotionEffect(MobEffects.field_76440_q, 300, 0, false, false)}),
        GREEN(3, "green", 1, 0.3f, false, 2, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 1200, 8, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false), new PotionEffect(MobEffects.field_76431_k, 600, 0, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 600, 4, false, false), new PotionEffect(MobEffects.field_76436_u, 25, 0, false, false)}),
        COPPER(4, "copper", 1, 0.2f, false, 2, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 600, 3, false, false), new PotionEffect(MobEffects.field_76436_u, 200, 0, false, false), new PotionEffect(MobEffects.field_76421_d, 600, 4, false, false), new PotionEffect(MobEffects.field_76419_f, 600, 4, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 100, 1, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false)}),
        SILVER(5, "silver", 1, 0.1f, false, 2, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76440_q, 30, 0, false, false), new PotionEffect(MobEffects.field_76433_i, 10, 0, false, false), new PotionEffect(MobEffects.field_82731_v, 300, 1, false, false), new PotionEffect(MobEffects.field_76438_s, 600, 2, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 150, 1, false, false), new PotionEffect(MobEffects.field_76438_s, 100, 1, false, false)}),
        BEIGE(6, "beige", 2, 0.2f, false, 3, 0.6f, true, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 400, 2, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false), new PotionEffect(MobEffects.field_76419_f, 800, 3, false, false)}, null),
        GOLD(7, "gold", 1, 0.1f, false, 3, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76433_i, 5, 0, false, false), new PotionEffect(MobEffects.field_76436_u, 200, 2, false, false), new PotionEffect(MobEffects.field_76431_k, 200, 0, false, false), new PotionEffect(MobEffects.field_76438_s, 400, 3, false, false), new PotionEffect(MobEffects.field_76419_f, 1200, 4, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76433_i, 5, 0, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 2, false, false), new PotionEffect(MobEffects.field_76431_k, 200, 0, false, false), new PotionEffect(MobEffects.field_76438_s, 200, 2, false, false), new PotionEffect(MobEffects.field_76419_f, 600, 2, false, false)}),
        WHITE(8, "white", 1, 0.1f, false, 2, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 600, 2, false, false), new PotionEffect(MobEffects.field_76436_u, 200, 0, false, false), new PotionEffect(MobEffects.field_76440_q, 200, 0, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 100, 0, false, false), new PotionEffect(MobEffects.field_76436_u, 25, 0, false, false), new PotionEffect(MobEffects.field_76440_q, 200, 0, false, false)}),
        VIOLET(9, "violet", 1, 0.1f, false, 3, 0.6f, false, new PotionEffect[]{new PotionEffect(MobEffects.field_76433_i, 5, 0, false, false), new PotionEffect(MobEffects.field_82731_v, 600, 0, false, false), new PotionEffect(MobEffects.field_76438_s, 600, 2, false, false), new PotionEffect(MobEffects.field_76437_t, 1200, 3, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_82731_v, 150, 0, false, false), new PotionEffect(MobEffects.field_76438_s, 200, 2, false, false), new PotionEffect(MobEffects.field_76437_t, 600, 2, false, false)}),
        LILAC(10, "lilac", 1, 0.1f, false, 2, 0.6f, true, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 600, 1, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false), new PotionEffect(MobEffects.field_76431_k, 40, 0, false, false)}, null),
        TAN(11, "tan", 1, 0.1f, false, 2, 0.6f, true, new PotionEffect[]{new PotionEffect(MobEffects.field_76433_i, 5, 0, false, false), new PotionEffect(MobEffects.field_76436_u, 100, 0, false, false), new PotionEffect(MobEffects.field_76438_s, 400, 3, false, false)}, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 400, 3, false, false)}, 0.2f);

        private static final MushroomType_1[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final int heal;
        private final float saturation;
        private final boolean edable;
        private final PotionEffect[] potion;
        private final float probability;
        private final int cookHeal;
        private final float cookSaturation;
        private final boolean cookEdable;
        private final PotionEffect[] cookPotion;
        private final float cookProbability;

        private MushroomType_1(int meta, String name, int heal, float saturation, boolean edable, int cookHeal, float cookSaturation, boolean cookEdable, PotionEffect[] potion, float probability, PotionEffect[] cookPotion, float cookProbability) {
            this.meta = meta;
            this.name = name;
            this.heal = heal;
            this.saturation = saturation;
            this.edable = edable;
            this.potion = potion;
            this.probability = probability;
            this.cookHeal = cookHeal;
            this.cookSaturation = cookSaturation;
            this.cookEdable = cookEdable;
            this.cookPotion = cookPotion;
            this.cookProbability = cookProbability;
        }

        private MushroomType_1(int meta, String name, int heal, float saturation, boolean edable, int cookHeal, float cookSaturation, boolean cookEdable, PotionEffect[] potion, PotionEffect[] cookPotion, float cookProbability) {
            this(meta, name, heal, saturation, edable, cookHeal, cookSaturation, cookEdable, potion, potion == null ? 0.0f : 1.0f, cookPotion, cookProbability);
        }

        private MushroomType_1(int meta, String name, int heal, float saturation, boolean edable, int cookHeal, float cookSaturation, boolean cookEdable, PotionEffect[] potion, PotionEffect[] cookPotion) {
            this(meta, name, heal, saturation, edable, cookHeal, cookSaturation, cookEdable, potion, potion == null ? 0.0f : 1.0f, cookPotion, cookPotion == null ? 0.0f : 1.0f);
        }

        private MushroomType_1(int meta, String name, int heal, float saturation, boolean edable, int cookHeal, float cookSaturation, boolean cookEdable) {
            this(meta, name, heal, saturation, edable, cookHeal, cookSaturation, cookEdable, null, 0.0f, null, 0.0f);
        }

        public int getMetadata() {
            return this.meta;
        }

        public static MushroomType_1 byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getHealAmount(boolean isCook) {
            return isCook ? this.cookHeal : this.heal;
        }

        @Override
        public float getSaturationModifier(boolean isCook) {
            return isCook ? this.cookSaturation : this.saturation;
        }

        @Override
        public PotionEffect[] getPotionEffect(boolean isCook) {
            return isCook ? this.cookPotion : this.potion;
        }

        @Override
        public float getProbability(boolean isCook) {
            return isCook ? this.cookProbability : this.probability;
        }

        @Override
        public boolean isEdable(boolean isCook) {
            return isCook ? this.cookEdable : this.edable;
        }

        static {
            META_LOOKUP = new MushroomType_1[MushroomType_1.values().length];
            MushroomType_1[] mushroomType_1Array = MushroomType_1.values();
            int n = mushroomType_1Array.length;
            for (int i = 0; i < n; ++i) {
                MushroomType_1 type;
                MushroomType_1.META_LOOKUP[type.getMetadata()] = type = mushroomType_1Array[i];
            }
        }
    }

    public static enum MushroomType_0 implements IStringSerializable,
    IFoodProperty
    {
        BROWN(0, "brown", 2, 0.5f, 5, 0.6f),
        BLACK(1, "black", 2, 0.3f, 4, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 300, 2, false, false)}, 0.2f),
        GRAY(2, "gray", 2, 0.4f, 4, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 100, 1, false, false)}, 0.1f),
        RED(3, "red", 2, 0.4f, 4, 0.6f),
        CORAL(4, "coral", 1, 0.1f, 3, 0.6f),
        ORANGE(5, "orange", 1, 0.4f, 3, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76438_s, 300, 3, false, false)}, 0.2f),
        YELLOW(6, "yellow", 2, 0.4f, 4, 0.6f),
        BLUE(7, "blue", 1, 0.5f, 3, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 600, 2, false, false), new PotionEffect(MobEffects.field_76437_t, 600, 2, false, false)}, 0.2f),
        PURPLE(8, "purple", 2, 0.2f, 5, 0.6f),
        MARSH(9, "marsh", 1, 0.4f, 3, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 400, 1, false, false)}, 0.2f),
        PINK(10, "pink", 1, 0.3f, 2, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 400, 1, false, false)}, 0.3f),
        PUFF(11, "puff", 1, 0.1f, 2, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76419_f, 1200, 1, false, false)}, 0.3f),
        SAND(12, "sand", 1, 0.2f, 3, 0.6f, new PotionEffect[]{new PotionEffect(MobEffects.field_76421_d, 200, 3, false, false), new PotionEffect(MobEffects.field_76438_s, 200, 1, false, false)}, 0.1f);

        private static final MushroomType_0[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final int heal;
        private final float saturation;
        private final boolean edable;
        private final PotionEffect[] potion;
        private final float probability;
        private final int cookHeal;
        private final float cookSaturation;
        private final boolean cookEdable;
        private final PotionEffect[] cookPotion;
        private final float cookProbability;

        private MushroomType_0(int meta, String name, int heal, float saturation, boolean edable, int cookHeal, float cookSaturation, boolean cookEdable, PotionEffect[] potion, float probability, PotionEffect[] cookPotion, float cookProbability) {
            this.meta = meta;
            this.name = name;
            this.heal = heal;
            this.saturation = saturation;
            this.edable = edable;
            this.potion = potion;
            this.probability = probability;
            this.cookHeal = cookHeal;
            this.cookSaturation = cookSaturation;
            this.cookEdable = cookEdable;
            this.cookPotion = cookPotion;
            this.cookProbability = cookProbability;
        }

        private MushroomType_0(int meta, String name, int heal, float saturation, int cookHeal, float cookSaturation, PotionEffect[] potion, float probability) {
            this(meta, name, heal, saturation, true, cookHeal, cookSaturation, true, potion, probability, null, 0.0f);
        }

        private MushroomType_0(int meta, String name, int heal, float saturation, int cookHeal, float cookSaturation) {
            this(meta, name, heal, saturation, true, cookHeal, cookSaturation, true, null, 0.0f, null, 0.0f);
        }

        public int getMetadata() {
            return this.meta;
        }

        public static MushroomType_0 byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        @Override
        public int getHealAmount(boolean isCook) {
            return isCook ? this.cookHeal : this.heal;
        }

        @Override
        public float getSaturationModifier(boolean isCook) {
            return isCook ? this.cookSaturation : this.saturation;
        }

        @Override
        public PotionEffect[] getPotionEffect(boolean isCook) {
            return isCook ? this.cookPotion : this.potion;
        }

        @Override
        public float getProbability(boolean isCook) {
            return isCook ? this.cookProbability : this.probability;
        }

        @Override
        public boolean isEdable(boolean isCook) {
            return isCook ? this.cookEdable : this.edable;
        }

        static {
            META_LOOKUP = new MushroomType_0[MushroomType_0.values().length];
            MushroomType_0[] mushroomType_0Array = MushroomType_0.values();
            int n = mushroomType_0Array.length;
            for (int i = 0; i < n; ++i) {
                MushroomType_0 type;
                MushroomType_0.META_LOOKUP[type.getMetadata()] = type = mushroomType_0Array[i];
            }
        }
    }
}

