/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.upperplant;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IRubberBallCollideble;
import ru.liahim.mist.api.block.ISeasonalChanges;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.common.MistTime;
import ru.liahim.mist.entity.EntityRubberBall;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.init.ModConfig;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.util.WorldUtil;
import ru.liahim.mist.world.MistWorld;

public class MistDesertCotton
extends BlockBush
implements IColoredBlock,
ISeasonalChanges,
IRubberBallCollideble {
    public static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)11);
    public static final PropertyBool ISUP = PropertyBool.func_177716_a((String)"isup");
    protected static final AxisAlignedBB UP_AABB = new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 0.6875, 0.6);
    protected static final AxisAlignedBB FULL_UP_AABB = new AxisAlignedBB(0.4, 0.0, 0.4, 0.6, 1.0, 0.6);
    protected static final AxisAlignedBB BLOOM_AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.8125, 0.7);
    protected static final AxisAlignedBB FULL_BUSH_AABB = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 1.0, 0.7);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                return world != null && pos != null ? MistDesertCotton.this.getMixColor(world, pos, state, tintIndex) : -1;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistDesertCotton() {
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(0.2f);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int age = (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)AGE);
        if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
            return age == 0 ? UP_AABB : (age <= 5 ? BLOOM_AABB : FULL_UP_AABB);
        }
        if (age >= 3 && age <= 6) {
            return FULL_BUSH_AABB;
        }
        return field_185515_b;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int age = (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)AGE);
        if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
            return age <= 5 ? UP_AABB : FULL_UP_AABB;
        }
        if (age >= 4 && age <= 6) {
            return FULL_UP_AABB;
        }
        return field_185506_k;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d start, Vec3d end) {
        int age = (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)AGE);
        if (!((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue() && age >= 3 && age <= 6) {
            ArrayList list = Lists.newArrayList();
            list.add(this.func_185503_a(pos, start, end, field_185515_b));
            list.add(this.func_185503_a(pos, start, end, FULL_UP_AABB));
            RayTraceResult raytraceresult1 = null;
            double d1 = 0.0;
            for (RayTraceResult raytraceresult : list) {
                double d0;
                if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
                raytraceresult1 = raytraceresult;
                d1 = d0;
            }
            return raytraceresult1;
        }
        return super.func_180636_a(state, world, pos, start, end);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int age;
        if (hand == EnumHand.MAIN_HAND && ((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue() && (age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) >= 1 && age <= 3) {
            Random rand = world instanceof World ? world.field_73012_v : RANDOM;
            int i = rand.nextInt(2) + 1;
            int j = rand.nextInt(2) + 1;
            if (age == 1) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(4)));
                BlockPos downPos = pos.func_177977_b();
                while (world.func_180495_p(downPos).func_177230_c() == this) {
                    if (!((Boolean)world.func_180495_p(downPos).func_177229_b((IProperty)ISUP)).booleanValue()) {
                        world.func_175656_a(downPos, state.func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(10)));
                    }
                    downPos = downPos.func_177977_b();
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistItems.DESERT_COTTON_SEED, i + j, 0));
            } else if (age == 2) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)));
                BlockPos downPos = pos.func_177977_b();
                while (world.func_180495_p(downPos).func_177230_c() == this) {
                    if (!((Boolean)world.func_180495_p(downPos).func_177229_b((IProperty)ISUP)).booleanValue()) {
                        world.func_175656_a(downPos, state.func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(10)));
                    } else {
                        world.func_175656_a(downPos, state.func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)));
                    }
                    downPos = downPos.func_177977_b();
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistItems.DESERT_COTTON_SEED, i, 0));
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistItems.DESERT_COTTON_SEED, j, 1));
            } else if (age == 3) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)));
                BlockPos downPos = pos.func_177977_b();
                while (world.func_180495_p(downPos).func_177230_c() == this) {
                    if (!((Boolean)world.func_180495_p(downPos).func_177229_b((IProperty)ISUP)).booleanValue()) {
                        int ageDown = (Integer)world.func_180495_p(downPos).func_177229_b((IProperty)AGE);
                        if (ageDown == 2) {
                            world.func_175656_a(downPos, state.func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(10)));
                        }
                        if (ageDown == 7) {
                            world.func_175656_a(downPos, state.func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(11)));
                        }
                    }
                    downPos = downPos.func_177977_b();
                }
                Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(MistItems.DESERT_COTTON_SEED, i + j, 1));
            }
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        super.func_180650_b(world, pos, state, rand);
        if (!(world.field_72995_K || ((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue() || MistWorld.isPosInFog(world, pos))) {
            Biome biome = world.func_180494_b(pos);
            IBlockState checkState = world.func_180495_p(pos.func_177977_b());
            if (checkState.func_177230_c() instanceof MistSoil && SoilHelper.getHumus(checkState) > 0 && ((MistSoil)checkState.func_177230_c()).getWaterPerm(checkState) > 1 && biome.func_180626_a(pos) > 0.5f && biome.func_76727_i() > 0.0f && biome.func_76727_i() <= 0.5f) {
                int age = (Integer)state.func_177229_b((IProperty)AGE);
                float percent = this.getBloomPersent(world, pos, MistTime.getTickOfMonth(world));
                if (age < 8) {
                    int i;
                    int size = (int)MistWorld.getPosRandom(world, pos, 4);
                    if (size == 1 || size == 2) {
                        size = 1;
                    }
                    if (size == 3) {
                        size = 2;
                    }
                    boolean air = true;
                    for (i = 0; i <= size; ++i) {
                        checkState = world.func_180495_p(pos.func_177981_b(1 + i));
                        if (checkState.func_177230_c() == Blocks.field_150350_a || checkState.func_177230_c() == this) continue;
                        air = false;
                        break;
                    }
                    if (age == 0) {
                        if ((double)percent >= 0.05) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
                        }
                    } else if (age == 1) {
                        if ((double)percent >= 0.1) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)));
                        }
                    } else if (age == 2) {
                        if ((double)percent >= 0.5) {
                            if ((double)percent < 0.55) {
                                if (size > 0 && world.func_175623_d(pos.func_177981_b(2))) {
                                    world.func_175656_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)));
                                }
                            } else if ((double)percent < 0.6) {
                                if (size > 1 && world.func_175623_d(pos.func_177981_b(3))) {
                                    if (world.func_175623_d(pos.func_177981_b(2))) {
                                        world.func_175656_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)));
                                    }
                                    world.func_175656_a(pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)));
                                }
                            } else if ((double)percent < 0.8) {
                                BlockPos checkPos = pos.func_177984_a();
                                while (world.func_180495_p(checkPos).func_177230_c() == this) {
                                    checkPos = checkPos.func_177984_a();
                                }
                                if (((Boolean)world.func_180495_p(checkPos = checkPos.func_177977_b()).func_177229_b((IProperty)ISUP)).booleanValue()) {
                                    int j = 1;
                                    if ((double)percent >= 0.7) {
                                        j = 2;
                                    }
                                    if ((double)percent >= 0.75) {
                                        j = 3;
                                    }
                                    world.func_175656_a(checkPos, this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(j)));
                                }
                            } else {
                                world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)));
                            }
                        } else if ((double)percent >= 0.4) {
                            if (!air) {
                                world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(10)));
                            } else if (world.func_175623_d(pos.func_177984_a())) {
                                world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)));
                            }
                        }
                    } else if (age == 3) {
                        if ((double)percent >= 0.45 && world.func_175623_d(pos.func_177984_a())) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(4)));
                            world.func_175656_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)));
                        }
                    } else if (age == 7) {
                        if ((double)percent >= 0.95) {
                            for (i = 1; i < 4 && world.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this; ++i) {
                                world.func_175656_a(pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P());
                            }
                        } else if ((double)percent >= 0.85) {
                            BlockPos checkPos = pos.func_177984_a();
                            while (world.func_180495_p(checkPos).func_177230_c() == this) {
                                checkPos = checkPos.func_177984_a();
                            }
                            if (((Boolean)world.func_180495_p(checkPos = checkPos.func_177977_b()).func_177229_b((IProperty)ISUP)).booleanValue()) {
                                world.func_175656_a(checkPos, this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)));
                            }
                        } else if ((double)percent < 0.8) {
                            this.dissemination(world, pos, rand);
                        }
                    }
                } else {
                    boolean grow;
                    boolean bl = grow = rand.nextInt(1 + MistTime.getDayInMonth() / ModConfig.time.desertCottonBloomCount) == 0;
                    if (age == 8 && (double)percent < 0.05) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
                    } else if (age == 9 && (double)percent >= 0.05 && (double)percent < 0.1) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)));
                    } else if (age == 10) {
                        BlockPos checkPos = pos.func_177984_a();
                        while (world.func_180495_p(checkPos).func_177230_c() == this) {
                            checkPos = checkPos.func_177984_a();
                        }
                        if (((Boolean)world.func_180495_p(checkPos = checkPos.func_177977_b()).func_177229_b((IProperty)ISUP)).booleanValue()) {
                            int ageUp;
                            if (((double)percent >= 0.95 || (double)percent < 0.1 || grow) && ((ageUp = ((Integer)world.func_180495_p(checkPos).func_177229_b((IProperty)AGE)).intValue()) == 4 || ageUp == 5)) {
                                for (int i = 1; i < 4 && world.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this; ++i) {
                                    world.func_175656_a(pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P());
                                }
                            }
                        } else if ((double)percent >= 0.1 && (double)percent < 0.4) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)));
                        }
                    } else if (age == 11) {
                        BlockPos checkPos = pos.func_177984_a();
                        while (world.func_180495_p(checkPos).func_177230_c() == this) {
                            checkPos = checkPos.func_177984_a();
                        }
                        if (((Boolean)world.func_180495_p(checkPos = checkPos.func_177977_b()).func_177229_b((IProperty)ISUP)).booleanValue()) {
                            int ageUp;
                            if (((double)percent >= 0.95 || (double)percent < 0.1 || grow) && ((ageUp = ((Integer)world.func_180495_p(checkPos).func_177229_b((IProperty)AGE)).intValue()) == 4 || ageUp == 5)) {
                                for (int i = 1; i < 4 && world.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this; ++i) {
                                    world.func_175656_a(pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P());
                                }
                            }
                        } else if ((double)percent >= 0.95) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)));
                        } else if ((double)percent < 0.05) {
                            this.dissemination(world, pos, rand);
                        } else {
                            world.func_175698_g(pos);
                        }
                    } else if (age < 10 && grow) {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + 1)));
                    }
                }
            }
        }
    }

    private void dissemination(World world, BlockPos pos, Random rand) {
        int k = 0;
        for (int i = 0; i < 3; ++i) {
            BlockPos checkPos = world.func_175645_m(pos.func_177982_a(rand.nextInt(5) - 2, 0, rand.nextInt(5) - 2)).func_177984_a();
            if (!this.func_180671_f(world, checkPos, this.func_176223_P())) continue;
            world.func_175656_a(checkPos, this.func_176223_P());
            ++k;
        }
        if (k > 0) {
            world.func_175698_g(pos);
        } else {
            world.func_175656_a(pos, this.func_176223_P());
        }
    }

    @Override
    public IBlockState getSeasonState(World world, BlockPos pos, IBlockState state, long monthTick) {
        if (!((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue() && !MistWorld.isPosInFog(world, pos)) {
            int age;
            Biome biome = world.func_180494_b(pos);
            IBlockState newState = world.func_180495_p(pos.func_177977_b());
            if (newState.func_177230_c() instanceof MistSoil && SoilHelper.getHumus(newState) > 0 && ((MistSoil)newState.func_177230_c()).getWaterPerm(newState) > 1 && biome.func_180626_a(pos) > 0.5f && biome.func_76727_i() > 0.0f && biome.func_76727_i() <= 0.5f && (age = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) < 8) {
                IBlockState checkState;
                int i;
                newState = null;
                float percent = this.getBloomPersent(world, pos, monthTick);
                int size = (int)MistWorld.getPosRandom(world, pos, 4);
                if (size == 1 || size == 2) {
                    size = 1;
                }
                if (size == 3) {
                    size = 2;
                }
                if ((double)percent < 0.5 || (double)percent >= 0.95) {
                    for (i = 1; i < 4 && (checkState = world.func_180495_p(pos.func_177981_b(i))).func_177230_c() == this; ++i) {
                        WorldUtil.simpleSetBlock(world, pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P(), true);
                    }
                }
                if ((double)percent < 0.05) {
                    newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0));
                } else if ((double)percent < 0.1) {
                    newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1));
                } else if ((double)percent < 0.4) {
                    newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2));
                } else if ((double)percent < 0.45) {
                    newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3));
                } else if ((double)percent < 0.8) {
                    newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2));
                    if ((double)percent < 0.5) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                        }
                        for (i = 2; i < 4 && (checkState = world.func_180495_p(pos.func_177981_b(i))).func_177230_c() == this; ++i) {
                            WorldUtil.simpleSetBlock(world, pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P(), true);
                        }
                    } else if ((double)percent < 0.55) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                if (world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this) {
                                    WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), Blocks.field_150350_a.func_176223_P(), true);
                                }
                            }
                        }
                    } else if ((double)percent < 0.6) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                if (size > 1 && (world.func_175623_d(pos.func_177981_b(3)) || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this)) {
                                    WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                }
                            }
                        }
                    } else if ((double)percent < 0.7) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                if (size > 1 && (world.func_175623_d(pos.func_177981_b(3)) || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this)) {
                                    WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                }
                            }
                        }
                    } else if ((double)percent < 0.75) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                if (size > 1 && (world.func_175623_d(pos.func_177981_b(3)) || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this)) {
                                    WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                }
                            }
                        }
                    } else if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                        WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                        if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                            WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 1 && (world.func_175623_d(pos.func_177981_b(3)) || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            }
                        }
                    }
                } else {
                    newState = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7));
                    if ((double)percent < 0.85) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                if (size > 1 && (world.func_175623_d(pos.func_177981_b(3)) || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this)) {
                                    WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                }
                            }
                        }
                    } else if ((double)percent < 0.95) {
                        if (world.func_175623_d(pos.func_177984_a()) || world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                            WorldUtil.simpleSetBlock(world, pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                            if (size > 0 && (world.func_175623_d(pos.func_177981_b(2)) || world.func_180495_p(pos.func_177981_b(2)).func_177230_c() == this)) {
                                WorldUtil.simpleSetBlock(world, pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                if (size > 1 && (world.func_175623_d(pos.func_177981_b(3)) || world.func_180495_p(pos.func_177981_b(3)).func_177230_c() == this)) {
                                    WorldUtil.simpleSetBlock(world, pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(true)), true);
                                }
                            }
                        }
                    } else if (age < 10) {
                        for (i = 1; i < 4 && world.func_180495_p(pos.func_177981_b(i)).func_177230_c() == this; ++i) {
                            WorldUtil.simpleSetBlock(world, pos.func_177981_b(i), Blocks.field_150350_a.func_176223_P(), true);
                        }
                    }
                }
                if (newState == state) {
                    return null;
                }
                return newState;
            }
        }
        return null;
    }

    private float getBloomPersent(World world, BlockPos pos, long monthTick) {
        long bloomRange = MistTime.getTickInYear() / (long)ModConfig.time.desertCottonBloomCount;
        return (float)(((long)MistTime.getMonth() * MistTime.getTickInMonth() + monthTick + MistWorld.getPosRandom(world, pos, 0) % (MistTime.getTickInMonth() / (long)(ModConfig.time.desertCottonBloomCount * 2))) % bloomRange) / (float)bloomRange;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            int ageUp = (Integer)stateUp.func_185899_b(world, pos.func_177984_a()).func_177229_b((IProperty)AGE);
            if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
                if (age != 7) {
                    if (ageUp < 2 || ageUp == 4) {
                        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(6));
                    }
                    if (ageUp == 2) {
                        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7));
                    }
                    if (ageUp == 3 || ageUp == 5) {
                        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(8));
                    }
                    return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(ageUp));
                }
            } else {
                if (age == 2 || age == 10) {
                    if (ageUp == 2 || ageUp == 3 || ageUp == 5 || ageUp == 8) {
                        return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5));
                    }
                    return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(4));
                }
                if (age == 7 || age == 11) {
                    return state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(6));
                }
            }
        }
        return state;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this || super.func_176196_c(world, pos);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() != this) {
            return super.func_180671_f(world, pos, state);
        }
        if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
            return world.func_180495_p(pos.func_177977_b()).func_177230_c() == this;
        }
        return super.func_180671_f(world, pos, state);
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        IBlockState down;
        super.func_180663_b(world, pos, state);
        if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() == this) {
            if (((Boolean)down.func_177229_b((IProperty)ISUP)).booleanValue()) {
                world.func_175655_b(pos.func_177977_b(), true);
            } else {
                int age = (Integer)down.func_177229_b((IProperty)AGE);
                if (age == 2) {
                    world.func_175656_a(pos.func_177977_b(), down.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(10)));
                } else if (age == 7) {
                    world.func_175656_a(pos.func_177977_b(), down.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(11)));
                }
            }
        }
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int age = (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)AGE);
        if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
            ret.add((Object)new ItemStack(Items.field_151055_y));
            int i = rand.nextInt(2) + 1;
            int j = rand.nextInt(2) + 1;
            if (age == 1) {
                ret.add((Object)new ItemStack(MistItems.DESERT_COTTON_SEED, i + j, 0));
            } else if (age == 2) {
                ret.add((Object)new ItemStack(MistItems.DESERT_COTTON_SEED, i, 0));
                ret.add((Object)new ItemStack(MistItems.DESERT_COTTON_SEED, j, 1));
            } else if (age == 3) {
                ret.add((Object)new ItemStack(MistItems.DESERT_COTTON_SEED, i + j, 1));
            }
        } else if (age == 0 || age == 8) {
            ret.add((Object)new ItemStack(MistItems.DESERT_COTTON_SEED, 1, 1));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE, ISUP});
    }

    public int func_176201_c(IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
            if (age < 6) {
                return age + 9;
            }
            if (age == 7) {
                return 15;
            }
            return 9;
        }
        if (age < 4) {
            return age;
        }
        if (age < 6) {
            return 2;
        }
        if (age < 8) {
            return 4;
        }
        return age - 3;
    }

    public IBlockState func_176203_a(int meta) {
        int age = meta < 4 ? meta : (meta == 4 ? 7 : (meta < 9 ? meta + 3 : (meta < 15 ? meta - 9 : 7)));
        return this.func_176223_P().func_177226_a((IProperty)ISUP, (Comparable)Boolean.valueOf(meta > 8)).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age));
    }

    private int getMixColor(IBlockAccess world, BlockPos pos, IBlockState state, int tintIndex) {
        int biomeColor = BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos);
        if (tintIndex == 0) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
                if (age == 2 || age == 3 || age == 5 || age == 8) {
                    return this.getBrownColor(biomeColor);
                }
                return this.getGreenColor(biomeColor);
            }
            if (age == 6 || age == 7 || age == 11) {
                return this.getBrownColor(biomeColor);
            }
            return this.getGreenColor(biomeColor);
        }
        if (tintIndex == 1) {
            int age = (Integer)state.func_177229_b((IProperty)AGE);
            if (((Boolean)state.func_177229_b((IProperty)ISUP)).booleanValue()) {
                if (age == 1 || age == 2) {
                    return this.getYellowColor(biomeColor);
                }
                if (age == 3) {
                    return this.getWhiteColor(biomeColor);
                }
                if (age == 7) {
                    return this.getBrownColor(biomeColor);
                }
                return this.getGreenColor(biomeColor);
            }
            if (age == 5) {
                return this.getBrownColor(biomeColor);
            }
            return this.getGreenColor(biomeColor);
        }
        if (tintIndex == 2) {
            return this.getWhiteColor(biomeColor);
        }
        return biomeColor;
    }

    private int getGreenColor(int biomeColor) {
        int r = (34 + (biomeColor >> 16 & 0xFF) * 3) / 4;
        int g = (111 + (biomeColor >> 8 & 0xFF) * 3) / 4;
        int b = (45 + (biomeColor & 0xFF) * 3) / 4;
        return r << 16 | g << 8 | b;
    }

    private int getBrownColor(int biomeColor) {
        int r = ((biomeColor >> 16 & 0xFF) + 400) / 3;
        int g = ((biomeColor >> 8 & 0xFF) + 320) / 3;
        int b = ((biomeColor & 0xFF) + 200) / 3;
        return r << 16 | g << 8 | b;
    }

    private int getYellowColor(int biomeColor) {
        int r = ((biomeColor >> 16 & 0xFF) + 510) / 3;
        int g = ((biomeColor >> 8 & 0xFF) + 444) / 3;
        int b = ((biomeColor & 0xFF) + 78) / 3;
        return r << 16 | g << 8 | b;
    }

    private int getWhiteColor(int biomeColor) {
        int r = ((biomeColor >> 16 & 0xFF) + 510) / 3;
        int g = ((biomeColor >> 8 & 0xFF) + 510) / 3;
        int b = ((biomeColor & 0xFF) + 510) / 3;
        return r << 16 | g << 8 | b;
    }

    @Override
    public boolean isCollide(World world, IBlockState state, EntityRubberBall ball, RayTraceResult result, Random rand) {
        if (!world.field_72995_K && ball.getMotion().func_189985_c() > 0.5) {
            world.func_175655_b(result.func_178782_a(), true);
            ball.field_70159_w *= rand.nextDouble() * 0.5 + 0.5;
            ball.field_70181_x *= rand.nextDouble() * 0.5 + 0.5;
            ball.field_70179_y *= rand.nextDouble() * 0.5 + 0.5;
            return false;
        }
        return true;
    }
}

