/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class MistTrunkWillow
extends MistTreeTrunk {
    public MistTrunkWillow() {
        super(4.0f, 2, 2, true, true, true, (MistTreeLeaves)MistBlocks.WILLOW_LEAVES, 1, 0, 5, new int[]{1, 1, 1, 2});
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 10;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 2;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return Math.min(3 + (int)(posRand % 6L) % 3 + (int)(posRand % 5L) % 2, 5);
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength + 7 + (int)(posRand % 6L) % 3;
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        if (rand.nextInt(1000) == 0 && ((MistSoil)soil.func_177230_c()).getWaterPerm(soil) > 2) {
            SoilHelper.setSoil(world, soilPos, soil, 3, 2);
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.2)) != 0) {
                return isBud ? 1 : 0;
            }
            if ((double)temp < -0.5 || (double)temp > 1.8 || humi < 10.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                int trunckSize = (Integer)world.func_180495_p(fixPos).func_185899_b((IBlockAccess)world, fixPos).func_177229_b((IProperty)SIZE);
                if (branchLength <= trunckSize && firstSizeChangeDistance == 1 && totalLength - branchLength < maxTreeHeight - 1 && fixPos.func_177951_i((Vec3i)pos) < 9.0) {
                    return 2;
                }
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance < 4) {
                if (totalLength < maxTreeHeight) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if (temp > 0.0f && (double)temp < 1.5 && humi > 30.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            return 0;
        }
        return -1;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        for (EnumFacing face : availableGrowthDirection) {
            if (face == EnumFacing.UP) {
                if ((branchLength != 0 || totalLength == maxTreeHeight - 2) && (dir == EnumFacing.UP || rand.nextInt(2) != 0)) continue;
                growthDir.add(face);
                continue;
            }
            if (trunckLength != totalLength - branchLength && branchLength <= 0 && dir != EnumFacing.UP && availableGrowthDirection.contains(EnumFacing.UP) && totalLength - trunckLength != 1) continue;
            if (branchLength == 0) {
                IBlockState downBranch;
                if ((totalLength <= minTrunckLength && availableGrowthDirection.contains(EnumFacing.UP) && totalLength != maxTreeHeight - 2 || rand.nextInt(3) <= 0) && totalLength != maxTreeHeight - 1 || (downBranch = world.func_180495_p(pos.func_177972_a(face).func_177977_b())).func_177230_c() == this && this.getDir(downBranch) == face) continue;
                growthDir.add(face);
                continue;
            }
            if (face != dir && !rand.nextBoolean()) continue;
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected boolean isLeavesRemoved(World world, int totalLength, int branchLength, int minTrunckLength, int trunckLength, int firstBranchDistance, BlockPos pos, BlockPos newPos, EnumFacing dir, Random rand) {
        if (dir != EnumFacing.UP) {
            IBlockState checkState;
            int i;
            int count = 0;
            for (i = 1; i < 5 && (checkState = world.func_180495_p(pos.func_177979_c(i))).func_177230_c() == this.leaves && checkState.func_177229_b((IProperty)LDIR) == EnumFacing.DOWN; ++i) {
                ++count;
            }
            world.func_175698_g(pos);
            if (count == 0) {
                count = rand.nextInt(2);
            }
            if (count > 0) {
                for (i = 1; i <= count && this.checkEnvironment(world, newPos.func_177979_c(i), false); ++i) {
                    world.func_175656_a(newPos.func_177979_c(i), this.leaves.func_176223_P().func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                }
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > 3 + rootSize) {
                return Math.min(trunckLength, lastSegment - 1);
            }
        }
        return 0;
    }

    @Override
    protected boolean checkEnvironment(World world, BlockPos pos, boolean checkLight) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.leaves && state.func_177229_b((IProperty)LDIR) == EnumFacing.DOWN) {
            return true;
        }
        return this.func_176196_c(world, pos) && (!checkLight || (double)this.checkLight(world, pos) > 0.45) && !(state.func_177230_c() instanceof BlockLiquid);
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState downState;
        if (!world.field_72995_K && (downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistSoil && ((MistSoil)downState.func_177230_c()).getWaterPerm(downState) < 3 && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            BlockPos checkPos;
            boolean potential;
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, 0);
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, 0);
            BlockPos trunkPos = pos;
            int counter = 0;
            for (int i = 0; i < maxTreeHight - 2 && this.checkEnvironment(world, trunkPos.func_177984_a(), false); ++i) {
                ++counter;
                world.func_180501_a(trunkPos, this.func_176223_P(), 2);
                trunkPos = trunkPos.func_177984_a();
            }
            maxTreeHight = counter;
            counter += 2;
            int size = 0;
            int nodeNumber = -1;
            for (int i = 0; i < 4; ++i) {
                if ((counter -= this.nodeDistance[i]) >= i + 2) {
                    ++size;
                    ++nodeNumber;
                    continue;
                }
                counter += this.nodeDistance[i];
                break;
            }
            boolean bl = potential = size == 4;
            if (size == 4) {
                SoilHelper.setSoil(world, pos.func_177977_b(), ((MistSoil)downState.func_177230_c()).getSoilBlock().func_176223_P(), 2, true, 18);
            }
            trunkPos = pos;
            ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
            ArrayList<BlockPos> branches2 = new ArrayList<BlockPos>();
            for (int i = 0; i < maxTreeHight; ++i) {
                boolean node = false;
                if (counter == 0 && nodeNumber >= 0) {
                    node = true;
                    counter = this.nodeDistance[nodeNumber];
                    --nodeNumber;
                    --size;
                }
                if (i >= minTrunckLength && i < maxTreeHight - 1) {
                    EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
                    int n = enumFacingArray.length;
                    for (int j = 0; j < n; ++j) {
                        EnumFacing dir = enumFacingArray[j];
                        if (rand.nextInt(3) <= 0 || !this.checkEnvironment(world, checkPos = trunkPos.func_177972_a(dir), false) || (downState = world.func_180495_p(checkPos.func_177977_b())).func_177230_c() == this && this.getDir(downState) == dir) continue;
                        boolean join = false;
                        int bud = 0;
                        for (int j2 = 0; j2 < 3 && j2 < size + 1; ++j2) {
                            if (this.checkEnvironment(world, checkPos.func_177972_a(dir), false)) {
                                world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(join)), 2);
                                checkPos = checkPos.func_177972_a(dir);
                                join = true;
                                ++bud;
                                continue;
                            }
                            if (j2 == 1 && size > 2) {
                                world.func_175698_g(checkPos.func_177972_a(dir.func_176734_d()));
                                bud = 0;
                                break;
                            }
                            if (j2 <= 0) break;
                            world.func_180501_a(trunkPos.func_177972_a(dir), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                            break;
                        }
                        if (bud > 0) {
                            this.createBud(world, trunkPos.func_177967_a(dir, bud), dir.func_176734_d(), potential);
                        }
                        if (bud > 1) {
                            checkPos = trunkPos.func_177972_a(dir);
                            for (EnumFacing dir2 : EnumFacing.field_176754_o) {
                                if (dir2 == dir || dir2 == dir.func_176734_d() || !rand.nextBoolean() || !this.checkEnvironment(world, checkPos.func_177972_a(dir2), false)) continue;
                                world.func_180501_a(checkPos.func_177972_a(dir2), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir2), 2);
                                branches.add(checkPos.func_177972_a(dir2));
                            }
                        }
                        if (bud <= 2) continue;
                        checkPos = trunkPos.func_177967_a(dir, 2);
                        for (EnumFacing dir2 : DIR.func_177700_c()) {
                            if (dir2 == dir || dir2 == dir.func_176734_d() || !rand.nextBoolean() || !this.checkEnvironment(world, checkPos.func_177972_a(dir2), false)) continue;
                            world.func_180501_a(checkPos.func_177972_a(dir2), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir2), 2);
                            branches.add(checkPos.func_177972_a(dir2));
                        }
                        checkPos = trunkPos.func_177972_a(dir);
                        for (EnumFacing dir2 : EnumFacing.field_176754_o) {
                            if (dir2 == dir || dir2 == dir.func_176734_d() || !rand.nextBoolean() || !this.checkEnvironment(world, checkPos.func_177972_a(dir2), false)) continue;
                            world.func_180501_a(checkPos.func_177972_a(dir2), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir2), 2);
                            branches2.add(checkPos.func_177972_a(dir2));
                        }
                    }
                }
                if (i == 0 && size == 4) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else if (j < 6) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    }
                } else {
                    world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                }
                trunkPos = trunkPos.func_177984_a();
                --counter;
            }
            trunkPos = trunkPos.func_177977_b();
            counter = 0;
            for (EnumFacing dir1 : EnumFacing.field_176754_o) {
                checkPos = trunkPos.func_177972_a(dir1);
                if (!rand.nextBoolean() && (counter != 0 || dir1 != EnumFacing.EAST) || !this.checkEnvironment(world, checkPos, false)) continue;
                world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir1), 2);
                if (this.createBranch(world, checkPos, rand, potential)) {
                    ++counter;
                    continue;
                }
                world.func_175698_g(checkPos);
            }
            if (counter == 0) {
                this.createBud(world, trunkPos, EnumFacing.DOWN, potential);
            }
            if (!branches.isEmpty()) {
                for (BlockPos pos1 : branches) {
                    downState = world.func_180495_p(pos1);
                    boolean up = downState.func_177229_b((IProperty)DIR) == EnumFacing.UP;
                    if (this.createBranch(world, downState, pos1, pos.func_177981_b(pos1.func_177956_o() - pos.func_177956_o() - (up ? 1 : 0)), rand, up ? EnumFacing.UP : EnumFacing.DOWN, potential)) continue;
                    world.func_175698_g(pos1);
                }
            }
            if (!branches2.isEmpty()) {
                for (BlockPos pos1 : branches2) {
                    boolean check = false;
                    for (EnumFacing dir1 : DIR.func_177700_c()) {
                        if (!rand.nextBoolean() || !this.checkEnvironment(world, checkPos = pos1.func_177972_a(dir1), false)) continue;
                        boolean up = dir1 == EnumFacing.UP;
                        downState = this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir1);
                        world.func_180501_a(checkPos, downState, 2);
                        if (!this.createBranch(world, downState, checkPos, pos.func_177981_b(checkPos.func_177956_o() - pos.func_177956_o() - (up ? 1 : 0)), rand, up ? EnumFacing.UP : EnumFacing.DOWN, potential)) {
                            world.func_175698_g(checkPos);
                            continue;
                        }
                        check = true;
                    }
                    if (check) continue;
                    downState = world.func_180495_p(pos1);
                    if (this.createBud(world, pos1, ((EnumFacing)downState.func_177229_b((IProperty)DIR)).func_176734_d(), potential)) {
                        world.func_180501_a(pos1, downState.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                        continue;
                    }
                    world.func_175698_g(pos1);
                }
            }
            for (int x = -4; x < 5; ++x) {
                for (int y = minTrunckLength; y <= maxTreeHight; ++y) {
                    for (int z = -4; z < 5; ++z) {
                        EnumFacing dir;
                        checkPos = pos.func_177982_a(x, y, z);
                        downState = world.func_180495_p(checkPos);
                        if (downState.func_177230_c() != this.leaves || (dir = (EnumFacing)downState.func_177229_b((IProperty)LDIR)) == EnumFacing.UP || dir == EnumFacing.DOWN) continue;
                        int count = (int)MistWorld.getPosRandom(world, checkPos, 4) + 1;
                        for (int i = 1; i <= count && this.checkEnvironment(world, checkPos.func_177979_c(i), false); ++i) {
                            if (potential) {
                                world.func_180501_a(checkPos.func_177979_c(i), this.leaves.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(checkPos.func_177979_c(i), this.leaves.func_176223_P().func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)), 2);
                        }
                    }
                }
            }
            this.drainZone(world, pos.func_177977_b(), 2, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 3);
            }
        }
    }

    @Override
    protected boolean checkDistanse(BlockPos pos, BlockPos oldPos, BlockPos rootPos) {
        return rootPos.func_177951_i((Vec3i)pos) < 9.0;
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(3) + 3;
            boolean check = true;
            for (int i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                for (int i = 0; i < j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.WILLOW_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (checkSnow && world.func_175708_f(checkPos.func_177984_a(), false)) {
                        world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                    }
                    if (i <= 1) continue;
                    for (EnumFacing branchFace : FacingHelper.NOTDOWN) {
                        BlockPos branchPos;
                        if (branchFace.func_176740_k() == face.func_176740_k() || rand.nextInt(3) != 0 || world.func_180495_p((branchPos = checkPos.func_177972_a(branchFace)).func_177972_a(face.func_176734_d())).func_177230_c() == MistBlocks.WILLOW_BRANCH || !world.func_180495_p(branchPos).func_185904_a().func_76222_j()) continue;
                        if (world.func_180495_p(branchPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                            world.func_175698_g(branchPos.func_177984_a());
                        }
                        world.func_180501_a(branchPos, MistBlocks.WILLOW_BRANCH.func_176223_P().func_177226_a((IProperty)MistBlockBranch.SIZE, (Comparable)Integer.valueOf(1)).func_177226_a(MistBlockBranch.AXIS, (Comparable)branchFace.func_176740_k()), 2);
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.WILLOW_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.WILLOW_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.WILLOW_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.WILLOW_BLOCK, 1, 7);
    }
}

