/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMist;

public class MistTrunkTTree
extends MistTreeTrunk {
    public MistTrunkTTree() {
        super(6.0f, 3, 4, true, true, false, (MistTreeLeaves)MistBlocks.T_TREE_LEAVES, 1, 0, 5, new int[]{1, 1, 2, 2});
    }

    @Override
    protected int getSoilDepth(World world, BlockPos rootPos) {
        int s = -1;
        BlockPos pos = rootPos.func_177977_b();
        while (s < 3 && world.func_180495_p(pos).func_177230_c() instanceof MistSoil) {
            ++s;
            pos = pos.func_177977_b();
        }
        return s;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return 2 + (int)(posRand % 6L) % 3;
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength + 6 + soilDepth * 2 + (int)(posRand % 8L) % 5;
    }

    @Override
    protected int getGrowingThickness(EnumFacing face, Random rand) {
        return rand.nextInt(2);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        long tick;
        Biome biome;
        if (!world.field_72995_K && MistWorld.canPlayAmbiendSounds(world, pos) && (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)SIZE) == 4 && (biome = world.func_180494_b(pos)) instanceof BiomeMist && ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Jungle && (tick = (world.func_72820_D() + 23000L) % 24000L) < 10000L && rand.nextInt(1 + (int)Math.abs(tick - 5000L) / 1000) == 0) {
            world.func_184133_a(null, pos, MistSounds.BLOCK_TROPIC_CICADA, SoundCategory.AMBIENT, world.field_73012_v.nextFloat() * 0.4f + 0.8f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
        }
        super.func_180650_b(world, pos, state, rand);
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.15)) != 0) {
                return isBud ? 1 : 0;
            }
            if ((double)temp < 0.0 || (double)temp > 2.5 || humi < 10.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                int trunckSize = (Integer)world.func_180495_p(fixPos).func_185899_b((IBlockAccess)world, fixPos).func_177229_b((IProperty)SIZE);
                if (pos.func_177956_o() == fixPos.func_177956_o()) {
                    if (branchLength <= Math.min(3, trunckSize) && fixPos.func_177951_i((Vec3i)pos) < 16.0) {
                        return 2;
                    }
                    return isBud ? 1 : 0;
                }
                BlockPos fixPos2 = pos.func_177967_a(dir.func_176734_d(), firstBendDistance);
                trunckSize = (Integer)world.func_180495_p(fixPos2).func_185899_b((IBlockAccess)world, fixPos2).func_177229_b((IProperty)SIZE);
                if (branchLength <= Math.min(3, trunckSize)) {
                    return 2;
                }
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance < 4) {
                if (totalLength < maxTreeHeight || dir != EnumFacing.UP) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if ((double)temp > 0.5 && (double)temp < 2.0 && humi > 20.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            return 0;
        }
        return -1;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        EnumFacing direct = null;
        int i = rand.nextInt(3) + 2;
        if (!(branchLength != 0 || firstBendDistance < i || availableGrowthDirection.isEmpty() || availableGrowthDirection.size() == 1 && availableGrowthDirection.contains(EnumFacing.UP))) {
            while ((direct = availableGrowthDirection.get(rand.nextInt(availableGrowthDirection.size()))) == EnumFacing.UP) {
            }
        }
        for (EnumFacing face : availableGrowthDirection) {
            if (face == EnumFacing.UP) {
                if (branchLength == 0 && (totalLength <= minTrunckLength || firstBendDistance > 0 && firstBendDistance < i || dir != EnumFacing.UP || rand.nextInt(4) == 0)) {
                    growthDir.add(face);
                }
                if (branchLength <= 0 || rand.nextInt(4) <= 0) continue;
                growthDir.add(face);
                continue;
            }
            if (trunckLength != totalLength - branchLength && branchLength <= 0 && dir != EnumFacing.UP && availableGrowthDirection.contains(EnumFacing.UP)) continue;
            if (branchLength == 0) {
                IBlockState downBranch;
                if (totalLength <= minTrunckLength && availableGrowthDirection.contains(EnumFacing.UP) || rand.nextInt(firstBendDistance >= i ? 6 : 3) != 0 && face != direct || (downBranch = world.func_180495_p(pos.func_177972_a(face).func_177977_b())).func_177230_c() == this && this.getDir(downBranch) == face) continue;
                growthDir.add(face);
                continue;
            }
            if (face != dir && rand.nextInt(3) <= 0) continue;
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected boolean isLeavesRemoved(World world, int totalLength, int branchLength, int minTrunckLength, int trunckLength, int firstBranchDistance, BlockPos pos, BlockPos newPos, EnumFacing dir, Random rand) {
        if (dir != EnumFacing.UP) {
            boolean cross = false;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                IBlockState checkState = world.func_180495_p(pos.func_177972_a(face));
                if (checkState.func_177230_c() == this.leaves && checkState.func_177229_b((IProperty)LDIR) == EnumFacing.DOWN) {
                    if (newPos.func_177972_a(face) == pos) {
                        cross = true;
                    } else if (this.checkEnvironment(world, newPos.func_177972_a(face), false)) {
                        world.func_175656_a(newPos.func_177972_a(face), checkState);
                    }
                    world.func_175698_g(pos.func_177972_a(face));
                    continue;
                }
                if (rand.nextInt(3) != 0 || !this.checkEnvironment(world, newPos.func_177972_a(face), false)) continue;
                world.func_175656_a(newPos.func_177972_a(face), this.leaves.func_176223_P().func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
            }
            if (cross) {
                world.func_175656_a(pos, this.leaves.func_176223_P().func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
            } else {
                world.func_175698_g(pos);
            }
        } else {
            return true;
        }
        return false;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > rootSize + 5) {
                return Math.min(trunckLength, lastSegment - this.nodeDistance[rootSize]);
            }
        }
        return 0;
    }

    @Override
    protected boolean checkEnvironment(World world, BlockPos pos, boolean checkLight) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.leaves && state.func_177229_b((IProperty)LDIR) == EnumFacing.DOWN) {
            return true;
        }
        return this.func_176196_c(world, pos) && (!checkLight || (double)this.checkLight(world, pos) > 0.45) && !(state.func_177230_c() instanceof BlockLiquid);
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState checkState;
        if (!world.field_72995_K && (checkState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistSoil && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            EnumFacing dir;
            int n;
            int size;
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int soilDepth = this.getSoilDepth(world, pos);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, soilDepth);
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, soilDepth);
            BlockPos checkPos = pos;
            int counter = 0;
            for (int i = 0; i <= minTrunckLength && this.checkEnvironment(world, checkPos.func_177984_a(), false); ++i) {
                ++counter;
                if (i == 0) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST), 2);
                    } else if (j < 6) {
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST), 2);
                    } else {
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)), 2);
                    }
                } else {
                    world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)), 2);
                }
                checkPos = checkPos.func_177984_a();
            }
            SoilHelper.setSoil(world, pos.func_177977_b(), ((MistSoil)checkState.func_177230_c()).getSoilBlock().func_176223_P(), 2, true, 18);
            Map<BlockPos, Integer> cornerPoses = new HashMap<BlockPos, Integer>();
            ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
            cornerPoses = this.chooseCornerPoses(world, checkPos.func_177977_b(), counter, rand, cornerPoses);
            if (!cornerPoses.isEmpty()) {
                while (!cornerPoses.isEmpty()) {
                    BlockPos cornerPos = (BlockPos)cornerPoses.keySet().toArray()[cornerPoses.size() - 1];
                    counter = cornerPoses.get(cornerPos);
                    int segment = Math.max(1, Math.min(rand.nextInt(3) + 2, maxTreeHight - counter));
                    checkState = world.func_180495_p(cornerPos);
                    if (checkState.func_177230_c() == this) {
                        int i;
                        size = (Integer)checkState.func_185899_b((IBlockAccess)world, cornerPos).func_177229_b((IProperty)SIZE);
                        checkPos = cornerPos.func_177984_a();
                        boolean check = true;
                        block2: for (i = 1; i <= (size == 0 ? 1 : segment); ++i) {
                            EnumFacing face;
                            int n2;
                            EnumFacing[] enumFacingArray;
                            if (!this.checkEnvironment(world, checkPos, false) && world.func_180495_p(checkPos).func_177230_c() != this.leaves) {
                                if (i != 1) break;
                                check = false;
                                checkPos = cornerPos.func_177972_a(this.getDir(checkState).func_176734_d());
                                world.func_175698_g(cornerPos);
                                enumFacingArray = EnumFacing.field_176754_o;
                                n2 = enumFacingArray.length;
                                for (n = 0; n < n2; ++n) {
                                    face = enumFacingArray[n];
                                    checkState = world.func_180495_p(checkPos.func_177972_a(face));
                                    if (checkState.func_177230_c() != this || this.getDir(checkState) != face) continue;
                                    check = true;
                                }
                                if (!check) {
                                    enumFacingArray = EnumFacing.field_176754_o;
                                    n2 = enumFacingArray.length;
                                    for (n = 0; n < n2; ++n) {
                                        face = enumFacingArray[n];
                                        if (checkPos.func_177972_a(face) == cornerPos || cornerPoses.containsKey(checkPos.func_177972_a(face)) || !this.checkEnvironment(world, checkPos.func_177972_a(face), false) || !this.checkEnvironment(world, checkPos.func_177972_a(face).func_177984_a(), false)) continue;
                                        world.func_180501_a(checkPos.func_177972_a(face), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)face), 2);
                                        cornerPoses.put(checkPos.func_177972_a(face), cornerPoses.get(cornerPos));
                                        break block2;
                                    }
                                    break;
                                }
                                check = false;
                                break;
                            }
                            world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)), 2);
                            if (i != segment && ++counter > minTrunckLength) {
                                enumFacingArray = EnumFacing.field_176754_o;
                                n2 = enumFacingArray.length;
                                for (n = 0; n < n2; ++n) {
                                    face = enumFacingArray[n];
                                    if (rand.nextInt(3) != 0 || !this.checkEnvironment(world, checkPos.func_177972_a(face), false) || (checkState = world.func_180495_p(checkPos.func_177972_a(face).func_177977_b())).func_177230_c() == this && this.getDir(checkState) == face) continue;
                                    world.func_180501_a(checkPos.func_177972_a(face), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)face), 2);
                                    branches.add(checkPos.func_177972_a(face));
                                }
                            }
                            checkPos = checkPos.func_177984_a();
                        }
                        cornerPoses.remove(cornerPos);
                        if (!check || (checkState = world.func_180495_p(checkPos = checkPos.func_177977_b())).func_177230_c() != this) continue;
                        if (counter < maxTreeHight) {
                            cornerPoses = this.chooseCornerPoses(world, checkPos, counter, rand, cornerPoses);
                            continue;
                        }
                        if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == this.leaves) {
                            world.func_175698_g(checkPos.func_177984_a());
                        }
                        this.createBud(world, checkPos, EnumFacing.DOWN, true);
                        if (size <= 0) continue;
                        world.func_180501_a(checkPos, checkState.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                        if (size <= 1) continue;
                        for (i = 1; i < size; ++i) {
                            if ((checkState = world.func_180495_p(checkPos = checkPos.func_177972_a(((EnumFacing)checkState.func_177229_b((IProperty)DIR)).func_176734_d()))).func_177230_c() != this) continue;
                            world.func_180501_a(checkPos, checkState.func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                        }
                        continue;
                    }
                    cornerPoses.remove(cornerPos);
                }
            }
            if (!branches.isEmpty()) {
                ArrayList<BlockPos> branches2 = new ArrayList<BlockPos>();
                block7: for (BlockPos brPos : branches) {
                    checkState = world.func_180495_p(brPos);
                    if (checkState.func_177230_c() != this) continue;
                    dir = (EnumFacing)checkState.func_177229_b((IProperty)DIR);
                    checkState = world.func_180495_p(brPos.func_177972_a(dir.func_176734_d()));
                    checkPos = brPos.func_177972_a(dir);
                    if (!this.checkEnvironment(world, checkPos, false) || checkState.func_177230_c() != this) {
                        world.func_175698_g(brPos);
                        continue;
                    }
                    size = Math.min(3, (Integer)checkState.func_185899_b((IBlockAccess)world, brPos).func_177229_b((IProperty)SIZE));
                    if (size > 1) {
                        for (int i = 0; i < size - 1; ++i) {
                            if (this.checkEnvironment(world, checkPos.func_177972_a(dir), false)) {
                                world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf((size - i) % 2 == 1)), 2);
                                if (i == size - 2) {
                                    branches2.add(checkPos);
                                    if (size != 3) continue;
                                    EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
                                    n = enumFacingArray.length;
                                    for (int face = 0; face < n; ++face) {
                                        EnumFacing face2 = enumFacingArray[face];
                                        if (face2 == dir || face2 == dir.func_176734_d() || rand.nextInt(4) <= 0 || !this.checkEnvironment(world, checkPos = brPos.func_177972_a(dir).func_177972_a(face2), false)) continue;
                                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)face2), 2);
                                        branches2.add(checkPos);
                                    }
                                    continue;
                                }
                                checkPos = checkPos.func_177972_a(dir);
                                continue;
                            }
                            if (i == 0) {
                                if (size < 3) {
                                    world.func_180501_a(brPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(false)), 2);
                                    this.createBud(world, brPos, dir.func_176734_d(), true);
                                    continue block7;
                                }
                                world.func_175698_g(brPos);
                                continue block7;
                            }
                            branches2.add(checkPos);
                            continue block7;
                        }
                        continue;
                    }
                    branches2.add(brPos);
                }
                if (!branches.isEmpty()) {
                    for (BlockPos brPos : branches2) {
                        this.createBranch(world, brPos, rand, true);
                    }
                }
            }
            for (int x = -6; x < 7; ++x) {
                for (int y = minTrunckLength; y <= maxTreeHight; ++y) {
                    for (int z = -6; z < 7; ++z) {
                        checkPos = pos.func_177982_a(x, y, z);
                        checkState = world.func_180495_p(checkPos);
                        if (checkState.func_177230_c() != this.leaves || (dir = (EnumFacing)checkState.func_177229_b((IProperty)LDIR)) == EnumFacing.UP || dir == EnumFacing.DOWN) continue;
                        for (EnumFacing face : EnumFacing.field_176754_o) {
                            if (!this.checkEnvironment(world, checkPos.func_177972_a(face), false)) continue;
                            world.func_180501_a(checkPos.func_177972_a(face), this.leaves.func_176223_P(), 2);
                        }
                    }
                }
            }
            this.drainZone(world, pos.func_177977_b(), 3, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 4);
            }
        }
    }

    private Map<BlockPos, Integer> chooseCornerPoses(World world, BlockPos pos, int counter, Random rand, Map<BlockPos, Integer> cornerPoses) {
        BlockPos trunckPos;
        ++counter;
        for (int i = 0; i < 5; ++i) {
            EnumFacing trunkDir = EnumFacing.field_176754_o[rand.nextInt(4)];
            trunckPos = pos.func_177972_a(trunkDir);
            if (!cornerPoses.containsKey(trunckPos) && this.checkEnvironment(world, trunckPos, false)) {
                world.func_180501_a(trunckPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)trunkDir), 2);
                cornerPoses.put(trunckPos, counter);
                break;
            }
            if (i != 4) continue;
            world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
            cornerPoses.remove(pos.func_177984_a());
            cornerPoses.put(pos.func_177984_a(), counter);
        }
        for (EnumFacing face : EnumFacing.field_176754_o) {
            trunckPos = pos.func_177972_a(face);
            if (rand.nextInt(6) != 0 || cornerPoses.containsKey(trunckPos) || !this.checkEnvironment(world, trunckPos, false)) continue;
            world.func_180501_a(trunckPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)face), 2);
            cornerPoses.put(trunckPos, counter);
            if (rand.nextBoolean()) break;
        }
        return cornerPoses;
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(3) + 3;
            boolean check = true;
            for (int i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                for (int i = 0; i < j; ++i) {
                    EnumFacing branchFace;
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.T_TREE_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (checkSnow && world.func_175708_f(checkPos.func_177984_a(), false)) {
                        world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                    }
                    if (i <= 1 || i < j - 2 || (branchFace = FacingHelper.NOTDOWN[rand.nextInt(5)]).func_176740_k() == face.func_176740_k() || !rand.nextBoolean() || !world.func_180495_p(checkPos = checkPos.func_177972_a(branchFace)).func_185904_a().func_76222_j()) continue;
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.T_TREE_BRANCH.func_176223_P().func_177226_a((IProperty)MistBlockBranch.SIZE, (Comparable)Integer.valueOf(1)).func_177226_a(MistBlockBranch.AXIS, (Comparable)branchFace.func_176740_k()), 2);
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.T_TREE_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.T_TREE_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.T_TREE_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.T_TREE_BLOCK, 1, 7);
    }
}

