/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class MistTrunkSTree
extends MistTreeTrunk {
    public MistTrunkSTree() {
        super(10.0f, 1, 2, false, true, true, (MistTreeLeaves)MistBlocks.S_TREE_LEAVES, 1, 0, 8, new int[]{1, 1, 1, 1});
        this.func_149752_b(15.0f);
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 1;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return 1 + (int)(posRand % 6L) % 3;
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength + 6 + (int)(posRand % 5L) % 2;
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        if (rand.nextInt(100) == 0 && ((MistSoil)soil.func_177230_c()).getWaterPerm(soil) < 3) {
            SoilHelper.setSoil(world, soilPos, soil, 3, 2);
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.2)) != 0) {
                return isBud ? 1 : 0;
            }
            if (temp < -1.0f || (double)temp >= 1.5 || humi < 5.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                int trunckSize = (Integer)world.func_180495_p(fixPos).func_185899_b((IBlockAccess)world, fixPos).func_177229_b((IProperty)SIZE);
                if (branchLength == Math.min(trunckSize, trunckLength <= minTrunckLength + 1 ? 0 : 1) && (totalLength < maxTreeHeight || trunckLength == totalLength - branchLength)) {
                    return 2;
                }
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance == 0 && totalLength < 3 || firstSizeChangeDistance == 1) {
                if (totalLength < maxTreeHeight) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if ((double)temp >= -0.5 && (double)temp <= 0.5 && humi > 20.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            return 0;
        }
        return -1;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        for (EnumFacing face : availableGrowthDirection) {
            if (face == EnumFacing.UP) {
                if ((branchLength != 0 || totalLength == maxTreeHeight - 2 && rand.nextInt(2) != 0) && (dir == EnumFacing.UP || rand.nextInt(3) <= 0)) continue;
                growthDir.add(face);
                continue;
            }
            if (totalLength != maxTreeHeight - 1 && trunckLength != totalLength - branchLength && branchLength <= 0 && dir != EnumFacing.UP && availableGrowthDirection.contains(EnumFacing.UP)) continue;
            if (branchLength == 0) {
                if (totalLength <= minTrunckLength && availableGrowthDirection.contains(EnumFacing.UP) || rand.nextInt(3) <= 0) continue;
                if (totalLength >= maxTreeHeight - 2) {
                    growthDir.add(face);
                    continue;
                }
                IBlockState downBranch = world.func_180495_p(pos.func_177972_a(face).func_177977_b());
                if (downBranch.func_177230_c() == this && this.getDir(downBranch) == face) continue;
                growthDir.add(face);
                continue;
            }
            if (face == dir && rand.nextInt(3) <= 0) continue;
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > Math.max(2, minTrunckLength - 2 + rootSize) && rand.nextInt(rootSize + 1) == 0) {
                return Math.min(trunckLength, lastSegment - 1);
            }
        }
        return 0;
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState downState;
        if (!world.field_72995_K && (downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistSoil && ((MistSoil)downState.func_177230_c()).getWaterPerm(downState) > 2 && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            BlockPos checkPos;
            boolean potential;
            boolean cropTop = rand.nextBoolean();
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, 0);
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, 0) - (cropTop ? 2 : 0);
            BlockPos trunkPos = pos;
            int counter = 0;
            for (int i = 0; i < maxTreeHight && this.checkEnvironment(world, trunkPos.func_177984_a(), false); ++i) {
                ++counter;
                world.func_180501_a(trunkPos, this.func_176223_P(), 2);
                trunkPos = trunkPos.func_177984_a();
            }
            maxTreeHight = counter += cropTop ? 2 : 0;
            int size = 0;
            int nodeNumber = -1;
            for (int i = 0; i < 4; ++i) {
                if ((counter -= this.nodeDistance[i]) >= Math.max(2, minTrunckLength - 2 + i)) {
                    ++size;
                    ++nodeNumber;
                    continue;
                }
                counter += this.nodeDistance[i];
                break;
            }
            boolean bl = potential = size == 4;
            if (size == 4) {
                SoilHelper.setSoil(world, pos.func_177977_b(), ((MistSoil)downState.func_177230_c()).getSoilBlock().func_176223_P(), 2, true, 18);
            }
            maxTreeHight -= cropTop ? 2 : 0;
            trunkPos = pos;
            ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
            for (int i = 0; i < maxTreeHight; ++i) {
                boolean node = false;
                if (counter == 0 && nodeNumber >= 0) {
                    node = true;
                    counter = this.nodeDistance[nodeNumber];
                    --nodeNumber;
                    --size;
                }
                if (i >= minTrunckLength && i < maxTreeHight - 1) {
                    EnumFacing[] enumFacingArray = EnumFacing.field_176754_o;
                    int n = enumFacingArray.length;
                    for (int j = 0; j < n; ++j) {
                        EnumFacing dir = enumFacingArray[j];
                        if (rand.nextInt(3) <= 0 || !this.checkEnvironment(world, checkPos = trunkPos.func_177972_a(dir), false)) continue;
                        downState = world.func_180495_p(checkPos.func_177977_b());
                        if ((cropTop && i == maxTreeHight - 1 || downState.func_177230_c() == this) && this.getDir(downState) == dir) continue;
                        boolean normalBranch = rand.nextInt(3) > 0;
                        boolean check = false;
                        for (EnumFacing dir1 : DIR.func_177700_c()) {
                            if (dir1 == EnumFacing.UP || dir1 == dir.func_176734_d() || !normalBranch && dir1 == dir || !this.checkEnvironment(world, checkPos.func_177972_a(dir1), false) || !this.createBud(world, checkPos.func_177972_a(dir1), dir1.func_176734_d(), potential)) continue;
                            world.func_180501_a(checkPos.func_177972_a(dir1), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir1).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(dir1 == dir)), 2);
                            check = true;
                        }
                        if (check) {
                            world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir), 2);
                            branches.add(checkPos.func_177984_a());
                            continue;
                        }
                        if (!this.createBud(world, checkPos, dir.func_176734_d(), potential)) continue;
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
                if (i == 0 && size == 4) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else if (j < 6) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    }
                } else {
                    world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                }
                trunkPos = trunkPos.func_177984_a();
                --counter;
            }
            trunkPos = trunkPos.func_177977_b();
            counter = 0;
            if (cropTop) {
                for (EnumFacing dir1 : EnumFacing.field_176754_o) {
                    checkPos = trunkPos.func_177972_a(dir1);
                    if (rand.nextInt(2) != 0 && (counter != 0 || dir1 != EnumFacing.EAST) || !this.checkEnvironment(world, checkPos.func_177981_b(2), false)) continue;
                    world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir1), 2);
                    world.func_180501_a(checkPos.func_177984_a(), this.func_176223_P(), 2);
                    this.createBud(world, checkPos.func_177984_a(), EnumFacing.DOWN, potential);
                    ++counter;
                }
            }
            if (counter == 0 || !cropTop) {
                this.createBud(world, trunkPos, EnumFacing.DOWN, potential);
            }
            if (!branches.isEmpty()) {
                for (BlockPos pos1 : branches) {
                    if (rand.nextInt(4) != 0 || !this.checkEnvironment(world, pos1, false) || !this.createBud(world, pos1, EnumFacing.DOWN, potential)) continue;
                    world.func_180501_a(pos1, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.UP).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                }
            }
            this.drainZone(world, pos.func_177977_b(), 2, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 3);
            }
        }
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            int i;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(2) + 2;
            boolean check = true;
            for (i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                for (i = 0; i < j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.S_TREE_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (!checkSnow || !world.func_175708_f(checkPos.func_177984_a(), false)) continue;
                    world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.S_TREE_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.S_TREE_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.S_TREE_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.S_TREE_BLOCK, 1, 7);
    }
}

