/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import ru.liahim.mist.api.biome.EnumBiomeType;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;
import ru.liahim.mist.world.biome.BiomeMist;

public class MistTrunkPoplar
extends MistTreeTrunk {
    public MistTrunkPoplar() {
        super(3.0f, 1, 2, false, false, false, (MistTreeLeaves)MistBlocks.POPLAR_LEAVES, 1, 0, 4, new int[]{3, 3, 3, 4});
    }

    @Override
    protected int getSoilDepth(World world, BlockPos rootPos) {
        int s = -1;
        BlockPos pos = rootPos.func_177977_b();
        while (s < 4 && world.func_180495_p(pos).func_177230_c() instanceof MistSoil) {
            ++s;
            pos = pos.func_177977_b();
        }
        return s;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return 2 + (int)(posRand % 5L) % 2;
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return 17 + soilDepth * 2 + (int)(posRand % 6L) % 3;
    }

    @Override
    protected int getGrowingThickness(EnumFacing face, Random rand) {
        return 2;
    }

    @Override
    protected boolean canCheckBranch(World world, BlockPos pos, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int size, Random rand) {
        return (isBud || !availableGrowthDirection.isEmpty()) && size < 3;
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            Biome biome;
            if ((Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)SIZE) == 4) {
                if (rand.nextInt(200) == 0) {
                    world.func_184133_a(null, pos, MistSounds.BLOCK_WOOD_CREAK, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                }
            } else if (pos.func_177956_o() > 130 && MistWorld.canPlayAmbiendSounds(world, pos) && (biome = world.func_180494_b(pos)) instanceof BiomeMist && ((BiomeMist)biome).getBiomeType() == EnumBiomeType.Swamp) {
                long tick = world.func_72820_D() % 24000L;
                if (tick > 12000L && rand.nextInt(20 + (int)Math.abs(tick - 18000L) / 200) == 0) {
                    world.func_184133_a(null, pos, MistSounds.BLOCK_SWAMP_BIRD, SoundCategory.AMBIENT, 1.5f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
                } else if (rand.nextInt(500) == 0) {
                    world.func_184133_a(null, pos, MistSounds.BLOCK_SWAMP_BIRD, SoundCategory.AMBIENT, 1.5f, world.field_73012_v.nextFloat() * 0.2f + 0.9f);
                }
            }
        }
        super.func_180650_b(world, pos, state, rand);
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        if (rand.nextInt(500) == 0 && ((MistSoil)soil.func_177230_c()).getWaterPerm(soil) > 2) {
            SoilHelper.setSoil(world, soilPos, soil, 3, 2);
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.1)) != 0) {
                return isBud ? 1 : 0;
            }
            if ((double)temp < -0.5 || temp > 2.0f || humi < 10.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                if (branchLength < 4) {
                    return availableGrowthDirection.contains(EnumFacing.UP) ? 2 : (isBud ? 1 : 0);
                }
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance < 4) {
                if (totalLength < maxTreeHeight && totalLength - trunckLength < 8) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if (temp > 0.0f && (double)temp < 1.5 && humi > 40.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            return 0;
        }
        return -1;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        for (EnumFacing face : availableGrowthDirection) {
            if (face == EnumFacing.UP) {
                growthDir.add(face);
                continue;
            }
            if (branchLength != 0 && totalLength - trunckLength != 0 || size <= 0 && (!isBud || availableGrowthDirection.contains(EnumFacing.UP)) || !rand.nextBoolean()) continue;
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected boolean isLeavesRemoved(World world, int totalLength, int branchLength, int minTrunckLength, int trunckLength, int firstBranchDistance, BlockPos pos, BlockPos newPos, EnumFacing dir, Random rand) {
        if (branchLength > 1) {
            return rand.nextInt(4) == 0;
        }
        if (branchLength == 1 || totalLength <= minTrunckLength || totalLength - trunckLength == 1 || rand.nextInt(3) > 0) {
            return true;
        }
        boolean delete = false;
        for (int i = 1; i <= 2; ++i) {
            IBlockState downPos = world.func_180495_p(pos.func_177979_c(i));
            if ((downPos.func_177230_c() != this.leaves || downPos.func_177229_b((IProperty)LDIR) != dir) && (downPos.func_177230_c() != this || this.getDir(downPos) != dir)) continue;
            delete = true;
        }
        return delete;
    }

    @Override
    protected ArrayList<BlockPos> getShiftedNodes(World world, int size, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, Random rand) {
        ArrayList<BlockPos> shiftedNodes = new ArrayList<BlockPos>();
        boolean moveAll = false;
        int total = 0;
        int i = 0;
        for (BlockPos pos : nodes) {
            int segment = segments.get(i);
            if (branchLength != 0 && (total += segment) > branchLength) continue;
            if (segment + (moveAll ? 1 : 0) > this.nodeDistance[i] + (i == 0 && firstSizeChangeDistance == this.nodeDistance[0] ? 1 : 0)) {
                moveAll = true;
                shiftedNodes.add(pos);
            }
            ++i;
        }
        return shiftedNodes;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > 5 + rootSize) {
                return Math.min(trunckLength, 3 + rootSize);
            }
        }
        return 0;
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState downState;
        if (!world.field_72995_K && (downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistSoil && ((MistSoil)downState.func_177230_c()).getWaterPerm(downState) < 3 && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            BlockPos checkPos;
            boolean potential;
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int soilDepth = this.getSoilDepth(world, pos);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, soilDepth);
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, soilDepth);
            BlockPos trunkPos = pos;
            int counter = 0;
            for (int i = 0; i < maxTreeHight && this.checkEnvironment(world, trunkPos.func_177984_a(), false); ++i) {
                ++counter;
                world.func_180501_a(trunkPos, this.func_176223_P(), 2);
                trunkPos = trunkPos.func_177984_a();
            }
            maxTreeHight = counter;
            int size = 0;
            int nodeNumber = -1;
            for (int i = 0; i < 4; ++i) {
                if ((counter -= this.nodeDistance[i]) >= i + 3) {
                    ++size;
                    ++nodeNumber;
                    continue;
                }
                counter += this.nodeDistance[i];
                break;
            }
            boolean bl = potential = size == 4;
            if (size == 4) {
                SoilHelper.setSoil(world, pos.func_177977_b(), ((MistSoil)downState.func_177230_c()).getSoilBlock().func_176223_P(), 2, true, 18);
            }
            trunkPos = pos;
            ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
            for (int i = 0; i < maxTreeHight; ++i) {
                boolean node = false;
                if (counter == 0 && nodeNumber >= 0) {
                    node = true;
                    counter = this.nodeDistance[nodeNumber];
                    --nodeNumber;
                    --size;
                }
                if (i >= minTrunckLength && i < maxTreeHight - 1) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (rand.nextInt(3) != 0 || !this.checkEnvironment(world, checkPos = trunkPos.func_177972_a(dir), false) || (downState = world.func_180495_p(checkPos.func_177977_b())).func_177230_c() == this && this.getDir(downState) == dir || (downState = world.func_180495_p(checkPos.func_177979_c(2))).func_177230_c() == this && this.getDir(downState) == dir) continue;
                        if (size == 0) {
                            if (potential) {
                                world.func_180501_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir), 2);
                                continue;
                            }
                            world.func_180501_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)), 2);
                            continue;
                        }
                        if (!this.checkEnvironment(world, checkPos.func_177972_a(dir), false)) continue;
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                        branches.add(checkPos);
                    }
                }
                if (i == 0 && size == 4) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else if (j < 6) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    }
                } else {
                    world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                }
                trunkPos = trunkPos.func_177984_a();
                --counter;
            }
            trunkPos = trunkPos.func_177977_b();
            this.createBud(world, trunkPos, EnumFacing.DOWN, potential);
            if (!branches.isEmpty()) {
                block4: for (BlockPos pos1 : branches) {
                    if (this.checkEnvironment(world, pos1.func_177984_a(), false)) {
                        for (int i = 1; i < 4; ++i) {
                            checkPos = pos1.func_177981_b(i);
                            if (this.checkEnvironment(world, checkPos.func_177984_a(), false)) {
                                world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(i == 1)), 2);
                                if (i == 3) {
                                    this.createBud(world, checkPos, EnumFacing.DOWN, potential);
                                    world.func_180501_a(pos1, world.func_180495_p(pos1).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(false)), 2);
                                    continue;
                                }
                                for (EnumFacing face : EnumFacing.field_176754_o) {
                                    if (rand.nextInt(4) <= 0 || !this.checkEnvironment(world, checkPos.func_177972_a(face), false)) continue;
                                    if (potential) {
                                        world.func_180501_a(checkPos.func_177972_a(face), this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face), 2);
                                        continue;
                                    }
                                    world.func_180501_a(checkPos.func_177972_a(face), this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)), 2);
                                }
                                continue;
                            }
                            this.createBud(world, checkPos.func_177977_b(), i == 1 ? ((EnumFacing)world.func_180495_p(checkPos.func_177977_b()).func_177229_b((IProperty)DIR)).func_176734_d() : EnumFacing.DOWN, potential);
                            continue block4;
                        }
                        continue;
                    }
                    this.createBud(world, pos1, ((EnumFacing)world.func_180495_p(pos1).func_177229_b((IProperty)DIR)).func_176734_d(), potential);
                }
            }
            this.drainZone(world, pos.func_177977_b(), 2, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 3);
            }
        }
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(5) + 4;
            boolean check = true;
            for (int i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                this.generateSoilLump(world, pos, face.func_176734_d(), rand, checkSnow);
                for (int i = 0; i < j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.POPLAR_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (checkSnow && world.func_175708_f(checkPos.func_177984_a(), false)) {
                        world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                    }
                    if (i <= 1) continue;
                    for (EnumFacing branchFace : FacingHelper.NOTDOWN) {
                        BlockPos branchPos;
                        if (branchFace.func_176740_k() == face.func_176740_k() || rand.nextInt(4) != 0 || world.func_180495_p((branchPos = checkPos.func_177972_a(branchFace)).func_177972_a(face.func_176734_d())).func_177230_c() == MistBlocks.POPLAR_BRANCH || world.func_180495_p(branchPos.func_177967_a(face.func_176734_d(), 2)).func_177230_c() == MistBlocks.POPLAR_BRANCH || world.func_180495_p(branchPos.func_177967_a(face.func_176734_d(), 3)).func_177230_c() == MistBlocks.POPLAR_BRANCH || !world.func_180495_p(branchPos).func_185904_a().func_76222_j()) continue;
                        if (world.func_180495_p(branchPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                            world.func_175698_g(branchPos.func_177984_a());
                        }
                        world.func_180501_a(branchPos, MistBlocks.POPLAR_BRANCH.func_176223_P().func_177226_a((IProperty)MistBlockBranch.SIZE, (Comparable)Integer.valueOf(0)).func_177226_a(MistBlockBranch.AXIS, (Comparable)branchFace.func_176740_k()), 2);
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.POPLAR_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.POPLAR_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.POPLAR_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.POPLAR_BLOCK, 1, 7);
    }
}

