/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class MistTrunkPine
extends MistTreeTrunk {
    public MistTrunkPine() {
        super(4.0f, 2, 2, true, true, true, (MistTreeLeaves)MistBlocks.PINE_LEAVES, 1, 0, 6, new int[]{1, 1, 1, 2});
    }

    @Override
    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    @Override
    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 8;
    }

    @Override
    protected int getSoilDepth(World world, BlockPos rootPos) {
        int s = -1;
        BlockPos pos = rootPos.func_177977_b();
        while (s < 4 && world.func_180495_p(pos).func_177230_c() instanceof MistSoil) {
            ++s;
            pos = pos.func_177977_b();
        }
        return s;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return 2 + (int)(posRand % 5L) % 2;
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength + 8 + soilDepth * 2 + (int)(posRand % 6L) % 3;
    }

    @Override
    protected int getMaxTrunckLength(World world, BlockPos rootPos, int maxTreeHeight, int minTrunckLength, long posRand, int soilDepth) {
        return Math.max(minTrunckLength, maxTreeHeight - 7 - (int)(posRand % 6L) % 3);
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && rand.nextInt(150) == 0 && (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)SIZE) == 4) {
            world.func_184133_a(null, pos, MistSounds.BLOCK_WOOD_CREAK, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.4f + 1.0f);
        }
        super.func_180650_b(world, pos, state, rand);
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        if (rand.nextInt(1000) == 0 && ((MistSoil)soil.func_177230_c()).getWaterPerm(soil) < 2) {
            SoilHelper.setSoil(world, soilPos, soil, 3, 2);
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.2)) != 0) {
                return isBud ? 1 : 0;
            }
            if ((double)temp < -1.0 || (double)temp > 1.8 || humi < 5.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                if (fixPos != null && this.removeBranch(world, trunckLength, maxTrunckLength, branchLength, fixPos)) {
                    return -1;
                }
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                int trunckSize = (Integer)world.func_180495_p(fixPos).func_185899_b((IBlockAccess)world, fixPos).func_177229_b((IProperty)SIZE);
                if (trunckSize == 4 && trunckLength <= maxTrunckLength && ((double)trunckLength < (double)maxTrunckLength * 0.75 || MistWorld.getPosRandom(world, fixPos, 4) != 0L)) {
                    return -1;
                }
                if (branchLength < Math.min(trunckSize, trunckLength <= minTrunckLength + 1 || trunckLength == maxTrunckLength + 1 || trunckLength <= maxTrunckLength && MistWorld.getPosRandom(world, fixPos, 4) == 0L ? 2 : 3)) {
                    return 2;
                }
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance < 4) {
                if (totalLength < maxTreeHeight) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if ((double)temp > -0.5 && (double)temp < 1.5 && humi > 10.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            if (this.removeBranch(world, trunckLength, maxTrunckLength, branchLength, fixPos)) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private boolean removeBranch(World world, int trunckLength, int maxTrunckLength, int branchLength, BlockPos fixPos) {
        return branchLength > 0 && trunckLength <= maxTrunckLength && ((double)trunckLength < (double)maxTrunckLength * 0.75 || MistWorld.getPosRandom(world, fixPos, 4) != 0L) && (Integer)world.func_180495_p(fixPos).func_185899_b((IBlockAccess)world, fixPos).func_177229_b((IProperty)SIZE) == 4;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        double distanse = pos.func_177951_i((Vec3i)rootPos);
        for (EnumFacing face : availableGrowthDirection) {
            boolean check = false;
            if (face == EnumFacing.UP) {
                if (branchLength == 0 || dir != EnumFacing.UP && rand.nextInt(3) == 0) {
                    check = true;
                }
            } else if (trunckLength == totalLength - branchLength || branchLength > 0 || dir == EnumFacing.UP || !availableGrowthDirection.contains(EnumFacing.UP)) {
                if (branchLength == 0) {
                    IBlockState downBranch;
                    if (!(totalLength <= minTrunckLength && availableGrowthDirection.contains(EnumFacing.UP) || rand.nextInt(2) != 0 || (downBranch = world.func_180495_p(pos.func_177972_a(face).func_177977_b())).func_177230_c() == this && this.getDir(downBranch) == face)) {
                        check = true;
                    }
                } else if (face == dir || rand.nextInt(3) > 0) {
                    check = true;
                }
            }
            if (!check || !(pos.func_177972_a(face).func_177951_i((Vec3i)rootPos) > distanse)) continue;
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > 3 + rootSize) {
                return Math.min(trunckLength, 2 + rootSize);
            }
        }
        return 0;
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState downState;
        if (!world.field_72995_K && (downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistSoil && ((MistSoil)downState.func_177230_c()).getWaterPerm(downState) > 1 && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            boolean potential;
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int soilDepth = this.getSoilDepth(world, pos);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, soilDepth);
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, soilDepth);
            int maxTrunckLength = this.getMaxTrunckLength(world, pos, maxTreeHight, minTrunckLength, posRand, soilDepth);
            BlockPos trunkPos = pos;
            int counter = 0;
            for (int i = 0; i < maxTreeHight && this.checkEnvironment(world, trunkPos.func_177984_a(), false); ++i) {
                ++counter;
                world.func_180501_a(trunkPos, this.func_176223_P(), 2);
                trunkPos = trunkPos.func_177984_a();
            }
            maxTreeHight = counter;
            minTrunckLength = maxTreeHight - maxTrunckLength < 7 ? Math.max(minTrunckLength, maxTreeHight - 7) : maxTrunckLength;
            int size = 0;
            int nodeNumber = -1;
            for (int i = 0; i < 4; ++i) {
                if ((counter -= this.nodeDistance[i]) >= i + 1) {
                    ++size;
                    ++nodeNumber;
                    continue;
                }
                counter += this.nodeDistance[i];
                break;
            }
            boolean bl = potential = size == 4;
            if (size == 4) {
                SoilHelper.setSoil(world, pos.func_177977_b(), ((MistSoil)downState.func_177230_c()).getSoilBlock().func_176223_P(), 2, true, 18);
            }
            trunkPos = pos;
            ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
            for (int i = 0; i < maxTreeHight; ++i) {
                BlockPos checkPos;
                boolean node = false;
                if (counter == 0 && nodeNumber >= 0) {
                    node = true;
                    counter = this.nodeDistance[nodeNumber];
                    --nodeNumber;
                    --size;
                }
                if (size == 4 && i > 3 && (double)i > (double)minTrunckLength * 0.75 && i < minTrunckLength && MistWorld.getPosRandom(world, trunkPos, 4) == 0L) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (rand.nextInt(4) != 0) continue;
                        checkPos = trunkPos.func_177972_a(dir);
                        downState = this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true));
                        if (!this.checkEnvironment(world, checkPos, false) || !this.createBranch(world, downState, checkPos, rand, potential)) continue;
                        world.func_180501_a(checkPos, downState, 2);
                    }
                }
                if (i >= minTrunckLength && i < maxTreeHight - 1) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        if (rand.nextInt(2) != 0 || !this.checkEnvironment(world, checkPos = trunkPos.func_177972_a(dir), false) || (downState = world.func_180495_p(checkPos.func_177977_b())).func_177230_c() == this && this.getDir(downState) == dir) continue;
                        boolean join = i == minTrunckLength;
                        int bud = 0;
                        for (int j = 0; j < (i == minTrunckLength ? 2 : 3) && j < size; ++j) {
                            if (this.checkEnvironment(world, checkPos.func_177972_a(dir), false)) {
                                world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(join)), 2);
                                checkPos = checkPos.func_177972_a(dir);
                                join = true;
                                ++bud;
                                continue;
                            }
                            if (j == 1 && size > 2) {
                                world.func_175698_g(checkPos.func_177972_a(dir.func_176734_d()));
                                bud = 0;
                                break;
                            }
                            if (j <= 0) break;
                            world.func_180501_a(trunkPos.func_177972_a(dir), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(true)), 2);
                            break;
                        }
                        if (bud > 0) {
                            this.createBud(world, trunkPos.func_177967_a(dir, bud), dir.func_176734_d(), potential);
                        }
                        if (bud > 1) {
                            branches.add(trunkPos.func_177967_a(dir, bud - 1));
                        }
                        if (bud <= 2) continue;
                        checkPos = trunkPos.func_177972_a(dir);
                        for (EnumFacing dir2 : EnumFacing.field_176754_o) {
                            if (dir2 == dir || dir2 == dir.func_176734_d() || rand.nextInt(3) <= 0 || !this.checkEnvironment(world, checkPos.func_177972_a(dir2), false)) continue;
                            world.func_180501_a(checkPos.func_177972_a(dir2), this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir2), 2);
                            branches.add(checkPos.func_177972_a(dir2));
                        }
                    }
                }
                if (i == 0 && size == 4) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else if (j < 6) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    }
                } else {
                    world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                }
                trunkPos = trunkPos.func_177984_a();
                --counter;
            }
            trunkPos = trunkPos.func_177977_b();
            this.createBud(world, trunkPos, EnumFacing.DOWN, potential);
            if (!branches.isEmpty()) {
                for (BlockPos pos1 : branches) {
                    this.createBranch(world, pos1, pos, rand, potential);
                }
            }
            this.drainZone(world, pos.func_177977_b(), 3, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 4);
            }
        }
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(4) + 4;
            boolean check = true;
            for (int i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                this.generateSoilLump(world, pos, face.func_176734_d(), rand, checkSnow);
                for (int i = 0; i < j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.PINE_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (checkSnow && world.func_175708_f(checkPos.func_177984_a(), false)) {
                        world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                    }
                    if (i <= j / 2) continue;
                    for (EnumFacing branchFace : FacingHelper.NOTDOWN) {
                        BlockPos branchPos;
                        if (branchFace.func_176740_k() == face.func_176740_k() || rand.nextInt(3) != 0 || world.func_180495_p((branchPos = checkPos.func_177972_a(branchFace)).func_177972_a(face.func_176734_d())).func_177230_c() == MistBlocks.PINE_BRANCH || !world.func_180495_p(branchPos).func_185904_a().func_76222_j()) continue;
                        if (world.func_180495_p(branchPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                            world.func_175698_g(branchPos.func_177984_a());
                        }
                        world.func_180501_a(branchPos, MistBlocks.PINE_BRANCH.func_176223_P().func_177226_a((IProperty)MistBlockBranch.SIZE, (Comparable)Integer.valueOf(1)).func_177226_a(MistBlockBranch.AXIS, (Comparable)branchFace.func_176740_k()), 2);
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.PINE_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.PINE_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.PINE_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.PINE_BLOCK, 1, 7);
    }
}

