/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class MistTrunkAspen
extends MistTreeTrunk {
    public MistTrunkAspen() {
        super(4.0f, 1, 2, true, true, true, (MistTreeLeaves)MistBlocks.ASPEN_LEAVES, 1, 0, 5, new int[]{1, 1, 2, 3});
    }

    @Override
    protected int getSoilDepth(World world, BlockPos rootPos) {
        int s = 0;
        if (world.func_180495_p(rootPos.func_177979_c(2)).func_177230_c() instanceof MistSoil) {
            s = 3;
        }
        return s;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return 2 + (int)(posRand % 5L) % 2;
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength + 8 + soilDepth + (int)(posRand % 7L) % 4;
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.15)) != 0) {
                return isBud ? 1 : 0;
            }
            if ((double)temp < -0.5 || temp > 2.0f || humi < 5.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                int trunckSize = (Integer)world.func_180495_p(fixPos).func_185899_b((IBlockAccess)world, fixPos).func_177229_b((IProperty)SIZE);
                if (branchLength < Math.min(trunckSize + 1, trunckLength <= minTrunckLength + 1 ? 1 : 2)) {
                    return 2;
                }
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance < 5) {
                if (totalLength < maxTreeHeight) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if (temp > 0.0f && (double)temp < 1.5 && humi > 25.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            return 0;
        }
        return -1;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        for (EnumFacing face : availableGrowthDirection) {
            if (face == EnumFacing.UP) {
                if (branchLength != 0 && (dir == EnumFacing.UP || rand.nextInt(3) != 0)) continue;
                growthDir.add(face);
                continue;
            }
            if (trunckLength != totalLength - branchLength && branchLength <= 0 && dir != EnumFacing.UP && availableGrowthDirection.contains(EnumFacing.UP)) continue;
            if (branchLength == 0) {
                IBlockState downBranch;
                if (totalLength <= minTrunckLength && availableGrowthDirection.contains(EnumFacing.UP) || rand.nextInt(3) <= 0 || (downBranch = world.func_180495_p(pos.func_177972_a(face).func_177977_b())).func_177230_c() == this && this.getDir(downBranch) == face) continue;
                growthDir.add(face);
                continue;
            }
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > Math.min(6, 2 + Math.max(1, rootSize) + rootSize)) {
                return Math.min(trunckLength, lastSegment - this.nodeDistance[rootSize]);
            }
        }
        return 0;
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState downState;
        if (!world.field_72995_K && (downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistSoil && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            boolean potential;
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int soilDepth = this.getSoilDepth(world, pos);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, soilDepth);
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, soilDepth);
            BlockPos trunkPos = pos;
            int counter = 0;
            for (int i = 0; i < maxTreeHight && this.checkEnvironment(world, trunkPos.func_177984_a(), false); ++i) {
                ++counter;
                world.func_180501_a(trunkPos, this.func_176223_P(), 2);
                trunkPos = trunkPos.func_177984_a();
            }
            maxTreeHight = counter;
            int size = 0;
            int nodeNumber = -1;
            for (int i = 0; i < 4; ++i) {
                if ((counter -= this.nodeDistance[i]) >= i + 1) {
                    ++size;
                    ++nodeNumber;
                    continue;
                }
                counter += this.nodeDistance[i];
                break;
            }
            boolean bl = potential = size == 4;
            if (size == 4) {
                SoilHelper.setSoil(world, pos.func_177977_b(), ((MistSoil)downState.func_177230_c()).getSoilBlock().func_176223_P(), 2, true, 18);
            }
            trunkPos = pos;
            ArrayList<BlockPos> branches = new ArrayList<BlockPos>();
            for (int i = 0; i < maxTreeHight; ++i) {
                boolean node = false;
                if (counter == 0 && nodeNumber >= 0) {
                    node = true;
                    counter = this.nodeDistance[nodeNumber];
                    --nodeNumber;
                    --size;
                }
                if (i >= minTrunckLength && i < maxTreeHight - 1) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        BlockPos checkPos;
                        if (rand.nextInt(5) <= 1 || !this.checkEnvironment(world, checkPos = trunkPos.func_177972_a(dir), false) || (downState = world.func_180495_p(checkPos.func_177977_b())).func_177230_c() == this && this.getDir(downState) == dir || !this.checkEnvironment(world, checkPos.func_177972_a(dir), false)) continue;
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(i == minTrunckLength)), 2);
                        if (i == minTrunckLength || size == 0) {
                            this.createBud(world, checkPos, dir.func_176734_d(), potential);
                            continue;
                        }
                        branches.add(checkPos);
                    }
                }
                if (i == 0 && size == 4) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else if (j < 6) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    }
                } else {
                    world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                }
                trunkPos = trunkPos.func_177984_a();
                --counter;
            }
            this.createBud(world, trunkPos.func_177977_b(), EnumFacing.DOWN, potential);
            if (!branches.isEmpty()) {
                for (BlockPos pos1 : branches) {
                    this.createBranch(world, pos1, rand, potential);
                }
            }
            this.drainZone(world, pos.func_177977_b(), 2, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 3);
            }
        }
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(4) + 3;
            boolean check = true;
            for (int i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                this.generateSoilLump(world, pos, face.func_176734_d(), rand, checkSnow);
                for (int i = 0; i < j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.ASPEN_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (checkSnow && world.func_175708_f(checkPos.func_177984_a(), false)) {
                        world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                    }
                    if (i <= 1) continue;
                    for (EnumFacing branchFace : FacingHelper.NOTDOWN) {
                        BlockPos branchPos;
                        if (branchFace.func_176740_k() == face.func_176740_k() || rand.nextInt(3) != 0 || world.func_180495_p((branchPos = checkPos.func_177972_a(branchFace)).func_177972_a(face.func_176734_d())).func_177230_c() == MistBlocks.ASPEN_BRANCH || !world.func_180495_p(branchPos).func_185904_a().func_76222_j()) continue;
                        if (world.func_180495_p(branchPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                            world.func_175698_g(branchPos.func_177984_a());
                        }
                        world.func_180501_a(branchPos, MistBlocks.ASPEN_BRANCH.func_176223_P().func_177226_a((IProperty)MistBlockBranch.SIZE, (Comparable)Integer.valueOf(0)).func_177226_a(MistBlockBranch.AXIS, (Comparable)branchFace.func_176740_k()), 2);
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.ASPEN_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.ASPEN_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.ASPEN_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.ASPEN_BLOCK, 1, 7);
    }
}

