/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.tree;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistBlockBranch;
import ru.liahim.mist.block.MistGrass;
import ru.liahim.mist.block.MistSand;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.MistTreeLeaves;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.block.MistWoodBlock;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.util.SoilHelper;
import ru.liahim.mist.world.MistWorld;

public class MistTrunkATree
extends MistTreeTrunk {
    public MistTrunkATree() {
        super(3.0f, 0, 0, true, true, true, (MistTreeLeaves)MistBlocks.A_TREE_LEAVES, 1, 1, 3, new int[]{2, 2, 2, 3});
    }

    @Override
    protected int getSoilDepth(World world, BlockPos rootPos) {
        int s = -1;
        BlockPos pos = rootPos.func_177977_b();
        while (s < 4 && world.func_180495_p(pos).func_177230_c() instanceof MistSoil) {
            ++s;
            pos = pos.func_177977_b();
        }
        return s;
    }

    @Override
    protected int getMinTrunckLength(World world, BlockPos rootPos, long posRand, int soilDepth) {
        return 1 + (int)(posRand % 5L) % 2;
    }

    @Override
    protected int getMaxTreeHeight(World world, BlockPos rootPos, int minTrunckLength, long posRand, int soilDepth) {
        return minTrunckLength + 8 + soilDepth * 2 + (int)(posRand % 6L) % 3;
    }

    @Override
    protected int getGrowingThickness(EnumFacing face, Random rand) {
        return 2;
    }

    @Override
    protected boolean canCheckBranch(World world, BlockPos pos, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int size, Random rand) {
        return (isBud || !availableGrowthDirection.isEmpty()) && size < 3;
    }

    @Override
    public boolean isDesertTree() {
        return true;
    }

    @Override
    protected int canGrowth(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        if (MistWorld.isPosInFog(world, rootPos)) {
            return -1;
        }
        if (!(soil.func_177230_c() instanceof MistSoil)) {
            return -1;
        }
        int humus = SoilHelper.getHumus(soil);
        if (humus == 3) {
            return -1;
        }
        if (rand.nextInt(500) == 0 && ((MistSoil)soil.func_177230_c()).getWaterPerm(soil) < 2) {
            SoilHelper.setSoil(world, soilPos, soil, 3, 2);
            return -1;
        }
        float temp = world.func_180494_b(rootPos).func_180626_a(rootPos);
        float humi = MistWorld.getHumi(world, rootPos, 0.0f);
        if (!((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() && humi >= 100.0f) {
            world.func_175656_a(soilPos, soil.func_177226_a((IProperty)IWettable.WET, (Comparable)Boolean.valueOf(true)));
        }
        if ((((Boolean)soil.func_177229_b((IProperty)IWettable.WET)).booleanValue() || (float)rand.nextInt(40) < humi - 10.0f) && humus > 0) {
            if (branchLength == 0 && rand.nextInt((int)Math.ceil((double)trunckLength * 0.15)) != 0) {
                return isBud ? 1 : 0;
            }
            if ((double)temp < 0.0 || (double)temp > 2.5 || humi < 5.0f) {
                return 0;
            }
            if (availableGrowthDirection.isEmpty()) {
                return isBud ? 1 : 0;
            }
            if (branchLength > 0) {
                return isBud ? 1 : 0;
            }
            if (firstSizeChangeDistance < 5) {
                if (totalLength < maxTreeHeight || firstBranchDistance == 1) {
                    return 2;
                }
                return this.trySetDead(world, rootPos, rootState, soilPos, soil, isBud, rand);
            }
            return isBud ? 1 : 0;
        }
        if ((double)temp > 0.5 && (double)temp < 2.0 && humi > 5.0f) {
            this.makeSoil(world, soilPos, soil, rand);
            return 0;
        }
        return -1;
    }

    @Override
    protected ArrayList<EnumFacing> chooseGrowthDir(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, ArrayList<BlockPos> nodes, @Nullable BlockPos fixPos, BlockPos rootPos, IBlockState rootState, Random rand) {
        ArrayList<EnumFacing> growthDir = new ArrayList<EnumFacing>();
        for (EnumFacing face : availableGrowthDirection) {
            if (face == EnumFacing.UP) {
                if (branchLength != 0) continue;
                growthDir.add(face);
                continue;
            }
            if (trunckLength <= minTrunckLength || dir != EnumFacing.UP || firstBranchDistance != 0 || isBud) continue;
            growthDir.add(face);
        }
        return growthDir;
    }

    @Override
    protected boolean growth(World world, BlockPos oldPos, BlockPos newPos, int size, EnumFacing baseDir, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        boolean growth = false;
        boolean check = false;
        BlockPos targetPos = newPos.func_177972_a(dir);
        if (this.checkEnvironment(world, targetPos)) {
            world.func_175656_a(newPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(size > 0)));
            world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
            growth = true;
        }
        if (growth) {
            for (EnumFacing face : DIR.func_177700_c()) {
                if (face == dir || face == dir.func_176734_d() || face == EnumFacing.UP) continue;
                targetPos = newPos.func_177972_a(face);
                IBlockState targetState = world.func_180495_p(targetPos);
                if (!this.checkEnvironment(world, targetPos) && (!check || targetState.func_177230_c() != this.leaves || targetState.func_177229_b((IProperty)LDIR) != face)) continue;
                if (availableGrowthDirection.contains(face) && world.func_180495_p(oldPos.func_177972_a(face)).func_177230_c() == this.leaves) {
                    if (this.isLeavesRemoved(world, totalLength, branchLength, minTrunckLength, trunckLength, firstBranchDistance, oldPos.func_177972_a(face), targetPos, face, rand)) {
                        world.func_175698_g(oldPos.func_177972_a(face));
                    }
                    world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                    continue;
                }
                if (totalLength != 1 && rand.nextInt(dir == EnumFacing.UP ? 2 : 3) <= 0) continue;
                world.func_175656_a(targetPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
            }
            if (this.removeHumus(world, soilPos, soil)) {
                this.makeSoil(world, soilPos, soil, rand);
            }
        }
        return growth;
    }

    @Override
    protected boolean isLeavesRemoved(World world, int totalLength, int branchLength, int minTrunckLength, int trunckLength, int firstBranchDistance, BlockPos pos, BlockPos newPos, EnumFacing dir, Random rand) {
        return firstBranchDistance == 1 || trunckLength <= minTrunckLength;
    }

    @Override
    protected int newNodeDistance(World world, BlockPos rootPos, IBlockState rootState, int totalLength, int branchLength, int firstSizeChangeDistance, int firstBendDistance, int firstBranchDistance, int trunckLength, int minTrunckLength, int maxTreeHeight, ArrayList<Integer> segments, Random rand) {
        int rootSize = (Integer)rootState.func_177229_b((IProperty)SIZE);
        if (branchLength == 0 && rootSize < 4) {
            int lastSegment;
            int n = lastSegment = segments.isEmpty() ? totalLength : segments.get(segments.size() - 1);
            if (lastSegment > Math.min(6, 4 + rootSize)) {
                return Math.min(trunckLength, 3 + rootSize);
            }
        }
        return 0;
    }

    @Override
    protected void setNewLeaves(World world, BlockPos pos, IBlockState state, int size, EnumFacing dir, ArrayList<EnumFacing> availableGrowthDirection, boolean isBud, BlockPos rootPos, IBlockState rootState, BlockPos soilPos, IBlockState soil, Random rand) {
        EnumFacing face;
        if (isBud && this.newGrowthChance > 0 && rand.nextInt(this.newGrowthChance) == 0 && availableGrowthDirection.size() < (dir == EnumFacing.UP ? 5 : 4) && (face = !availableGrowthDirection.contains(dir) ? dir : (EnumFacing)DIR.func_177700_c().toArray()[rand.nextInt(DIR.func_177700_c().size())]) != dir.func_176734_d() && !availableGrowthDirection.contains(face) && (dir == EnumFacing.UP || face != EnumFacing.UP)) {
            BlockPos checkPos = pos.func_177972_a(face);
            if (this.checkEnvironment(world, checkPos)) {
                world.func_175656_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)face).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)));
                if (this.removeHumus(world, soilPos, soil)) {
                    this.makeSoil(world, soilPos, soil, rand);
                }
            } else {
                IBlockState leaves = world.func_180495_p(checkPos);
                if (leaves.func_177230_c() == this.leaves && leaves.func_177229_b((IProperty)LDIR) == face) {
                    this.leaves.updateLeaves(world, checkPos, leaves, rootPos, rootState, soilPos, soil, rand);
                }
            }
        }
    }

    @Override
    public void generateTree(World world, BlockPos pos, Random rand, boolean checkSnow) {
        IBlockState downState;
        if (!world.field_72995_K && (downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof MistGrass && ((MistGrass)downState.func_177230_c()).getWaterPerm(downState) > 1 && this.checkEnvironment(world, pos, false) && world.func_175710_j(pos)) {
            boolean potential;
            int soilDepth;
            long posRand = MistWorld.getPosRandom(world, pos, 0);
            int minTrunckLength = this.getMinTrunckLength(world, pos, posRand, soilDepth = this.getSoilDepth(world, pos));
            int maxTreeHight = this.getMaxTreeHeight(world, pos, minTrunckLength, posRand, soilDepth);
            if ((maxTreeHight - minTrunckLength) % 2 == 0) {
                ++maxTreeHight;
            }
            BlockPos trunkPos = pos;
            int counter = 0;
            for (int i = 0; i < maxTreeHight && this.checkEnvironment(world, trunkPos.func_177984_a(), false); ++i) {
                ++counter;
                world.func_180501_a(trunkPos, this.func_176223_P(), 2);
                trunkPos = trunkPos.func_177984_a();
            }
            maxTreeHight = counter;
            int size = 0;
            int nodeNumber = -1;
            for (int i = 0; i < 4; ++i) {
                if ((counter -= this.nodeDistance[i]) >= i + 3) {
                    ++size;
                    ++nodeNumber;
                    continue;
                }
                counter += this.nodeDistance[i];
                break;
            }
            boolean bl = potential = size == 4;
            if (size == 4) {
                SoilHelper.setSoil(world, pos.func_177977_b(), ((MistGrass)downState.func_177230_c()).getSoilBlock().func_176223_P(), 2, false, 18);
            }
            trunkPos = pos;
            for (int i = 0; i < maxTreeHight; ++i) {
                boolean node = false;
                if (counter == 0 && nodeNumber >= 0) {
                    node = true;
                    counter = this.nodeDistance[nodeNumber];
                    --nodeNumber;
                    --size;
                }
                if (i >= minTrunckLength && i < maxTreeHight - 1 && (i - minTrunckLength) % 2 == 0) {
                    for (EnumFacing dir : EnumFacing.field_176754_o) {
                        BlockPos checkPos = trunkPos.func_177972_a(dir);
                        if (!this.checkEnvironment(world, checkPos, false) || !this.checkEnvironment(world, checkPos.func_177972_a(dir), false)) continue;
                        world.func_180501_a(checkPos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir), 2);
                        this.createBud(world, checkPos, dir.func_176734_d(), EnumFacing.UP, potential);
                    }
                }
                if (i == 0 && size == 4) {
                    int j = rand.nextInt(11);
                    if (j == 0) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else if (j < 6) {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)DIR, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    } else {
                        world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                    }
                } else {
                    world.func_180501_a(trunkPos, this.func_176223_P().func_177226_a((IProperty)SIZE, (Comparable)Integer.valueOf(size)).func_177226_a((IProperty)NODE, (Comparable)Boolean.valueOf(node)), 2);
                }
                trunkPos = trunkPos.func_177984_a();
                --counter;
            }
            trunkPos = trunkPos.func_177977_b();
            this.createBud(world, trunkPos, EnumFacing.DOWN, potential);
            this.drainZone(world, pos.func_177977_b(), 2, rand);
            if (checkSnow) {
                this.checkSnow(world, pos, 3);
            }
        }
    }

    private boolean createBud(World world, BlockPos pos, EnumFacing branchDir, EnumFacing mask, boolean potential) {
        boolean check = false;
        if (this.checkEnvironment(world, pos.func_177972_a(branchDir.func_176734_d()), false)) {
            for (EnumFacing dir : DIR.func_177700_c()) {
                BlockPos checkPos;
                if (dir == branchDir || dir == mask || !this.checkEnvironment(world, checkPos = pos.func_177972_a(dir), false)) continue;
                check = true;
                if (potential) {
                    world.func_180501_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir), 2);
                    continue;
                }
                world.func_180501_a(checkPos, this.leaves.func_176223_P().func_177226_a((IProperty)LDIR, (Comparable)dir).func_177226_a(MistTreeLeaves.AGE, (Comparable)((Object)MistTreeLeaves.EnumAge.EMPTY)), 2);
            }
        }
        return check;
    }

    @Override
    public void generateTrunk(World world, BlockPos pos, Random rand, boolean checkSnow) {
        if (!world.field_72995_K && world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            BlockPos checkPos;
            EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
            int j = rand.nextInt(3) + 4;
            boolean check = true;
            for (int i = 0; i <= j; ++i) {
                checkPos = pos.func_177967_a(face, i);
                if (world.func_180495_p(checkPos).func_185904_a().func_76222_j() && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                check = false;
                break;
            }
            if (check) {
                this.generateSoilLump(world, pos, face.func_176734_d(), rand, checkSnow);
                for (int i = 0; i < j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                        world.func_175698_g(checkPos.func_177984_a());
                    }
                    world.func_180501_a(checkPos, MistBlocks.A_TREE_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))), 2);
                    if (checkSnow && world.func_175708_f(checkPos.func_177984_a(), false)) {
                        world.func_175656_a(checkPos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
                    }
                    if ((i & 1) != 1) continue;
                    for (EnumFacing branchFace : FacingHelper.NOTDOWN) {
                        BlockPos branchPos;
                        if (branchFace.func_176740_k() == face.func_176740_k() || !rand.nextBoolean() || !world.func_180495_p(branchPos = checkPos.func_177972_a(branchFace)).func_185904_a().func_76222_j()) continue;
                        if (world.func_180495_p(branchPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                            world.func_175698_g(branchPos.func_177984_a());
                        }
                        world.func_180501_a(branchPos, MistBlocks.A_TREE_BRANCH.func_176223_P().func_177226_a((IProperty)MistBlockBranch.SIZE, (Comparable)Integer.valueOf(0)).func_177226_a(MistBlockBranch.AXIS, (Comparable)branchFace.func_176740_k()), 2);
                    }
                }
            }
        }
    }

    public void generateDunesTrunk(World world, BlockPos pos, Random rand) {
        if (!world.field_72995_K) {
            boolean check = false;
            BlockPos checkPos = pos.func_177977_b();
            IBlockState checkState = world.func_180495_p(checkPos);
            if (checkState.func_177230_c() instanceof MistSoil) {
                check = true;
            } else if (checkState.func_177230_c() instanceof MistSand) {
                while ((checkPos = checkPos.func_177977_b()).func_177956_o() >= 120) {
                    checkState = world.func_180495_p(checkPos.func_177977_b());
                    if (checkState.func_177230_c() instanceof MistSoil) {
                        check = true;
                        pos = checkPos;
                        break;
                    }
                    if (checkState.func_177230_c() instanceof MistSand) continue;
                }
            }
            if (check) {
                int i;
                EnumFacing face = EnumFacing.func_176731_b((int)rand.nextInt(4));
                int j = rand.nextInt(4) + 3;
                for (i = 0; i <= j; ++i) {
                    checkPos = pos.func_177967_a(face, i);
                    checkState = world.func_180495_p(checkPos);
                    if ((checkState.func_185904_a().func_76222_j() || checkState.func_177230_c() instanceof MistSand) && world.isSideSolid(checkPos.func_177977_b(), EnumFacing.UP)) continue;
                    check = false;
                    break;
                }
                if (check) {
                    for (i = 0; i < j; ++i) {
                        checkPos = pos.func_177967_a(face, i);
                        if (world.func_180495_p(checkPos.func_177984_a()).func_177230_c() == Blocks.field_150398_cm) {
                            world.func_175698_g(checkPos.func_177984_a());
                        }
                        world.func_180501_a(checkPos, MistBlocks.A_TREE_BLOCK.func_176223_P().func_177226_a(MistWoodBlock.AXIS, (Comparable)((Object)MistWoodBlock.EnumAxis.fromFacingAxis(face.func_176740_k()))).func_177226_a(MistWoodBlock.TYPE, (Comparable)((Object)MistWoodBlock.EnumType.DEBARKING)), 2);
                    }
                }
            }
        }
    }

    @Override
    protected ItemStack getBranch() {
        return new ItemStack(MistBlocks.A_TREE_BRANCH);
    }

    @Override
    protected ItemStack getTrunk() {
        return new ItemStack(MistBlocks.A_TREE_BRANCH, 1, 6);
    }

    @Override
    protected ItemStack getBlock() {
        return new ItemStack(MistBlocks.A_TREE_BLOCK);
    }

    @Override
    protected ItemStack getNode() {
        return new ItemStack(MistBlocks.A_TREE_BLOCK, 1, 7);
    }
}

