/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IShiftPlaceable;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.gizmos.MistBlockContainer;
import ru.liahim.mist.entity.EntityGraveBug;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.tileentity.TileEntityRemains;

public class Remains
extends MistBlockContainer
implements IShiftPlaceable {
    public static final PropertyInteger LAYERS = PropertyInteger.func_177719_a((String)"layers", (int)0, (int)7);
    public static final PropertyBool OLD = PropertyBool.func_177716_a((String)"old");

    public Remains() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)OLD, (Comparable)Boolean.valueOf(false)));
        this.func_149711_c(1.0f);
        this.setHarvestLevel("shovel", 0);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)((Integer)state.func_177229_b((IProperty)LAYERS) + 1) * 0.125, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)((Integer)state.func_177229_b((IProperty)LAYERS)).intValue() * 0.125 + 0.0625, 1.0);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)LAYERS) < 4;
    }

    public boolean func_185481_k(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 7;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN || (Integer)state.func_177229_b((IProperty)LAYERS) == 7 ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te;
        ItemStack heldItem = player.func_184586_b(hand);
        if (Block.func_149634_a((Item)heldItem.func_77973_b()) == this) {
            return false;
        }
        if (!heldItem.func_190926_b() && (te = world.func_175625_s(pos)) instanceof TileEntityRemains) {
            TileEntityRemains remains = (TileEntityRemains)te;
            if (heldItem.func_77973_b() == MistItems.REMAINS) {
                if (side != EnumFacing.UP) {
                    return false;
                }
                if ((Integer)state.func_177229_b((IProperty)LAYERS) < 7) {
                    NBTTagCompound tag = remains.writeItems(new NBTTagCompound());
                    if (world.func_175656_a(pos, state.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)LAYERS) + 1)))) {
                        ((TileEntityRemains)world.func_175625_s(pos)).readItems(tag);
                        world.func_184133_a(null, pos, SoundEvents.field_187587_bZ, SoundCategory.BLOCKS, 1.0f, 0.8f);
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190918_g(1);
                        }
                        return true;
                    }
                } else if (world.func_180495_p(pos.func_177984_a()).func_185904_a().func_76222_j()) {
                    world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                    world.func_184133_a(null, pos, SoundEvents.field_187587_bZ, SoundCategory.BLOCKS, 1.0f, 0.8f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                    }
                    return true;
                }
            } else if (remains.putStack(heldItem)) {
                world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 0.8f, 1.0f);
                return true;
            }
        }
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149686_d(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 7;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (((Boolean)state.func_177229_b((IProperty)OLD)).booleanValue() && player instanceof EntityPlayerMP) {
            ModAdvancements.REMAINS.trigger((EntityPlayerMP)player, world, pos, state);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!(world.field_72995_K || ((Boolean)state.func_177229_b((IProperty)OLD)).booleanValue() || world.isSideSolid(pos.func_177977_b(), EnumFacing.UP))) {
            world.func_175655_b(pos, true);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        TileEntityRemains te = new TileEntityRemains();
        te.init(((meta & 7) + 1) * 3);
        return te;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 7));
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IInventory) {
            Remains.dropInventoryItems(world, pos, (IInventory)te);
            world.func_175666_e(pos, (Block)this);
        }
        if (((Boolean)state.func_177229_b((IProperty)OLD)).booleanValue()) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                IBlockState neighbor = world.func_180495_p(pos.func_177972_a(face));
                if (neighbor.func_177230_c() != this || !((Boolean)neighbor.func_177229_b((IProperty)OLD)).booleanValue()) continue;
                world.func_175655_b(pos.func_177972_a(face), true);
            }
            EntityGraveBug.spawnBug(world, pos, world.field_73012_v);
        }
        super.func_180663_b(world, pos, state);
    }

    private static void dropInventoryItems(World world, BlockPos pos, IInventory inventory) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Remains.spawnItemStack(world, pos, stack, world.field_73012_v);
        }
    }

    private static void spawnItemStack(World world, BlockPos pos, ItemStack stack, Random rand) {
        float f = rand.nextFloat() * 0.8f + 0.1f;
        float f1 = rand.nextFloat() * 0.8f + 0.1f;
        float f2 = rand.nextFloat() * 0.8f + 0.1f;
        while (!stack.func_190926_b()) {
            EntityItem entity = new EntityItem(world, (double)pos.func_177958_n() + (double)f, (double)pos.func_177956_o() + (double)f1, (double)pos.func_177952_p() + (double)f2, stack.func_77979_a(rand.nextInt(21) + 10));
            entity.field_70159_w = rand.nextGaussian() * 0.05;
            entity.field_70181_x = rand.nextGaussian() * 0.05 + 0.2;
            entity.field_70179_y = rand.nextGaussian() * 0.05;
            entity.func_174867_a(20);
            world.func_72838_d((Entity)entity);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MistItems.REMAINS;
    }

    public int quantityDropped(IBlockState state, int fortune, Random rand) {
        return (Boolean)state.func_177229_b((IProperty)OLD) != false ? rand.nextInt(rand.nextInt((Integer)state.func_177229_b((IProperty)LAYERS) + 1) + 1) : (Integer)state.func_177229_b((IProperty)LAYERS) + 1;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World world, BlockPos pos) {
        return this.getContainer(world, pos, false);
    }

    @Nullable
    public ILockableContainer getContainer(World world, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityRemains)) {
            return null;
        }
        if (!allowBlocking) {
            return null;
        }
        return (TileEntityRemains)tileentity;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(world, pos));
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        int layer = (Integer)state.func_177229_b((IProperty)LAYERS);
        if (entity.field_70163_u < (double)pos.func_177956_o() + (double)(layer + 1) * 0.125) {
            TileEntity te;
            if (!world.field_72995_K && !((Boolean)state.func_177229_b((IProperty)OLD)).booleanValue() && entity != null && entity instanceof EntityItem && (te = world.func_175625_s(pos)) instanceof TileEntityRemains) {
                TileEntityRemains remains = (TileEntityRemains)te;
                if (remains.cooldown < 0) {
                    ItemStack stack = ((EntityItem)entity).func_92059_d();
                    if (stack.func_77973_b() == MistItems.REMAINS) {
                        if (layer < 7) {
                            NBTTagCompound tag = remains.writeItems(new NBTTagCompound());
                            if (world.func_175656_a(pos, state.func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf((Integer)state.func_177229_b((IProperty)LAYERS) + 1)))) {
                                ((TileEntityRemains)world.func_175625_s(pos)).readItems(tag);
                                ((EntityItem)entity).func_92059_d().func_190918_g(1);
                                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + 0.125, entity.field_70161_v);
                            }
                        }
                    } else if (Block.func_149634_a((Item)stack.func_77973_b()) != this) {
                        remains.pullStack((EntityItem)entity);
                    }
                    remains.cooldown = 8;
                } else {
                    --remains.cooldown;
                }
            }
            entity.field_70159_w *= 0.4;
            entity.field_70179_y *= 0.4;
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)OLD) != false ? 1 : 0) << 3 | (Integer)state.func_177229_b((IProperty)LAYERS);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LAYERS, (Comparable)Integer.valueOf(meta & 7)).func_177226_a((IProperty)OLD, (Comparable)Boolean.valueOf(meta > 7));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LAYERS, OLD});
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == EnumFacing.UP) {
            return true;
        }
        IBlockState checkState = world.func_180495_p(pos.func_177972_a(side));
        return checkState.func_177230_c() == this && (Integer)checkState.func_177229_b((IProperty)LAYERS) >= (Integer)state.func_177229_b((IProperty)LAYERS) ? false : super.func_176225_a(state, world, pos, side);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return (Integer)state.func_177229_b((IProperty)LAYERS) == 7 ? new ItemStack((Block)this, 1, 7) : new ItemStack(MistItems.REMAINS, 1);
    }

    @Override
    public boolean onShiftPlacing(World world, BlockPos pos, ItemStack stack, EntityPlayer player, float hitX, float hitY, float hitZ, BlockFaceShape bfs) {
        if (bfs != BlockFaceShape.SOLID) {
            return false;
        }
        if (stack.func_77973_b() == MistItems.REMAINS && world.func_175656_a(pos, this.func_176223_P())) {
            world.func_184133_a(null, pos, SoundEvents.field_187587_bZ, SoundCategory.BLOCKS, 1.0f, 0.8f);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190920_e(stack.func_190916_E() - 1);
            }
            return true;
        }
        return false;
    }
}

