/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IShiftPlaceable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.sound.MistSounds;
import ru.liahim.mist.block.gizmos.MistBlockContainer;
import ru.liahim.mist.entity.EntityGraveBug;
import ru.liahim.mist.tileentity.TileEntityUrn;
import ru.liahim.mist.util.ColorHelper;

public class MistUrn
extends MistBlockContainer
implements IColoredBlock,
IShiftPlaceable {
    protected static final AxisAlignedBB URN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.5625, 0.6875);
    private static final int breakChance = 2;

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                if (world != null && pos != null && tintIndex == 0 && world.func_175625_s(pos) instanceof TileEntityUrn) {
                    return ((TileEntityUrn)world.func_175625_s(pos)).getTintColor();
                }
                return -1;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                NBTTagCompound tag = stack.func_179543_a("Urn");
                if (tag != null) {
                    if (!TileEntityUrn.UrnType.byId(tag.func_74762_e("UrnType")).isRare()) {
                        int patina;
                        int tint;
                        int n = tint = tag.func_74764_b("TintColor") ? tag.func_74762_e("TintColor") : -1;
                        if (tint < 0) {
                            tint = 12613979;
                        }
                        int n2 = patina = tag.func_74764_b("PatinaColor") ? tag.func_74762_e("PatinaColor") : -1;
                        if (patina < 0) {
                            patina = tint;
                        }
                        return tintIndex == 0 ? tint : (tintIndex == 1 ? patina : ColorHelper.mixColor(tint, patina));
                    }
                    return -1;
                }
                return stack.func_77952_i() == 0 ? 12613979 : 12503253;
            }
        };
    }

    public MistUrn() {
        super(Material.field_151571_B);
        this.func_149711_c(0.2f);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return URN_AABB;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)this.getUrnItem(world.func_175625_s(pos)));
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityUrn) {
            TileEntityUrn urn = (TileEntityUrn)te;
            if (urn.isBug() && this.spawnBug(world, pos) || urn.getUrnType().isRare() && urn.func_184276_b() != null && world.field_73012_v.nextInt(2) == 0) {
                this.destroy(world, player, pos, te);
            } else {
                MistUrn.func_180635_a((World)world, (BlockPos)pos, (ItemStack)this.getUrnItem(te));
            }
        }
    }

    private void destroy(World world, EntityPlayer player, BlockPos pos, TileEntity te) {
        world.func_184133_a(null, pos, MistSounds.BLOCK_URN_BREAK, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
        world.func_175655_b(pos, false);
        this.dropInventory(world, pos, player, te);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(world, pos, state, player);
        if (player.func_184812_l_()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityUrn && ((TileEntityUrn)te).isBug()) {
                this.spawnBug(world, pos);
            }
            this.dropInventory(world, pos, player, te);
        }
    }

    private ItemStack getUrnItem(@Nullable TileEntity te) {
        ItemStack stack = new ItemStack((Block)this);
        if (te instanceof TileEntityUrn) {
            ((TileEntityUrn)te).func_184281_d(null);
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound urnTag = ((TileEntityUrn)te).writeToNBTUrn(new NBTTagCompound(), false);
            tag.func_74782_a("Urn", (NBTBase)urnTag);
            stack.func_77982_d(tag);
            if (((TileEntityUrn)te).func_145818_k_()) {
                stack.func_151001_c(((TileEntityUrn)te).func_70005_c_());
            }
        }
        return stack;
    }

    public boolean func_149659_a(Explosion explosion) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityUrn && ((TileEntityUrn)te).isBug()) {
            this.spawnBug(world, pos);
        }
        this.dropInventory(world, pos, null, te);
        world.func_175698_g(pos);
    }

    private void dropInventory(World world, BlockPos pos, EntityPlayer player, TileEntity urn) {
        if (!world.field_72995_K) {
            if (urn == null) {
                urn = world.func_175625_s(pos);
            }
            if (urn instanceof TileEntityUrn) {
                ((TileEntityUrn)urn).func_184281_d(player);
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityUrn)urn));
                world.func_175666_e(pos, (Block)this);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntityUrn te = (TileEntityUrn)this.getLockableContainer(world, pos);
        if (te != null) {
            if (te.isBug() && this.spawnBug(world, pos) || !te.getUrnType().isRare() && te.func_184276_b() != null && world.field_73012_v.nextInt(2) == 0) {
                this.destroy(world, player, pos, (TileEntity)te);
            } else {
                if (te.lidAngle == 0.0f) {
                    te.openSide = player.func_174811_aO();
                }
                player.openGui((Object)"mist", 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity te;
        if (!this.canStay(world.func_180495_p(pos.func_177977_b()).func_193401_d((IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP)) && (te = world.func_175625_s(pos)) instanceof TileEntityUrn) {
            TileEntityUrn urn = (TileEntityUrn)te;
            if (urn.isBug() && this.spawnBug(world, pos) || !urn.getUrnType().isRare() || urn.func_184276_b() != null && world.field_73012_v.nextInt(2) == 0) {
                this.destroy(world, null, pos, te);
            } else {
                world.func_175655_b(pos, true);
            }
        }
    }

    private boolean spawnBug(World world, BlockPos pos) {
        return EntityGraveBug.spawnBug(world, pos, world.field_73012_v);
    }

    private boolean canStay(BlockFaceShape bfs) {
        return bfs != BlockFaceShape.BOWL && bfs != BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public ILockableContainer getLockableContainer(World world, BlockPos pos) {
        return this.getContainer(world, pos, false);
    }

    @Nullable
    public ILockableContainer getContainer(World world, BlockPos pos, boolean allowBlocking) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityUrn)) {
            return null;
        }
        if (!allowBlocking && this.isBlocked(world, pos)) {
            return null;
        }
        return (TileEntityUrn)tileentity;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityUrn();
    }

    private boolean isBlocked(World world, BlockPos pos) {
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_94526_b((IInventory)this.getLockableContainer(world, pos));
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, 1));
        list.add((Object)new ItemStack((Block)this, 1, 0));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getUrnItem(world.func_175625_s(pos));
    }

    @Override
    public boolean onShiftPlacing(World world, BlockPos pos, @Nonnull ItemStack stack, EntityPlayer player, float hitX, float hitY, float hitZ, BlockFaceShape bfs) {
        if (stack.func_77952_i() != 0 || !this.canStay(bfs)) {
            return false;
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) == MistBlocks.URN && world.func_175656_a(pos, MistBlocks.URN.func_176223_P())) {
            world.func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityUrn) {
                NBTTagCompound tag = stack.func_179543_a("Urn");
                if (tag != null) {
                    ((TileEntityUrn)te).readFromNBTUrn(tag);
                }
                if (stack.func_82837_s()) {
                    ((TileEntityUrn)te).func_190575_a(stack.func_82833_r());
                }
            }
            stack.func_190918_g(1);
            return true;
        }
        return false;
    }
}

