/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.ISeasonalChanges;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistTreeTrunk;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.init.ModParticle;
import ru.liahim.mist.tileentity.TileEntityLatexPot;
import ru.liahim.mist.util.SoilHelper;

public class MistLatexPot
extends MistBlock
implements ITileEntityProvider,
ISeasonalChanges {
    public static final PropertyDirection DIR = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.3125, 0.0, 0.0, 0.6875, 0.375, 0.375);
    protected static final AxisAlignedBB NORTH = new AxisAlignedBB(0.3125, 0.0, 0.625, 0.6875, 0.375, 1.0);
    protected static final AxisAlignedBB EAST = new AxisAlignedBB(0.0, 0.0, 0.3125, 0.375, 0.375, 0.6875);
    protected static final AxisAlignedBB WEST = new AxisAlignedBB(0.625, 0.0, 0.3125, 1.0, 0.375, 0.6875);
    private static int updateTime = 3600;

    public MistLatexPot() {
        super(Material.field_151575_d);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.SOUTH));
        this.func_149711_c(0.5f);
        this.func_149675_a(true);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        if (facing.func_176736_b() < 0) {
            return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)placer.func_174811_aO().func_176734_d());
        }
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)facing);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        IBlockState state;
        if (side.func_176736_b() >= 0 && (state = world.func_180495_p(pos = pos.func_177972_a(side.func_176734_d()))).func_177230_c() == MistBlocks.R_TREE_TRUNK && (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)MistTreeTrunk.SIZE) == 4) {
            for (EnumFacing face : EnumFacing.field_176754_o) {
                if (face == side || (state = world.func_180495_p(pos.func_177972_a(face))).func_177230_c() != this || state.func_177229_b((IProperty)DIR) != face) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176734_d())).func_177230_c() != MistBlocks.R_TREE_TRUNK) {
            world.func_175655_b(pos, true);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)DIR);
        if (face == EnumFacing.SOUTH) {
            return SOUTH;
        }
        if (face == EnumFacing.NORTH) {
            return NORTH;
        }
        if (face == EnumFacing.EAST) {
            return EAST;
        }
        return WEST;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityLatexPot) {
            ((TileEntityLatexPot)te).updateTime();
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntityLatexPot pot;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLatexPot && (pot = (TileEntityLatexPot)te).getStage() == 6) {
            if (!world.field_72995_K) {
                ItemStack stack = new ItemStack(MistItems.LATEX);
                pot.setStage(1);
                pot.updateStatus(state, state);
                pot.updateTime();
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.LATEX.trigger((EntityPlayerMP)player, stack);
                }
            }
            return true;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.update(world, pos, state, rand, false);
    }

    public void update(World world, BlockPos pos, IBlockState state, Random rand, boolean seasonalTest) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityLatexPot) {
            BlockPos down;
            TileEntityLatexPot pot = (TileEntityLatexPot)te;
            if (pot.root == null) {
                pot.root = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176734_d());
                down = pot.root.func_177977_b();
                while (world.func_180495_p(down).func_177230_c() == MistBlocks.R_TREE_TRUNK) {
                    down = down.func_177977_b();
                }
                pot.root = down.func_177984_a();
            }
            down = pot.root.func_177977_b();
            if (!pot.isDead) {
                boolean bl = pot.isDead = SoilHelper.getHumus(world.func_180495_p(down)) == 3;
            }
            if (!pot.isDead) {
                long step;
                int st = pot.getStage();
                long lastUpdate = pot.getLastUpdateTime();
                if (st < 6 && (step = world.func_82737_E() - lastUpdate) >= (long)updateTime) {
                    if ((st = (int)((long)st + (step /= (long)updateTime))) == 1) {
                        st = 2;
                    } else if (st > 6) {
                        st = 6;
                    }
                    pot.setStage(st);
                    pot.updateStatus(state, state);
                    pot.updateTime();
                }
                if (seasonalTest) {
                    step = world.func_82737_E() - lastUpdate;
                    if (step > 600000L) {
                        step /= 600000L;
                        int i = 0;
                        while ((long)i < step) {
                            ((MistTreeTrunk)MistBlocks.R_TREE_TRUNK).makeOlder(world, pot.root, world.func_180495_p(pot.root), down, world.func_180495_p(down), rand, true);
                            ++i;
                        }
                    }
                } else if (rand.nextInt(500) == 0) {
                    ((MistTreeTrunk)MistBlocks.R_TREE_TRUNK).makeOlder(world, pot.root, world.func_180495_p(pot.root), down, world.func_180495_p(down), rand, true);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity te;
        if (rand.nextInt(32) == 0 && (te = world.func_175625_s(pos)) instanceof TileEntityLatexPot) {
            TileEntityLatexPot pot = (TileEntityLatexPot)te;
            if (!pot.isDead && pot.getStage() > 0) {
                EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)DIR);
                double x = (double)pos.func_177958_n() + 0.5;
                double y = (double)pos.func_177956_o() + 0.37;
                double z = (double)pos.func_177952_p() + 0.5;
                if (dir == EnumFacing.SOUTH) {
                    world.func_175688_a(ModParticle.MIST_LATEX, x, y, z - 0.37, 0.0, 0.0, 0.0, new int[0]);
                } else if (dir == EnumFacing.NORTH) {
                    world.func_175688_a(ModParticle.MIST_LATEX, x, y, z + 0.37, 0.0, 0.0, 0.0, new int[0]);
                } else if (dir == EnumFacing.WEST) {
                    world.func_175688_a(ModParticle.MIST_LATEX, x + 0.37, y, z, 0.0, 0.0, 0.0, new int[0]);
                } else {
                    world.func_175688_a(ModParticle.MIST_LATEX, x - 0.37, y, z, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Block)this));
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityLatexPot && ((TileEntityLatexPot)te).getStage() == 6) {
            drops.add((Object)new ItemStack(MistItems.LATEX));
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLatexPot();
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIR});
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public IBlockState getSeasonState(World world, BlockPos pos, IBlockState state, long monthTick) {
        this.update(world, pos, state, world.field_73012_v, true);
        return null;
    }
}

