/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.gizmos.MistBlockContainer;
import ru.liahim.mist.tileentity.TileEntityMistFurnace;

public class MistFurnace
extends MistBlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyInteger STATUS = PropertyInteger.func_177719_a((String)"status", (int)0, (int)4);
    private static boolean keepInventory;

    public MistFurnace() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STATUS, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return MistItems.ROCKS;
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return 8;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.setDefaultFacing(world, pos, state);
        MistFurnace.checkSingal(world, pos);
    }

    public static void checkSingal(World world, BlockPos pos, TileEntityMistFurnace furnace) {
        int power = world.func_175687_A(pos);
        if (power > 0) {
            if (furnace.isClose()) {
                furnace.setSignal(true);
                furnace.func_70296_d();
            } else if (furnace.getComparatorOutput() >= power) {
                furnace.setSignal(true);
                furnace.setClose(true);
                furnace.updateStatus();
                furnace.func_70296_d();
            }
        } else if (furnace.hasSignal()) {
            furnace.setSignal(false);
            furnace.setClose(false);
            furnace.updateStatus();
            furnace.func_70296_d();
        }
    }

    public static void checkSingal(World world, BlockPos pos) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof TileEntityMistFurnace) {
            MistFurnace.checkSingal(world, pos, (TileEntityMistFurnace)te);
        }
    }

    public boolean shouldCheckWeakPower(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    private void setDefaultFacing(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            IBlockState state_n = world.func_180495_p(pos.func_177978_c());
            IBlockState state_s = world.func_180495_p(pos.func_177968_d());
            IBlockState state_w = world.func_180495_p(pos.func_177976_e());
            IBlockState state_e = world.func_180495_p(pos.func_177974_f());
            EnumFacing face = (EnumFacing)state.func_177229_b((IProperty)FACING);
            if (face == EnumFacing.NORTH && state_n.func_185913_b() && !state_s.func_185913_b()) {
                face = EnumFacing.SOUTH;
            } else if (face == EnumFacing.SOUTH && state_s.func_185913_b() && !state_n.func_185913_b()) {
                face = EnumFacing.NORTH;
            } else if (face == EnumFacing.WEST && state_w.func_185913_b() && !state_e.func_185913_b()) {
                face = EnumFacing.EAST;
            } else if (face == EnumFacing.EAST && state_e.func_185913_b() && !state_w.func_185913_b()) {
                face = EnumFacing.WEST;
            }
            world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)face), 2);
        }
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int i = (Integer)state.func_177229_b((IProperty)STATUS);
        return i < 2 ? 0 : (i == 3 ? 14 : 7);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int i = (Integer)state.func_177229_b((IProperty)STATUS);
        if (i == 3) {
            if (rand.nextInt(24) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187643_bs, SoundCategory.BLOCKS, 1.0f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
            }
            if (rand.nextBoolean()) {
                EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)FACING);
                double d0 = (double)pos.func_177958_n() + 0.5;
                double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 3.0 / 16.0 + 0.5625;
                double d2 = (double)pos.func_177952_p() + 0.5;
                double d3 = 0.52;
                double d4 = rand.nextDouble() * 0.4 - 0.2;
                switch (enumfacing) {
                    case WEST: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case EAST: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + 0.52, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case NORTH: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - 0.52, 0.0, 0.0, 0.0, new int[0]);
                        break;
                    }
                    case SOUTH: {
                        world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + 0.52, 0.0, 0.0, 0.0, new int[0]);
                    }
                }
            }
        } else if ((i == 2 || i == 4) && rand.nextDouble() < 0.1) {
            world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileEntityMistFurnace) {
            ItemStack heldItem = player.func_184586_b(hand);
            if (heldItem.func_77973_b() instanceof ItemFlintAndSteel && (Integer)state.func_177229_b((IProperty)STATUS) == 1) {
                heldItem.func_77972_a(1, (EntityLivingBase)player);
                ((TileEntityMistFurnace)tileentity).fire();
                world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
            } else {
                player.openGui((Object)"mist", 7, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public static void setState(int status, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if ((Integer)state.func_177229_b((IProperty)STATUS) != status) {
            TileEntity te = world.func_175625_s(pos);
            state = state.func_177226_a((IProperty)STATUS, (Comparable)Integer.valueOf(status));
            keepInventory = true;
            world.func_180501_a(pos, state, 3);
            world.func_180501_a(pos, state, 3);
            keepInventory = false;
            if (te != null) {
                te.func_145829_t();
                world.func_175690_a(pos, te);
            }
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMistFurnace();
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity te;
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
        if (stack.func_82837_s() && (te = world.func_175625_s(pos)) instanceof TileEntityMistFurnace) {
            ((TileEntityMistFurnace)te).func_190575_a(stack.func_82833_r());
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!keepInventory && (te = world.func_175625_s(pos)) instanceof TileEntityMistFurnace) {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileEntityMistFurnace)te));
            int ash = ((TileEntityMistFurnace)te).ashProgress[0] + ((TileEntityMistFurnace)te).ashProgress[1];
            if (ash >= 1000) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(MistItems.ASH));
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityMistFurnace) {
            return ((TileEntityMistFurnace)te).getComparatorOutput();
        }
        return 0;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        MistFurnace.checkSingal(world, pos);
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return new ItemStack(MistBlocks.FURNACE);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return (Integer)state.func_177229_b((IProperty)STATUS) == 3 ? layer == BlockRenderLayer.CUTOUT_MIPPED : layer == BlockRenderLayer.SOLID;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)STATUS, (Comparable)Integer.valueOf(meta >> 2));
    }

    public int func_176201_c(IBlockState state) {
        int status = (Integer)state.func_177229_b((IProperty)STATUS);
        if (status == 4) {
            status = 0;
        }
        return status << 2 | ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATUS, FACING});
    }
}

