/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistTreeSapling;
import ru.liahim.mist.block.gizmos.MistBlockContainer;

public class MistFlowerPot
extends MistBlockContainer {
    public static final PropertyEnum<EnumFlowerType> CONTENTS = PropertyEnum.func_177709_a((String)"type", EnumFlowerType.class);
    protected static final AxisAlignedBB FLOWER_POT_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.375, 0.6875);

    public MistFlowerPot() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(CONTENTS, (Comparable)((Object)EnumFlowerType.EMPTY)));
        this.func_149675_a(true);
    }

    public String func_149732_F() {
        return Blocks.field_150457_bL.func_149732_F();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FLOWER_POT_AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntityFlowerPot te = MistFlowerPot.getTileEntity(world, pos);
        if (te == null) {
            return false;
        }
        ItemStack flower = te.func_184403_b();
        if (!flower.func_190926_b()) {
            if (stack.func_190926_b()) {
                player.func_184611_a(hand, flower);
            } else if (!player.func_191521_c(flower)) {
                player.func_71019_a(flower, false);
            }
            world.func_175656_a(pos, Blocks.field_150457_bL.func_176223_P());
        }
        return true;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        TileEntityFlowerPot te;
        if (rand.nextInt(8) == 0 && (te = MistFlowerPot.getTileEntity(world, pos)) != null && te.func_145965_a() == MistItems.TREE_SEEDS) {
            IBlockState newState;
            boolean grow = false;
            int i = ((EnumFlowerType)((Object)state.func_177229_b(CONTENTS))).ordinal();
            if (i < 3) {
                newState = state.func_177226_a(CONTENTS, (Comparable)((Object)EnumFlowerType.values()[i + 1]));
            } else {
                newState = this.func_176223_P();
                grow = true;
            }
            world.func_180501_a(pos, newState, 3);
            if (grow) {
                te.func_190614_a(new ItemStack(MistBlocks.TREE_SAPLING, 1, te.func_145966_b()));
                te.func_70296_d();
                world.func_184138_a(pos, state, newState, 3);
            }
        }
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te;
        EnumFlowerType type = EnumFlowerType.EMPTY;
        TileEntity tileEntity = te = world instanceof ChunkCache ? ((ChunkCache)world).func_190300_a(pos, Chunk.EnumCreateEntityType.CHECK) : world.func_175625_s(pos);
        if (te instanceof TileEntityFlowerPot) {
            TileEntityFlowerPot tePot = (TileEntityFlowerPot)te;
            Item item = tePot.func_145965_a();
            int i = tePot.func_145966_b();
            if (item instanceof ItemBlock) {
                Block block = Block.func_149634_a((Item)item);
                if (block == MistBlocks.TREE_SAPLING) {
                    switch (MistTreeSapling.EnumType.byMeta(i)) {
                        case ACACIA: {
                            type = EnumFlowerType.ACACIA_SAPLING;
                            break;
                        }
                        case ASPEN: {
                            type = EnumFlowerType.ASPEN_SAPLING;
                            break;
                        }
                        case ATREE: {
                            type = EnumFlowerType.ATREE_SAPLING;
                            break;
                        }
                        case BIRCH: {
                            type = EnumFlowerType.BIRCH_SAPLING;
                            break;
                        }
                        case OAK: {
                            type = EnumFlowerType.OAK_SAPLING;
                            break;
                        }
                        case PINE: {
                            type = EnumFlowerType.PINE_SAPLING;
                            break;
                        }
                        case POPLAR: {
                            type = EnumFlowerType.POPLAR_SAPLING;
                            break;
                        }
                        case SNOW: {
                            type = EnumFlowerType.SNOW_SAPLING;
                            break;
                        }
                        case SPRUCE: {
                            type = EnumFlowerType.SPRUCE_SAPLING;
                            break;
                        }
                        case STREE: {
                            type = EnumFlowerType.STREE_SAPLING;
                            break;
                        }
                        case TTREE: {
                            type = EnumFlowerType.TTREE_SAPLING;
                            break;
                        }
                        case WILLOW: {
                            type = EnumFlowerType.WILLOW_SAPLING;
                            break;
                        }
                        case RTREE: {
                            type = EnumFlowerType.R_TREE_SAPLING;
                            break;
                        }
                        default: {
                            type = EnumFlowerType.EMPTY;
                        }
                    }
                }
            } else if (item == MistItems.TREE_SEEDS) {
                type = EnumFlowerType.SEED_0;
            } else if (item == MistItems.MUSHROOMS_FOOD) {
                switch (i) {
                    case 0: {
                        type = EnumFlowerType.BROWN_MUSHROOM;
                        break;
                    }
                    case 1: {
                        type = EnumFlowerType.BLACK_MUSHROOM;
                        break;
                    }
                    case 2: {
                        type = EnumFlowerType.GRAY_MUSHROOM;
                        break;
                    }
                    case 3: {
                        type = EnumFlowerType.RED_MUSHROOM;
                        break;
                    }
                    case 4: {
                        type = EnumFlowerType.CORAL_MUSHROOM;
                        break;
                    }
                    case 5: {
                        type = EnumFlowerType.ORANGE_MUSHROOM;
                        break;
                    }
                    case 6: {
                        type = EnumFlowerType.YELLOW_MUSHROOM;
                        break;
                    }
                    case 7: {
                        type = EnumFlowerType.BLUE_MUSHROOM;
                        break;
                    }
                    case 8: {
                        type = EnumFlowerType.PURPLE_MUSHROOM;
                        break;
                    }
                    case 9: {
                        type = EnumFlowerType.MARSH_MUSHROOM;
                        break;
                    }
                    case 10: {
                        type = EnumFlowerType.PINK_MUSHROOM;
                        break;
                    }
                    case 11: {
                        type = EnumFlowerType.PUFF_MUSHROOM;
                        break;
                    }
                    case 12: {
                        type = EnumFlowerType.SAND_MUSHROOM;
                        break;
                    }
                    case 16: {
                        type = EnumFlowerType.SPOT_MUSHROOM;
                        break;
                    }
                    case 17: {
                        type = EnumFlowerType.CUP_MUSHROOM;
                        break;
                    }
                    case 18: {
                        type = EnumFlowerType.AZURE_MUSHROOM;
                        break;
                    }
                    case 19: {
                        type = EnumFlowerType.GREEN_MUSHROOM;
                        break;
                    }
                    case 20: {
                        type = EnumFlowerType.COPPER_MUSHROOM;
                        break;
                    }
                    case 21: {
                        type = EnumFlowerType.SILVER_MUSHROOM;
                        break;
                    }
                    case 22: {
                        type = EnumFlowerType.BEIGE_MUSHROOM;
                        break;
                    }
                    case 23: {
                        type = EnumFlowerType.GOLD_MUSHROOM;
                        break;
                    }
                    case 24: {
                        type = EnumFlowerType.WHITE_MUSHROOM;
                        break;
                    }
                    case 25: {
                        type = EnumFlowerType.VIOLET_MUSHROOM;
                        break;
                    }
                    case 26: {
                        type = EnumFlowerType.LILAC_MUSHROOM;
                        break;
                    }
                    case 27: {
                        type = EnumFlowerType.TAN_MUSHROOM;
                        break;
                    }
                    default: {
                        type = EnumFlowerType.EMPTY;
                        break;
                    }
                }
            } else if (item == MistItems.SPONGE_SPORE) {
                type = EnumFlowerType.SPONGE;
            }
        }
        return state.func_177226_a(CONTENTS, (Comparable)((Object)type));
    }

    public static boolean canBePotted(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)item);
            return block == MistBlocks.TREE_SAPLING;
        }
        return item == MistItems.TREE_SEEDS || item == MistItems.MUSHROOMS_FOOD || item == MistItems.SPONGE_SPORE;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        ItemStack stack;
        TileEntityFlowerPot te = MistFlowerPot.getTileEntity(world, pos);
        if (te != null && !(stack = te.func_184403_b()).func_190926_b()) {
            return stack;
        }
        return new ItemStack(Items.field_151162_bE);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileEntityFlowerPot tileentityflowerpot;
        super.func_176208_a(world, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (tileentityflowerpot = MistFlowerPot.getTileEntity(world, pos)) != null) {
            tileentityflowerpot.func_190614_a(ItemStack.field_190927_a);
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_151162_bE;
    }

    @Nullable
    public static TileEntityFlowerPot getTileEntity(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        return te instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)te : null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFlowerPot();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CONTENTS});
    }

    public IBlockState func_176203_a(int meta) {
        return meta <= 3 ? this.func_176223_P().func_177226_a(CONTENTS, (Comparable)((Object)EnumFlowerType.values()[meta])) : this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFlowerType)((Object)state.func_177229_b(CONTENTS))).ordinal();
        return i <= 3 ? i : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityFlowerPot te;
        super.getDrops(drops, world, pos, state, fortune);
        TileEntityFlowerPot tileEntityFlowerPot = te = world.func_175625_s(pos) instanceof TileEntityFlowerPot ? (TileEntityFlowerPot)world.func_175625_s(pos) : null;
        if (te != null && te.func_145965_a() != null) {
            drops.add((Object)new ItemStack(te.func_145965_a(), 1, te.func_145966_b()));
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack tool) {
        super.func_180657_a(world, player, pos, state, te, tool);
        world.func_175698_g(pos);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public static enum EnumFlowerType implements IStringSerializable
    {
        EMPTY("empty"),
        SEED_0("seed"),
        SEED_1("seed_1"),
        SEED_2("seed_2"),
        ACACIA_SAPLING("acacia_sapling"),
        ASPEN_SAPLING("aspen_sapling"),
        ATREE_SAPLING("a_tree_sapling"),
        BIRCH_SAPLING("birch_sapling"),
        OAK_SAPLING("oak_sapling"),
        PINE_SAPLING("pine_sapling"),
        POPLAR_SAPLING("poplar_sapling"),
        SNOW_SAPLING("snow_sapling"),
        SPRUCE_SAPLING("spruce_sapling"),
        STREE_SAPLING("s_tree_sapling"),
        TTREE_SAPLING("t_tree_sapling"),
        WILLOW_SAPLING("willow_sapling"),
        R_TREE_SAPLING("r_tree_sapling"),
        BROWN_MUSHROOM("brown_mushroom"),
        BLACK_MUSHROOM("black_mushroom"),
        GRAY_MUSHROOM("gray_mushroom"),
        RED_MUSHROOM("red_mushroom"),
        CORAL_MUSHROOM("coral_mushroom"),
        ORANGE_MUSHROOM("orange_mushroom"),
        YELLOW_MUSHROOM("yellow_mushroom"),
        BLUE_MUSHROOM("blue_mushroom"),
        PURPLE_MUSHROOM("purple_mushroom"),
        MARSH_MUSHROOM("marsh_mushroom"),
        PINK_MUSHROOM("pink_mushroom"),
        PUFF_MUSHROOM("puff_mushroom"),
        SAND_MUSHROOM("sand_mushroom"),
        SPOT_MUSHROOM("spot_mushroom"),
        CUP_MUSHROOM("cup_mushroom"),
        AZURE_MUSHROOM("azure_mushroom"),
        GREEN_MUSHROOM("green_mushroom"),
        COPPER_MUSHROOM("copper_mushroom"),
        SILVER_MUSHROOM("silver_mushroom"),
        BEIGE_MUSHROOM("beige_mushroom"),
        GOLD_MUSHROOM("gold_mushroom"),
        WHITE_MUSHROOM("white_mushroom"),
        VIOLET_MUSHROOM("violet_mushroom"),
        LILAC_MUSHROOM("lilac_mushroom"),
        TAN_MUSHROOM("tan_mushroom"),
        SPONGE("sponge");

        private final String name;

        private EnumFlowerType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

