/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IShiftPlaceable;
import ru.liahim.mist.api.block.IWettable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.api.registry.ICompostIngredient;
import ru.liahim.mist.api.registry.MistRegistry;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.block.MistLeaves;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.init.ModAdvancements;
import ru.liahim.mist.world.MistWorld;

public class MistCompostHeap
extends MistBlock
implements IShiftPlaceable {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)7);
    public static final PropertyBool WORK = PropertyBool.func_177716_a((String)"work");

    public MistCompostHeap() {
        super(Material.field_151578_c);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WORK, (Comparable)Boolean.valueOf(false)));
        this.setHarvestLevel("shovel", 0);
        this.func_149675_a(true);
        this.field_149783_u = true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)WORK)).booleanValue()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)((Integer)state.func_177229_b((IProperty)STAGE) + 1) * 0.125, 1.0);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)WORK)).booleanValue()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.9375, 1.0);
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)((Integer)state.func_177229_b((IProperty)STAGE)).intValue() * 0.125 + 0.0625, 1.0);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (side == EnumFacing.UP) {
            ItemStack heldItem = player.func_184586_b(hand);
            int st = (Integer)state.func_177229_b((IProperty)STAGE);
            if (((Boolean)state.func_177229_b((IProperty)WORK)).booleanValue()) {
                if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 15) {
                    IBlockState downState = world.func_180495_p(pos.func_177977_b());
                    if (player.field_71075_bZ.field_75098_d || downState.func_177230_c() instanceof IWettable && (Boolean)downState.func_177229_b((IProperty)IWettable.WET) != false || world.func_175727_C(pos.func_177984_a()) || MistWorld.getHumi(world, pos, 0.0f) >= 50.0f || IWettable.checkWaterDist(world, pos, EnumFacing.UP, 3, 0) >= 0) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                        }
                        if (st < 6) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(st + 2 >> 1 << 1)));
                        } else {
                            world.func_175656_a(pos, MistBlocks.HUMUS_DIRT.func_176223_P());
                        }
                        world.func_175718_b(2005, pos.func_177984_a(), 0);
                        return true;
                    }
                }
            } else if (st == 7) {
                if (heldItem != null && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 15) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                    }
                    world.func_175656_a(pos, state.func_177226_a((IProperty)WORK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
                    world.func_175718_b(2005, pos.func_177984_a(), 0);
                    return true;
                }
            } else if (MistCompostHeap.isCompostIngredient(heldItem)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190920_e(heldItem.func_190916_E() - 1);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(st + 1)));
                world.func_184133_a(null, pos.func_177984_a(), SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 0.8f);
                return true;
            }
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
                world.func_175655_b(pos, true);
            } else if (!((Boolean)state.func_177229_b((IProperty)WORK)).booleanValue() && block != MistBlocks.FLOATING_MAT) {
                int count = 0;
                for (EnumFacing face : EnumFacing.field_176754_o) {
                    if (count >= 2) break;
                    if (!world.isSideSolid(pos.func_177972_a(face), face.func_176734_d()) && !MistCompostHeap.checkCompostHeap(world.func_180495_p(pos.func_177972_a(face)))) continue;
                    ++count;
                }
                if (count < 2) {
                    world.func_175655_b(pos, true);
                }
            }
        }
    }

    public static boolean checkCompostHeap(IBlockState state) {
        return state.func_177230_c() == MistBlocks.COMPOST_HEAP && ((Boolean)state.func_177229_b((IProperty)WORK) != false || (Integer)state.func_177229_b((IProperty)STAGE) == 7);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && rand.nextInt(8) == 0) {
            IBlockState downState;
            int i = -1;
            if (((Boolean)state.func_177229_b((IProperty)WORK)).booleanValue()) {
                i = 1;
            } else if ((Integer)state.func_177229_b((IProperty)STAGE) == 7) {
                i = 0;
            }
            if (i >= 0 && ((downState = world.func_180495_p(pos.func_177977_b())).func_177230_c() instanceof IWettable && (Boolean)downState.func_177229_b((IProperty)IWettable.WET) != false || world.func_175727_C(pos.func_177984_a()) || MistWorld.getHumi(world, pos, 0.0f) >= 50.0f || IWettable.checkWaterDist(world, pos, EnumFacing.UP, 3, 0) >= 0)) {
                if (i == 0) {
                    world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)WORK, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
                } else {
                    i = (Integer)state.func_177229_b((IProperty)STAGE);
                    if (i == 7) {
                        world.func_175656_a(pos, MistBlocks.HUMUS_DIRT.func_176223_P());
                    } else {
                        world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(i + 1)));
                    }
                }
            }
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE) + ((Boolean)state.func_177229_b((IProperty)WORK) != false ? 8 : 0);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta % 8)).func_177226_a((IProperty)WORK, (Comparable)Boolean.valueOf(meta > 7));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, WORK});
    }

    public static boolean isCompostIngredient(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ICompostIngredient) {
            return true;
        }
        if (item instanceof ItemBlock && Block.func_149634_a((Item)item) != Blocks.field_150350_a) {
            Block block = Block.func_149634_a((Item)item);
            if (block instanceof MistLeaves) {
                return true;
            }
            if (block == MistBlocks.TREE_SAPLING) {
                return true;
            }
            if (block == Blocks.field_150329_H) {
                return true;
            }
            if (block == Blocks.field_150327_N) {
                return true;
            }
            if (block == Blocks.field_150328_O) {
                return true;
            }
            if (block == Blocks.field_150398_cm) {
                return true;
            }
            if (block == Blocks.field_150337_Q) {
                return true;
            }
            if (block == Blocks.field_150338_P) {
                return true;
            }
            if (block == Blocks.field_150395_bd) {
                return true;
            }
            if (block == Blocks.field_150392_bi) {
                return true;
            }
            if (block == Blocks.field_150330_I) {
                return true;
            }
            if (block == Blocks.field_150345_g) {
                return true;
            }
            if (block == Blocks.field_150436_aH) {
                return true;
            }
        }
        if (item == MistItems.COMPOST) {
            return true;
        }
        if (item == MistItems.MULCH) {
            return true;
        }
        if (item == MistItems.DESERT_COTTON_SEED) {
            return true;
        }
        if (item == MistItems.REMAINS) {
            return true;
        }
        if (item == MistItems.TREE_SEEDS) {
            return true;
        }
        if (item == MistItems.MUSHROOMS_FOOD) {
            return true;
        }
        if (item == MistItems.MUSHROOMS_COOK) {
            return true;
        }
        if (item == MistItems.NIGHTBERRY) {
            return true;
        }
        if (item == MistItems.TINDER_FUNGUS) {
            return true;
        }
        if (item == Items.field_151170_bI) {
            return true;
        }
        if (item == Items.field_151120_aE) {
            return true;
        }
        if (item == Items.field_151034_e) {
            return true;
        }
        if (item == Items.field_151174_bG) {
            return true;
        }
        if (item == Items.field_151172_bF) {
            return true;
        }
        if (item == Items.field_185164_cV) {
            return true;
        }
        if (item == Items.field_151015_O) {
            return true;
        }
        return MistRegistry.isCompostIngredient(stack);
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        boolean work = (Boolean)state.func_177229_b((IProperty)WORK);
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int count = work ? 8 : st + 1;
        int humus = work ? (st >> 1 << 1) / 2 : 0;
        for (int i = 0; i < count; ++i) {
            if (humus > 0) {
                ret.add((Object)new ItemStack(MistItems.HUMUS, 1));
                --count;
            } else {
                ret.add((Object)new ItemStack(MistItems.COMPOST, 1));
            }
            --humus;
        }
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public boolean func_185481_k(IBlockState state) {
        return this.func_149686_d(state);
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149686_d(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WORK) == false && (Integer)state.func_177229_b((IProperty)STAGE) == 7;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)WORK) != false || (Integer)state.func_177229_b((IProperty)STAGE) == 7;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.field_70159_w *= 0.4;
        entityIn.field_70179_y *= 0.4;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(MistItems.COMPOST, 1);
    }

    @Override
    public boolean onShiftPlacing(World world, BlockPos pos, @Nonnull ItemStack stack, EntityPlayer player, float hitX, float hitY, float hitZ, BlockFaceShape bfs) {
        if (stack.func_77973_b() == MistItems.REMAINS) {
            return false;
        }
        if (bfs != BlockFaceShape.SOLID) {
            return false;
        }
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistSoil) {
            int count = 0;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                if (count >= 2) break;
                if (!world.isSideSolid(pos.func_177972_a(face), face.func_176734_d()) && !MistCompostHeap.checkCompostHeap(world.func_180495_p(pos.func_177972_a(face)))) continue;
                ++count;
            }
            if (count > 1 && MistCompostHeap.isCompostIngredient(stack) && world.func_175656_a(pos, this.func_176223_P())) {
                world.func_184133_a(null, pos, SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 1.0f, 0.8f);
                if (player instanceof EntityPlayerMP) {
                    ModAdvancements.COMPOST.trigger((EntityPlayerMP)player, stack);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190920_e(stack.func_190916_E() - 1);
                }
                return true;
            }
        }
        return false;
    }
}

