/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import net.minecraft.block.BlockChest;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.ILockableContainer;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.tileentity.TileEntityMistChest;

public class MistChest
extends BlockChest {
    public static final BlockChest.Type MIST_CHEST = (BlockChest.Type)EnumHelper.addEnum(BlockChest.Type.class, (String)"mist_chest", (Class[])new Class[0], (Object[])new Object[0]);
    public final ChestType type;

    public MistChest(ChestType chestType) {
        super(MIST_CHEST);
        this.type = chestType;
        this.func_149647_a(Mist.mistTab);
    }

    public MistChest(ChestType chestType, Material material) {
        super(MIST_CHEST);
        this.type = chestType;
        this.field_149764_J = material;
        this.field_181083_K = material.func_151565_r();
        this.field_149785_s = !material.func_76228_b();
        this.func_149647_a(Mist.mistTab);
    }

    public String func_149739_a() {
        return "tile.mist." + super.func_149739_a().substring(5);
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityMistChest();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isType(this.type, world, pos.func_177978_c()) ? field_185557_b : (this.isType(this.type, world, pos.func_177968_d()) ? field_185558_c : (this.isType(this.type, world, pos.func_177976_e()) ? field_185559_d : (this.isType(this.type, world, pos.func_177974_f()) ? field_185560_e : field_185561_f)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ILockableContainer container = this.func_180676_d(world, pos);
        if (container != null) {
            player.func_71007_a((IInventory)container);
            if (!this.type.isTrapped()) {
                player.func_71029_a(StatList.field_188063_ac);
            } else {
                player.func_71029_a(StatList.field_188089_W);
            }
        }
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return this.type.isTrapped();
    }

    public boolean isType(ChestType type, IBlockAccess world, BlockPos pos) {
        ChestType other = this.getType(world, pos);
        return other != null && other == type;
    }

    public ChestType getType(IBlockAccess world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == this) {
            return ((MistChest)world.func_180495_p((BlockPos)pos).func_177230_c()).type;
        }
        return null;
    }

    public static enum ChestType {
        NIOBIUM_BASIC(false),
        NIOBIUM_TRAP(true);

        private final boolean isTrapped;

        private ChestType(boolean isTrapped) {
            this.isTrapped = isTrapped;
        }

        public boolean isTrapped() {
            return this.isTrapped;
        }
    }
}

