/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ru.liahim.mist.api.block.IColoredBlock;
import ru.liahim.mist.api.block.IShiftPlaceable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.MistSoil;
import ru.liahim.mist.block.gizmos.MistBlockContainer;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.init.BlockColoring;
import ru.liahim.mist.item.food.ItemMistSoup;
import ru.liahim.mist.tileentity.TileEntityCampStick;
import ru.liahim.mist.tileentity.TileEntityCampfire;
import ru.liahim.mist.util.SoilHelper;

public class MistCampfire
extends MistBlockContainer
implements IColoredBlock,
IShiftPlaceable {
    public static final PropertyEnum<CookingTool> TOOL = PropertyEnum.func_177709_a((String)"tool", CookingTool.class);
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)10);
    public static final PropertyDirection DIR = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB AABB_FIRE_PIT_0 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);
    protected static final AxisAlignedBB AABB_FIRE_PIT_6 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    protected static final AxisAlignedBB AABB_FIRE_PIT_POT = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.8125, 1.0);
    protected static final AxisAlignedBB AABB_FIRE_WOOD = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.375, 0.75);
    protected static final AxisAlignedBB AABB_POT = new AxisAlignedBB(0.21875, 0.0, 0.21875, 0.78125, 0.8125, 0.78125);
    protected static final AxisAlignedBB AABB_FIRE_GRILL = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5625, 1.0);

    @Override
    @SideOnly(value=Side.CLIENT)
    public IBlockColor getBlockColor() {
        return new IBlockColor(){

            public int func_186720_a(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
                if (world != null && pos != null && tintIndex == 1 && world.func_175625_s(pos) instanceof TileEntityCampfire) {
                    return ((TileEntityCampfire)world.func_175625_s(pos)).getStoneColor();
                }
                return -1;
            }
        };
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return BlockColoring.BLOCK_ITEM_COLORING;
    }

    public MistCampfire() {
        super(Material.field_151578_c, MapColor.field_151650_B);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(7)));
        this.func_149711_c(0.5f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((state = this.func_176221_a(state, world, pos)).func_177229_b(TOOL) == CookingTool.POT) {
            return AABB_FIRE_PIT_POT;
        }
        if (state.func_177229_b(TOOL) == CookingTool.GRILL) {
            return AABB_FIRE_GRILL;
        }
        return (Integer)state.func_177229_b((IProperty)STAGE) < 6 ? AABB_FIRE_PIT_0 : AABB_FIRE_PIT_6;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean par_7) {
        if (!par_7) {
            state = this.func_176221_a(state, (IBlockAccess)world, pos);
        }
        for (AxisAlignedBB axisalignedbb : MistCampfire.getCollisionBoxList(state)) {
            MistCampfire.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)axisalignedbb);
        }
    }

    private static List<AxisAlignedBB> getCollisionBoxList(IBlockState state) {
        ArrayList list = Lists.newArrayList();
        if (state.func_177229_b(TOOL) == CookingTool.GRILL) {
            list.add(AABB_FIRE_GRILL);
        } else {
            list.add(AABB_FIRE_PIT_0);
            if (state.func_177229_b(TOOL) == CookingTool.POT) {
                list.add(AABB_POT);
            } else if ((Integer)state.func_177229_b((IProperty)STAGE) > 5) {
                list.add(AABB_FIRE_WOOD);
            }
        }
        return list;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        return st == 8 ? 14 : (st == 9 ? 10 : 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        state = this.func_176221_a(state, (IBlockAccess)world, pos);
        ItemStack heldItem = player.func_184586_b(hand);
        TileEntityCampfire te = (TileEntityCampfire)world.func_175625_s(pos);
        if (player.func_70093_af()) {
            if (hand != EnumHand.MAIN_HAND) return false;
            if (te.getCookingTool() == CookingTool.POT) {
                if (!heldItem.func_190926_b() || te.getVolum() != 0) return false;
                player.func_184611_a(hand, CookingTool.POT.getItem());
                te.setCookingTool(CookingTool.NONE);
                te.updateStatus(state.func_177226_a(TOOL, (Comparable)((Object)CookingTool.NONE)));
                return true;
            }
            if (te.getCookingTool() != CookingTool.GRILL) return false;
            if (te.isGrillEmpty()) {
                if (!heldItem.func_190926_b()) return false;
                player.func_184611_a(hand, CookingTool.GRILL.getItem());
                te.setCookingTool(CookingTool.NONE);
                te.updateStatus(state.func_177226_a(TOOL, (Comparable)((Object)CookingTool.NONE)));
                return true;
            }
            int i = this.getGrillSlot(hitX, hitZ, te.getFacing());
            ItemStack food = te.getGrillStack(i);
            if (food.func_190926_b() || !heldItem.func_190926_b() && (!heldItem.func_77985_e() || heldItem.func_190916_E() >= heldItem.func_77976_d() || !heldItem.func_77969_a(food))) return false;
            if (heldItem.func_190926_b()) {
                player.func_184611_a(hand, food);
            } else {
                heldItem.func_190917_f(1);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187728_s, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
            te.setGrillStack(i, ItemStack.field_190927_a);
            te.updateStatus(state);
            return true;
        }
        if (!heldItem.func_190926_b()) {
            ItemStack stack;
            int stage;
            Item item = heldItem.func_77973_b();
            if (state.func_177229_b(TOOL) == CookingTool.POT) {
                FluidStack fStack;
                IFluidHandlerItem fluidHandler;
                if (item instanceof ItemFood && !(item instanceof ItemMistSoup)) {
                    ItemStack stack2 = heldItem.func_77946_l();
                    stack2.func_190920_e(1);
                    ArrayList<ItemStack> list = te.addFood(stack2, -1);
                    if (!list.get(0).func_190926_b()) return false;
                    heldItem.func_190918_g(1);
                    if (list.size() > 1) {
                        for (int i = 1; i < list.size(); ++i) {
                            if (heldItem.func_190926_b()) {
                                player.func_184611_a(hand, list.get(i));
                                continue;
                            }
                            if (player.field_71071_by.func_70441_a(list.get(i))) continue;
                            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, list.get(i)));
                        }
                    }
                    te.updateStatus(state);
                    world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
                    return true;
                }
                if (item == Items.field_151054_z || item instanceof ItemMistSoup && ((ItemMistSoup)item).getCurrentPortion(heldItem) < ((ItemMistSoup)item).getMaxPortion()) {
                    if (world.field_72995_K) return false;
                    ItemStack soup = te.getSoup(heldItem, 1);
                    if (!soup.func_190926_b()) {
                        heldItem.func_190918_g(1);
                        if (heldItem.func_190926_b()) {
                            player.func_184611_a(hand, soup);
                        } else if (!player.field_71071_by.func_70441_a(soup)) {
                            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 0.5, soup));
                        }
                        world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
                        return true;
                    }
                } else if (hand == EnumHand.MAIN_HAND && (fluidHandler = FluidUtil.getFluidHandler((ItemStack)heldItem)) != null && (fStack = fluidHandler.drain(1000, false)) != null && (fStack.getFluid() == FluidRegistry.WATER || fStack.getFluid().getName().equals("milk"))) {
                    player.openGui((Object)Mist.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
            } else if (state.func_177229_b(TOOL) == CookingTool.GRILL && item instanceof ItemFood) {
                ItemStack stack3 = heldItem.func_77946_l();
                stack3.func_190920_e(1);
                ArrayList<ItemStack> list = te.addFood(stack3, this.getGrillSlot(hitX, hitZ, te.getFacing()));
                if (!list.get(0).func_190926_b()) return false;
                heldItem.func_190918_g(1);
                world.func_184133_a(null, pos, SoundEvents.field_187728_s, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
                return true;
            }
            if ((stage = ((Integer)state.func_177229_b((IProperty)STAGE)).intValue()) < 3) {
                if (!te.getStone().func_190926_b() && item == te.getStone().func_77973_b() && heldItem.func_77952_i() == te.getStone().func_77952_i()) {
                    heldItem.func_190918_g(1);
                    int count = TileEntityCampfire.getStoneCount(te.getStone());
                    count = Math.round((float)Math.round((float)((stage + 1) * count) / 4.0f + 1.0f) * 4.0f / (float)count) - 1;
                    world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(count)));
                    world.func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    return true;
                }
            } else if (stage < 7) {
                if (item == Items.field_151055_y || Block.func_149634_a((Item)item).func_176223_P().func_185904_a() == Material.field_151575_d || item instanceof ItemTool && "WOOD".equals(((ItemTool)item).func_77861_e()) || item instanceof ItemSword && "WOOD".equals(((ItemSword)item).func_150932_j()) || item instanceof ItemHoe && "WOOD".equals(((ItemHoe)item).func_77842_f())) {
                    stack = heldItem.func_77946_l();
                    stack.func_190920_e(1);
                    stack = te.addFuel(stack);
                    if (stack.func_190926_b()) {
                        heldItem.func_190918_g(1);
                        world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)));
                        world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                        return true;
                    }
                }
            } else {
                if (item instanceof ItemFlintAndSteel) {
                    heldItem.func_77972_a(1, (EntityLivingBase)player);
                    world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(8)));
                    world.func_184133_a(null, pos, SoundEvents.field_187649_bu, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    te.setFire();
                    return true;
                }
                if (stage > 7 && item != Items.field_151054_z) {
                    stack = heldItem.func_77946_l();
                    stack.func_190920_e(1);
                    stack = te.addFuel(stack);
                    if (stack.func_190926_b()) {
                        heldItem.func_190918_g(1);
                        if (stage == 9) {
                            world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(8)));
                        }
                        world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                        return true;
                    }
                }
            }
            if (stage >= 7 && !te.hasCookingTool()) {
                if (!this.canPlace(world, pos)) return true;
                for (CookingTool tool : CookingTool.values()) {
                    if (tool == CookingTool.NONE || !heldItem.func_77969_a(tool.getItem())) continue;
                    heldItem.func_190918_g(1);
                    world.func_184133_a(null, pos, SoundEvents.field_187772_dn, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    te.setCookingTool(tool);
                    te.updateStatus(state.func_177226_a(TOOL, (Comparable)((Object)tool)));
                }
                return true;
            }
        }
        if (hand != EnumHand.MAIN_HAND || te.getCookingTool() != CookingTool.POT || te.getVolum() <= 0) return false;
        player.openGui((Object)Mist.instance, 3, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    private boolean canPlace(World world, BlockPos pos) {
        for (EnumFacing face : EnumFacing.field_176754_o) {
            TileEntity te = world.func_175625_s(pos.func_177972_a(face));
            if (te == null || !(te instanceof TileEntityCampStick) || ((TileEntityCampStick)te).getFood().func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private int getGrillSlot(float hitX, float hitZ, EnumFacing face) {
        int i = (double)hitZ < 0.5 ? ((double)hitX < 0.5 ? 3 : 2) : ((double)hitX < 0.5 ? 0 : 1);
        return i + face.func_176736_b() & 3;
    }

    public void extinguish(World world, BlockPos pos, boolean hasFuel) {
        IBlockState state = world.func_180495_p(pos).func_185899_b((IBlockAccess)world, pos);
        int stage = (Integer)state.func_177229_b((IProperty)STAGE);
        if (stage == 8 || stage == 9) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(hasFuel ? 9 : 10)));
        }
    }

    public void func_176224_k(World world, BlockPos pos) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityCampfire) {
            int hum;
            IBlockState soil;
            ((TileEntityCampfire)te).fillWithRain();
            int ash = ((TileEntityCampfire)te).getAshTimer();
            if (ash >= 1000 && (soil = world.func_180495_p(pos.func_177977_b())) instanceof MistSoil && (hum = SoilHelper.getHumus(soil)) < 3 && SoilHelper.setSoil(world, pos, soil, hum + 1, 2)) {
                ((TileEntityCampfire)te).setAshTimer(ash - 1000);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity te = world.func_175625_s(pos);
        if (!world.field_72995_K && te != null && te instanceof TileEntityCampfire) {
            for (ItemStack stack : ((TileEntityCampfire)te).getDrops(state)) {
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        if (!world.field_72995_K && (Integer)world.func_180495_p(pos).func_177229_b((IProperty)STAGE) < 7) {
            world.func_175655_b(pos, true);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (fromPos.equals((Object)pos.func_177977_b()) && !world.isSideSolid(fromPos, EnumFacing.UP) || world.func_180495_p(fromPos).func_185904_a().func_76224_d()) {
                world.func_175655_b(pos, true);
            } else {
                TileEntity te = world.func_175625_s(pos);
                if (te != null && te instanceof TileEntityCampfire) {
                    ((TileEntityCampfire)te).setMinedStone(world.func_180495_p(pos.func_177984_a()).func_177230_c() == MistBlocks.STONE_MINED);
                }
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityCampfire) {
            ((TileEntityCampfire)te).setMinedStone(world.func_180495_p(pos.func_177984_a()).func_177230_c() == MistBlocks.STONE_MINED);
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        ArrayList list = Lists.newArrayList();
        for (AxisAlignedBB axisalignedbb : MistCampfire.getCollisionBoxList(this.func_176221_a(blockState, (IBlockAccess)world, pos))) {
            list.add(this.func_185503_a(pos, start, end, axisalignedbb));
        }
        RayTraceResult rtresult = null;
        double d1 = 0.0;
        for (RayTraceResult raytraceresult : list) {
            double d0;
            if (raytraceresult == null || !((d0 = raytraceresult.field_72307_f.func_72436_e(end)) > d1)) continue;
            rtresult = raytraceresult;
            d1 = d0;
        }
        return rtresult;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 8) {
            double x = (double)pos.func_177958_n() + 0.2 + rand.nextDouble() * 0.6;
            double y = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0 + 0.1;
            double z = (double)pos.func_177952_p() + 0.2 + rand.nextDouble() * 0.6;
            if (rand.nextDouble() < 0.2) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.5f, 1.0f, false);
            }
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x, y, z, 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityCampfire te = (TileEntityCampfire)world.func_175625_s(pos);
        if (te != null) {
            state = state.func_177226_a((IProperty)DIR, (Comparable)te.getFacing());
            if (te.hasCookingTool()) {
                return state.func_177226_a(TOOL, (Comparable)((Object)te.getCookingTool()));
            }
            return state.func_177226_a(TOOL, (Comparable)((Object)CookingTool.NONE));
        }
        return state;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIR, STAGE, TOOL});
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCampfire();
    }

    @Override
    public boolean onShiftPlacing(World world, BlockPos pos, @Nonnull ItemStack stack, EntityPlayer player, float hitX, float hitY, float hitZ, BlockFaceShape bfs) {
        if (bfs != BlockFaceShape.SOLID) {
            return false;
        }
        int count = TileEntityCampfire.getStoneCount(stack);
        if (count > 0) {
            EnumFacing face = player.func_174811_aO().func_176734_d();
            if (world.func_175656_a(pos, MistBlocks.CAMPFIRE.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(Math.round(4.0f / (float)count) - 1)).func_177226_a((IProperty)DIR, (Comparable)face))) {
                world.func_184133_a(null, pos, SoundEvents.field_187845_fY, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                TileEntityCampfire te = (TileEntityCampfire)world.func_175625_s(pos);
                te.setStone(stack);
                te.setFacing(face);
                stack.func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public static enum CookingTool implements IStringSerializable
    {
        NONE("none", 0, ItemStack.field_190927_a),
        POT("pot", 1, new ItemStack(Items.field_151066_bu)),
        GRILL("grill", 2, new ItemStack(Blocks.field_150411_aY));

        private final String name;
        private final int index;
        private final ItemStack item;
        private static final CookingTool[] META_LOOKUP;

        private CookingTool(String name, int index, ItemStack item) {
            this.name = name;
            this.index = index;
            this.item = item;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getIndex() {
            return this.index;
        }

        public ItemStack getItem() {
            return this.item.func_77946_l();
        }

        public static CookingTool fromIndex(int index) {
            if (index < 0 || index >= META_LOOKUP.length) {
                index = 0;
            }
            return META_LOOKUP[index];
        }

        static {
            META_LOOKUP = new CookingTool[CookingTool.values().length];
            CookingTool[] cookingToolArray = CookingTool.values();
            int n = cookingToolArray.length;
            for (int i = 0; i < n; ++i) {
                CookingTool type;
                CookingTool.META_LOOKUP[type.getIndex()] = type = cookingToolArray[i];
            }
        }
    }
}

