/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.gizmos;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import ru.liahim.mist.api.block.IShiftPlaceable;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.block.gizmos.MistBlockContainer;
import ru.liahim.mist.block.gizmos.MistCampfire;
import ru.liahim.mist.tileentity.TileEntityCampStick;
import ru.liahim.mist.tileentity.TileEntityCampfire;

public class MistCampStick
extends MistBlockContainer
implements IShiftPlaceable {
    public static final PropertyDirection DIR = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB EAST = new AxisAlignedBB(0.625, 0.0, 0.4375, 1.0625, 0.75, 0.625);
    protected static final AxisAlignedBB WEST = new AxisAlignedBB(-0.0625, 0.0, 0.375, 0.375, 0.75, 0.5625);
    protected static final AxisAlignedBB SOUTH = new AxisAlignedBB(0.375, 0.0, 0.625, 0.5625, 0.75, 1.0625);
    protected static final AxisAlignedBB NORTH = new AxisAlignedBB(0.4375, 0.0, -0.0625, 0.625, 0.75, 0.375);

    public MistCampStick() {
        super(Material.field_151578_c, MapColor.field_151660_b);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.4f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)DIR)) {
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
            case SOUTH: {
                return SOUTH;
            }
            case NORTH: {
                return NORTH;
            }
        }
        return field_185505_j;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            if (fromPos.equals((Object)pos.func_177977_b()) && !world.isSideSolid(fromPos, EnumFacing.UP) || world.func_180495_p(fromPos).func_185904_a().func_76224_d() || fromPos.equals((Object)pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)DIR))) && !world.func_175623_d(fromPos) && world.func_180495_p(fromPos).func_177230_c() != MistBlocks.CAMPFIRE) {
                world.func_175655_b(pos, true);
            } else {
                TileEntity te = world.func_175625_s(pos);
                if (te != null && te instanceof TileEntityCampStick) {
                    this.isWork(world, pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)DIR)), (TileEntityCampStick)te);
                }
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (hand == EnumHand.MAIN_HAND) {
            ItemStack heldItem = player.func_184586_b(hand);
            TileEntity te = world.func_175625_s(pos);
            if (te != null && te instanceof TileEntityCampStick) {
                ItemStack food = ((TileEntityCampStick)te).getFood();
                if (player.func_70093_af()) {
                    if (heldItem.func_190926_b()) {
                        if (!food.func_190926_b()) {
                            player.func_184611_a(hand, food);
                            ((TileEntityCampStick)te).clearFood();
                            world.func_184133_a(null, pos, SoundEvents.field_187728_s, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
                            return true;
                        }
                    } else if (heldItem.func_190916_E() < heldItem.func_77976_d() && heldItem.func_77969_a(food)) {
                        heldItem.func_190917_f(1);
                        ((TileEntityCampStick)te).clearFood();
                        world.func_184133_a(null, pos, SoundEvents.field_187728_s, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
                        return true;
                    }
                } else {
                    TileEntity camp = world.func_175625_s(pos.func_177972_a((EnumFacing)state.func_177229_b((IProperty)DIR)));
                    if ((camp == null || camp instanceof TileEntityCampfire && !((TileEntityCampfire)camp).hasCookingTool()) && ((TileEntityCampStick)te).setFood(heldItem)) {
                        world.func_184133_a(null, pos, SoundEvents.field_187728_s, SoundCategory.BLOCKS, 0.25f, 1.2f - world.field_73012_v.nextFloat() * 0.4f);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public boolean onShiftPlacing(World world, BlockPos pos, @Nonnull ItemStack stack, EntityPlayer player, float hitX, float hitY, float hitZ, BlockFaceShape bfs) {
        if (bfs != BlockFaceShape.SOLID) {
            return false;
        }
        if (stack.func_77973_b() == Items.field_151055_y) {
            EnumFacing dir2;
            float i = 1.0f - hitZ;
            EnumFacing dir = player.func_174811_aO();
            EnumFacing enumFacing = hitX < hitZ ? (hitX < i ? EnumFacing.WEST : EnumFacing.SOUTH) : (dir2 = hitX < i ? EnumFacing.NORTH : EnumFacing.EAST);
            if (world.func_180495_p(pos.func_177972_a(dir2)).func_177230_c() != MistBlocks.CAMPFIRE) {
                if (dir != dir2 && world.func_180495_p(pos.func_177972_a(dir)).func_177230_c() == MistBlocks.CAMPFIRE) {
                    dir2 = dir;
                } else {
                    if (dir.func_176740_k() == EnumFacing.Axis.X) {
                        dir2 = hitZ < 0.5f ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    } else {
                        EnumFacing enumFacing2 = dir2 = hitX < 0.5f ? EnumFacing.WEST : EnumFacing.EAST;
                    }
                    if (world.func_180495_p(pos.func_177972_a(dir2)).func_177230_c() != MistBlocks.CAMPFIRE) {
                        if (world.func_180495_p(pos.func_177972_a(dir = dir.func_176734_d())).func_177230_c() == MistBlocks.CAMPFIRE) {
                            dir2 = dir;
                        } else if (world.func_180495_p(pos.func_177972_a(dir2 = dir2.func_176734_d())).func_177230_c() != MistBlocks.CAMPFIRE) {
                            dir2 = EnumFacing.DOWN;
                        }
                    }
                }
            }
            if (dir2 != EnumFacing.DOWN && world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)dir2))) {
                TileEntityCampStick te = (TileEntityCampStick)world.func_175625_s(pos);
                te.setFacing(dir2);
                this.isWork(world, pos.func_177972_a(dir2), te);
                world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.BLOCKS, 0.8f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                stack.func_190918_g(1);
                return true;
            }
        }
        return false;
    }

    private void isWork(World world, BlockPos pos, TileEntityCampStick te) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == MistBlocks.CAMPFIRE) {
            int stage = (Integer)state.func_177229_b((IProperty)MistCampfire.STAGE);
            if (stage == 8 || stage == 9) {
                te.setWork(true);
            } else {
                te.setWork(false);
            }
        } else {
            te.setWork(false);
        }
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityCampStick();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(Items.field_151055_y));
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te instanceof TileEntityCampStick) {
            ItemStack stack = ((TileEntityCampStick)te).getFood();
            if (!stack.func_190926_b()) {
                InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180649_a(World world, BlockPos pos, EntityPlayer player) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) != null && te instanceof TileEntityCampStick && ((TileEntityCampStick)te).getFood().func_190926_b()) {
            world.func_175655_b(pos, true);
        }
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DIR)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DIR, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DIR});
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.DESTROY;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

