/*
 * Decompiled with CFR 0.152.
 */
package ru.liahim.mist.block.downplant;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import ru.liahim.mist.api.block.IDownPlant;
import ru.liahim.mist.api.block.IMistAdsorbent;
import ru.liahim.mist.api.block.MistBlocks;
import ru.liahim.mist.api.item.MistItems;
import ru.liahim.mist.block.MistAcidSoil;
import ru.liahim.mist.block.MistBlock;
import ru.liahim.mist.common.Mist;
import ru.liahim.mist.util.FacingHelper;
import ru.liahim.mist.world.MistWorld;

public class MistSponge
extends MistBlock
implements IPlantable,
IMistAdsorbent,
IDownPlant {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)5);
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"var", (int)0, (int)8);

    public MistSponge() {
        super(Material.field_151577_b, MapColor.field_193561_M);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(8)));
        this.func_149711_c(0.4f);
        this.func_149675_a(true);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_185899_b(source, pos).func_177229_b((IProperty)VARIANT);
        double n = 0.0;
        double e = 1.0;
        double s = 1.0;
        double w = 0.0;
        double u = 1.0;
        if (st == 0) {
            switch (var) {
                case 0: {
                    n = 0.3125;
                    e = 0.6875;
                    s = 0.6875;
                    w = 0.3125;
                    u = 0.375;
                    break;
                }
                case 1: {
                    n = 0.25;
                    e = 0.6875;
                    s = 0.625;
                    w = 0.3125;
                    u = 0.375;
                    break;
                }
                case 2: {
                    n = 0.25;
                    e = 0.75;
                    s = 0.625;
                    w = 0.375;
                    u = 0.375;
                    break;
                }
                case 3: {
                    n = 0.3125;
                    e = 0.75;
                    s = 0.6875;
                    w = 0.375;
                    u = 0.375;
                    break;
                }
                case 4: {
                    n = 0.375;
                    e = 0.75;
                    s = 0.75;
                    w = 0.375;
                    u = 0.375;
                    break;
                }
                case 5: {
                    n = 0.375;
                    e = 0.6875;
                    s = 0.75;
                    w = 0.3125;
                    u = 0.375;
                    break;
                }
                case 6: {
                    n = 0.375;
                    e = 0.625;
                    s = 0.75;
                    w = 0.25;
                    u = 0.375;
                    break;
                }
                case 7: {
                    n = 0.3125;
                    e = 0.625;
                    s = 0.6875;
                    w = 0.25;
                    u = 0.375;
                    break;
                }
                case 8: {
                    n = 0.25;
                    e = 0.625;
                    s = 0.625;
                    w = 0.25;
                    u = 0.375;
                }
            }
        } else if (st == 1) {
            switch (var) {
                case 0: {
                    n = 0.1875;
                    e = 0.8125;
                    s = 0.8125;
                    w = 0.1875;
                    u = 0.625;
                    break;
                }
                case 1: {
                    n = 0.125;
                    e = 0.8125;
                    s = 0.75;
                    w = 0.1875;
                    u = 0.625;
                    break;
                }
                case 2: {
                    n = 0.125;
                    e = 0.875;
                    s = 0.75;
                    w = 0.25;
                    u = 0.625;
                    break;
                }
                case 3: {
                    n = 0.1875;
                    e = 0.875;
                    s = 0.8125;
                    w = 0.25;
                    u = 0.625;
                    break;
                }
                case 4: {
                    n = 0.25;
                    e = 0.875;
                    s = 0.875;
                    w = 0.25;
                    u = 0.625;
                    break;
                }
                case 5: {
                    n = 0.25;
                    e = 0.8125;
                    s = 0.875;
                    w = 0.1875;
                    u = 0.625;
                    break;
                }
                case 6: {
                    n = 0.25;
                    e = 0.75;
                    s = 0.875;
                    w = 0.125;
                    u = 0.625;
                    break;
                }
                case 7: {
                    n = 0.1875;
                    e = 0.75;
                    s = 0.8125;
                    w = 0.125;
                    u = 0.625;
                    break;
                }
                case 8: {
                    n = 0.125;
                    e = 0.75;
                    s = 0.75;
                    w = 0.125;
                    u = 0.625;
                }
            }
        } else if (st == 2) {
            switch (var) {
                case 0: {
                    n = 0.3125;
                    e = 0.6875;
                    s = 0.6875;
                    w = 0.3125;
                    u = 1.0;
                    break;
                }
                case 1: {
                    n = 0.1875;
                    e = 0.6875;
                    s = 0.5625;
                    w = 0.3125;
                    u = 1.0;
                    break;
                }
                case 2: {
                    n = 0.1875;
                    e = 0.8125;
                    s = 0.5625;
                    w = 0.4375;
                    u = 1.0;
                    break;
                }
                case 3: {
                    n = 0.3125;
                    e = 0.8125;
                    s = 0.6875;
                    w = 0.4375;
                    u = 1.0;
                    break;
                }
                case 4: {
                    n = 0.4375;
                    e = 0.8125;
                    s = 0.8125;
                    w = 0.4375;
                    u = 1.0;
                    break;
                }
                case 5: {
                    n = 0.4375;
                    e = 0.6875;
                    s = 0.8125;
                    w = 0.3125;
                    u = 1.0;
                    break;
                }
                case 6: {
                    n = 0.4375;
                    e = 0.5625;
                    s = 0.8125;
                    w = 0.1875;
                    u = 1.0;
                    break;
                }
                case 7: {
                    n = 0.3125;
                    e = 0.5625;
                    s = 0.6875;
                    w = 0.1875;
                    u = 1.0;
                    break;
                }
                case 8: {
                    n = 0.1875;
                    e = 0.5625;
                    s = 0.5625;
                    w = 0.1875;
                    u = 1.0;
                }
            }
        } else if (st == 3) {
            switch (var) {
                case 0: {
                    n = 0.1875;
                    e = 0.8125;
                    s = 0.8125;
                    w = 0.1875;
                    u = 1.0;
                    break;
                }
                case 1: {
                    n = 0.125;
                    e = 0.8125;
                    s = 0.75;
                    w = 0.1875;
                    u = 1.0;
                    break;
                }
                case 2: {
                    n = 0.125;
                    e = 0.875;
                    s = 0.75;
                    w = 0.25;
                    u = 1.0;
                    break;
                }
                case 3: {
                    n = 0.1875;
                    e = 0.875;
                    s = 0.8125;
                    w = 0.25;
                    u = 1.0;
                    break;
                }
                case 4: {
                    n = 0.25;
                    e = 0.875;
                    s = 0.875;
                    w = 0.25;
                    u = 1.0;
                    break;
                }
                case 5: {
                    n = 0.25;
                    e = 0.8125;
                    s = 0.875;
                    w = 0.1875;
                    u = 1.0;
                    break;
                }
                case 6: {
                    n = 0.25;
                    e = 0.75;
                    s = 0.875;
                    w = 0.125;
                    u = 1.0;
                    break;
                }
                case 7: {
                    n = 0.1875;
                    e = 0.75;
                    s = 0.8125;
                    w = 0.125;
                    u = 1.0;
                    break;
                }
                case 8: {
                    n = 0.125;
                    e = 0.75;
                    s = 0.75;
                    w = 0.125;
                    u = 1.0;
                }
            }
        } else if (st == 4) {
            if (var < 4) {
                n = 0.0625;
                e = 0.9375;
                s = 0.9375;
                w = 0.0625;
                u = 1.0;
            }
        } else if (st == 5) {
            if (var == 8) {
                n = 0.375;
                e = 0.625;
                s = 0.625;
                w = 0.375;
                u = 0.125;
            } else if (var < 3) {
                n = 0.0625;
                e = 0.9375;
                s = 0.9375;
                w = 0.0625;
                u = 0.8125;
            } else if (var < 6) {
                n = 0.0625;
                e = 0.9375;
                s = 0.9375;
                w = 0.0625;
                u = 0.9375;
            } else {
                n = 0.0;
                e = 1.0;
                s = 1.0;
                w = 0.0;
                u = 0.9375;
            }
        }
        return new AxisAlignedBB(w, 0.0, n, e, u, s);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        if (!world.field_72995_K) {
            int st = (Integer)state.func_177229_b((IProperty)STAGE);
            int var = (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)VARIANT);
            if (st != 4 || var < 6) {
                if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistAcidSoil || st > 2 && (st != 5 || var != 8) || st == 1 && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this)) {
                    world.func_175655_b(pos, true);
                }
            } else if (var < 8) {
                int i = this.checkLiquid(world, pos);
                if (i < 0) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(8)));
                } else if (i > 0 && var == 7 && !MistWorld.isPosInFog(world, pos)) {
                    world.func_175656_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(6)));
                }
            }
        }
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        int var;
        if (!(world.field_72995_K || (Integer)state.func_177229_b((IProperty)STAGE) != 4 || (var = ((Integer)state.func_177229_b((IProperty)VARIANT)).intValue()) != 6 && var != 7)) {
            int i = this.checkLiquid(world, pos);
            if (i < 0) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(8)));
            } else if (i > 0 && var == 7 && !MistWorld.isPosInFog(world, pos)) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(6)));
            }
        }
    }

    private int checkLiquid(World world, BlockPos pos) {
        int i = 0;
        for (EnumFacing face : FacingHelper.NOTDOWN) {
            IBlockState checkState = world.func_180495_p(pos.func_177972_a(face));
            if (checkState.func_185904_a() != Material.field_151586_h) continue;
            if (checkState.func_177230_c() == MistBlocks.ACID_BLOCK) {
                return -1;
            }
            if (checkState.func_177230_c() != Blocks.field_150355_j && checkState.func_177230_c() != Blocks.field_150358_i) continue;
            i = 1;
        }
        return i;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)VARIANT);
        if (st == 5 && var == 4 && side == EnumFacing.UP) {
            if (!world.field_72995_K) {
                ItemStack stack = new ItemStack(MistItems.SPONGE_SLIME);
                EntityItem entity_item = new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, stack);
                entity_item.func_174869_p();
                world.func_72838_d((Entity)entity_item);
                world.func_184133_a(null, pos, SoundEvents.field_187633_N, SoundCategory.BLOCKS, 0.2f, 1.5f);
                world.func_184133_a(null, pos, SoundEvents.field_187546_ae, SoundCategory.BLOCKS, 0.5f, 0.8f);
                world.func_175656_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(3)));
                if (world.func_180495_p(pos.func_177979_c(2)).func_177230_c() == this && (Integer)world.func_180495_p(pos.func_177979_c(2)).func_177229_b((IProperty)STAGE) == 4 && (Integer)world.func_180495_p(pos.func_177979_c(2)).func_185899_b((IBlockAccess)world, pos.func_177979_c(2)).func_177229_b((IProperty)VARIANT) == 2) {
                    world.func_175656_a(pos.func_177979_c(2), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)));
                }
            }
            return true;
        }
        return false;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            int mutateChance = 4;
            int aging = 4;
            int st = (Integer)state.func_177229_b((IProperty)STAGE);
            int var = (Integer)state.func_185899_b((IBlockAccess)worldIn, pos).func_177229_b((IProperty)VARIANT);
            boolean fog = MistWorld.isPosInFog(worldIn, pos);
            boolean soil = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof MistAcidSoil;
            int downSt = -1;
            int downVar = -1;
            if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
                downSt = (Integer)worldIn.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)STAGE);
                downVar = (Integer)worldIn.func_180495_p(pos.func_177977_b()).func_185899_b((IBlockAccess)worldIn, pos.func_177977_b()).func_177229_b((IProperty)VARIANT);
            }
            int upSt = -1;
            int upVar = -1;
            if (worldIn.func_180495_p(pos.func_177984_a()).func_177230_c() == this) {
                upSt = (Integer)worldIn.func_180495_p(pos.func_177984_a()).func_177229_b((IProperty)STAGE);
                upVar = (Integer)worldIn.func_180495_p(pos.func_177984_a()).func_185899_b((IBlockAccess)worldIn, pos.func_177984_a()).func_177229_b((IProperty)VARIANT);
            }
            int downSt2 = -1;
            int downVar2 = -1;
            if (worldIn.func_180495_p(pos.func_177979_c(2)).func_177230_c() == this) {
                downSt2 = (Integer)worldIn.func_180495_p(pos.func_177979_c(2)).func_177229_b((IProperty)STAGE);
                downVar2 = (Integer)worldIn.func_180495_p(pos.func_177979_c(2)).func_185899_b((IBlockAccess)worldIn, pos.func_177979_c(2)).func_177229_b((IProperty)VARIANT);
            }
            if (rand.nextInt(8) == 0) {
                if (st == 0) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                } else if (st == 1) {
                    if (soil) {
                        if (worldIn.func_175623_d(pos.func_177984_a())) {
                            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                            worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                        }
                    } else if (downSt > -1) {
                        if (downSt == 2) {
                            if (worldIn.func_175623_d(pos.func_177984_a()) && fog) {
                                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                                worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                            }
                        } else if (downSt == 3) {
                            if (worldIn.func_175623_d(pos.func_177984_a()) && fog) {
                                if (downSt2 == 3) {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                } else if (rand.nextInt(mutateChance) == 0) {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var)), 3);
                                } else {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                }
                            }
                        } else {
                            worldIn.func_175655_b(pos, false);
                        }
                    } else {
                        worldIn.func_175655_b(pos, false);
                    }
                } else if (st == 2) {
                    if (!soil || upSt < 0 || upSt > 4 || upSt == 4 && upVar >= 6) {
                        worldIn.func_175655_b(pos, false);
                    }
                } else if (st == 3) {
                    if (downSt < 2 || downSt > 3 || upSt < 3 && upSt != 1 || upSt == 4 && upVar >= 6 || upSt == 5) {
                        worldIn.func_175655_b(pos, false);
                    }
                } else if (st == 4) {
                    if (fog) {
                        if (var == 0) {
                            boolean fog2;
                            boolean bl = fog2 = (float)pos.func_177981_b(2).func_177956_o() < MistWorld.getFogHight(worldIn, 0.0f) + 4.0f;
                            if (downSt < 3 || downSt == 4 && downVar > 0 || upSt < 4 || upSt == 4 && upVar >= 6 || upSt == 5 && upVar != 0) {
                                worldIn.func_175655_b(pos, false);
                            } else if (downSt == 3 && upSt == 5) {
                                if (rand.nextInt(mutateChance) == 0 || !worldIn.func_175623_d(pos.func_177981_b(2))) {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                } else if (worldIn.func_175623_d(pos.func_177981_b(2)) && fog2) {
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                    worldIn.func_180501_a(pos.func_177981_b(2), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                }
                            } else if (downSt == 4 && upSt == 5) {
                                if (downSt2 == 4) {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                } else if (rand.nextInt(mutateChance) == 0 && worldIn.func_175623_d(pos.func_177981_b(2)) && fog2) {
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                    worldIn.func_180501_a(pos.func_177981_b(2), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 3);
                                } else {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                }
                            }
                        } else if (var == 1) {
                            if (downSt < 2 || upSt < 4 || upSt == 4 && upVar >= 6 || upSt == 5 && upVar == 8) {
                                worldIn.func_175655_b(pos, false);
                            } else if (upSt == 5 && upVar == 1) {
                                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                if (downSt == 4 && downVar == 0) {
                                    worldIn.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                }
                            } else if (upSt == 5 && upVar == 3) {
                                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 3);
                            }
                        } else if (var == 2) {
                            if (downSt < 2 || upSt < 4 || upSt == 4 && upVar >= 6 || upSt == 5 && upVar == 8) {
                                worldIn.func_175655_b(pos, false);
                            } else if (upSt == 5 && upVar == 2) {
                                boolean open = false;
                                if (downSt == 3) {
                                    open = true;
                                } else if (downSt == 4) {
                                    if (downVar == 1) {
                                        worldIn.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                        if (downSt2 == 4 && downVar2 == 0) {
                                            worldIn.func_180501_a(pos.func_177979_c(2), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                        }
                                    } else if (downVar == 2) {
                                        if (downSt2 == 3) {
                                            open = true;
                                        } else if (downSt2 == 4 && downVar2 == 1) {
                                            worldIn.func_180501_a(pos.func_177979_c(2), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                        } else if (downSt2 == 4 && downVar2 == 2) {
                                            open = true;
                                        }
                                    }
                                }
                                if (open) {
                                    worldIn.func_175655_b(pos.func_177984_a(), false);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 3);
                                }
                            } else if (upSt == 5 && upVar == 4 && rand.nextInt(aging) == 0) {
                                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 3);
                                worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(6)), 3);
                                if (downSt == 3) {
                                    worldIn.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                }
                            }
                        } else if (var == 3) {
                            if (downSt < 2 || upSt < 5 || upSt == 5 && upVar == 8) {
                                worldIn.func_175655_b(pos, false);
                            } else if (upSt == 5) {
                                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(3)), 3);
                                if (downSt == 4 && downVar == 1) {
                                    worldIn.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                }
                            }
                        } else if (var == 4) {
                            if (downSt < 2 || upSt < 4 || upSt == 4 && upVar >= 6 || upSt == 5 && upVar == 8) {
                                worldIn.func_175655_b(pos, false);
                            } else if (upSt == 5) {
                                if (downSt == 3 || downSt == 4 && downVar == 1) {
                                    worldIn.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 3);
                                } else if (downSt == 4 && downVar == 2) {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(5)), 3);
                                    worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(7)), 3);
                                    worldIn.func_180501_a(pos.func_177977_b(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 3);
                                    if (downSt2 == 3) {
                                        worldIn.func_180501_a(pos.func_177979_c(2), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 3);
                                    }
                                }
                            }
                        } else if (var == 5) {
                            if (downSt < 4 || upSt < 5 || upSt == 5 && upVar == 8) {
                                worldIn.func_175655_b(pos, false);
                            } else if (upSt == 5) {
                                worldIn.func_175655_b(pos.func_177984_a(), false);
                                this.dissemination(worldIn, pos.func_177984_a(), rand);
                                if (downSt2 == 2) {
                                    worldIn.func_175655_b(pos, false);
                                } else if (downSt2 == 4 && (downVar2 == 1 || downVar2 == 2)) {
                                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(6)), 3);
                                }
                            }
                        }
                    } else if (var < 6 && (downSt < 2 || upSt < 4 || upSt == 4 && upVar >= 6 || upSt == 5 && upVar == 8)) {
                        worldIn.func_175655_b(pos, false);
                    }
                } else if (st == 5 && var == 8) {
                    worldIn.func_180501_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(Math.abs(pos.func_177958_n() * pos.func_177956_o() * pos.func_177952_p()) % 9)), 3);
                }
            }
        }
    }

    private void dissemination(World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < rand.nextInt(3) + 3; ++i) {
            BlockPos pos1 = pos.func_177982_a(rand.nextInt(3) - rand.nextInt(3), 0, rand.nextInt(3) - rand.nextInt(3));
            BlockPos pos2 = pos1.func_177977_b();
            while (pos2.func_177956_o() > pos.func_177956_o() - 10 && (worldIn.func_175623_d(pos2) || worldIn.func_180495_p(pos2).func_185904_a().func_76222_j() && !worldIn.func_180495_p(pos1).func_185904_a().func_76224_d()) && pos2.func_177956_o() > 1) {
                pos1 = pos2;
                pos2 = pos1.func_177977_b();
            }
            if (!worldIn.func_175623_d(pos1) && (!worldIn.func_180495_p(pos1).func_185904_a().func_76222_j() || worldIn.func_180495_p(pos1).func_185904_a().func_76224_d())) continue;
            ItemStack stack = new ItemStack(MistItems.SPONGE_SPORE);
            EntityItem entity_item = new EntityItem(worldIn, (double)pos1.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)pos1.func_177952_p() + 0.5, stack);
            entity_item.func_174869_p();
            if (worldIn.func_180495_p(pos2).func_177230_c() instanceof MistAcidSoil) {
                int spore = 0;
                for (int x = -8; x <= 8; ++x) {
                    for (int y = -2; y <= 2; ++y) {
                        for (int z = -8; z <= 8; ++z) {
                            BlockPos pos3 = pos1.func_177982_a(x, y, z);
                            IBlockState state = worldIn.func_180495_p(pos3);
                            if (state.func_177230_c() != this || (Integer)state.func_177229_b((IProperty)STAGE) > 2 && state.func_185899_b((IBlockAccess)worldIn, pos3) != this.func_176223_P()) continue;
                            ++spore;
                        }
                    }
                }
                if (spore < 8) {
                    worldIn.func_180501_a(pos1, this.func_176223_P(), 3);
                    continue;
                }
                if (rand.nextInt(3) != 0) continue;
                worldIn.func_72838_d((Entity)entity_item);
                continue;
            }
            if (rand.nextInt(3) != 0) continue;
            worldIn.func_72838_d((Entity)entity_item);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return this.func_149686_d(state);
    }

    public boolean func_149686_d(IBlockState state) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_177229_b((IProperty)VARIANT);
        return st == 4 ? var >= 6 : false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(6)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(7)))));
        list.add((Object)new ItemStack((Block)this, 1, this.func_176201_c(this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(8)))));
    }

    public int func_176201_c(IBlockState state) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_177229_b((IProperty)VARIANT);
        int i = st < 4 ? st + 1 : (st == 4 ? (var < 6 ? var + 5 : var + 7) : (var < 3 ? 11 : (var < 8 ? 12 : 0)));
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        if (meta == 0) {
            return this.func_176223_P();
        }
        if (meta < 5) {
            return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta - 1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0));
        }
        if (meta < 11) {
            return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta - 5));
        }
        if (meta == 11) {
            return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0));
        }
        if (meta == 12) {
            return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(3));
        }
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(meta - 7));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_177229_b((IProperty)VARIANT);
        int downVar = worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == this ? (Integer)worldIn.func_180495_p(pos.func_177977_b()).func_185899_b(worldIn, pos.func_177977_b()).func_177229_b((IProperty)VARIANT) : -1;
        return this.getActualState(state, pos, st, var, downVar);
    }

    private IBlockState getActualState(IBlockState state, BlockPos pos, int st, int var, int downVar) {
        if (st < 4) {
            if (downVar < 0) {
                downVar = Math.abs(pos.func_177958_n() * pos.func_177956_o() * pos.func_177952_p()) % 9;
            }
            var = downVar;
        } else if (st == 5 && downVar >= 0) {
            if (var < 3 && downVar < 3) {
                var = downVar;
            } else if (var < 8) {
                if (downVar == 0) {
                    var = downVar;
                } else if (downVar > 0 && downVar <= 5) {
                    var = downVar + 2;
                }
            }
        }
        return state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(st)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(var));
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer player) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (!worldIn.field_72995_K && (Integer)state.func_177229_b((IProperty)STAGE) == 5 && (Integer)state.func_177229_b((IProperty)VARIANT) == 8) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        IBlockState upState = worldIn.func_180495_p(pos.func_177984_a());
        if (!worldIn.field_72995_K && upState.func_177230_c() == this) {
            int upSt = (Integer)upState.func_177229_b((IProperty)STAGE);
            int upVar = (Integer)this.getActualState(upState, pos.func_177984_a(), upSt, (Integer)upState.func_177229_b((IProperty)VARIANT), (Integer)state.func_185899_b((IBlockAccess)worldIn, pos).func_177229_b((IProperty)VARIANT)).func_177229_b((IProperty)VARIANT);
            if (upSt != 4 || upVar < 6) {
                worldIn.func_180501_a(pos.func_177984_a(), state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(upSt)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(upVar)), 1);
                worldIn.func_175655_b(pos.func_177984_a(), true);
            }
        }
    }

    public void getDrops(NonNullList ret, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_185899_b(world, pos).func_177229_b((IProperty)VARIANT);
        int count = this.quantityDropped(st, var, rand);
        for (int i = 0; i < count; ++i) {
            Item item = this.getItemDropped(st, var, rand);
            if (item == null) continue;
            ret.add((Object)new ItemStack(item, 1, this.damageDropped(st, var, state)));
        }
    }

    private Item getItemDropped(int st, int var, Random random) {
        if (st == 0 || st == 2) {
            return null;
        }
        if (st == 1 || st == 3 || st >= 4 && var == 0) {
            return MistItems.SPONGE_MEAT;
        }
        if (st == 4) {
            if (var <= 3) {
                return MistItems.SPONGE_FIBRE;
            }
            return new ItemStack((Block)this).func_77973_b();
        }
        if (var <= 5) {
            return MistItems.SPONGE_FIBRE;
        }
        if (var == 6) {
            return random.nextBoolean() ? MistItems.SPONGE_FIBRE : MistItems.SPONGE_SPORE;
        }
        if (var == 7) {
            return MistItems.SPONGE_SPORE;
        }
        return MistItems.SPONGE_SPORE;
    }

    private int quantityDropped(int st, int var, Random random) {
        if (st == 0 || st == 2) {
            return 0;
        }
        if (st == 1) {
            return random.nextInt(2);
        }
        if (st == 3) {
            return random.nextInt(2) + 1;
        }
        if (st >= 4 && var == 0) {
            return random.nextInt(3) + 1;
        }
        if (st == 4) {
            if (var <= 3) {
                return random.nextInt(2);
            }
            return 1;
        }
        if (var <= 5) {
            return random.nextInt(2);
        }
        if (var == 6) {
            return random.nextInt(2);
        }
        if (var == 7) {
            return random.nextInt(3) + 3;
        }
        return 1;
    }

    private int damageDropped(int st, int var, IBlockState state) {
        if (st == 4) {
            if (var <= 3) {
                return 0;
            }
            if (var <= 5) {
                return 14;
            }
            return this.func_176201_c(state);
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE, VARIANT});
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        if (this.func_176201_c(state) >= 13) {
            return EnumPushReaction.NORMAL;
        }
        return EnumPushReaction.DESTROY;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return Mist.MIST_DOWN_PLANT;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return this.func_176223_P();
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        int i = this.func_176201_c(state);
        if (i == 0 || i >= 13) {
            return (ItemStack)this.getDrops((IBlockAccess)world, pos, state, 0).get(0);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public boolean isMistAdsorbent(World world, BlockPos pos, IBlockState state) {
        int st = (Integer)state.func_177229_b((IProperty)STAGE);
        int var = (Integer)state.func_185899_b((IBlockAccess)world, pos).func_177229_b((IProperty)VARIANT);
        return st == 3 || st > 3 && (var < 2 || var == 3) || st == 5 && var == 5;
    }

    public void generateSponge(World world, BlockPos pos, Random rand) {
        if (!world.field_72995_K) {
            for (int i = 0; i < rand.nextInt(4) + 5; ++i) {
                BlockPos pos1 = world.func_175645_m(pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), 0, rand.nextInt(4) - rand.nextInt(4)));
                while ((world.func_175623_d(pos1) || world.func_180495_p(pos1).func_185904_a().func_76222_j()) && Math.abs(pos1.func_177956_o() - pos.func_177956_o()) < 5) {
                    pos1 = pos1.func_177977_b();
                }
                this.generateSingleSponge(world, pos1, rand);
            }
        }
    }

    public void generateSingleSponge(World world, BlockPos pos, Random rand) {
        if (!world.field_72995_K && world.func_180495_p(pos).func_177230_c() instanceof MistAcidSoil) {
            boolean check = false;
            for (int i = 1; i < 8; ++i) {
                Material mat = world.func_180495_p(pos.func_177981_b(i)).func_185904_a();
                if (mat.func_76222_j() && !mat.func_76224_d()) continue;
                check = true;
                break;
            }
            if (!check) {
                int age = rand.nextInt(25);
                if (age == 0) {
                    world.func_175656_a(pos.func_177984_a(), this.func_176223_P());
                } else if (age < 3) {
                    world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(age - 1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                } else {
                    world.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(2)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                    if (age == 3) {
                        world.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                    } else if (age < 17) {
                        int up = rand.nextInt(3) == 0 ? rand.nextInt(3) : 1;
                        int down = rand.nextInt(4) == 0 ? 1 : 0;
                        world.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                        if (down > 0) {
                            world.func_180501_a(pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                        }
                        if (age < 6) {
                            world.func_180501_a(pos.func_177981_b(3 + down), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                        } else if (age < 9) {
                            world.func_180501_a(pos.func_177981_b(3 + down), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                            for (int i = 0; i < up; ++i) {
                                world.func_180501_a(pos.func_177981_b(4 + down + i), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                            }
                            world.func_180501_a(pos.func_177981_b(4 + down + up), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                        } else if (age < 13) {
                            world.func_180501_a(pos.func_177981_b(3 + down), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(age - 8 - up), (int)0, (int)2))), 18);
                            for (int i = 0; i < up; ++i) {
                                world.func_180501_a(pos.func_177981_b(4 + down + i), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(age + i - 7 - up), (int)0, (int)2))), 18);
                            }
                            world.func_180501_a(pos.func_177981_b(4 + down + up), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                        } else {
                            world.func_180501_a(pos.func_177981_b(3 + down), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 18);
                            for (int i = 0; i < up; ++i) {
                                world.func_180501_a(pos.func_177981_b(4 + down + i), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 18);
                            }
                            world.func_180501_a(pos.func_177981_b(4 + down + up), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 18);
                        }
                    } else if (age < 22) {
                        int i;
                        int down;
                        int med;
                        boolean crown = rand.nextBoolean();
                        int n = med = rand.nextInt(3) == 0 ? 1 : 0;
                        int n2 = rand.nextInt(3) == 0 ? 0 : (down = rand.nextInt(4) == 0 && med == 0 ? 2 : 1);
                        int full = !(med != 0 || down <= 0 && crown) ? (rand.nextInt(8) == 0 && down > 0 && !crown ? 2 : 1) : 0;
                        for (i = 0; i < down; ++i) {
                            world.func_180501_a(pos.func_177981_b(2 + i), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(3)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(0)), 18);
                        }
                        if (med == 0) {
                            for (i = 0; i < full; ++i) {
                                world.func_180501_a(pos.func_177981_b(2 + down + i), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(2)), 18);
                            }
                        } else {
                            world.func_180501_a(pos.func_177981_b(2 + down), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(1)), 18);
                        }
                        world.func_180501_a(pos.func_177981_b(2 + down + full + med), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 18);
                        if (crown) {
                            world.func_180501_a(pos.func_177981_b(3 + down + full + med), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(5)), 18);
                            world.func_180501_a(pos.func_177981_b(4 + down + full + med), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(7)), 18);
                        } else {
                            world.func_180501_a(pos.func_177981_b(3 + down + full + med), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(6)), 18);
                        }
                    } else if (age < 24) {
                        world.func_180501_a(pos.func_177981_b(2), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(4)), 18);
                        if (age == 22) {
                            world.func_180501_a(pos.func_177981_b(3), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(4)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(5)), 18);
                            world.func_180501_a(pos.func_177981_b(4), this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(5)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(7)), 18);
                        }
                    }
                }
            }
        }
    }
}

